/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.Config;
import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamSettingsController;
import bluej.groupwork.TeamworkProvider;
import bluej.groupwork.actions.ValidateConnectionAction;
import bluej.groupwork.ui.TeamSettingsDialog;
import bluej.utility.javafx.JavaFXUtil;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class TeamSettingsPanel
extends VBox {
    private TeamSettingsController teamSettingsController;
    private TeamworkProvider teamworkProvider;
    private TeamSettingsDialog teamSettingsDialog;
    private GridPane personalPane;
    private GridPane locationPane;
    private Label serverLabel = new Label(Config.getString("team.settings.server"));
    private Label prefixLabel = new Label(Config.getString("team.settings.prefix"));
    private Label protocolLabel = new Label(Config.getString("team.settings.protocol"));
    private Label uriLabel = new Label(Config.getString("team.settings.uri"));
    private Label branchLabel = new Label(Config.getString("team.settings.branch"));
    private Label yourNameLabel = new Label(Config.getString("team.settings.yourName"));
    private Label yourEmailLabel = new Label(Config.getString("team.settings.yourEmail"));
    private Label userLabel = new Label(Config.getString("team.settings.user"));
    private Label passwordLabel = new Label(Config.getString("team.settings.password"));
    private final TextField serverField = new TextField();
    private final TextField portField = new TextField();
    private final TextField prefixField = new TextField();
    private final ComboBox<String> protocolComboBox = new ComboBox();
    private final TextField uriField = new TextField();
    private final TextField branchField = new TextField();
    private final TextField yourNameField = new TextField();
    private final TextField yourEmailField = new TextField();
    private final TextField userField = new TextField();
    private final PasswordField passwordField = new PasswordField();
    private TextField locationPrimaryField;
    private TextField personalPrimaryField;
    private CheckBox useAsDefault;
    private boolean isShareAction = false;

    public TeamSettingsPanel(TeamSettingsController teamSettingsController, TeamSettingsDialog dialog, boolean isShareAction) {
        this.teamSettingsController = teamSettingsController;
        this.teamworkProvider = teamSettingsController.getTeamworkProvider();
        this.teamSettingsDialog = dialog;
        this.isShareAction = isShareAction;
        JavaFXUtil.addStyleClass((Styleable)this, "panel");
        this.useAsDefault = new CheckBox(Config.getString("team.settings.rememberSettings"));
        this.locationPane = this.createGridPane();
        this.personalPane = this.createGridPane();
        this.preparePanes();
        ValidateConnectionAction validateConnectionAction = new ValidateConnectionAction(this, () -> ((TeamSettingsDialog)dialog).getOwner());
        Button validateButton = new Button();
        validateConnectionAction.useButton(teamSettingsController.getProject(), (ButtonBase)validateButton);
        this.getChildren().addAll((Object[])new Node[]{this.createPropertiesContainer(Config.getString("team.settings.location"), (Pane)this.locationPane), this.createPropertiesContainer(Config.getString("team.settings.personal"), (Pane)this.personalPane), this.useAsDefault, validateButton});
        this.setupContent();
        this.updateOKButtonBinding();
        if (!teamSettingsController.hasProject()) {
            this.useAsDefault.setSelected(true);
            this.useAsDefault.setDisable(true);
        }
    }

    public void doRequestFocus() {
        if (this.locationPrimaryField != null && this.locationPrimaryField.getText().isEmpty()) {
            this.locationPrimaryField.requestFocus();
        } else if (this.personalPrimaryField.getText().isEmpty()) {
            this.personalPrimaryField.requestFocus();
        } else {
            this.passwordField.requestFocus();
        }
    }

    private GridPane createGridPane() {
        GridPane pane = new GridPane();
        pane.getStyleClass().add((Object)"grid");
        ColumnConstraints column1 = new ColumnConstraints();
        column1.setPrefWidth(102.0);
        ColumnConstraints column2 = new ColumnConstraints();
        column2.setPrefWidth(260.0);
        column2.setHgrow(Priority.ALWAYS);
        pane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2});
        return pane;
    }

    private Pane createPropertiesContainer(String title, Pane gridPane) {
        VBox container = new VBox();
        container.setSpacing(-5.0);
        container.getChildren().addAll((Object[])new Node[]{new Label(title), gridPane});
        return container;
    }

    private void preparePanes() {
        this.prepareLocationPane();
        this.preparePersonalPane();
        this.setProviderSettings();
        this.useAsDefault.setDisable(false);
    }

    private void preparePersonalPane() {
        this.personalPane.getChildren().clear();
        this.personalPane.addRow(0, new Node[]{this.yourNameLabel, this.yourNameField});
        this.personalPane.addRow(1, new Node[]{this.yourEmailLabel, this.yourEmailField});
        this.personalPane.addRow(2, new Node[]{this.userLabel, this.userField});
        this.personalPane.addRow(3, new Node[]{this.passwordLabel, this.passwordField});
        this.personalPrimaryField = this.yourNameField;
    }

    private void prepareLocationPane() {
        this.locationPane.getChildren().clear();
        this.protocolComboBox.setEditable(false);
        this.locationPane.addRow(0, new Node[]{this.uriLabel, this.uriField});
        this.locationPrimaryField = this.uriField;
        if (!this.isShareAction) {
            this.locationPane.addRow(1, new Node[]{this.branchLabel, this.branchField});
        }
        this.branchField.setPromptText(Config.getString("team.settings.defaultBranch"));
    }

    private void setTextFieldText(TextField field, String value) {
        field.setText(value == null ? "" : value);
    }

    private void setupContent() {
        String useAsDefault;
        String password;
        String yourEmail;
        String yourName;
        String user = this.teamSettingsController.getPropString("bluej.teamsettings.user");
        if (user != null) {
            this.setUser(user);
        }
        if ((yourName = this.teamSettingsController.getPropString("bluej.teamsettings.yourName")) != null) {
            this.setYourName(yourName);
        }
        if ((yourEmail = this.teamSettingsController.getPropString("bluej.teamsettings.yourEmail")) != null) {
            this.setYourEmail(yourEmail);
        }
        if ((password = this.teamSettingsController.getPasswordString()) != null) {
            this.setPassword(password);
        }
        if ((useAsDefault = this.teamSettingsController.getPropString("bluej.teamsettings.useAsDefault")) != null) {
            this.setUseAsDefault(Boolean.getBoolean(useAsDefault));
        }
        String providerName = this.teamSettingsController.getPropString("bluej.teamsettings.vcs");
        if ((this.teamworkProvider.getProviderName().equalsIgnoreCase(providerName) || providerName == null) && this.teamSettingsController.getProject() != null) {
            File respositoryRoot = this.teamSettingsController.getProject().getProjectDir();
            this.setTextFieldText(this.yourEmailField, this.teamworkProvider.getYourEmailFromRepo(respositoryRoot));
            this.setTextFieldText(this.yourNameField, this.teamworkProvider.getYourNameFromRepo(respositoryRoot));
        }
        this.setProviderSettings();
    }

    private void setProviderSettings() {
        String branch;
        int port;
        String server;
        String keyBase = "bluej.teamsettings." + this.teamworkProvider.getProviderName().toLowerCase() + ".";
        String prefix = this.teamSettingsController.getPropString(keyBase + "repositoryPrefix");
        if (prefix != null) {
            this.setPrefix(prefix);
        }
        if ((server = this.teamSettingsController.getPropString(keyBase + "server")) != null) {
            this.setServer(server);
        }
        if ((port = this.teamSettingsController.getPropInt(keyBase + "port")) > 0) {
            this.setPort(port);
        }
        this.fillProtocolSelections();
        String protocol = this.readProtocolString();
        if (protocol != null) {
            this.setProtocol(protocol);
        }
        if ((branch = this.teamSettingsController.getPropString(keyBase + "branch")) != null) {
            this.setBranch(branch);
        }
    }

    private void fillProtocolSelections() {
        this.protocolComboBox.getItems().addAll(Arrays.asList(this.teamworkProvider.getProtocols()));
    }

    private String readProtocolString() {
        String keyBase = "bluej.teamsettings." + this.teamworkProvider.getProviderName().toLowerCase() + ".";
        return this.teamSettingsController.getPropString(keyBase + "protocol");
    }

    private void setBranch(String branch) {
        this.branchField.setText(branch);
    }

    private void setUser(String user) {
        this.userField.setText(user);
    }

    private void setYourName(String yourName) {
        this.yourNameField.setText(yourName);
    }

    private void setYourEmail(String yourEmail) {
        this.yourEmailField.setText(yourEmail);
    }

    private void setPassword(String password) {
        this.passwordField.setText(password);
    }

    private void setPrefix(String prefix) {
        this.prefixField.setText(prefix);
    }

    private void setServer(String server) {
        this.serverField.setText(server);
    }

    private void setPort(int port) {
        this.portField.setText("" + port);
    }

    private void setProtocol(String protocolKey) {
        String protocolLabel = this.teamworkProvider.getProtocolLabel(protocolKey);
        this.protocolComboBox.getSelectionModel().select((Object)protocolLabel);
    }

    private void setUseAsDefault(boolean use) {
        this.useAsDefault.setSelected(use);
    }

    public TeamworkProvider getProvider() {
        return this.teamworkProvider;
    }

    private String getUser() {
        return this.userField.getText();
    }

    private String getPassword() {
        return this.passwordField.getText();
    }

    private String getPrefix() {
        try {
            URI uri = new URI(this.uriField.getText());
            return uri.getPath();
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    private String getBranch() {
        return this.branchField.getText();
    }

    private String getServer() {
        try {
            URI uri = new URI(this.uriField.getText());
            return uri.getHost();
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    private int getPort() {
        try {
            URI uri = new URI(this.uriField.getText());
            return uri.getPort();
        }
        catch (URISyntaxException ex) {
            return -1;
        }
    }

    private String getProtocolKey() {
        try {
            URI uri = new URI(this.uriField.getText());
            return uri.getScheme();
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public boolean getUseAsDefault() {
        return this.useAsDefault.isSelected();
    }

    private String getYourName() {
        return this.yourNameField.getText();
    }

    private String getYourEmail() {
        return this.yourEmailField.getText();
    }

    public TeamSettings getSettings() {
        TeamSettings result = new TeamSettings(this.getProtocolKey(), this.getServer(), this.getPort(), this.getPrefix(), this.getBranch(), this.getUser(), this.getPassword());
        result.setYourEmail(this.getYourEmail());
        result.setYourName(this.getYourName());
        return result;
    }

    private void updateOKButtonBinding() {
        this.teamSettingsDialog.getOkButton().disableProperty().unbind();
        BooleanBinding disabled = this.userField.textProperty().isEmpty().or((ObservableBooleanValue)this.uriField.textProperty().isEmpty()).or((ObservableBooleanValue)this.yourNameField.textProperty().isEmpty()).or((ObservableBooleanValue)this.yourEmailField.textProperty().isEmpty()).or((ObservableBooleanValue)Bindings.createBooleanBinding(() -> !this.yourEmailField.getText().contains("@"), (Observable[])new Observable[]{this.yourEmailField.textProperty()}));
        this.teamSettingsDialog.getOkButton().disableProperty().bind((ObservableValue)disabled);
    }

    public void disableRepositorySettings() {
        this.prefixField.setDisable(true);
        this.branchField.setDisable(true);
        this.serverField.setDisable(true);
        this.portField.setDisable(true);
        this.protocolComboBox.setDisable(true);
        this.uriField.setDisable(true);
        if (this.uriField.isVisible() && this.uriField.getText().isEmpty()) {
            int port = -1;
            try {
                port = Integer.parseInt(this.portField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.uriField.setText(TeamSettings.getURI(this.readProtocolString(), this.serverField.getText(), port, this.prefixField.getText()));
        }
        this.prefixLabel.setDisable(true);
        this.branchLabel.setDisable(true);
        this.serverLabel.setDisable(true);
        this.protocolLabel.setDisable(true);
    }
}

