/*
 * Decompiled with CFR 0.152.
 */
package bluej.graph;

import bluej.Config;
import bluej.graph.Marquee;
import bluej.graph.SelectionSet;
import bluej.graph.TraverseStrategy;
import bluej.graph.TraverseStrategyImpl;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.target.Target;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class SelectionController {
    private final PackageEditor graphEditor;
    private final Package graph;
    private final Marquee marquee;
    private final SelectionSet selection;
    private boolean moving = false;
    private boolean resizing = false;
    private TraverseStrategy traverseStragegiImpl = new TraverseStrategyImpl();
    private ArrayList<Target> mostRecentSelection = new ArrayList();

    public SelectionController(PackageEditor graphEditor) {
        this.graphEditor = graphEditor;
        this.graph = graphEditor.getPackage();
        this.selection = new SelectionSet(Utility.filterList(this.graph.getVertices(), Target::isSelected));
        this.marquee = new Marquee(this.graph, this.selection);
    }

    public void mousePressed(MouseEvent evt) {
        int clickX = (int)evt.getX();
        int clickY = (int)evt.getY();
        if (!this.isMultiselectionKeyDown(evt)) {
            this.selection.clear();
        }
        if (this.isButtonOne(evt)) {
            this.marquee.start(clickX, clickY);
        }
    }

    public void mouseReleased(MouseEvent evt) {
        this.marquee.stop();
        this.graphEditor.repaint();
        if (this.moving || this.resizing) {
            this.endMove();
            this.graphEditor.repaint();
        }
        for (Target t : this.graph.getVertices()) {
            if (!t.isFocused() || t.isSelected()) continue;
            this.selectOnly(t);
            break;
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (this.isButtonOne(evt) && evt.getClickCount() > 1) {
            this.selection.getSelected().forEach(target -> {
                if (evt.getTarget().equals(target)) {
                    this.selection.doubleClick(false);
                    return;
                }
            });
        }
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.isButtonOne(evt)) {
            if (this.marquee.isActive()) {
                this.marquee.move((int)evt.getX(), (int)evt.getY());
                this.graphEditor.repaint();
            } else {
                if (!this.selection.isEmpty()) {
                    // empty if block
                }
                this.graphEditor.repaint();
            }
        }
    }

    public void navigate(KeyEvent evt) {
        Target currentTarget = this.findSingleVertex();
        currentTarget = this.traverseStragegiImpl.findNextVertex(this.graph, currentTarget, evt.getCode());
        this.selection.selectOnly(currentTarget);
        currentTarget.requestFocus();
    }

    private void endMove() {
        this.selection.moveStopped();
        this.moving = false;
        this.resizing = false;
    }

    public Marquee getMarquee() {
        return this.marquee;
    }

    private Target findSingleVertex() {
        Target vertex = this.selection.getAnyVertex();
        if (vertex == null) {
            vertex = this.graph.getVertices().get(0);
        }
        return vertex;
    }

    public void clearSelection() {
        this.mostRecentSelection = new ArrayList<Target>(this.getSelection());
        this.selection.clear();
    }

    public void selectAll() {
        for (Target t : this.graph.getVertices()) {
            this.selection.add(t);
        }
    }

    public void removeFromSelection(Target element) {
        this.selection.remove(element);
    }

    public void addToSelection(Target element) {
        this.selection.add(element);
    }

    private boolean isButtonOne(MouseEvent evt) {
        return !evt.isPopupTrigger() && evt.getButton() == MouseButton.PRIMARY;
    }

    private boolean isMultiselectionKeyDown(MouseEvent evt) {
        if (Config.isMacOS()) {
            return evt.isShiftDown() || evt.isMetaDown();
        }
        return evt.isShiftDown() || evt.isControlDown();
    }

    public void selectOnly(Target target) {
        this.selection.selectOnly(target);
    }

    public List<Target> getSelection() {
        return this.selection.getSelected();
    }

    public void addSelectionListener(FXPlatformConsumer<Collection<Target>> selectionListener) {
        this.selection.addListener(selectionListener);
    }

    public boolean restoreRecentSelectionAndFocus(Predicate<Target> stillAValidTarget) {
        this.selection.clear();
        boolean haveFocused = false;
        for (Target target : this.mostRecentSelection) {
            if (!stillAValidTarget.test(target)) continue;
            this.selection.add(target);
            if (haveFocused) continue;
            target.getNode().requestFocus();
            haveFocused = true;
        }
        return !this.selection.isEmpty();
    }
}

