/*
 * Decompiled with CFR 0.152.
 */
package bluej.extmgr;

import bluej.extmgr.ExtensionMenu;
import bluej.extmgr.ExtensionWrapper;
import bluej.extmgr.ExtensionsManager;
import bluej.pkgmgr.Project;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXPlatformSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public final class ExtensionsMenuManager {
    private final ExtensionsManager extMgr;
    private final SeparatorMenuItem menuSeparator;
    private final @OnThread(value=Tag.Any) ContextMenu popupMenu;
    private final @OnThread(value=Tag.Any) Menu menu;
    private @OnThread(value=Tag.Any, requireSynchronized=true) ExtensionMenu menuGenerator;

    @OnThread(value=Tag.Any)
    public synchronized void setMenuGenerator(ExtensionMenu menuGenerator) {
        this.menuGenerator = menuGenerator;
    }

    public ExtensionsMenuManager(ContextMenu aPopupMenu, ExtensionsManager extMgr, ExtensionMenu menuGenerator) {
        this.extMgr = extMgr;
        this.menuGenerator = menuGenerator;
        this.menuSeparator = new SeparatorMenuItem();
        this.popupMenu = aPopupMenu;
        this.popupMenu.setOnShowing(this::menuWillBecomeVisible);
        this.menu = null;
    }

    public ExtensionsMenuManager(Menu aMenu, ExtensionsManager extMgr, ExtensionMenu menuGenerator) {
        this.extMgr = extMgr;
        this.menuGenerator = menuGenerator;
        this.menuSeparator = new SeparatorMenuItem();
        this.menu = aMenu;
        this.menu.setOnShowing(this::menuWillBecomeVisible);
        this.popupMenu = null;
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized void addExtensionMenu(Project onThisProject) {
        LinkedList<MenuItem> menuItems = this.extMgr.getMenuItems(this.menuGenerator, onThisProject);
        ObservableList<MenuItem> items = this.getItems();
        ArrayList<MenuItem> oldPopupItems = new ArrayList<MenuItem>((Collection<MenuItem>)items);
        for (MenuItem aComponent : oldPopupItems) {
            ExtensionWrapper aWrapper = (ExtensionWrapper)aComponent.getProperties().get((Object)"bluej.extmgr.ExtensionWrapper");
            if (aWrapper == null) continue;
            items.remove((Object)aComponent);
        }
        items.remove((Object)this.menuSeparator);
        if (!menuItems.isEmpty()) {
            items.add((Object)this.menuSeparator);
            if (this.popupMenu != null) {
                this.popupMenu.getItems().addAll(menuItems);
            } else {
                this.menu.getItems().addAll(menuItems);
            }
        }
    }

    @OnThread(value=Tag.Any)
    private FXPlatformRunnable supplierToRunnable(FXPlatformSupplier<Menu> menuFXSupplier) {
        return () -> menuFXSupplier.get();
    }

    private ObservableList<MenuItem> getItems() {
        if (this.popupMenu != null) {
            return this.popupMenu.getItems();
        }
        return this.menu.getItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void menuWillBecomeVisible(Event event) {
        int itemsCount = 0;
        ObservableList<MenuItem> items = this.getItems();
        ArrayList<MenuItem> popupMenuItems = new ArrayList<MenuItem>((Collection<MenuItem>)items);
        for (MenuItem aComponent : popupMenuItems) {
            ExtensionWrapper aWrapper = (ExtensionWrapper)aComponent.getProperties().get((Object)"bluej.extmgr.ExtensionWrapper");
            if (aWrapper == null) continue;
            if (!aWrapper.isValid()) {
                items.remove((Object)aComponent);
            } else {
                ExtensionsMenuManager extensionsMenuManager = this;
                synchronized (extensionsMenuManager) {
                    aWrapper.safePostMenuItem(this.menuGenerator, aComponent);
                }
            }
            ++itemsCount;
        }
        if (itemsCount <= 0) {
            items.remove((Object)this.menuSeparator);
        }
    }
}

