/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.Config;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerThread;
import bluej.debugger.SourceLocation;
import bluej.debugger.VarDisplayInfo;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.jdi.JdiClass;
import bluej.debugger.jdi.JdiDebugger;
import bluej.debugger.jdi.JdiObject;
import bluej.debugger.jdi.JdiReflective;
import bluej.debugger.jdi.JdiUtils;
import bluej.debugger.jdi.VMReference;
import bluej.utility.Debug;
import bluej.utility.javafx.FXPlatformSupplier;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import threadchecker.OnThread;
import threadchecker.Tag;

class JdiThread
extends DebuggerThread {
    static final String statusFinished = Config.getString("debugger.threadstatus.finished");
    static final String statusBreakpoint = Config.getString("debugger.threadstatus.breakpoint");
    static final String statusStopped = Config.getString("debugger.threadstatus.stopped");
    static final String statusMonitor = Config.getString("debugger.threadstatus.monitor");
    static final String statusNotStarted = Config.getString("debugger.threadstatus.notstarted");
    static final String statusRunning = Config.getString("debugger.threadstatus.running");
    static final String statusSleeping = Config.getString("debugger.threadstatus.sleeping");
    static final String statusUnknown = Config.getString("debugger.threadstatus.unknown");
    static final String statusWaiting = Config.getString("debugger.threadstatus.waiting");
    static final String statusZombie = Config.getString("debugger.threadstatus.zombie");
    private static @OnThread(value=Tag.Any, requireSynchronized=true) List<String> excludes;
    private final @OnThread(value=Tag.VMEventHandler) ThreadReference rt;
    private @OnThread(value=Tag.VMEventHandler) boolean isSuspended;
    @OnThread(value=Tag.VMEventHandler) StepRequest stepRequest;
    private int selectedFrame;
    private @OnThread(value=Tag.VMEventHandler) EventRequestManager eventReqMgr;
    private final @OnThread(value=Tag.VMEventHandler) JdiDebugger debugger;
    static final String MAIN_THREADGROUP = "main";

    @OnThread(value=Tag.Any)
    private static synchronized List<String> getExcludes() {
        if (excludes == null) {
            JdiThread.setExcludes("java.*, javax.*, sun.*, com.sun.*");
        }
        return excludes;
    }

    @OnThread(value=Tag.Any)
    private static synchronized void setExcludes(String excludeString) {
        StringTokenizer t = new StringTokenizer(excludeString, " ,;");
        ArrayList<String> list = new ArrayList<String>();
        while (t.hasMoreTokens()) {
            list.add(t.nextToken());
        }
        excludes = list;
    }

    @OnThread(value=Tag.Any)
    static void addExcludesToRequest(StepRequest request) {
        for (String pattern : JdiThread.getExcludes()) {
            request.addClassExclusionFilter(pattern);
        }
    }

    @OnThread(value=Tag.Any)
    public JdiThread(JdiDebugger debugger, ThreadReference rt) {
        this.rt = rt;
        this.debugger = debugger;
        this.selectedFrame = 0;
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getName() {
        String name = null;
        try {
            name = this.rt.name();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    @Override
    @OnThread(value=Tag.VMEventHandler)
    public String getStatus() {
        try {
            if (this.rt.isAtBreakpoint()) {
                if (VMReference.isAtMainBreakpoint(this.rt)) {
                    return statusFinished;
                }
                return statusBreakpoint;
            }
            if (this.rt.isSuspended()) {
                return statusStopped;
            }
            int status = this.rt.status();
            switch (status) {
                case 3: {
                    return statusMonitor;
                }
                case 5: {
                    return statusNotStarted;
                }
                case 1: {
                    return statusRunning;
                }
                case 2: {
                    return statusSleeping;
                }
                case -1: {
                    return statusUnknown;
                }
                case 4: {
                    return statusWaiting;
                }
                case 0: {
                    return statusZombie;
                }
            }
        }
        catch (Exception e) {
            return "???";
        }
        return null;
    }

    @Override
    @OnThread(value=Tag.VMEventHandler)
    public synchronized boolean isSuspended() {
        return this.isSuspended;
    }

    @Override
    @OnThread(value=Tag.VMEventHandler)
    public boolean isAtBreakpoint() {
        return this.rt.isAtBreakpoint();
    }

    @Override
    @OnThread(value=Tag.VMEventHandler)
    public String getClass(int frameNo) {
        try {
            return this.rt.frame(frameNo).location().declaringType().name();
        }
        catch (Exception e) {
            return "<error finding type at frame " + frameNo + ">";
        }
    }

    @Override
    @OnThread(value=Tag.VMEventHandler)
    public String getClassSourceName(int frameNo) {
        try {
            return this.rt.frame(frameNo).location().sourceName();
        }
        catch (Exception e) {
            return "<no source at frame no " + frameNo + ">";
        }
    }

    @Override
    @OnThread(value=Tag.VMEventHandler)
    public int getLineNumber(int frameNo) {
        try {
            return this.rt.frame(frameNo).location().lineNumber();
        }
        catch (Exception e) {
            return 1;
        }
    }

    @Override
    @OnThread(value=Tag.Any)
    public boolean isKnownSystemThread() {
        try {
            ThreadGroupReference tgr = this.rt.threadGroup();
            if (tgr == null || !tgr.name().equals(MAIN_THREADGROUP)) {
                return true;
            }
            String name = this.rt.name();
            if (name.startsWith("AWT-Event") || name.equals("JavaFX Application Thread") || name.startsWith("WindowsNative")) {
                return false;
            }
            return name.startsWith("AWT-") || name.equals("DestroyJavaVM") || name.equals("BlueJ worker thread") || name.equals("Timer Queue") || name.equals("Screen Updater") || name.startsWith("SunToolkit.") || name.startsWith("Native Carbon") || name.equals("JavaFX-Launcher") || name.startsWith("QuantumRenderer") || name.equals("JavaFX BlueJ Helper") || name.equals("Java2D Disposer") || name.equals("InvokeLaterDispatcher");
        }
        catch (VMDisconnectedException vmde) {
            return false;
        }
        catch (ObjectCollectedException oce) {
            return true;
        }
    }

    @Override
    @OnThread(value=Tag.VMEventHandler)
    public List<SourceLocation> getStack() {
        return JdiThread.getStack(this.rt);
    }

    @OnThread(value=Tag.VMEventHandler)
    public static List<SourceLocation> getStack(ThreadReference thr) {
        block7: {
            try {
                if (!thr.isSuspended()) break block7;
                ArrayList<SourceLocation> stack = new ArrayList<SourceLocation>();
                List<StackFrame> frames = thr.frames();
                for (int i = 0; i < frames.size(); ++i) {
                    StackFrame f = frames.get(i);
                    Location loc = f.location();
                    String className = loc.declaringType().name();
                    String fileName = null;
                    try {
                        fileName = loc.sourceName();
                    }
                    catch (AbsentInformationException absentInformationException) {
                        // empty catch block
                    }
                    String methodName = loc.method().name();
                    int lineNumber = loc.lineNumber();
                    stack.add(new SourceLocation(className, fileName, methodName, lineNumber));
                }
                return stack;
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                // empty catch block
            }
        }
        return new ArrayList<SourceLocation>();
    }

    @Override
    @OnThread(value=Tag.VMEventHandler)
    public List<FXPlatformSupplier<VarDisplayInfo>> getLocalVariables(int frameNo) {
        block11: {
            try {
                LocalVariable var;
                int i;
                if (!this.rt.isSuspended()) break block11;
                StackFrame frame = this.rt.frame(frameNo);
                List<LocalVariable> vars = frame.visibleVariables();
                ArrayList<FXPlatformSupplier<VarDisplayInfo>> localVars = new ArrayList<FXPlatformSupplier<VarDisplayInfo>>();
                ArrayList<String> localVals = new ArrayList<String>();
                ArrayList<Type> localTypes = new ArrayList<Type>();
                ArrayList<String> genericSigs = new ArrayList<String>();
                ArrayList<String> typeNames = new ArrayList<String>();
                ReferenceType declaringType = frame.location().declaringType();
                for (i = 0; i < vars.size(); ++i) {
                    var = vars.get(i);
                    String val = JdiUtils.getJdiUtils().getValueString(frame.getValue(var));
                    localVals.add(val);
                    try {
                        localTypes.add(var.type());
                    }
                    catch (ClassNotLoadedException cnle) {
                        localTypes.add(null);
                    }
                    genericSigs.add(var.genericSignature());
                    typeNames.add(var.typeName());
                }
                for (i = 0; i < vars.size(); ++i) {
                    var = vars.get(i);
                    int iFinal = i;
                    FXPlatformSupplier<DebuggerObject> getObjectToInspect = this.varIsObject(frameNo, i) ? this.getStackObject(frameNo, iFinal) : null;
                    localVars.add(() -> {
                        JavaType vartype = JdiReflective.fromLocalVar((Type)localTypes.get(iFinal), (String)genericSigs.get(iFinal), (String)typeNames.get(iFinal), declaringType);
                        return new VarDisplayInfo(vartype, var, (String)localVals.get(iFinal), getObjectToInspect);
                    });
                }
                return localVars;
            }
            catch (IncompatibleThreadStateException frame) {
            }
            catch (AbsentInformationException frame) {
            }
            catch (VMDisconnectedException frame) {
            }
            catch (InvalidStackFrameException e) {
                try {
                    Thread.sleep(100L);
                    return this.getLocalVariables(frameNo);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return new ArrayList<FXPlatformSupplier<VarDisplayInfo>>();
    }

    @Override
    @OnThread(value=Tag.VMEventHandler)
    public boolean varIsObject(int frameNo, int index) {
        try {
            if (this.rt.isSuspended()) {
                StackFrame frame = this.rt.frame(frameNo);
                List<LocalVariable> vars = frame.visibleVariables();
                if (index >= vars.size()) {
                    return false;
                }
                LocalVariable var = vars.get(index);
                Value val = frame.getValue(var);
                return val instanceof ObjectReference;
            }
            return false;
        }
        catch (IncompatibleThreadStateException | InvalidStackFrameException frame) {
        }
        catch (Exception e) {
            Debug.reportError("could not get local variable info: " + e);
            e.printStackTrace(System.out);
        }
        return false;
    }

    @Override
    @OnThread(value=Tag.VMEventHandler)
    public FXPlatformSupplier<DebuggerObject> getStackObject(int frameNo, int index) {
        try {
            if (this.rt.isSuspended()) {
                StackFrame frame = this.rt.frame(frameNo);
                List<LocalVariable> vars = frame.visibleVariables();
                LocalVariable var = vars.get(index);
                FXPlatformSupplier<JavaType> vartype = JdiReflective.fromLocalVar(frame, var);
                ObjectReference val = (ObjectReference)frame.getValue(var);
                return () -> JdiObject.getDebuggerObject(val, (JavaType)vartype.get());
            }
            return null;
        }
        catch (Exception e) {
            Debug.reportError("could not get local variable info: " + e);
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    @OnThread(value=Tag.VMEventHandler)
    public DebuggerObject getStackObjectUntyped(int frameNo, int index) {
        try {
            if (this.rt.isSuspended()) {
                StackFrame frame = this.rt.frame(frameNo);
                List<LocalVariable> vars = frame.visibleVariables();
                LocalVariable var = vars.get(index);
                ObjectReference val = (ObjectReference)frame.getValue(var);
                return JdiObject.getDebuggerObject(val);
            }
            return null;
        }
        catch (Exception e) {
            Debug.reportError("could not get local variable info: " + e);
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    @OnThread(value=Tag.VMEventHandler)
    public DebuggerObject getCurrentObject(int frameNo) {
        try {
            if (this.rt.isSuspended()) {
                StackFrame frame = this.rt.frame(frameNo);
                return JdiObject.getDebuggerObject(frame.thisObject());
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            // empty catch block
        }
        return JdiObject.getDebuggerObject(null);
    }

    @Override
    @OnThread(value=Tag.VMEventHandler)
    public DebuggerClass getCurrentClass(int frameNo) {
        try {
            if (this.rt.isSuspended()) {
                StackFrame frame = this.rt.frame(frameNo);
                return new JdiClass(frame.location().declaringType());
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void setSelectedFrame(int frame) {
        this.selectedFrame = frame;
    }

    @Override
    public int getSelectedFrame() {
        return this.selectedFrame;
    }

    @Override
    @OnThread(value=Tag.VMEventHandler)
    public synchronized void halt() {
        try {
            if (!this.isSuspended) {
                this.rt.suspend();
                this.debugger.emitThreadHaltEvent(this);
                this.isSuspended = true;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    @Override
    @OnThread(value=Tag.VMEventHandler)
    public synchronized void cont() {
        try {
            if (this.isSuspended) {
                this.debugger.emitThreadResumedEvent(this);
                this.rt.resume();
                this.isSuspended = false;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.VMEventHandler)
    public void stopped() {
        JdiThread jdiThread = this;
        synchronized (jdiThread) {
            this.isSuspended = true;
        }
        this.clearPreviousStep(this.rt);
    }

    @Override
    @OnThread(value=Tag.VMEventHandler)
    public void step() {
        boolean doStepOver = true;
        try {
            Location loc = this.rt.frame(0).location();
            doStepOver = loc.codeIndex() != -1L;
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
        this.doStep(doStepOver ? 2 : 3);
    }

    @Override
    @OnThread(value=Tag.VMEventHandler)
    public void stepInto() {
        this.doStep(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.VMEventHandler)
    private void doStep(int depth) {
        this.clearPreviousStep(this.rt);
        this.stepRequest = this.eventReqMgr.createStepRequest(this.rt, -2, depth);
        JdiThread.addExcludesToRequest(this.stepRequest);
        this.stepRequest.addCountFilter(1);
        this.stepRequest.putProperty("dontResume", "yes");
        this.stepRequest.enable();
        JdiThread jdiThread = this;
        synchronized (jdiThread) {
            if (this.isSuspended) {
                this.debugger.emitThreadResumedEvent(this);
                this.rt.resume();
                this.isSuspended = false;
            }
        }
    }

    @OnThread(value=Tag.VMEventHandler)
    private void clearPreviousStep(ThreadReference thread) {
        if (this.eventReqMgr == null) {
            this.getEventRequestManager();
        }
        if (this.stepRequest != null) {
            this.eventReqMgr.deleteEventRequest(this.stepRequest);
            this.stepRequest = null;
        }
    }

    @OnThread(value=Tag.VMEventHandler)
    private void getEventRequestManager() {
        this.eventReqMgr = this.rt.virtualMachine().eventRequestManager();
    }

    @OnThread(value=Tag.VMEventHandler, ignoreParent=true)
    public @OnThread(value=Tag.VMEventHandler, ignoreParent=true) String toString() {
        try {
            return this.getName() + " (" + this.getStatus() + ")";
        }
        catch (ObjectCollectedException oce) {
            return "collected";
        }
    }

    @Override
    @OnThread(value=Tag.Any)
    public boolean sameThread(DebuggerThread dt) {
        if (dt != null && dt instanceof JdiThread) {
            return this.rt.uniqueID() == ((JdiThread)dt).rt.uniqueID();
        }
        return false;
    }

    @OnThread(value=Tag.Any)
    public boolean sameThread(ThreadReference threadReference) {
        if (threadReference != null) {
            return this.rt.uniqueID() == threadReference.uniqueID();
        }
        return false;
    }

    @OnThread(value=Tag.Any)
    public synchronized void contServerThread() {
        this.rt.resume();
        this.isSuspended = false;
    }
}

