/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.BlueJGuiHandler;
import bluej.Boot;
import bluej.Config;
import bluej.GuiHandler;
import bluej.collect.DataCollector;
import bluej.extensions2.event.ApplicationEvent;
import bluej.extensions2.event.ExtensionEvent;
import bluej.extmgr.ExtensionWrapper;
import bluej.extmgr.ExtensionsManager;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import de.codecentric.centerdevice.MenuToolkit;
import de.codecentric.centerdevice.dialogs.about.AboutStageBuilder;
import java.awt.Desktop;
import java.awt.desktop.QuitResponse;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.html.HTMLAnchorElement;
import threadchecker.OnThread;
import threadchecker.Tag;

public class Main {
    private static final String MESSAGE_ROOT = "https://www.bluej.org/message/";
    private static final String TESTING_MESSAGE_ROOT = "https://www.bluej.org/message_test/";
    private static boolean launched = false;
    private static List<File> initialProjects;
    private static QuitResponse macEventResponse;
    private static ClassLoader storedContextClassLoader;
    private static GuiHandler guiHandler;

    @OnThread(value=Tag.Any)
    public Main(ClassLoader runtimeClassLoader) {
        Boot boot = Boot.getInstance();
        String[] args = Boot.cmdLineArgs;
        Properties commandLineProps = boot.getCommandLineProperties();
        File bluejLibDir = Boot.getBluejLibDir();
        Config.initialise(bluejLibDir, commandLineProps, boot.isGreenfoot());
        CompletableFuture futureMainWindow = new CompletableFuture();
        if (!Config.isGreenfoot()) {
            new Thread(() -> Main.fetchAndShowCentralMsg(PrefMgr.getFlag("bluej.news.testing") ? TESTING_MESSAGE_ROOT : MESSAGE_ROOT, futureMainWindow), "Fetching news message").start();
        }
        if (guiHandler == null) {
            if (Config.isGreenfoot()) {
                try {
                    guiHandler = (GuiHandler)runtimeClassLoader.loadClass("greenfoot.guifx.GreenfootGuiHandler").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    Debug.reportError(e);
                }
            } else {
                guiHandler = new BlueJGuiHandler();
            }
        }
        if (Config.isMacOS()) {
            Main.prepareMacOSApp();
        }
        Platform.runLater(() -> {
            List<ExtensionWrapper> loadedExtensions = ExtensionsManager.getInstance().getLoadedExtensions(null);
            DataCollector.bluejOpened(Main.getOperatingSystem(), Main.getJavaVersion(), Main.getBlueJVersion(), Main.getInterfaceLanguage(), loadedExtensions);
            Stage stage = Main.processArgs(args);
            futureMainWindow.complete(stage);
        });
        new Thread("Updating central stats"){

            @Override
            public void run() {
                Main.updateStats();
            }
        }.start();
    }

    @OnThread(value=Tag.FXPlatform)
    private static Stage processArgs(String[] args) {
        boolean openOrphans;
        launched = true;
        boolean oneOpened = false;
        if (args.length > 0) {
            for (String arg : args) {
                if (arg.startsWith("-")) continue;
                oneOpened |= guiHandler.tryOpen(new File(arg), true);
            }
        }
        if (initialProjects != null) {
            for (File initialProject : initialProjects) {
                oneOpened |= guiHandler.tryOpen(initialProject, true);
            }
        }
        if (!oneOpened && (openOrphans = "true".equals(Config.getPropString("bluej.autoOpenLastProject"))) && Main.hadOrphanPackages()) {
            String exists = "";
            int i = 1;
            while (exists != null) {
                exists = Config.getPropString("bluej.openPackage" + i, null);
                if (exists != null) {
                    oneOpened |= guiHandler.tryOpen(new File(exists), false);
                }
                ++i;
            }
        }
        Stage window = guiHandler.initialOpenComplete(oneOpened);
        Boot.getInstance().disposeSplashWindow();
        ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)new ApplicationEvent(ApplicationEvent.EventType.APP_READY_EVENT));
        return window;
    }

    private static void prepareMacOSApp() {
        storedContextClassLoader = Thread.currentThread().getContextClassLoader();
        initialProjects = Boot.getMacInitialProjects();
        Main.prepareMacOSMenuSwing();
        Main.prepareMacOSMenuFX();
        if (Config.isGreenfoot()) {
            Debug.message("Disabling App Nap");
            try {
                Runtime.getRuntime().exec("defaults write org.greenfoot NSAppSleepDisabled -bool YES");
            }
            catch (IOException e) {
                Debug.reportError("Error disabling App Nap", e);
            }
        }
    }

    private static void prepareMacOSMenuFX() {
        Platform.runLater(() -> {
            FXMLLoader.setDefaultClassLoader((ClassLoader)AboutStageBuilder.class.getClassLoader());
            MenuToolkit menuToolkit = MenuToolkit.toolkit();
            Menu defaultApplicationMenu = menuToolkit.createDefaultApplicationMenu(Config.getApplicationName());
            menuToolkit.setApplicationMenu(defaultApplicationMenu);
            ((MenuItem)defaultApplicationMenu.getItems().get(0)).setOnAction(event -> guiHandler.handleAbout());
            MenuItem preferences = new MenuItem(Config.getString("menu.tools.preferences"));
            if (Config.hasAcceleratorKey("menu.tools.preferences")) {
                preferences.setAccelerator(Config.getAcceleratorKeyFX("menu.tools.preferences"));
            }
            preferences.setOnAction(event -> guiHandler.handlePreferences());
            defaultApplicationMenu.getItems().add(1, (Object)preferences);
            ((MenuItem)defaultApplicationMenu.getItems().get(defaultApplicationMenu.getItems().size() - 1)).setOnAction(event -> guiHandler.handleQuit());
        });
    }

    private static void prepareMacOSMenuSwing() {
        Desktop.getDesktop().setAboutHandler(e -> Platform.runLater(() -> guiHandler.handleAbout()));
        Desktop.getDesktop().setPreferencesHandler(e -> Platform.runLater(() -> guiHandler.handlePreferences()));
        Desktop.getDesktop().setQuitHandler((e, response) -> {
            macEventResponse = response;
            Platform.runLater(() -> guiHandler.handleQuit());
        });
        Desktop.getDesktop().setOpenFileHandler(e -> {
            if (launched) {
                List<File> files = e.getFiles();
                Platform.runLater(() -> {
                    for (File file : files) {
                        guiHandler.tryOpen(file, true);
                    }
                });
            } else {
                initialProjects = e.getFiles();
            }
        });
        Boot.getInstance().setQuitHandler(() -> Platform.runLater(() -> guiHandler.handleQuit()));
    }

    @OnThread(value=Tag.FXPlatform)
    public static void wantToQuit() {
        int answer;
        int projectCount = Project.getOpenProjectCount();
        int n = answer = projectCount <= 1 ? 0 : DialogManager.askQuestionFX(null, "quit-all");
        if (answer == 0) {
            Main.doQuit();
        } else {
            SwingUtilities.invokeLater(() -> {
                if (macEventResponse != null) {
                    macEventResponse.cancelQuit();
                    macEventResponse = null;
                }
            });
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public static void doQuit() {
        guiHandler.doExitCleanup();
        ExtensionsManager extMgr = ExtensionsManager.getInstance();
        extMgr.unloadExtensions();
        Main.exit();
    }

    public static boolean hadOrphanPackages() {
        String dir = "";
        int i = 1;
        while (dir != null) {
            dir = Config.getPropString("bluej.openPackage" + i, null);
            if (dir != null && Project.isProject(dir)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void updateStats() {
        String appVersion;
        String baseURL;
        String uidPropName;
        if (Config.isGreenfoot()) {
            uidPropName = "greenfoot.uid";
            baseURL = "http://stats.greenfoot.org/updateGreenfoot.php";
            appVersion = Boot.GREENFOOT_VERSION;
        } else {
            uidPropName = "bluej.uid";
            baseURL = "http://stats.bluej.org/updateBlueJ.php";
            appVersion = Main.getBlueJVersion();
        }
        String language = Main.getInterfaceLanguage();
        String javaVersion = Main.getJavaVersion();
        String systemID = Main.getOperatingSystem();
        Object editorStats = "";
        int javaEditors = Config.getEditorCount(Config.SourceType.Java);
        int strideEditors = Config.getEditorCount(Config.SourceType.Stride);
        try {
            if (javaEditors != -1 && strideEditors != -1) {
                editorStats = "&javaeditors=" + URLEncoder.encode(Integer.toString(javaEditors), "UTF-8") + "&strideeditors=" + URLEncoder.encode(Integer.toString(strideEditors), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException ex) {
            Debug.reportError(ex);
        }
        Config.resetEditorsCount();
        String uid = Config.getPropString(uidPropName, null);
        if (uid == null) {
            uid = UUID.randomUUID().toString();
            Config.putPropString(uidPropName, uid);
        } else if (uid.equalsIgnoreCase("private")) {
            return;
        }
        try {
            URL url = new URL(baseURL + "?uid=" + URLEncoder.encode(uid, "UTF-8") + "&osname=" + URLEncoder.encode(systemID, "UTF-8") + "&appversion=" + URLEncoder.encode(appVersion, "UTF-8") + "&javaversion=" + URLEncoder.encode(javaVersion, "UTF-8") + "&language=" + URLEncoder.encode(language, "UTF-8") + (String)editorStats);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            int rc = conn.getResponseCode();
            conn.disconnect();
            if (rc != 200) {
                Debug.reportError("Update stats failed, HTTP response code: " + rc);
            }
        }
        catch (Exception ex) {
            Debug.reportError("Update stats failed: " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    private static String getBlueJVersion() {
        return "5.0.2a";
    }

    private static String getOperatingSystem() {
        Object osArch = System.getProperty("os.arch");
        if (Config.isWinOS()) {
            String arch = System.getenv("PROCESSOR_ARCHITECTURE");
            String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
            osArch = (String)osArch + (arch != null && arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64") ? "(64)" : "");
        }
        return System.getProperty("os.name") + "/" + (String)osArch + "/" + System.getProperty("os.version");
    }

    private static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    private static String getInterfaceLanguage() {
        return Config.language;
    }

    @OnThread(value=Tag.FXPlatform)
    private static void exit() {
        DataCollector.bluejClosed();
        Config.handleExit();
        JavaFXUtil.runAfterCurrent(() -> SwingUtilities.invokeLater(() -> System.exit(0)));
    }

    public static ClassLoader getStoredContextClassLoader() {
        return storedContextClassLoader;
    }

    public static void setGuiHandler(GuiHandler initialGUI) {
        guiHandler = initialGUI;
    }

    private static void fetchAndShowCentralMsg(String messageRoot, CompletableFuture<Stage> withStage) {
        try {
            Scanner scanner = new Scanner(new URL(messageRoot + "latest.txt").openStream(), "UTF-8").useDelimiter("\n");
            LocalDate startDate = LocalDate.parse(scanner.nextLine());
            LocalDate endDate = LocalDate.parse(scanner.nextLine());
            LocalDate lastSeen = null;
            try {
                lastSeen = LocalDate.parse(Config.getPropString("bluej.latest.msg"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean seenMessage = lastSeen != null && (startDate.isBefore(lastSeen) || startDate.isEqual(lastSeen));
            boolean expired = LocalDate.now().isAfter(endDate);
            if (!seenMessage && !expired) {
                Platform.runLater(() -> {
                    WebView webView = new WebView();
                    FXPlatformRunnable preventTimeout = JavaFXUtil.runAfter(Duration.seconds((double)5.0), () -> webView.getEngine().getLoadWorker().cancel());
                    AtomicBoolean shownWindow = new AtomicBoolean(false);
                    JavaFXUtil.addChangeListener(webView.getEngine().getLoadWorker().stateProperty(), state -> {
                        if (state == Worker.State.SUCCEEDED && !shownWindow.get()) {
                            shownWindow.set(true);
                            JavaFXUtil.runNowOrLater(() -> {
                                preventTimeout.run();
                                Main.makeLinksOpenExternally(webView.getEngine().getDocument());
                            });
                            withStage.handle((parent, error) -> {
                                if (parent != null) {
                                    JavaFXUtil.runNowOrLater(() -> Main.showMessageWindow(startDate, webView, parent));
                                }
                                return null;
                            });
                        }
                    });
                    webView.getEngine().load(messageRoot + startDate.toString() + ".html");
                });
            }
        }
        catch (MalformedURLException e) {
            Debug.reportError(e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void makeLinksOpenExternally(Document document) {
        NodeList nodeList = document.getElementsByTagName("a");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            org.w3c.dom.Node node = nodeList.item(i);
            EventTarget eventTarget = (EventTarget)((Object)node);
            eventTarget.addEventListener("click", new EventListener(){

                @Override
                public void handleEvent(Event evt) {
                    EventTarget target = evt.getCurrentTarget();
                    HTMLAnchorElement anchorElement = (HTMLAnchorElement)((Object)target);
                    String href = anchorElement.getHref();
                    SwingUtilities.invokeLater(() -> Utility.openWebBrowser(href));
                    evt.preventDefault();
                }
            }, false);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private static void showMessageWindow(LocalDate startDate, WebView webView, Stage parent) {
        Stage window = new Stage();
        window.initModality(Modality.WINDOW_MODAL);
        window.initOwner((Window)parent);
        window.setTitle(Config.getString("bluej.central.msg.title"));
        Button button = new Button(Config.getString("okay"));
        button.setDefaultButton(true);
        button.setOnAction(e -> window.hide());
        window.setOnHidden(e -> Config.recordLatestSeen(startDate));
        BorderPane.setAlignment((Node)button, (Pos)Pos.CENTER);
        BorderPane.setMargin((Node)button, (Insets)new Insets(15.0));
        BorderPane.setMargin((Node)webView, (Insets)new Insets(10.0));
        webView.setPrefWidth(650.0);
        webView.setPrefHeight(400.0);
        window.setScene(new Scene((Parent)new BorderPane((Node)webView, null, null, (Node)button, null)));
        window.show();
        window.toFront();
    }

    static {
        macEventResponse = null;
        guiHandler = null;
    }
}

