/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.SplashWindow;
import com.sun.glass.ui.Application;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import threadchecker.OnThread;
import threadchecker.Tag;

public class Boot {
    public static final int BLUEJ_VERSION_MAJOR = 5;
    public static final int BLUEJ_VERSION_MINOR = 0;
    public static final int BLUEJ_VERSION_RELEASE = 2;
    public static final String BLUEJ_VERSION_SUFFIX = "a";
    public static final String BLUEJ_VERSION = "5.0.2a";
    public static final String BLUEJ_VERSION_TITLE = "BlueJ 5.0.2a";
    private static final int bluejBuildJars = 3;
    private static final String[] bluejUserJars = new String[]{"bluejcore.jar", "junit-*.jar", "hamcrest-core-1.3.jar", "hamcrest-library-1.3.jar", "lang-stride.jar"};
    private static final int bluejUserBuildJars = 1;
    private static final String JLAYER_MP3_JAR = "jl1.0.1.jar";
    public static final String[] GREENFOOT_EXPORT_JARS = new String[]{"jl1.0.1.jar", "lang-stride.jar"};
    private static final String[] greenfootUserJars = new String[]{"greenfoot.jar", "bluejcore.jar", "bluejeditor.jar", "bluejext2.jar", "junit-*.jar", "hamcrest-core-1.3.jar", "hamcrest-library-1.3.jar", "bluej.jar", "classgraph-4.8.90.jar", "diffutils-1.2.1.jar", "commons-logging-api-1.1.2.jar", "jl1.0.1.jar", "opencsv-2.3.jar", "xom-1.2.9.jar", "lang-stride.jar", "nsmenufx-2.1.8.jar", "richtextfx-fat-0.9.0.jar", "guava-17.0.jar", "httpclient-4.1.1.jar", "httpcore-4.1.jar", "httpmime-4.1.1.jar"};
    private static final int greenfootUserBuildJars = 4;
    public static String GREENFOOT_VERSION = "3.7.0";
    public static String GREENFOOT_API_VERSION = "3.0.0";
    private static Boot instance;
    private static final String[] bluejJars;
    private static String[] runtimeJars;
    private static String[] userJars;
    private static int numBuildJars;
    private static int numUserBuildJars;
    private static String[] javafxJars;
    private static boolean isGreenfoot;
    private static File bluejLibDir;
    private static final ArrayList<File> macInitialProjects;
    private @OnThread(value=Tag.FXPlatform) SplashWindow splashWindow;
    public static String[] cmdLineArgs;
    private final Properties commandLineProps;
    private File javaHomeDir;
    private ClassLoader bootLoader;
    private URL[] runtimeUserClassPath;
    private URL[] runtimeClassPath;
    private Runnable quitAction;

    private Boot(Properties props, FXPlatformSupplier<Image> image) {
        CompletableFuture shown = new CompletableFuture();
        Platform.runLater(() -> {
            this.splashWindow = new SplashWindow((Image)image.get());
            shown.complete(true);
        });
        try {
            shown.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
        this.commandLineProps = props;
    }

    public static void main(String[] args) {
        cmdLineArgs = args;
        javafx.application.Application.launch(App.class, (String[])args);
    }

    public static List<File> getMacInitialProjects() {
        return macInitialProjects;
    }

    public URL[] getJavaFXClassPath() {
        String javafxJarsProp = this.commandLineProps.getProperty("javafxjars", null);
        if (javafxJarsProp != null) {
            return (URL[])Arrays.stream(javafxJarsProp.split(":")).map(s -> {
                try {
                    return new File((String)s).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(URL[]::new);
        }
        File javafxLibPath = this.getJavaFXLibDir();
        URL[] urls = new URL[javafxJars.length];
        for (int i = 0; i < javafxJars.length; ++i) {
            try {
                urls[i] = new File(javafxLibPath, javafxJars[i]).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return urls;
    }

    public File getJavaFXLibDir() {
        String javafxPathProp = this.commandLineProps.getProperty("javafxpath", null);
        File javafxPath = javafxPathProp != null ? new File(javafxPathProp) : new File(Boot.getBluejLibDir(), "javafx");
        return new File(javafxPath, "lib");
    }

    public File getJavaFXSourcePath() {
        File javafxLibPath = this.getJavaFXLibDir();
        File javafxSrcPath = new File(javafxLibPath, "src.zip");
        return javafxSrcPath;
    }

    @OnThread(value=Tag.Any)
    public static void subMain() {
        Properties commandLineProps = Boot.processCommandLineProperties(cmdLineArgs);
        isGreenfoot = commandLineProps.getProperty("greenfoot", "false").equals("true");
        FXPlatformSupplier<Image> image = new FXPlatformSupplier<Image>(){

            @Override
            @OnThread(value=Tag.FXPlatform)
            public Image get() {
                URL url = Boot.class.getResource(isGreenfoot ? "gen-greenfoot-splash.png" : "gen-bluej-splash.png");
                if (url != null) {
                    return new Image(url.toString());
                }
                WritableImage writableImage = new WritableImage(500, 300);
                int y = 0;
                while ((double)y < writableImage.getHeight()) {
                    int x = 0;
                    while ((double)x < writableImage.getWidth()) {
                        writableImage.getPixelWriter().setColor(x, y, Color.WHITE);
                        ++x;
                    }
                    ++y;
                }
                return writableImage;
            }
        };
        if (isGreenfoot) {
            runtimeJars = greenfootUserJars;
            userJars = greenfootUserJars;
            numBuildJars = 4;
            numUserBuildJars = 4;
        }
        try {
            instance = new Boot(commandLineProps, image);
            instance.bootBluej();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
        Boot boot = instance;
        synchronized (boot) {
            while (true) {
                try {
                    while (true) {
                        instance.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public static Boot getInstance() {
        return instance;
    }

    public static File getBluejLibDir() {
        if (bluejLibDir == null) {
            bluejLibDir = Boot.calculateBluejLibDir();
        }
        return bluejLibDir;
    }

    private static File calculateBluejLibDir() {
        File bluejDir = null;
        String bootFullName = Boot.class.getResource("Boot.class").toString();
        try {
            if (!bootFullName.startsWith("jar:")) {
                File startingDir;
                for (startingDir = new File(new URI(bootFullName)).getParentFile(); startingDir != null && !new File(startingDir.getParentFile(), "lib").isDirectory(); startingDir = startingDir.getParentFile()) {
                }
                bluejDir = startingDir == null ? null : new File(startingDir.getParentFile(), "lib");
            } else {
                int classIndex = bootFullName.indexOf("!");
                String bootName = bootFullName.substring(4, classIndex);
                File finalFile = new File(new URI(bootName));
                bluejDir = finalFile.getParentFile();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return bluejDir;
    }

    public static URL getJREJar(String name) throws MalformedURLException {
        String jrePathName = System.getProperty("java.home");
        if (jrePathName != null) {
            File jrePath = new File(jrePathName);
            if (jrePath.canRead()) {
                File jarPath = new File(jrePath, "lib/" + name);
                if (jarPath.canRead()) {
                    return jarPath.toURI().toURL();
                }
                System.err.println("Could not find " + name + " at: " + jarPath.getAbsolutePath());
            } else {
                System.err.println("Could not find JRE at: " + jrePath.getAbsolutePath());
            }
        } else {
            System.err.println("Could not find Java path");
        }
        return null;
    }

    private static Properties processCommandLineProperties(String[] args) {
        Properties props = new Properties();
        for (String arg : args) {
            String definition;
            int definitionEquals;
            if (!arg.startsWith("-") || (definitionEquals = (definition = arg.substring(1)).indexOf(61)) < 0) continue;
            String propName = definition.substring(0, definitionEquals);
            String propValue = definition.substring(definitionEquals + 1);
            if (propName.equals("") || propValue.equals("")) continue;
            props.put(propName, propValue);
        }
        return props;
    }

    public static boolean isTrialRecording() {
        return false;
    }

    public void disposeSplashWindow() {
        Platform.runLater(() -> {
            if (this.splashWindow != null) {
                this.splashWindow.hide();
                this.splashWindow = null;
            }
        });
    }

    public boolean isGreenfoot() {
        return isGreenfoot;
    }

    public File getJavaHome() {
        return this.javaHomeDir;
    }

    public URL[] getRuntimeClassPath() {
        return this.runtimeClassPath;
    }

    public URL[] getRuntimeUserClassPath() {
        return this.runtimeUserClassPath;
    }

    public ClassLoader getBootClassLoader() {
        return this.bootLoader;
    }

    @OnThread(value=Tag.Any)
    private void bootBluej() {
        this.initializeBoot();
        try {
            URLClassLoader runtimeLoader = new URLClassLoader(this.runtimeClassPath, this.bootLoader);
            Class<?> mainClass = Class.forName("bluej.Main", true, runtimeLoader);
            mainClass.getDeclaredConstructor(ClassLoader.class).newInstance(runtimeLoader);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exc) {
            throw new RuntimeException(exc);
        }
    }

    private void initializeBoot() {
        this.bootLoader = this.getClass().getClassLoader();
        this.javaHomeDir = new File(System.getProperty("java.home"));
        try {
            this.runtimeClassPath = this.getKnownJars(Boot.getBluejLibDir(), runtimeJars, false, numBuildJars);
            this.runtimeUserClassPath = this.getKnownJars(Boot.getBluejLibDir(), userJars, true, numUserBuildJars);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private URL[] getKnownJars(File libDir, String[] jars, boolean isForUserVM, int numBuildJars) throws MalformedURLException {
        File classesDir;
        boolean useClassesDir = this.commandLineProps.getProperty("useclassesdir", "false").equals("true");
        int startJar = 0;
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (numBuildJars != 0 && useClassesDir && (classesDir = new File(libDir.getParentFile(), "classes")).isDirectory()) {
            String gfClassesDir;
            urlList.add(classesDir.toURI().toURL());
            urlList.add(new File(libDir.getParentFile(), "threadchecker/classes").toURI().toURL());
            if (isGreenfoot && (gfClassesDir = this.commandLineProps.getProperty("greenfootclassesdir")) != null) {
                classesDir = new File(gfClassesDir);
                urlList.add(classesDir.toURI().toURL());
            }
            startJar = numBuildJars;
        }
        for (int i = startJar; i < jars.length; ++i) {
            File[] filesToAdd;
            if (!jars[i].contains("*")) {
                filesToAdd = new File[]{new File(libDir, jars[i])};
            } else {
                File dir = new File(libDir.getPath());
                String[] beforeAfter = jars[i].split("\\*");
                FileFilter fileFilter = f -> f.getName().startsWith(beforeAfter[0]) && f.getName().endsWith(beforeAfter[1]);
                filesToAdd = dir.listFiles(fileFilter);
            }
            for (File toAdd : filesToAdd) {
                if (!toAdd.canRead()) continue;
                urlList.add(toAdd.toURI().toURL());
            }
        }
        if (isForUserVM) {
            urlList.addAll(Arrays.asList(this.getJavaFXClassPath()));
        }
        return urlList.toArray(new URL[0]);
    }

    public Properties getCommandLineProperties() {
        return this.commandLineProps;
    }

    public void setQuitHandler(Runnable quitAction) {
        this.quitAction = quitAction;
    }

    static {
        bluejJars = new String[]{"bluejcore.jar", "bluejeditor.jar", "bluejext2.jar", "classgraph-4.8.90.jar", "commons-logging-api-1.1.2.jar", "diffutils-1.2.1.jar", "guava-17.0.jar", "hamcrest-core-1.3.jar", "hamcrest-library-1.3.jar", "httpclient-4.1.1.jar", "httpcore-4.1.jar", "httpmime-4.1.1.jar", "jsch-0.1.53.jar", "junit-*.jar", "lang-stride.jar", "nsmenufx-2.1.8.jar", "org.eclipse.jgit-4.9.0.jar", "richtextfx-fat-0.9.0.jar", "slf4j-api-1.7.2.jar", "slf4j-jdk14-1.7.2.jar", "xom-1.2.9.jar"};
        runtimeJars = bluejJars;
        userJars = bluejUserJars;
        numBuildJars = 3;
        numUserBuildJars = 1;
        javafxJars = new String[]{"javafx.base.jar", "javafx.controls.jar", "javafx.fxml.jar", "javafx.graphics.jar", "javafx.media.jar", "javafx.properties.jar", "javafx.swing.jar", "javafx.web.jar"};
        isGreenfoot = false;
        macInitialProjects = new ArrayList();
    }

    public static class App
    extends javafx.application.Application {
        public App() {
            if (System.getProperty("os.name").contains("OS X")) {
                Application glassApp = Application.GetApplication();
                glassApp.setEventHandler(new Application.EventHandler(){

                    public void handleOpenFilesAction(Application app, long time, String[] files) {
                        for (String f : files) {
                            if (f.contains(":") || f.equals("bluej.Boot") || f.startsWith("-")) continue;
                            macInitialProjects.add(new File(f));
                        }
                        super.handleOpenFilesAction(app, time, files);
                    }

                    public void handleQuitAction(Application app, long time) {
                        Boot.getInstance().quitAction.run();
                        super.handleQuitAction(app, time);
                    }
                });
            }
        }

        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        public void start(Stage s) throws Exception {
            Platform.setImplicitExit((boolean)false);
            s.setTitle("BlueJ");
            new Thread(() -> Boot.subMain(), "subMain thread").start();
        }
    }

    @FunctionalInterface
    private static interface FXPlatformSupplier<T> {
        @OnThread(value=Tag.FXPlatform)
        public T get();
    }
}

