/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.ValuesOf;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;

public class EnumGenerator
extends Generator<Enum> {
    private final Class<?> enumType;
    private ValuesOf turnOffRandomness;

    public EnumGenerator(Class<?> enumType) {
        super(Enum.class);
        this.enumType = enumType;
    }

    public void configure(ValuesOf flag) {
        this.turnOffRandomness = flag;
    }

    @Override
    public Enum<?> generate(SourceOfRandomness random, GenerationStatus status) {
        ?[] values = this.enumType.getEnumConstants();
        int index = this.turnOffRandomness == null ? random.nextInt(0, values.length - 1) : status.attempts() % values.length;
        return (Enum)values[index];
    }

    @Override
    public boolean canShrink(Object larger) {
        return this.enumType.isInstance(larger);
    }
}

