/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.Config;
import bluej.editor.stride.FXTab;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.TabMenuManager;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.EditableTarget;
import bluej.testmgr.TestDisplayFrame;
import bluej.utility.Utility;
import bluej.utility.javafx.JavaFXUtil;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.web.WebView;
import javafx.stage.Popup;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventTarget;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FX)
public class WebTab
extends FXTab {
    private final WebView browser;
    private final boolean tutorial;
    private FXTabbedEditor parent;
    private final TabMenuManager menuManager;
    private final WeakHashMap<Project, OverlayInfo> tutorialOverlays = new WeakHashMap();

    @OnThread(value=Tag.FXPlatform)
    public WebTab(String url, boolean enableTutorial) {
        super(false);
        this.browser = new WebView();
        this.tutorial = enableTutorial;
        if (enableTutorial) {
            this.setClosable(false);
            JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.browser.getEngine().documentProperty(), this::tutorialDocumentMangle);
        }
        this.browser.getEngine().load(url);
        this.browser.getEngine().setCreatePopupHandler(p -> {
            WebTab newTab = new WebTab(null, enableTutorial);
            this.parent.addTab(newTab, true, true);
            return newTab.browser.getEngine();
        });
        this.setGraphic(this.getWebIcon());
        this.setContent((Node)this.browser);
        this.textProperty().bind((ObservableValue)this.browser.getEngine().titleProperty());
        this.menuManager = new TabMenuManager(this){
            final List<Menu> menus;
            {
                this.menus = Collections.singletonList(JavaFXUtil.makeMenu((String)Config.getString((String)"frame.webmenu.title"), (MenuItem[])new MenuItem[]{this.mainMoveMenu, JavaFXUtil.makeMenuItem((String)Config.getString((String)"frame.webmenu.open.external"), () -> {
                    String location = WebTab.this.browser.getEngine().getLocation();
                    SwingUtilities.invokeLater(() -> Utility.openWebBrowser((String)location));
                }, (KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN})), JavaFXUtil.makeMenuItem((String)Config.getString((String)"frame.classmenu.close"), () -> this.tab.getParent().close(this.tab), (KeyCombination)new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}))}));
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            List<Menu> getMenus() {
                this.updateMoveMenus();
                return this.menus;
            }
        };
    }

    private Node getWebIcon() {
        Label j = new Label("W");
        JavaFXUtil.addStyleClass((Styleable)j, (String[])new String[]{"icon-label"});
        return j;
    }

    @Override
    void focusWhenShown() {
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    List<Menu> getMenus() {
        return this.menuManager.getMenus();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    String getWebAddress() {
        return this.browser.getEngine().getLocation();
    }

    @Override
    void initialiseFX() {
    }

    @Override
    void setParent(FXTabbedEditor parent, boolean partOfMove) {
        this.parent = parent;
    }

    @Override
    FXTabbedEditor getParent() {
        return this.parent;
    }

    @Override
    ObservableStringValue windowTitleProperty() {
        return this.textProperty();
    }

    @Override
    public void notifySelected() {
    }

    @Override
    public void notifyUnselected() {
    }

    @Override
    public boolean isTutorial() {
        return this.tutorial;
    }

    @OnThread(value=Tag.FXPlatform)
    private void tutorialDocumentMangle(Document doc) {
        if (doc != null) {
            NodeList anchors = doc.getElementsByTagName("a");
            for (int i = 0; i < anchors.getLength(); ++i) {
                org.w3c.dom.Node anchorItem = anchors.item(i);
                org.w3c.dom.Node anchorHref = anchorItem.getAttributes().getNamedItem("href");
                if (anchorHref == null || anchorHref.getNodeValue() == null) continue;
                if (anchorHref.getNodeValue().startsWith("class:")) {
                    ((EventTarget)((Object)anchorItem)).addEventListener("click", e -> {
                        ((EditableTarget)this.parent.getProject().getTarget(anchorHref.getNodeValue().substring("class:".length()).trim())).getEditor().setEditorVisible(true, false);
                        e.stopPropagation();
                    }, true);
                    continue;
                }
                if (!anchorHref.getNodeValue().startsWith("guicss:")) continue;
                ((EventTarget)((Object)anchorItem)).addEventListener("click", e -> {
                    Stage targetWindow;
                    String nodeCSS;
                    OverlayInfo prevOverlay = this.tutorialOverlays.get(this.parent.getProject());
                    if (prevOverlay != null) {
                        prevOverlay.hide();
                    }
                    if ((nodeCSS = anchorHref.getNodeValue().substring("guicss:".length())).startsWith("Terminal")) {
                        targetWindow = this.parent.getProject().getTerminal().getWindow();
                        nodeCSS = nodeCSS.substring("Terminal".length());
                    } else if (nodeCSS.startsWith("Editor")) {
                        targetWindow = this.parent.getProject().getDefaultFXTabbedEditor().getStage();
                        nodeCSS = nodeCSS.substring("Editor".length());
                    } else if (nodeCSS.startsWith("TestResults")) {
                        targetWindow = TestDisplayFrame.getTestDisplay().getWindow();
                        nodeCSS = nodeCSS.substring("TestResults".length());
                    } else {
                        targetWindow = this.parent.getProject().getPackage("").getEditor().getFXWindow();
                    }
                    Node n = targetWindow.getScene().lookup(nodeCSS);
                    if (n != null) {
                        Bounds screenBounds = n.localToScreen(n.getBoundsInLocal());
                        Rectangle[] rects = new Rectangle[]{new Rectangle(screenBounds.getWidth() + 20.0, 5.0), new Rectangle(5.0, screenBounds.getHeight() + 20.0), new Rectangle(screenBounds.getWidth() + 20.0, 5.0), new Rectangle(5.0, screenBounds.getHeight() + 20.0)};
                        Popup[] overlays = new Popup[4];
                        for (int j = 0; j < 4; ++j) {
                            rects[j].setFill((Paint)Color.RED);
                            overlays[j] = new Popup();
                            overlays[j].getContent().setAll((Object[])new Node[]{rects[j]});
                        }
                        overlays[0].show((Window)targetWindow, screenBounds.getMinX() - 10.0, screenBounds.getMinY() - 10.0);
                        overlays[1].show((Window)targetWindow, screenBounds.getMaxX() + 5.0, screenBounds.getMinY() - 10.0);
                        overlays[2].show((Window)targetWindow, screenBounds.getMinX() - 10.0, screenBounds.getMaxY() + 5.0);
                        overlays[3].show((Window)targetWindow, screenBounds.getMinX() - 10.0, screenBounds.getMinY() - 10.0);
                        OverlayInfo overlayInfo = new OverlayInfo((Window)targetWindow, n, overlays);
                        this.tutorialOverlays.put(this.parent.getProject(), overlayInfo);
                        Utility.bringToFrontFX((Window)targetWindow);
                        targetWindow.requestFocus();
                    }
                    e.stopPropagation();
                }, true);
            }
        }
    }

    private static class OverlayInfo
    implements EventHandler<MouseEvent>,
    ChangeListener<Object> {
        private final Popup[] overlays;
        private final Node target;
        private final Window targetWindow;

        public OverlayInfo(Window targetWindow, Node target, Popup[] overlays) {
            this.targetWindow = targetWindow;
            this.target = target;
            this.overlays = overlays;
            target.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)this);
            targetWindow.focusedProperty().addListener((ChangeListener)this);
            targetWindow.xProperty().addListener((ChangeListener)this);
            targetWindow.yProperty().addListener((ChangeListener)this);
            targetWindow.widthProperty().addListener((ChangeListener)this);
            targetWindow.heightProperty().addListener((ChangeListener)this);
        }

        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        public void handle(MouseEvent event) {
            this.hide();
        }

        @OnThread(value=Tag.FXPlatform)
        public void hide() {
            for (Popup overlay : this.overlays) {
                overlay.hide();
            }
            this.target.removeEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)this);
            this.targetWindow.focusedProperty().removeListener((ChangeListener)this);
            this.targetWindow.xProperty().removeListener((ChangeListener)this);
            this.targetWindow.yProperty().removeListener((ChangeListener)this);
            this.targetWindow.widthProperty().removeListener((ChangeListener)this);
            this.targetWindow.heightProperty().removeListener((ChangeListener)this);
        }

        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
            if (observable == this.targetWindow.focusedProperty() && !((Boolean)newValue).booleanValue()) {
                this.hide();
            }
            if (observable == this.targetWindow.xProperty() || observable == this.targetWindow.yProperty() || observable == this.targetWindow.widthProperty() || observable == this.targetWindow.heightProperty()) {
                this.hide();
            }
        }
    }
}

