/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.Config;
import bluej.collect.StrideEditReason;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.debugger.DebuggerThread;
import bluej.editor.fixes.SuggestionList;
import bluej.editor.stride.BirdseyeManager;
import bluej.editor.stride.BorderPaneWithHighlightColor;
import bluej.editor.stride.CodeOverlayPane;
import bluej.editor.stride.CursorOrSlot;
import bluej.editor.stride.ErrorOverviewBar;
import bluej.editor.stride.FXTab;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.FrameCatalogue;
import bluej.editor.stride.FrameEditor;
import bluej.editor.stride.FrameMenuManager;
import bluej.editor.stride.FrameSelection;
import bluej.editor.stride.ImageCompletion;
import bluej.editor.stride.SoundCompletion;
import bluej.editor.stride.WindowOverlayPane;
import bluej.parser.AssistContent;
import bluej.parser.AssistContentThreadSafe;
import bluej.parser.ConstructorCompletion;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.PackageOrClass;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.role.Kind;
import bluej.prefmgr.PrefMgr;
import bluej.stride.framedjava.ast.ASTUtility;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.ast.links.PossibleKnownMethodLink;
import bluej.stride.framedjava.ast.links.PossibleLink;
import bluej.stride.framedjava.ast.links.PossibleMethodUseLink;
import bluej.stride.framedjava.ast.links.PossibleTypeLink;
import bluej.stride.framedjava.ast.links.PossibleVarLink;
import bluej.stride.framedjava.elements.CallElement;
import bluej.stride.framedjava.elements.ClassElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.elements.MethodWithBodyElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.stride.framedjava.elements.TopLevelCodeElement;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.errors.ErrorAndFixDisplay;
import bluej.stride.framedjava.frames.CallFrame;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.ConstructorFrame;
import bluej.stride.framedjava.frames.GreenfootFrameUtil;
import bluej.stride.framedjava.frames.ImportFrame;
import bluej.stride.framedjava.frames.MethodFrameWithBody;
import bluej.stride.framedjava.frames.NormalMethodFrame;
import bluej.stride.framedjava.frames.StrideCategory;
import bluej.stride.framedjava.frames.StrideDictionary;
import bluej.stride.framedjava.frames.TopLevelFrame;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentItem;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameDictionary;
import bluej.stride.generic.FrameState;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.RecallableFocus;
import bluej.stride.generic.SuggestedFollowUpDisplay;
import bluej.stride.operations.UndoRedoManager;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.LinkedIdentifier;
import bluej.utility.BackgroundConsumer;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.CircleCountdown;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.FXSupplier;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import bluej.utility.javafx.binding.ViewportHeightBinding;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.StringBinding;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FX)
public class FrameEditorTab
extends FXTab
implements InteractionManager,
SuggestionList.SuggestionListParent {
    private final SimpleObjectProperty<CursorOrSlot> focusedItem = new SimpleObjectProperty(null);
    private final TopLevelCodeElement initialSource;
    private final StringProperty nameProperty = new SimpleStringProperty();
    private final FrameSelection selection = new FrameSelection(this);
    private final FrameEditor editor;
    private final UndoRedoManager undoRedoManager;
    private final ObjectProperty<Frame.View> viewProperty = new SimpleObjectProperty((Object)Frame.View.NORMAL);
    private final EntityResolver projectResolver;
    private final FrameMenuManager menuManager;
    private WindowOverlayPane windowOverlayPane;
    private CodeOverlayPane codeOverlayPane;
    private VBox bannerPane;
    private boolean undoBannerShowing = false;
    private Observable observableScroll;
    private ViewportHeightBinding viewportHeight;
    private boolean manualScrolledSinceLastFocusChange = false;
    private CursorOrSlot focusOwnerDuringLastManualScroll = null;
    private final @OnThread(value=Tag.FX) Property<TopLevelFrame<? extends TopLevelCodeElement>> topLevelFrameProperty = new SimpleObjectProperty();
    private ContextMenu menu;
    private HBox controlPanel;
    private FrameCursor dragTarget;
    private BorderPaneWithHighlightColor contentRoot;
    private StackPane scrollAndOverlays;
    private StackPane scrollContent;
    private final ObjectProperty<FXTabbedEditor> parent = new SimpleObjectProperty();
    private final Project project;
    private ScrollPane scroll;
    private boolean selectingByDrag;
    private BirdseyeManager birdseyeManager;
    private Rectangle birdseyeSelection;
    private Pane birdseyeSelectionPane;
    private Node birdseyeDefaultFocusAfter;
    private FXRunnable birdseyeDefaultRequestFocusAfter;
    private Iterator<CodeError> errors;
    private SimpleBooleanProperty initialised = new SimpleBooleanProperty(false);
    private boolean startedInitialising;
    private Frame stackHighlight;
    private EditableSlot showingUnderlinesFor = null;
    private ErrorOverviewBar errorOverviewBar;
    private @OnThread(value=Tag.FX) boolean loading = false;
    private boolean animatingScroll = false;
    private boolean anyButtonsPressed = false;
    private SharedTransition viewChange;
    private ErrorAndFixDisplay cursorErrorDisplay;
    private boolean inScrollTo = false;
    private Canvas execHistoryCanvas;
    private final Set<Node> execNodesListenedTo = new HashSet<Node>();
    private final SimpleBooleanProperty debugVarVisibleProperty = new SimpleBooleanProperty(false);
    private List<HighlightedBreakpoint> latestExecHistory;
    private StringBinding strideFontSizeAsString;
    private StringExpression strideFontCSS;
    private final SimpleObjectProperty<Image> imageProperty = new SimpleObjectProperty(null);

    @OnThread(value=Tag.FXPlatform)
    public FrameEditorTab(Project project, EntityResolver resolver, FrameEditor editor, TopLevelCodeElement initialSource) {
        super(true);
        this.project = project;
        this.projectResolver = resolver;
        this.editor = editor;
        this.initialSource = initialSource;
        this.undoRedoManager = new UndoRedoManager(new FrameState(initialSource));
        this.menuManager = new FrameMenuManager(this);
    }

    public static String blockSkipModifierLabel() {
        return Config.isMacOS() ? "\u2325" : "^";
    }

    private static boolean hasBlockSkipModifierPressed(KeyEvent event) {
        if (Config.isMacOS()) {
            return event.isAltDown();
        }
        return event.isControlDown();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void initialiseFX() {
        if (this.startedInitialising) {
            return;
        }
        this.startedInitialising = true;
        this.setText("");
        Label titleLabel = new Label(this.initialSource.getName());
        titleLabel.textProperty().bind((ObservableValue)this.nameProperty);
        HBox tabHeader = new HBox(new Node[]{titleLabel, FrameEditorTab.makeClassGraphicIcon(this.imageProperty, 16, false)});
        tabHeader.setAlignment(Pos.CENTER);
        tabHeader.setSpacing(3.0);
        tabHeader.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
            if (e.getButton() == MouseButton.MIDDLE) {
                this.setWindowVisible(false, false);
            }
        });
        this.setGraphic((Node)tabHeader);
        JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"frame-editor-tab", this.initialSource.getStylePrefix() + "frame-editor-tab"});
        JavaFXUtil.addChangeListener(this.focusedItem, focused -> {
            JavaFXUtil.runNowOrLater(() -> this.menuManager.setMenuItems(focused != null ? focused.getMenuItems(false) : (this.selection != null ? this.selection.getEditMenuItems(false) : Collections.emptyMap())));
            if (focused != null && !focused.equals(this.focusOwnerDuringLastManualScroll)) {
                this.manualScrolledSinceLastFocusChange = false;
            }
        });
        this.selection.addChangeListener(() -> this.menuManager.setMenuItems(this.focusedItem.get() != null ? ((CursorOrSlot)this.focusedItem.get()).getMenuItems(false) : Collections.emptyMap()));
        this.contentRoot = new BorderPaneWithHighlightColor();
        JavaFXUtil.addStyleClass((Styleable)this.contentRoot, (String[])new String[]{"frame-editor-tab-content", this.initialSource.getStylePrefix() + "frame-editor-tab-content"});
        this.scrollAndOverlays = new StackPane();
        this.windowOverlayPane = new WindowOverlayPane();
        this.bannerPane = new VBox();
        this.bannerPane.setPickOnBounds(false);
        this.scroll = new ScrollPane(){

            public void requestFocus() {
            }
        };
        this.scroll.getStyleClass().add((Object)"frame-editor-scroll-pane");
        this.scroll.setFitToWidth(true);
        this.observableScroll = this.scroll.vvalueProperty();
        this.viewportHeight = new ViewportHeightBinding(this.scroll);
        this.scrollAndOverlays.getChildren().addAll((Object[])new Node[]{this.scroll, this.windowOverlayPane.getNode(), this.bannerPane});
        this.scroll.setFitToWidth(true);
        JavaFXUtil.addChangeListener((ObservableValue)this.scroll.vvalueProperty(), v -> {
            if (!this.animatingScroll) {
                this.manualScrolledSinceLastFocusChange = true;
                if (this.focusedItem.get() != null) {
                    this.focusOwnerDuringLastManualScroll = (CursorOrSlot)this.focusedItem.get();
                }
            }
        });
        this.scrollAndOverlays.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            FrameCursor focusedCursor = this.getFocusedCursor();
            boolean blockCursorFocused = focusedCursor != null;
            switch (event.getCode()) {
                case UP: {
                    FrameCursor c;
                    if (!blockCursorFocused) break;
                    if (event.isShiftDown() && this.viewProperty.get() != Frame.View.JAVA_PREVIEW) {
                        c = focusedCursor.getPrevSkip();
                        this.selection.toggleSelectUp(focusedCursor.getFrameBefore());
                    } else if (FrameEditorTab.hasBlockSkipModifierPressed(event) || this.viewProperty.get() == Frame.View.JAVA_PREVIEW && focusedCursor.getFrameBefore() != null && !focusedCursor.getFrameBefore().isFrameEnabled()) {
                        this.selection.clear();
                        c = focusedCursor.getPrevSkip();
                    } else {
                        this.selection.clear();
                        c = focusedCursor.getParentCanvas().getPrevCursor(focusedCursor, true);
                    }
                    if (c != null) {
                        c.requestFocus();
                    }
                    event.consume();
                    break;
                }
                case DOWN: {
                    FrameCursor c;
                    if (!blockCursorFocused) break;
                    if (event.isShiftDown() && this.viewProperty.get() != Frame.View.JAVA_PREVIEW) {
                        c = focusedCursor.getNextSkip();
                        this.selection.toggleSelectDown(focusedCursor.getFrameAfter());
                    } else if (FrameEditorTab.hasBlockSkipModifierPressed(event) || this.viewProperty.get() == Frame.View.JAVA_PREVIEW && focusedCursor.getFrameAfter() != null && !focusedCursor.getFrameAfter().isFrameEnabled()) {
                        this.selection.clear();
                        c = focusedCursor.getNextSkip();
                    } else {
                        this.selection.clear();
                        c = focusedCursor.getParentCanvas().getNextCursor(focusedCursor, true);
                    }
                    if (c != null) {
                        c.requestFocus();
                    }
                    event.consume();
                    break;
                }
                case HOME: {
                    if (!blockCursorFocused) break;
                    this.getTopLevelFrame().focusOnBody(TopLevelFrame.BodyFocus.TOP);
                    this.selection.clear();
                    event.consume();
                    break;
                }
                case END: {
                    if (!blockCursorFocused) break;
                    this.getTopLevelFrame().focusOnBody(TopLevelFrame.BodyFocus.BOTTOM);
                    this.selection.clear();
                    event.consume();
                    break;
                }
                case LEFT: {
                    if (!blockCursorFocused) break;
                    Frame frameBefore = focusedCursor.getFrameBefore();
                    if (frameBefore != null) {
                        if (!frameBefore.focusFrameEnd(false)) {
                            focusedCursor.getUp().requestFocus();
                        }
                    } else {
                        Frame enclosingFrame = focusedCursor.getEnclosingFrame();
                        if (enclosingFrame != null) {
                            enclosingFrame.focusLeft((FrameContentItem)focusedCursor.getParentCanvas());
                        } else {
                            Debug.message((String)"No enclosing frame on cursor");
                        }
                    }
                    this.selection.clear();
                    event.consume();
                    break;
                }
                case RIGHT: {
                    if (!blockCursorFocused) break;
                    Frame frame = focusedCursor.getFrameAfter();
                    if (frame != null) {
                        if (!frame.focusFrameStart()) {
                            focusedCursor.getParentCanvas().getNextCursor(focusedCursor, true).requestFocus();
                        }
                    } else {
                        Frame enclosingFrame = focusedCursor.getEnclosingFrame();
                        if (enclosingFrame != null) {
                            enclosingFrame.focusRight((FrameContentItem)focusedCursor.getParentCanvas());
                        } else {
                            Debug.message((String)"No enclosing frame on cursor");
                        }
                    }
                    this.selection.clear();
                    event.consume();
                    break;
                }
                case EQUALS: {
                    if (!Config.isMacOS() || !event.isMetaDown()) break;
                    this.increaseFontSize();
                    break;
                }
                case MINUS: {
                    if (!Config.isMacOS() || !event.isMetaDown()) break;
                    this.decreaseFontSize();
                    break;
                }
                default: {
                    if (event.getCode() == Config.getKeyCodeForYesNo((InteractionManager.ShortcutKey)InteractionManager.ShortcutKey.YES_ANYWHERE)) {
                        SuggestedFollowUpDisplay.shortcutTyped((InteractionManager)this, (InteractionManager.ShortcutKey)InteractionManager.ShortcutKey.YES_ANYWHERE);
                        break;
                    }
                    if (event.getCode() != Config.getKeyCodeForYesNo((InteractionManager.ShortcutKey)InteractionManager.ShortcutKey.NO_ANYWHERE)) break;
                    SuggestedFollowUpDisplay.shortcutTyped((InteractionManager)this, (InteractionManager.ShortcutKey)InteractionManager.ShortcutKey.NO_ANYWHERE);
                }
            }
        });
        this.scrollAndOverlays.addEventFilter(MouseEvent.ANY, e -> {
            this.anyButtonsPressed = e.isPrimaryButtonDown() || e.isSecondaryButtonDown() || e.isMiddleButtonDown();
        });
        this.controlPanel = new HBox();
        Button stepButton = new Button("Step");
        Button continueButton = new Button("Continue");
        this.controlPanel.getChildren().addAll((Object[])new Node[]{stepButton, continueButton});
        this.controlPanel.setSpacing(10.0);
        this.contentRoot.setCenter((Node)this.scrollAndOverlays);
        this.codeOverlayPane = new CodeOverlayPane();
        this.scrollContent = new StackPane();
        this.errorOverviewBar = new ErrorOverviewBar(this, (Pane)this.scrollContent, this::nextError);
        JavaFXUtil.addChangeListener((ObservableValue)this.errorOverviewBar.showingCount(), count -> {
            if (count.intValue() > 0) {
                JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"bj-tab-error"});
            } else {
                this.getStyleClass().removeAll((Object[])new String[]{"bj-tab-error"});
            }
        });
        this.contentRoot.setRight((Node)this.errorOverviewBar);
        this.loading = true;
        final FrameEditor frameEditor = this.getFrameEditor();
        new Thread("Load Stride class " + titleLabel.getText()){

            @Override
            @OnThread(value=Tag.FX, ignoreParent=true)
            public void run() {
                TopLevelFrame frame = FrameEditorTab.this.initialSource.createTopLevelFrame((InteractionManager)FrameEditorTab.this);
                frame.regenerateCode();
                TopLevelCodeElement el = (TopLevelCodeElement)frame.getCode();
                JavaFXUtil.runPlatformLater(() -> {
                    el.updateSourcePositions();
                    FrameEditorTab.this.topLevelFrameProperty.setValue((Object)frame);
                    FrameEditorTab.this.nameProperty.bind((ObservableValue)FrameEditorTab.this.getTopLevelFrame().nameProperty());
                    JavaFXUtil.addChangeListener((ObservableValue)FrameEditorTab.this.getTopLevelFrame().nameProperty(), n -> JavaFXUtil.runNowOrLater(() -> {
                        FrameEditorTab.this.editor.codeModified();
                        try {
                            FrameEditorTab.this.editor.save();
                        }
                        catch (IOException e) {
                            Debug.reportError((String)"Problem saving after name change", (Throwable)e);
                        }
                    }));
                    FrameEditorTab.this.getTopLevelFrame().bindMinHeight((DoubleBinding)FrameEditorTab.this.viewportHeight);
                    FrameEditorTab.this.scrollContent.getChildren().add(0, (Object)FrameEditorTab.this.getTopLevelFrame().getNode());
                    FrameEditorTab.this.updateFontSize();
                    List<Future<List<AssistContentThreadSafe>>> importsToUpdate = FrameEditorTab.this.getFrameEditor().getEditorFixesManager().getImportedTypesFutureList();
                    JavaFXUtil.bindMap(importsToUpdate, (ObservableList)FrameEditorTab.this.getTopLevelFrame().getImports(), FrameEditorTab.this.getFrameEditor().getEditorFixesManager()::scanImports, change -> {
                        frameEditor.getEditorFixesManager().getImportedTypesLock().writeLock().lock();
                        change.run();
                        frameEditor.getEditorFixesManager().getImportedTypesLock().writeLock().unlock();
                    });
                    if (FrameEditorTab.this.getTopLevelFrame() != null) {
                        FrameEditorTab.this.saved();
                        FrameEditorTab.this.editor.earlyErrorCheck(((TopLevelCodeElement)FrameEditorTab.this.getTopLevelFrame().getCode()).findEarlyErrors(), -1);
                        Platform.runLater(() -> FrameEditorTab.this.updateDisplays());
                    }
                    FrameEditorTab.this.initialised.set(true);
                    FrameEditorTab.this.loading = false;
                });
            }
        }.start();
        JavaFXUtil.addChangeListener(this.viewProperty, this.menuManager::notifyView);
        this.birdseyeSelection = new Rectangle();
        JavaFXUtil.addStyleClass((Styleable)this.birdseyeSelection, (String[])new String[]{"birdseye-selection"});
        this.birdseyeSelectionPane = new Pane(new Node[]{this.birdseyeSelection});
        this.birdseyeSelectionPane.setVisible(false);
        this.birdseyeSelectionPane.setMouseTransparent(false);
        this.birdseyeSelectionPane.setOnMouseClicked(e -> {
            FrameCursor clickTarget = this.birdseyeManager.getClickedTarget(e.getSceneX(), e.getSceneY());
            if (clickTarget == null) {
                this.disableBirdseyeView(Frame.ViewChangeReason.MOUSE_CLICKED);
            } else {
                this.disableBirdseyeView((Node)clickTarget.getNode(), Frame.ViewChangeReason.MOUSE_CLICKED, () -> ((FrameCursor)clickTarget).requestFocus());
            }
            e.consume();
        });
        this.birdseyeSelectionPane.setOnMouseMoved(e -> this.birdseyeSelectionPane.setCursor(this.birdseyeManager.canClick(e.getSceneX(), e.getSceneY()) ? Cursor.HAND : Cursor.DEFAULT));
        this.scrollContent.getChildren().addAll((Object[])new Node[]{this.codeOverlayPane.getNode(), this.birdseyeSelectionPane});
        this.scroll.setContent((Node)this.scrollContent);
        this.setContent((Node)this.contentRoot);
        this.contentRoot.addEventHandler(MouseEvent.MOUSE_PRESSED, Event::consume);
        this.contentRoot.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            switch (event.getCode()) {
                case Y: {
                    if (Config.isMacOS() || !event.isShortcutDown() || event.isShiftDown()) break;
                    this.redo();
                    event.consume();
                    break;
                }
                case Z: {
                    if (Config.isMacOS() || !event.isShortcutDown() || event.isShiftDown()) break;
                    this.undo();
                    event.consume();
                    break;
                }
                case UP: {
                    if (!((Frame.View)this.viewProperty.get()).isBirdseye()) break;
                    this.birdseyeManager.up();
                    this.calculateBirdseyeRectangle();
                    event.consume();
                    break;
                }
                case DOWN: {
                    if (!((Frame.View)this.viewProperty.get()).isBirdseye()) break;
                    this.birdseyeManager.down();
                    this.calculateBirdseyeRectangle();
                    event.consume();
                    break;
                }
                case ENTER: {
                    if (!((Frame.View)this.viewProperty.get()).isBirdseye()) break;
                    FrameCursor target = this.birdseyeManager.getCursorForCurrent();
                    this.disableBirdseyeView((Node)target.getNode(), Frame.ViewChangeReason.KEY_PRESSED_ENTER, () -> ((FrameCursor)target).requestFocus());
                    event.consume();
                    break;
                }
                case ESCAPE: {
                    if (this.viewProperty.get() == Frame.View.JAVA_PREVIEW) {
                        this.disableJavaPreview(Frame.ViewChangeReason.KEY_PRESSED_ESCAPE);
                        event.consume();
                        break;
                    }
                    if (!((Frame.View)this.viewProperty.get()).isBirdseye()) break;
                    this.disableBirdseyeView(Frame.ViewChangeReason.KEY_PRESSED_ESCAPE);
                    event.consume();
                }
            }
        });
        this.contentRoot.addEventFilter(ScrollEvent.SCROLL, e -> {
            if (e.isShortcutDown()) {
                if (e.getDeltaY() > 0.0) {
                    this.increaseFontSize();
                } else {
                    this.decreaseFontSize();
                }
                e.consume();
            }
        });
        FrameEditorTab.addWeakFontSizeUpdater(this);
        this.regenerateAndReparse();
    }

    private TopLevelFrame<? extends TopLevelCodeElement> getTopLevelFrame() {
        return (TopLevelFrame)this.topLevelFrameProperty.getValue();
    }

    @OnThread(value=Tag.FXPlatform)
    public void withTopLevelFrame(FXPlatformConsumer<TopLevelFrame<? extends TopLevelCodeElement>> action) {
        JavaFXUtil.onceNotNull(this.topLevelFrameProperty, action);
    }

    @OnThread(value=Tag.FXPlatform)
    public void redrawExecHistory(List<HighlightedBreakpoint> execHistory) {
        this.latestExecHistory = execHistory;
        CodeOverlayPane overlay = this.getCodeOverlayPane();
        if (this.execHistoryCanvas != null) {
            overlay.removeOverlay((Node)this.execHistoryCanvas);
        }
        this.execHistoryCanvas = overlay.addFullSizeCanvas();
        GraphicsContext g = this.execHistoryCanvas.getGraphicsContext2D();
        double prevTargetX = 0.0;
        double prevTargetY = 0.0;
        HighlightedBreakpoint prevPoint = null;
        ArrayList<HighlightedBreakpoint> drawnFrom = new ArrayList<HighlightedBreakpoint>();
        for (int i = 0; i < execHistory.size(); ++i) {
            HighlightedBreakpoint b = execHistory.get(i);
            if (b.getNode() == null) continue;
            Bounds bounds = b.getNode().localToScene(b.getNode().getBoundsInLocal());
            if (!this.execNodesListenedTo.contains(b.getNode())) {
                JavaFXUtil.addChangeListenerPlatform((ObservableValue)b.getNode().localToSceneTransformProperty(), t -> this.redrawExecHistory(this.latestExecHistory));
                this.execNodesListenedTo.add(b.getNode());
            }
            double targetX = this.execHistoryCanvas.getWidth() * 0.75;
            double targetY = overlay.sceneYToCodeOverlayY(bounds.getMinY()) + b.getYOffset();
            if (b.showExec(i)) {
                if (i == 0) {
                    prevTargetX = targetX;
                    prevTargetY = targetY - 10.0;
                }
                g.setStroke((Paint)Color.WHITE);
                g.setLineWidth(4.0);
                for (int k = 0; k < 2; ++k) {
                    if (Math.abs(prevTargetY - targetY) < 15.0) {
                        g.strokeLine(prevTargetX, prevTargetY, targetX, targetY);
                        g.strokeLine(targetX - 10.0, targetY - 10.0, targetX, targetY);
                        g.strokeLine(targetX + 10.0, targetY - 10.0, targetX, targetY);
                    } else {
                        double angle;
                        double bulge;
                        if (prevPoint != null && drawnFrom.contains(prevPoint)) {
                            bulge = 35.0;
                            angle = 0.15;
                        } else if (Math.abs(prevTargetY - targetY) < 60.0) {
                            bulge = 5.0;
                            angle = 0.4;
                        } else {
                            bulge = 10.0;
                            angle = 0.15;
                        }
                        if (prevTargetY < targetY) {
                            g.beginPath();
                            g.moveTo(prevTargetX, prevTargetY);
                            g.bezierCurveTo(prevTargetX + bulge, prevTargetY, prevTargetX + bulge, targetY, prevTargetX, targetY);
                            g.stroke();
                            g.strokeLine(targetX - 14.4 * Math.sin(angle), targetY - 14.4 * Math.cos(angle), targetX, targetY);
                            g.strokeLine(targetX + 14.4 * Math.cos(angle), targetY - 14.4 * Math.sin(angle), targetX, targetY);
                        } else {
                            double turnBack = overlay.sceneYToCodeOverlayY(bounds.getMinY()) + b.getYOffsetOfTurnBack();
                            g.beginPath();
                            g.moveTo(prevTargetX, prevTargetY);
                            g.bezierCurveTo(prevTargetX + bulge, prevTargetY, prevTargetX + bulge, turnBack, prevTargetX, turnBack);
                            g.bezierCurveTo(targetX - 2.0 * bulge, turnBack, targetX - 2.0 * bulge, targetY, targetX, targetY);
                            g.stroke();
                            g.strokeLine(targetX + 14.4 * Math.sin(angle), targetY + 14.4 * Math.cos(angle), targetX, targetY);
                            g.strokeLine(targetX - 14.4 * Math.cos(angle), targetY + 14.4 * Math.sin(angle), targetX, targetY);
                        }
                    }
                    g.setStroke((Paint)Color.BLUE);
                    g.setLineWidth(2.0);
                }
                if (prevPoint != null) {
                    drawnFrom.add(prevPoint);
                }
            }
            prevTargetX = targetX;
            prevTargetY = targetY + 5.0;
            prevPoint = b;
        }
    }

    ObservableBooleanValue debugVarVisibleProperty() {
        return this.debugVarVisibleProperty;
    }

    @OnThread(value=Tag.FXPlatform)
    public void addExtends(String className) {
        this.withTopLevelFrame((FXPlatformConsumer<TopLevelFrame<? extends TopLevelCodeElement>>)((FXPlatformConsumer)f -> {
            f.addExtendsClassOrInterface(className);
            this.saveAfterAutomatedEdit();
        }));
    }

    @OnThread(value=Tag.FXPlatform)
    public void removeExtendsClass() {
        this.withTopLevelFrame((FXPlatformConsumer<TopLevelFrame<? extends TopLevelCodeElement>>)((FXPlatformConsumer)f -> {
            f.removeExtendsClass();
            this.saveAfterAutomatedEdit();
        }));
    }

    @OnThread(value=Tag.FXPlatform)
    public void addImplements(String className) {
        this.withTopLevelFrame((FXPlatformConsumer<TopLevelFrame<? extends TopLevelCodeElement>>)((FXPlatformConsumer)f -> {
            f.addImplements(className);
            this.saveAfterAutomatedEdit();
        }));
    }

    @OnThread(value=Tag.FXPlatform)
    public void removeExtendsOrImplementsInterface(String interfaceName) {
        this.withTopLevelFrame((FXPlatformConsumer<TopLevelFrame<? extends TopLevelCodeElement>>)((FXPlatformConsumer)f -> {
            f.removeExtendsOrImplementsInterface(interfaceName);
            this.saveAfterAutomatedEdit();
        }));
    }

    @OnThread(value=Tag.FXPlatform)
    private void saveAfterAutomatedEdit() {
        this.modifiedFrame(null, true);
        this.editor.getWatcher().scheduleCompilation(false, CompileReason.MODIFIED, CompileType.INDIRECT_USER_COMPILE);
    }

    public String getXPathForItemAtPosition(int screenX, int screenY, boolean includePseudoElements, boolean includeSubstringIndex) {
        TopLevelFrame<? extends TopLevelCodeElement> topLevelFrame = this.getTopLevelFrame();
        if (topLevelFrame == null) {
            return null;
        }
        Node frameNode = topLevelFrame.getNode();
        FXTabbedEditor fxTabbedEditor = (FXTabbedEditor)this.parent.get();
        int windowX = fxTabbedEditor.getX();
        int windowY = fxTabbedEditor.getY();
        double sceneX = frameNode.getScene().getX();
        double sceneY = frameNode.getScene().getY();
        double renderScaleX = fxTabbedEditor.getRenderScaleX();
        double renderScaleY = fxTabbedEditor.getRenderScaleY();
        Point2D sceneLocation = new Point2D((double)screenX / renderScaleX - (double)windowX, (double)screenY / renderScaleY - (double)windowY).subtract(sceneX, sceneY);
        return topLevelFrame.getXPathForElementAt(sceneLocation.getX(), sceneLocation.getY(), this.getLocationMap(), includePseudoElements, includeSubstringIndex);
    }

    void showDebuggerControls(DebuggerThread thread) {
        if (this.contentRoot.getBottom() != null) {
            return;
        }
        HBox buttons = new HBox();
        JavaFXUtil.addStyleClass((Styleable)buttons, (String[])new String[]{"debugger-buttons"});
        ImageView stepIcon = new ImageView(Config.getFixedImageAsFXImage((String)"step.gif"));
        stepIcon.setRotate(90.0);
        Button stepButton = new Button("Step", (Node)stepIcon);
        stepButton.setOnAction(e -> this.project.getDebugger().runOnEventHandler(() -> thread.step()));
        ImageView continueIcon = new ImageView(Config.getFixedImageAsFXImage((String)"continue.gif"));
        continueIcon.setRotate(90.0);
        Button continueButton = new Button("Continue", (Node)continueIcon);
        continueButton.setOnAction(e -> {
            this.project.getDebugger().runOnEventHandler(() -> thread.cont());
            this.hideDebuggerControls();
        });
        Button haltButton = new Button("Halt", Config.makeStopIcon((boolean)true));
        Label showVarLabel = new Label("Show variables: ");
        ComboBox showVars = new ComboBox(FXCollections.observableArrayList((Object[])ShowVars.values()));
        showVars.getSelectionModel().select(0);
        this.debugVarVisibleProperty.bind((ObservableValue)showVars.getSelectionModel().selectedItemProperty().isEqualTo((Object)ShowVars.FIELDS));
        buttons.getChildren().addAll((Object[])new Node[]{stepButton, continueButton, haltButton, showVarLabel, showVars});
        this.contentRoot.setBottom((Node)buttons);
    }

    private void hideDebuggerControls() {
        this.contentRoot.setBottom(null);
    }

    private static void addWeakFontSizeUpdater(FrameEditorTab ed) {
        PrefMgr.strideFontSizeProperty().addListener((ChangeListener)new WeakFontSizeUpdater(ed));
    }

    void resetFontSize() {
        PrefMgr.strideFontSizeProperty().set(11);
        if (((Frame.View)this.viewProperty.get()).isBirdseye()) {
            JavaFXUtil.runAfterNextLayout((Scene)this.getTabPane().getScene(), () -> JavaFXUtil.runAfterNextLayout((Scene)this.getTabPane().getScene(), () -> this.calculateBirdseyeRectangle()));
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void searchLink(PossibleLink link, final FXPlatformConsumer<Optional<LinkedIdentifier>> paramCallback) {
        Consumer<Optional<LinkedIdentifier>> callback = new Consumer<Optional<LinkedIdentifier>>(){

            @Override
            @OnThread(value=Tag.Any)
            public void accept(Optional<LinkedIdentifier> ol) {
                Platform.runLater(() -> paramCallback.accept((Object)ol));
            }
        };
        TopLevelFrame<? extends TopLevelCodeElement> topLevelFrame = this.getTopLevelFrame();
        if (topLevelFrame == null) {
            callback.accept(Optional.empty());
            return;
        }
        if (link instanceof PossibleTypeLink) {
            String name = ((PossibleTypeLink)link).getTypeName();
            Package pkg = this.project.getPackage("");
            if (pkg.getAllClassnamesWithSource().contains(name)) {
                Target t = pkg.getTarget(name);
                if (t instanceof ClassTarget) {
                    callback.accept(Optional.of(new LinkedIdentifier(name, link.getStartPosition(), link.getEndPosition(), link.getSlot(), () -> {
                        link.getSlot().removeAllUnderlines();
                        ((ClassTarget)t).open();
                    })));
                    return;
                }
            } else {
                TopLevelCodeElement code = (TopLevelCodeElement)topLevelFrame.getCode();
                if (code != null) {
                    PackageOrClass resolved = code.getResolver().resolvePackageOrClass(name, null);
                    if (resolved.getName().startsWith("java.") || resolved.getName().startsWith("javax.")) {
                        callback.accept(Optional.of(new LinkedIdentifier(name, link.getStartPosition(), link.getEndPosition(), link.getSlot(), () -> this.getParent().openJavaCoreDocTab(resolved.getName()))));
                        return;
                    }
                    if (resolved.getName().startsWith("greenfoot.")) {
                        callback.accept(Optional.of(new LinkedIdentifier(name, link.getStartPosition(), link.getEndPosition(), link.getSlot(), () -> this.getParent().openGreenfootDocTab(resolved.getName()))));
                        return;
                    }
                }
            }
            callback.accept(Optional.empty());
        } else if (link instanceof PossibleKnownMethodLink) {
            PossibleKnownMethodLink pml = (PossibleKnownMethodLink)link;
            String qualClassName = pml.getQualClassName();
            String urlSuffix = pml.getURLMethodSuffix();
            this.searchMethodLink((TopLevelCodeElement)topLevelFrame.getCode(), link, qualClassName, pml.getDisplayName(), pml.getDisplayName(), urlSuffix, callback);
        } else if (link instanceof PossibleMethodUseLink) {
            PossibleMethodUseLink pmul = (PossibleMethodUseLink)link;
            List candidates = this.editor.getAvailableMembers((TopLevelCodeElement)topLevelFrame.getCode(), (JavaFragment.PosInSourceDoc)pmul.getSourcePositionSupplier().get(), Collections.singleton(AssistContent.CompletionKind.METHOD), true).stream().filter(ac -> ac.getName().equals(pmul.getMethodName())).collect(Collectors.toList());
            if (candidates.size() > 1 && candidates.stream().anyMatch(ac -> ac.getParams().size() == pmul.getNumParams())) {
                candidates.removeIf(ac -> ac.getParams().size() != pmul.getNumParams());
            }
            if (candidates.size() >= 1) {
                AssistContent ac2 = (AssistContent)candidates.get(0);
                String displayName = ac2.getName() + "(" + ac2.getParams().stream().map(AssistContent.ParamInfo::getUnqualifiedType).collect(Collectors.joining(", ")) + ")";
                this.searchMethodLink((TopLevelCodeElement)topLevelFrame.getCode(), link, ac2.getDeclaringClass(), ac2.getName(), displayName, PossibleKnownMethodLink.encodeSuffix((String)ac2.getName(), (List)Utility.mapList((Collection)ac2.getParams(), AssistContent.ParamInfo::getQualifiedType)), callback);
            } else {
                callback.accept(Optional.empty());
            }
        } else if (link instanceof PossibleVarLink) {
            String name = ((PossibleVarLink)link).getVarName();
            CodeElement el = ((PossibleVarLink)link).getUsePoint();
            FrameEditorTab ed = (FrameEditorTab)ASTUtility.getTopLevelElement((CodeElement)el).getEditor();
            if (ed == this) {
                callback.accept(Optional.of(new LinkedIdentifier(name, link.getStartPosition(), link.getEndPosition(), link.getSlot(), () -> el.show(Frame.ShowReason.LINK_TARGET))));
            } else {
                callback.accept(Optional.of(new LinkedIdentifier(name, link.getStartPosition(), link.getEndPosition(), link.getSlot(), () -> {
                    this.getParent().setWindowVisible(true, ed);
                    el.show(Frame.ShowReason.LINK_TARGET);
                })));
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void searchMethodLink(TopLevelCodeElement code, PossibleLink link, String qualClassName, String methodName, String methodDisplayName, String urlSuffix, Consumer<Optional<LinkedIdentifier>> callback) {
        Package pkg = this.project.getPackage("");
        if (pkg.getAllClassnamesWithSource().contains(qualClassName)) {
            Target t = pkg.getTarget(qualClassName);
            if (t instanceof ClassTarget) {
                ClassTarget classTarget = (ClassTarget)t;
                callback.accept(Optional.of(new LinkedIdentifier(methodDisplayName, link.getStartPosition(), link.getEndPosition(), link.getSlot(), () -> {
                    link.getSlot().removeAllUnderlines();
                    classTarget.open();
                    classTarget.getEditor().focusMethod(methodName, null);
                })));
                return;
            }
        } else if (code != null) {
            PackageOrClass resolved = code.getResolver().resolvePackageOrClass(qualClassName, null);
            if (resolved.getName().startsWith("java.") || resolved.getName().startsWith("javax.")) {
                callback.accept(Optional.of(new LinkedIdentifier(methodDisplayName, link.getStartPosition(), link.getEndPosition(), link.getSlot(), () -> this.getParent().openJavaCoreDocTab(resolved.getName(), urlSuffix))));
                return;
            }
            if (resolved.getName().startsWith("greenfoot.")) {
                callback.accept(Optional.of(new LinkedIdentifier(methodDisplayName, link.getStartPosition(), link.getEndPosition(), link.getSlot(), () -> this.getParent().openGreenfootDocTab(resolved.getName(), urlSuffix))));
                return;
            }
        }
        callback.accept(Optional.empty());
    }

    @OnThread(value=Tag.FXPlatform)
    void enableCycleBirdseyeView() {
        this.selection.clear();
        if (this.viewProperty.get() == Frame.View.NORMAL && this.getTopLevelFrame().canDoBirdseye()) {
            if (this.viewChange != null) {
                this.viewChange.stop();
            }
            this.viewChange = new SharedTransition();
            this.viewChange.addOnStopped(() -> JavaFXUtil.runAfter((Duration)Duration.millis((double)50.0), () -> {
                this.birdseyeSelectionPane.setVisible(true);
                this.calculateBirdseyeRectangle();
            }));
            this.birdseyeDefaultFocusAfter = this.scroll.getScene().getFocusOwner();
            this.birdseyeDefaultRequestFocusAfter = () -> {
                if (this.birdseyeDefaultFocusAfter != null) {
                    this.birdseyeDefaultFocusAfter.requestFocus();
                }
            };
            this.birdseyeManager = this.getTopLevelFrame().prepareBirdsEyeView(this.viewChange);
            this.changeViewMode(Frame.View.BIRDSEYE_NODOC, Frame.ViewChangeReason.MENU_OR_SHORTCUT);
            this.setupAnimateViewTo(Frame.View.NORMAL, Frame.View.BIRDSEYE_NODOC, this.viewChange);
            this.viewChange.animateOver(Duration.millis((double)500.0));
        } else if (this.viewProperty.get() == Frame.View.JAVA_PREVIEW) {
            this.disableJavaPreview(Frame.ViewChangeReason.MENU_OR_SHORTCUT);
            this.enableCycleBirdseyeView();
        } else if (((Frame.View)this.viewProperty.get()).isBirdseye()) {
            if (this.viewChange != null) {
                this.viewChange.stop();
            }
            this.viewChange = new SharedTransition();
            this.viewChange.addOnStopped(() -> JavaFXUtil.runAfter((Duration)Duration.millis((double)50.0), () -> this.calculateBirdseyeRectangle()));
            JavaFXUtil.addChangeListener((ObservableValue)this.viewChange.getProgress(), t -> this.calculateBirdseyeRectangle());
            Frame.View oldView = (Frame.View)this.viewProperty.get();
            Frame.View newView = this.viewProperty.get() == Frame.View.BIRDSEYE_DOC ? Frame.View.BIRDSEYE_NODOC : Frame.View.BIRDSEYE_DOC;
            this.changeViewMode(newView, Frame.ViewChangeReason.MENU_OR_SHORTCUT);
            this.setupAnimateViewTo(oldView, newView, this.viewChange);
            this.viewChange.animateOver(Duration.millis((double)500.0));
        }
    }

    @OnThread(value=Tag.FXPlatform)
    void disableBirdseyeView(Node viewTarget, Frame.ViewChangeReason reason, FXRunnable requestFocus) {
        if (((Frame.View)this.viewProperty.get()).isBirdseye()) {
            if (this.viewChange != null) {
                this.viewChange.stop();
            }
            this.viewChange = new SharedTransition();
            this.birdseyeSelectionPane.setVisible(false);
            this.birdseyeManager = null;
            FXRunnable remove = JavaFXUtil.addChangeListener((ObservableValue)viewTarget.localToSceneTransformProperty(), t -> {
                if (!this.inScrollTo) {
                    this.scrollTo(viewTarget, -200.0);
                }
            });
            this.viewChange.addOnStopped(() -> {
                remove.run();
                if (requestFocus != null) {
                    requestFocus.run();
                }
            });
            Frame.View oldView = (Frame.View)this.viewProperty.get();
            this.changeViewMode(Frame.View.NORMAL, reason);
            this.setupAnimateViewTo(oldView, Frame.View.NORMAL, this.viewChange);
            this.viewChange.animateOver(Duration.millis((double)500.0));
        }
    }

    @OnThread(value=Tag.FXPlatform)
    void disableBirdseyeView(Frame.ViewChangeReason reason) {
        this.disableBirdseyeView(this.birdseyeDefaultFocusAfter, reason, this.birdseyeDefaultRequestFocusAfter);
    }

    @OnThread(value=Tag.FXPlatform)
    void enableJavaPreview(Frame.ViewChangeReason reason) {
        if (this.viewProperty.get() == Frame.View.NORMAL) {
            this.selection.clear();
            if (this.viewChange != null) {
                this.viewChange.stop();
            }
            this.viewChange = new SharedTransition();
            this.changeViewMode(Frame.View.JAVA_PREVIEW, reason);
            this.setupAnimateViewTo(Frame.View.NORMAL, Frame.View.JAVA_PREVIEW, this.viewChange);
            this.viewChange.animateOver(Duration.millis((double)3000.0));
        } else if (((Frame.View)this.viewProperty.get()).isBirdseye()) {
            this.disableBirdseyeView(reason);
            this.enableJavaPreview(reason);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    void disableJavaPreview(Frame.ViewChangeReason reason) {
        if (this.viewProperty.get() == Frame.View.JAVA_PREVIEW) {
            if (this.viewChange != null) {
                this.viewChange.stop();
            }
            this.viewChange = new SharedTransition();
            this.changeViewMode(Frame.View.NORMAL, reason);
            this.setupAnimateViewTo(Frame.View.JAVA_PREVIEW, Frame.View.NORMAL, this.viewChange);
            this.viewChange.animateOver(Duration.millis((double)3000.0));
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void changeViewMode(Frame.View newView, Frame.ViewChangeReason reason) {
        this.recordViewChange((Frame.View)this.viewProperty.get(), newView, reason);
        this.viewProperty.set((Object)newView);
    }

    @OnThread(value=Tag.FXPlatform)
    private void setupAnimateViewTo(Frame.View oldView, Frame.View newView, SharedTransition animateProgress) {
        FrameCursor fixpoint = this.getFocusedCursor();
        double y = fixpoint == null ? 0.0 : fixpoint.getSceneBounds().getMinY() - this.scroll.localToScene(this.scroll.getBoundsInLocal()).getMinY();
        this.getTopLevelFrame().getAllFrames().forEach(f -> f.setView(oldView, newView, animateProgress));
        if (fixpoint != null) {
            FrameCursor finalFixpoint = fixpoint;
            FXRunnable remove = JavaFXUtil.addChangeListener((ObservableValue)this.getFocusedCursor().getNode().localToSceneTransformProperty(), ignore -> this.scrollTo((Node)finalFixpoint.getNode(), -y));
            animateProgress.addOnStopped(() -> JavaFXUtil.runAfterCurrent((FXPlatformRunnable)remove));
        }
        this.getParent().scheduleUpdateCatalogue(this, newView == Frame.View.NORMAL ? this.getFocusedCursor() : null, FXTabbedEditor.CodeCompletionState.NOT_POSSIBLE, false, newView, Collections.emptyList(), Collections.emptyList());
    }

    @OnThread(value=Tag.FXPlatform)
    public BooleanProperty cheatSheetShowingProperty() {
        return this.getParent().catalogueShowingProperty();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void focusWhenShown() {
        this.withTopLevelFrame((FXPlatformConsumer<TopLevelFrame<? extends TopLevelCodeElement>>)((FXPlatformConsumer)f -> f.focusOnBody(TopLevelFrame.BodyFocus.BEST_PICK)));
    }

    @OnThread(value=Tag.FXPlatform)
    public void cancelFreshState() {
        this.withTopLevelFrame((FXPlatformConsumer<TopLevelFrame<? extends TopLevelCodeElement>>)((FXPlatformConsumer)f -> f.getAllFrames().forEach(Frame::markNonFresh)));
    }

    @OnThread(value=Tag.FXPlatform)
    void dragEndTab(List<Frame> dragSourceFrames, boolean fromShelf, boolean copying) {
        if (dragSourceFrames != null && !dragSourceFrames.isEmpty() && this.dragTarget != null) {
            boolean canMove = dragSourceFrames.stream().allMatch(src -> this.dragTarget.getParentCanvas().acceptsType(src));
            if (canMove && !FXTabbedEditor.isUselessDrag(this.dragTarget, dragSourceFrames, copying)) {
                this.beginRecordingState((RecallableFocus)this.dragTarget);
                this.performDrag(dragSourceFrames, fromShelf, copying);
                this.endRecordingState((RecallableFocus)this.dragTarget);
            }
            this.selection.clear();
            this.dragTarget.stopShowAsDropTarget();
            this.dragTarget = null;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void performDrag(List<Frame> dragSourceFrames, boolean fromShelf, boolean copying) {
        boolean shouldDisable = !this.dragTarget.getParentCanvas().getParent().getFrame().isFrameEnabled();
        this.editor.recordEdits(StrideEditReason.FLUSH);
        Collections.reverse(dragSourceFrames);
        List elements = GreenfootFrameUtil.getElementsForMultipleFrames(dragSourceFrames);
        for (CodeElement codeElement : elements) {
            Frame frame = codeElement.createFrame((InteractionManager)this);
            this.dragTarget.insertBlockAfter(frame);
            if (!shouldDisable) continue;
            frame.setFrameEnabled(false);
        }
        if (!copying) {
            dragSourceFrames.forEach(src -> src.getParentCanvas().removeBlock(src));
        }
        this.editor.recordEdits(fromShelf ? StrideEditReason.FRAMES_DRAG_SHELF : StrideEditReason.FRAMES_DRAG);
    }

    @OnThread(value=Tag.FXPlatform)
    void draggedToTab(List<Frame> dragSourceFrames, double sceneX, double sceneY, boolean copying) {
        Bounds scrollBounds = this.scroll.localToScene(this.scroll.getBoundsInLocal());
        if (sceneX < scrollBounds.getMinX() || sceneX > scrollBounds.getMaxX()) {
            if (this.dragTarget != null) {
                this.dragTarget.stopShowAsDropTarget();
                this.dragTarget = null;
            }
        } else {
            FrameCursor newDragTarget = this.getTopLevelFrame().findCursor(sceneX, sceneY, null, null, dragSourceFrames, true, true);
            if (newDragTarget != null && this.dragTarget != newDragTarget) {
                if (this.dragTarget != null) {
                    this.dragTarget.stopShowAsDropTarget();
                    this.dragTarget = null;
                }
                boolean src = FXTabbedEditor.isUselessDrag(newDragTarget, dragSourceFrames, copying);
                boolean acceptsAll = true;
                for (Frame srcFrame : dragSourceFrames) {
                    acceptsAll &= newDragTarget.getParentCanvas().acceptsType(srcFrame);
                }
                newDragTarget.showAsDropTarget(src, acceptsAll, copying);
                this.dragTarget = newDragTarget;
            }
        }
        if (this.dragTarget != null) {
            this.dragTarget.updateDragCopyState(copying);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    void draggedToAnotherTab() {
        if (this.dragTarget != null) {
            this.dragTarget.stopShowAsDropTarget();
            this.dragTarget = null;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void clickNearestCursor(double sceneX, double sceneY, boolean shiftDown) {
        FrameCursor target = this.getTopLevelFrame().findCursor(sceneX, sceneY, null, null, null, false, true);
        if (target != null) {
            if (shiftDown && this.viewProperty.get() != Frame.View.JAVA_PREVIEW) {
                FrameCursor anchor;
                if (this.selection.getSelected().size() == 0) {
                    anchor = this.getFocusedCursor();
                } else {
                    FrameCursor frameCursor = anchor = this.selection.getCursorAfter() == this.getFocusedCursor() ? this.selection.getCursorBefore() : this.selection.getCursorAfter();
                }
                if (this.getFocusedCursor() == null || target.getParentCanvas() != anchor.getParentCanvas()) {
                    return;
                }
                this.selection.set(target.getParentCanvas().framesBetween(anchor, target));
                target.requestFocus();
            } else {
                target.requestFocus();
                this.selection.clear();
            }
        }
    }

    public FrameDictionary<StrideCategory> getDictionary() {
        return StrideDictionary.getDictionary();
    }

    public void setupFrameCursor(final FrameCursor f) {
        f.getNode().setOnDragDetected(e -> {
            this.selectingByDrag = true;
            e.consume();
        });
        f.getNode().setOnMouseDragged(e -> {
            if (!this.selectingByDrag || this.viewProperty.get() == Frame.View.JAVA_PREVIEW) {
                return;
            }
            FrameCanvas fCanvas = f.getParentCanvas();
            FrameCursor closest = fCanvas.getParent().findCursor(e.getSceneX(), e.getSceneY(), fCanvas.getFirstCursor(), fCanvas.getLastCursor(), null, true, false);
            if (closest != null) {
                this.selection.set(fCanvas.framesBetween(closest, f));
            }
            e.consume();
        });
        f.getNode().setOnMouseReleased(e -> {
            if (this.selectingByDrag) {
                this.selectingByDrag = false;
                e.consume();
            }
        });
        JavaFXUtil.addFocusListener((Node)f.getNode(), (FXPlatformConsumer)new FXPlatformConsumer<Boolean>(){
            private FXRunnable cancelTimer;

            @OnThread(value=Tag.FXPlatform)
            public void accept(Boolean focused) {
                if (FrameEditorTab.this.getParent() != null) {
                    FrameEditorTab.this.getParent().scheduleUpdateCatalogue(FrameEditorTab.this, focused != false ? f : null, FXTabbedEditor.CodeCompletionState.NOT_POSSIBLE, !FrameEditorTab.this.selection.getSelected().isEmpty(), FrameEditorTab.this.getView(), Collections.emptyList(), Collections.emptyList());
                }
                if (this.cancelTimer != null) {
                    this.cancelTimer.run();
                    this.cancelTimer = null;
                }
                if (!focused.booleanValue()) {
                    this.hideError();
                } else {
                    this.cancelTimer = JavaFXUtil.runRegular((Duration)Duration.millis((double)1000.0), this::updateFocusedDisplay);
                }
            }

            @OnThread(value=Tag.FXPlatform)
            private void hideError() {
                if (FrameEditorTab.this.cursorErrorDisplay != null) {
                    FrameEditorTab.this.cursorErrorDisplay.hide();
                    FrameEditorTab.this.cursorErrorDisplay = null;
                }
            }

            @OnThread(value=Tag.FXPlatform)
            private void updateFocusedDisplay() {
                if (!f.getNode().focusedProperty().get()) {
                    this.hideError();
                    return;
                }
                Optional maybeErr = Optional.ofNullable(f.getFrameAfter()).flatMap(fr -> fr.getCurrentErrors().findFirst());
                if (maybeErr.isPresent()) {
                    if (FrameEditorTab.this.cursorErrorDisplay != null && maybeErr.get() == FrameEditorTab.this.cursorErrorDisplay.getError()) {
                        return;
                    }
                    this.hideError();
                    FrameEditorTab.this.cursorErrorDisplay = new ErrorAndFixDisplay((InteractionManager)FrameEditorTab.this, "Below: ", (CodeError)maybeErr.get(), null);
                    FrameEditorTab.this.cursorErrorDisplay.showAbove(f.getNode());
                } else {
                    maybeErr = Optional.ofNullable(f.getFrameBefore()).flatMap(fr -> fr.getCurrentErrors().findFirst());
                    if (maybeErr.isPresent()) {
                        if (FrameEditorTab.this.cursorErrorDisplay != null && maybeErr.get() == FrameEditorTab.this.cursorErrorDisplay.getError()) {
                            return;
                        }
                        this.hideError();
                        FrameEditorTab.this.cursorErrorDisplay = new ErrorAndFixDisplay((InteractionManager)FrameEditorTab.this, "Above: ", (CodeError)maybeErr.get(), null);
                        FrameEditorTab.this.cursorErrorDisplay.showBelow(f.getNode());
                    } else {
                        maybeErr = Optional.ofNullable(f.getParentCanvas().getParent()).map(CanvasParent::getFrame).flatMap(fr -> fr.getCurrentErrors().findFirst());
                        if (maybeErr.isPresent() && ((CodeError)maybeErr.get()).visibleProperty().get()) {
                            if (FrameEditorTab.this.cursorErrorDisplay != null && maybeErr.get() == FrameEditorTab.this.cursorErrorDisplay.getError()) {
                                return;
                            }
                            this.hideError();
                            FrameEditorTab.this.cursorErrorDisplay = new ErrorAndFixDisplay((InteractionManager)FrameEditorTab.this, "Enclosing frame: ", (CodeError)maybeErr.get(), null);
                            FrameEditorTab.this.cursorErrorDisplay.showBelow(f.getNode());
                        } else {
                            this.hideError();
                        }
                    }
                }
            }
        });
        this.setupFocusable(new CursorOrSlot(f), (Node)f.getNode());
    }

    public void setupFrame(Frame f) {
        JavaFXUtil.listenForContextMenu((Node)f.getNode(), (x, y) -> {
            if (this.viewProperty.get() != Frame.View.NORMAL) {
                return true;
            }
            if (!this.selection.contains(f)) {
                this.selection.set(Arrays.asList(f));
            }
            if (this.menu != null) {
                this.menu.hide();
            }
            this.menu = this.selection.getContextMenu();
            if (this.menu != null) {
                this.menu.show(f.getNode(), x.doubleValue(), y.doubleValue());
                return true;
            }
            return false;
        }, (KeyCode[])new KeyCode[0]);
        f.getNode().addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
            if (this.getFocusedCursor() != null && e.isShiftDown()) {
                e.consume();
            }
        });
        f.getNode().addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getButton() == MouseButton.PRIMARY && event.isStillSincePress() && f.leftClicked(event.getSceneX(), event.getSceneY(), event.isShiftDown())) {
                event.consume();
            }
        });
        FXTabbedEditor.setupFrameDrag(f, false, (FXSupplier<FXTabbedEditor>)((FXSupplier)this::getParent), (FXSupplier<Boolean>)((FXSupplier)() -> {
            if (this.dragTarget != null) {
                throw new IllegalStateException("Drag begun while drag in progress");
            }
            return this.viewProperty.get() != Frame.View.JAVA_PREVIEW;
        }), (FXSupplier<FrameSelection>)((FXSupplier)this::getSelection));
    }

    public FrameCursor createCursor(FrameCanvas parent) {
        return new FrameCursor((InteractionManager)this, parent);
    }

    public TopLevelCodeElement getSource() {
        if (this.getTopLevelFrame() == null) {
            return null;
        }
        return (TopLevelCodeElement)this.getTopLevelFrame().getCode();
    }

    private void regenerateCode() {
        if (this.getTopLevelFrame() != null) {
            this.getTopLevelFrame().regenerateCode();
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void flagErrorsAsOld() {
        if (this.getTopLevelFrame() != null) {
            this.getTopLevelFrame().flagErrorsAsOld();
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void removeOldErrors() {
        if (this.getTopLevelFrame() != null) {
            this.getTopLevelFrame().removeOldErrors();
        }
        this.errors = null;
        this.updateErrorOverviewBar(false);
    }

    @OnThread(value=Tag.FXPlatform)
    void updateErrorOverviewBar(boolean waitingForCompile) {
        if (this.getTopLevelFrame() == null) {
            return;
        }
        List<ErrorOverviewBar.ErrorInfo> errors = this.getAllErrors().filter(e -> e.getRelevantNode() != null).map(e -> new ErrorOverviewBar.ErrorInfo(e.getMessage(), e.getRelevantNode(), e.visibleProperty(), (ObservableBooleanValue)e.focusedProperty(), () -> {
            if (this.getView().isBirdseye()) {
                this.disableBirdseyeView(e.getRelevantNode(), Frame.ViewChangeReason.MOUSE_CLICKED, () -> e.jumpTo((InteractionManager)this));
            } else {
                e.jumpTo((InteractionManager)this);
            }
        })).collect(Collectors.toList());
        ErrorOverviewBar.ErrorState state = waitingForCompile || this.getTopLevelFrame().getAllFrames().anyMatch(Frame::isFresh) ? ErrorOverviewBar.ErrorState.EDITING : (errors.stream().filter(e -> e.isVisible()).count() == 0L ? ErrorOverviewBar.ErrorState.NO_ERRORS : ErrorOverviewBar.ErrorState.ERRORS);
        this.errorOverviewBar.update(errors, state);
    }

    @OnThread(value=Tag.FXPlatform)
    private Stream<CodeError> getAllErrors() {
        return Stream.concat(this.getTopLevelFrame().getEditableSlots().flatMap(EditableSlot::getCurrentErrors), this.getTopLevelFrame().getAllFrames().flatMap(Frame::getCurrentErrors));
    }

    public void modifiedFrame(Frame f, boolean force) {
        if (f != null) {
            f.trackBlank();
        }
        if (!this.isLoading() || force) {
            JavaFXUtil.runNowOrLater(() -> {
                if (!this.isLoading() && this.getParent() != null || force) {
                    this.editor.codeModified();
                    this.registerStackHighlight(null);
                    JavaFXUtil.runNowOrLater(() -> this.updateErrorOverviewBar(true));
                    SuggestedFollowUpDisplay.modificationIn((InteractionManager)this);
                }
            });
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void setWindowVisible(boolean vis, boolean bringToFront) {
        if (this.getParent() == null) {
            this.parent.setValue((Object)this.project.getDefaultFXTabbedEditor());
        }
        if (vis) {
            this.getParent().addTab(this, vis, bringToFront);
        }
        this.getParent().setWindowVisible(vis, this);
        if (bringToFront) {
            this.getParent().bringToFront(this);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean isWindowVisible() {
        return this.getParent() != null && this.getParent().containsTab(this) && this.getParent().isWindowVisible();
    }

    @OnThread(value=Tag.FXPlatform)
    public void withCompletions(JavaFragment.PosInSourceDoc pos, ExpressionSlot<?> completing, CodeElement codeEl, FXPlatformConsumer<List<AssistContentThreadSafe>> handler) {
        this.withTopLevelFrame((FXPlatformConsumer<TopLevelFrame<? extends TopLevelCodeElement>>)((FXPlatformConsumer)_frame -> JavaFXUtil.runNowOrLater(() -> {
            TopLevelCodeElement allCode = this.getSource();
            handler.accept((Object)Utility.mapList(Arrays.asList(this.editor.getCompletions(allCode, pos, completing, codeEl)), AssistContentThreadSafe::copy));
        })));
    }

    @OnThread(value=Tag.FXPlatform)
    public void withSuperConstructors(FXPlatformConsumer<List<AssistContentThreadSafe>> handler) {
        TopLevelCodeElement codeEl = this.getSource();
        handler.accept((Object)Utility.mapList((Collection)codeEl.getSuperConstructors(), c -> new AssistContentThreadSafe((AssistContent)new ConstructorCompletion(c, Collections.emptyMap(), this.editor.getJavadocResolver()))));
    }

    @OnThread(value=Tag.FXPlatform)
    public List<AssistContentThreadSafe> getThisConstructors() {
        TopLevelCodeElement codeEl = this.getSource();
        return codeEl.getThisConstructors();
    }

    public void beginRecordingState(RecallableFocus f) {
        this.undoRedoManager.beginFrameState(this.getCurrentState(f));
    }

    public void endRecordingState(RecallableFocus f) {
        this.undoRedoManager.endFrameState(this.getCurrentState(f));
    }

    private FrameState getCurrentState(RecallableFocus f) {
        this.regenerateCode();
        return new FrameState(this.getTopLevelFrame(), this.getSource(), f);
    }

    @OnThread(value=Tag.FXPlatform)
    public void undo() {
        if (this.undoRedoManager.isRecording()) {
            CursorOrSlot cursorOrSlot = (CursorOrSlot)this.focusedItem.get();
            this.endRecordingState(cursorOrSlot != null ? cursorOrSlot.getRecallableFocus() : null);
        }
        this.editor.recordEdits(StrideEditReason.FLUSH);
        this.undoRedoManager.startRestoring();
        this.updateClassContents(this.undoRedoManager.undo());
        this.undoRedoManager.stopRestoring();
        this.editor.recordEdits(StrideEditReason.UNDO_GLOBAL);
    }

    @OnThread(value=Tag.FXPlatform)
    public void redo() {
        this.editor.recordEdits(StrideEditReason.FLUSH);
        this.undoRedoManager.startRestoring();
        this.updateClassContents(this.undoRedoManager.redo());
        this.undoRedoManager.stopRestoring();
        this.editor.recordEdits(StrideEditReason.REDO_GLOBAL);
    }

    @OnThread(value=Tag.FXPlatform)
    private void updateClassContents(FrameState state) {
        if (state != null) {
            ClassElement classElement = state.getClassElement(this.projectResolver, this.editor.getPackage().getQualifiedName());
            this.getTopLevelFrame().restoreCast((TopLevelCodeElement)classElement);
            this.getTopLevelFrame().regenerateCode();
            Node n = state.recallFocus(this.getTopLevelFrame());
            if (n != null) {
                this.ensureNodeVisible(n);
            }
        }
    }

    public void scrollTo(Node n, double yOffsetFromTop, Duration duration) {
        if (this.inScrollTo) {
            return;
        }
        this.inScrollTo = true;
        Bounds totalBound = this.scroll.getContent().localToScene(this.scroll.getContent().getBoundsInLocal());
        Bounds targetBound = n.localToScene(n.getBoundsInLocal());
        double totalMinusView = totalBound.getHeight() - this.scroll.getHeight();
        double targetV = Math.max(0.0, Math.min(1.0, (targetBound.getMinY() + yOffsetFromTop - totalBound.getMinY()) / totalMinusView));
        targetV = this.scroll.getVmin() + targetV * (this.scroll.getVmax() - this.scroll.getVmin());
        if (duration == null) {
            this.scroll.setVvalue(targetV);
        } else {
            this.animatingScroll = true;
            Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)this.scroll.vvalueProperty(), (Object)targetV)})});
            t.setOnFinished(e -> {
                this.animatingScroll = false;
            });
            t.play();
        }
        this.inScrollTo = false;
    }

    public FrameSelection getSelection() {
        return this.selection;
    }

    @OnThread(value=Tag.FXPlatform)
    public void saved() {
        this.getTopLevelFrame().saved();
        this.getTopLevelFrame().getEditableSlots().forEach(EditableSlot::saved);
    }

    @OnThread(value=Tag.FXPlatform)
    public void withAccessibleMembers(JavaFragment.PosInSourceDoc pos, Set<AssistContent.CompletionKind> kinds, boolean includeOverriden, FXPlatformConsumer<List<AssistContentThreadSafe>> handler) {
        TopLevelCodeElement allCode = this.getSource();
        handler.accept((Object)Utility.mapList(this.editor.getAvailableMembers(allCode, pos, kinds, includeOverriden), AssistContentThreadSafe::copy));
    }

    @OnThread(value=Tag.FXPlatform)
    void regenerateAndReparse() {
        this.regenerateCode();
        if (this.getTopLevelFrame() != null) {
            TopLevelCodeElement code = (TopLevelCodeElement)this.getTopLevelFrame().getCode();
            code.updateSourcePositions();
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void afterRegenerateAndReparse(FXPlatformRunnable action) {
        this.withTopLevelFrame((FXPlatformConsumer<TopLevelFrame<? extends TopLevelCodeElement>>)((FXPlatformConsumer)f -> {
            this.regenerateAndReparse();
            if (action != null) {
                action.run();
            }
        }));
    }

    @OnThread(value=Tag.FXPlatform)
    private void updateDisplays() {
        CodeElement el;
        if (this.getTopLevelFrame() != null && (el = this.getTopLevelFrame().getCode()) != null) {
            this.getTopLevelFrame().getAllFrames().forEach(f -> {
                if (f instanceof NormalMethodFrame) {
                    ((NormalMethodFrame)f).updateOverrideDisplay((ClassElement)el);
                }
            });
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void updateFontSize() {
        this.getTopLevelFrame().getNode().setStyle((String)this.getFontCSS().get());
        JavaFXUtil.runAfter((Duration)Duration.millis((double)500.0), () -> this.getTopLevelFrame().getAllFrames().forEach(Frame::fontSizeChanged));
    }

    @OnThread(value=Tag.FXPlatform)
    void decreaseFontSize() {
        IntegerProperty fontSize = PrefMgr.strideFontSizeProperty();
        Utility.decreaseFontSize((IntegerProperty)fontSize);
        if (((Frame.View)this.viewProperty.get()).isBirdseye()) {
            JavaFXUtil.runAfterNextLayout((Scene)this.getTabPane().getScene(), () -> JavaFXUtil.runAfterNextLayout((Scene)this.getTabPane().getScene(), () -> this.calculateBirdseyeRectangle()));
        }
    }

    @OnThread(value=Tag.FXPlatform)
    void increaseFontSize() {
        IntegerProperty fontSize = PrefMgr.strideFontSizeProperty();
        Utility.increaseFontSize((IntegerProperty)fontSize);
        if (((Frame.View)this.viewProperty.get()).isBirdseye()) {
            JavaFXUtil.runAfterNextLayout((Scene)this.getTabPane().getScene(), () -> JavaFXUtil.runAfterNextLayout((Scene)this.getTabPane().getScene(), () -> this.calculateBirdseyeRectangle()));
        }
    }

    @Override
    public StringExpression getFontCSS() {
        if (this.strideFontSizeAsString == null) {
            this.strideFontSizeAsString = PrefMgr.strideFontSizeProperty().asString();
        }
        if (this.strideFontCSS == null) {
            this.strideFontCSS = Bindings.concat((Object[])new Object[]{"-fx-font-size:", this.strideFontSizeAsString, "pt;"});
        }
        return this.strideFontCSS;
    }

    @Override
    public double getFontSize() {
        return PrefMgr.strideFontSizeProperty().get();
    }

    private void calculateBirdseyeRectangle() {
        Node n = this.birdseyeManager.getNodeForRectangle();
        Point2D scene = n.localToScene(n.getBoundsInLocal().getMinX(), n.getBoundsInLocal().getMinY());
        Point2D onPane = this.getTopLevelFrame().getNode().sceneToLocal(scene);
        this.birdseyeSelection.setX(onPane.getX());
        this.birdseyeSelection.setY(onPane.getY() + 1.5);
        this.birdseyeSelection.setWidth(n.getBoundsInLocal().getWidth());
        this.birdseyeSelection.setHeight(n.getBoundsInLocal().getHeight() - 1.5);
        this.birdseyeSelection.setFocusTraversable(true);
        this.birdseyeSelection.requestFocus();
        this.ensureNodeVisible(this.birdseyeManager.getNodeForVisibility());
    }

    @OnThread(value=Tag.FXPlatform)
    public void withTypes(Class<?> superType, boolean includeSelf, Set<Kind> kinds, BackgroundConsumer<Map<String, AssistContentThreadSafe>> handler) {
        HashMap<String, AssistContentThreadSafe> r = new HashMap<String, AssistContentThreadSafe>();
        if (kinds.contains(Kind.PRIMITIVE)) {
            FrameEditorTab.addAllToMap(r, this.editor.getEditorFixesManager().getPrimitiveTypes());
        }
        FrameEditorTab.addAllToMap(r, this.editor.getLocalTypes(superType, kinds));
        FrameEditor frameEditor = this.getFrameEditor();
        Utility.runBackground(() -> {
            FrameEditorTab.addAllToMap(r, frameEditor.getEditorFixesManager().getImportedTypes(superType, includeSelf, kinds));
            handler.accept((Object)r);
        });
    }

    @OnThread(value=Tag.Any)
    private static void addAllToMap(Map<String, AssistContentThreadSafe> r, List<AssistContentThreadSafe> acs) {
        for (AssistContentThreadSafe ac : acs) {
            r.put(ac.getName(), ac);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void withTypes(BackgroundConsumer<Map<String, AssistContentThreadSafe>> handler) {
        this.withTypes(null, true, Kind.all(), handler);
    }

    @OnThread(value=Tag.FXPlatform)
    public void removeImports(List<String> importTargets) {
        this.withTopLevelFrame((FXPlatformConsumer<TopLevelFrame<? extends TopLevelCodeElement>>)((FXPlatformConsumer)topLevelFrame -> JavaFXUtil.runNowOrLater(() -> {
            FrameCanvas importCanvas = topLevelFrame.getImportCanvas();
            ArrayList frames = new ArrayList(importCanvas.getBlockContents());
            for (Frame frame : frames) {
                ImportFrame importFrame;
                if (!(frame instanceof ImportFrame) || !importTargets.contains((importFrame = (ImportFrame)frame).getImport())) continue;
                importCanvas.removeBlock((Frame)importFrame);
            }
        })));
    }

    @OnThread(value=Tag.FXPlatform)
    public void insertAppendMethod(NormalMethodElement method, FXPlatformConsumer<Boolean> after) {
        this.withTopLevelFrame((FXPlatformConsumer<TopLevelFrame<? extends TopLevelCodeElement>>)((FXPlatformConsumer)topLevelFrame -> {
            for (NormalMethodFrame normalMethodFrame : topLevelFrame.getMethods()) {
                if (!normalMethodFrame.getName().equals(method.getName())) continue;
                this.insertMethodContentsIntoMethodFrame((MethodWithBodyElement)method, (MethodFrameWithBody<? extends MethodWithBodyElement>)normalMethodFrame);
                after.accept((Object)false);
                return;
            }
            this.insertMethodElementAtTheEnd((MethodWithBodyElement)method);
            after.accept((Object)true);
        }));
    }

    @OnThread(value=Tag.FXPlatform)
    public void insertMethodCallInConstructor(CallElement methodCall, FXPlatformConsumer<Boolean> after) {
        this.withTopLevelFrame((FXPlatformConsumer<TopLevelFrame<? extends TopLevelCodeElement>>)((FXPlatformConsumer)topLevelFrame -> {
            if (topLevelFrame.getConstructors().isEmpty()) {
                topLevelFrame.addDefaultConstructor();
            }
            for (ConstructorFrame constructorFrame : topLevelFrame.getConstructors()) {
                for (CodeFrame innerFrame : constructorFrame.getMembersFrames()) {
                    CallFrame doFrame;
                    if (!(innerFrame instanceof CallFrame) || !(doFrame = (CallFrame)innerFrame).getCode().toJavaSource().toTemporaryJavaCodeString().equals(methodCall.toJavaSource().toTemporaryJavaCodeString())) continue;
                    after.accept((Object)true);
                    return;
                }
                this.insertElementIntoMethod((CodeElement)methodCall, (MethodFrameWithBody<? extends MethodWithBodyElement>)constructorFrame);
            }
            after.accept((Object)false);
        }));
    }

    @OnThread(value=Tag.FXPlatform)
    public void insertElementIntoMethod(CodeElement element, MethodFrameWithBody<? extends MethodWithBodyElement> methodFrame) {
        methodFrame.getLastInternalCursor().insertBlockAfter(element.createFrame((InteractionManager)this));
    }

    @OnThread(value=Tag.FXPlatform)
    private void insertMethodContentsIntoMethodFrame(MethodWithBodyElement methodElement, MethodFrameWithBody<? extends MethodWithBodyElement> methodFrame) {
        for (CodeElement element : methodElement.getContents()) {
            methodFrame.getLastInternalCursor().insertBlockAfter(element.createFrame((InteractionManager)this));
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void insertMethodElementAtTheEnd(MethodWithBodyElement method) {
        this.getTopLevelFrame().insertAtEnd(method.createFrame((InteractionManager)this));
    }

    public boolean containsImport(String importSrc) {
        return this.getTopLevelFrame().getImports().contains((Object)importSrc);
    }

    public void addImport(String importSrc) {
        this.getTopLevelFrame().addImport(importSrc);
    }

    public List<InteractionManager.FileCompletion> getAvailableFilenames() {
        ArrayList<InteractionManager.FileCompletion> r = new ArrayList<InteractionManager.FileCompletion>();
        if (Config.isGreenfoot()) {
            File soundDir;
            File imageDir = new File(this.project.getProjectDir(), "images");
            if (imageDir.exists()) {
                File[] files = imageDir.listFiles(name -> name.getName().toLowerCase().endsWith(".png") || name.getName().toLowerCase().endsWith(".jpg") || name.getName().toLowerCase().endsWith(".jpeg"));
                r.addAll(Utility.mapList(Arrays.asList(files), ImageCompletion::new));
            }
            if ((soundDir = new File(this.project.getProjectDir(), "sounds")).exists()) {
                File[] files = soundDir.listFiles(name -> name.getName().toLowerCase().endsWith(".wav"));
                r.addAll(Utility.mapList(Arrays.asList(files), SoundCompletion::new));
            }
        } else {
            File[] files = this.project.getProjectDir().listFiles(name -> name.getName().toLowerCase().endsWith(".css"));
            r.addAll(Utility.mapList(Arrays.asList(files), file -> new InteractionManager.FileCompletion((File)file){
                final /* synthetic */ File val$file;
                {
                    this.val$file = file;
                }

                public File getFile() {
                    return this.val$file;
                }

                public String getType() {
                    return "CSS";
                }

                public Node getPreview(double maxWidth, double maxHeight) {
                    return null;
                }

                public Map<KeyCode, Runnable> getShortcuts() {
                    return Collections.emptyMap();
                }
            }));
        }
        return r;
    }

    @OnThread(value=Tag.FXPlatform)
    public void nextError() {
        if (this.errors == null || !this.errors.hasNext()) {
            this.errors = this.getAllErrors().iterator();
        }
        if (!this.errors.hasNext()) {
            this.editor.getWatcher().scheduleCompilation(true, CompileReason.USER, CompileType.EXPLICIT_USER_COMPILE);
            return;
        }
        while (this.errors.hasNext()) {
            CodeError e = this.errors.next();
            if (!e.visibleProperty().get()) continue;
            e.jumpTo((InteractionManager)this);
            return;
        }
        this.cancelFreshState();
    }

    public void registerStackHighlight(Frame frame) {
        if (this.stackHighlight != null && this.stackHighlight != frame) {
            this.stackHighlight.removeStackHighlight();
        }
        this.stackHighlight = frame;
    }

    public ObservableBooleanValue initialisedProperty() {
        return this.initialised;
    }

    public ObservableStringValue nameProperty() {
        return this.nameProperty;
    }

    public void setupFocusableSlotComponent(EditableSlot parent, Node node, boolean canCodeComplete, FXSupplier<List<ExtensionDescription>> getExtensions, List<FrameCatalogue.Hint> hints) {
        JavaFXUtil.addFocusListener((Node)node, focused -> {
            if (focused.booleanValue()) {
                this.selection.clear();
            }
            this.getParent().scheduleUpdateCatalogue(this, null, focused != false && canCodeComplete ? FXTabbedEditor.CodeCompletionState.POSSIBLE : FXTabbedEditor.CodeCompletionState.NOT_POSSIBLE, false, this.getView(), (List)getExtensions.get(), hints);
        });
        node.addEventHandler(MouseEvent.MOUSE_MOVED, e -> {
            if (this.dragTarget == null && e.isShortcutDown()) {
                if (this.showingUnderlinesFor != parent) {
                    if (this.showingUnderlinesFor != null) {
                        this.showingUnderlinesFor.removeAllUnderlines();
                    }
                    this.showingUnderlinesFor = parent;
                    parent.findLinks().stream().forEach(l -> this.searchLink((PossibleLink)l, (FXPlatformConsumer<Optional<LinkedIdentifier>>)((FXPlatformConsumer)olid -> olid.ifPresent(lid -> lid.show()))));
                }
            } else if (this.showingUnderlinesFor == parent) {
                this.showingUnderlinesFor = null;
                parent.removeAllUnderlines();
            }
        });
        node.addEventHandler(MouseEvent.MOUSE_EXITED, e -> {
            if (this.showingUnderlinesFor == parent) {
                this.showingUnderlinesFor = null;
                parent.removeAllUnderlines();
            }
        });
        this.setupFocusable(new CursorOrSlot(parent), node);
    }

    private void setupFocusable(CursorOrSlot parent, final Node node) {
        FXRunnable checkPositionChange = new FXRunnable(){
            Bounds lastBounds;
            {
                this.lastBounds = FrameEditorTab.this.boundsInScrollContent(node);
            }

            public void run() {
                if (node.isFocused()) {
                    Bounds boundsInScroll = FrameEditorTab.this.boundsInScrollContent(node);
                    if (Math.abs(boundsInScroll.getMinY() - this.lastBounds.getMinY()) >= 1.0 || Math.abs(boundsInScroll.getMaxY() - this.lastBounds.getMaxY()) >= 1.0) {
                        this.lastBounds = boundsInScroll;
                        if (!FrameEditorTab.this.anyButtonsPressed) {
                            FrameEditorTab.this.ensureNodeVisible(node);
                        }
                    } else {
                        this.lastBounds = boundsInScroll;
                    }
                }
            }
        };
        ChangeListener listener = (a, b, c) -> JavaFXUtil.runPlatformLater((FXPlatformRunnable)checkPositionChange);
        JavaFXUtil.addFocusListener((Node)node, focused -> {
            if (focused.booleanValue()) {
                node.localToSceneTransformProperty().addListener(listener);
                node.boundsInLocalProperty().addListener(listener);
                this.focusedItem.set((Object)parent);
                if (this.menu != null) {
                    this.menu.hide();
                }
                if (parent.isInsideCanvas(this.getTopLevelFrame().getImportCanvas())) {
                    this.getTopLevelFrame().ensureImportCanvasShowing();
                }
                if (!(this.animatingScroll || this.anyButtonsPressed || this.manualScrolledSinceLastFocusChange)) {
                    this.ensureNodeVisible(node);
                }
                if (this.getTopLevelFrame() != null) {
                    List<EditableSlot> lostFocusSlots = this.getTopLevelFrame().getEditableSlots().filter(s -> !parent.matchesSlot((EditableSlot)s)).collect(Collectors.toList());
                    lostFocusSlots.forEach(EditableSlot::lostFocus);
                    Frame focusedFrame = parent.getParentFrame();
                    HashSet<Frame> frameAndAncestors = new HashSet<Frame>();
                    Frame f = focusedFrame;
                    while (f != null) {
                        frameAndAncestors.add(f);
                        f = f.getParentCanvas() == null ? null : f.getParentCanvas().getParent().getFrame();
                    }
                    for (Frame f2 : Utility.iterableStream((Stream)this.getTopLevelFrame().getAllFrames())) {
                        if (!frameAndAncestors.contains(f2)) {
                            f2.markNonFresh();
                        }
                        if (f2 == focusedFrame) continue;
                        f2.lostFocus();
                    }
                }
            } else {
                node.localToSceneTransformProperty().removeListener(listener);
                node.boundsInLocalProperty().removeListener(listener);
                if (parent.equals(this.focusedItem.get())) {
                    this.focusedItem.set(null);
                }
            }
        });
    }

    public void ensureNodeVisible(Node node) {
        Bounds boundsInScroll = this.boundsInScroll(node);
        if (boundsInScroll == null) {
            return;
        }
        if (boundsInScroll.getHeight() < 1.0) {
            JavaFXUtil.addSelfRemovingListener((ObservableValue)node.boundsInLocalProperty(), x -> this.ensureNodeVisible(node));
            return;
        }
        double MIN = 75.0;
        Duration SCROLL_TIME = Duration.millis((double)150.0);
        if (boundsInScroll.getMaxY() < 75.0) {
            this.scrollTo(node, -75.0, SCROLL_TIME);
        } else if (boundsInScroll.getMinY() > this.scroll.heightProperty().get() - 75.0) {
            this.scrollTo(node, -(this.scroll.heightProperty().get() - 75.0), SCROLL_TIME);
        }
    }

    private Bounds boundsInScroll(Node node) {
        Bounds local = node.getBoundsInLocal();
        Bounds scene = node.localToScene(local);
        if (local.getMinY() != scene.getMinY() && local.getMaxY() != scene.getMaxY()) {
            return this.scroll.sceneToLocal(scene);
        }
        return null;
    }

    private Bounds boundsInScrollContent(Node node) {
        return this.scrollContent.sceneToLocal(node.localToScene(node.getBoundsInLocal()));
    }

    @OnThread(value=Tag.FX)
    public boolean isLoading() {
        return this.loading;
    }

    public boolean isEditable() {
        return this.viewProperty.get() != Frame.View.JAVA_PREVIEW;
    }

    @Override
    public void setupSuggestionWindow(Stage window) {
        JavaFXUtil.addFocusListener((Stage)window, focused -> this.getParent().scheduleUpdateCatalogue(this, null, focused != false ? FXTabbedEditor.CodeCompletionState.SHOWING : FXTabbedEditor.CodeCompletionState.NOT_POSSIBLE, false, Frame.View.NORMAL, Collections.emptyList(), Collections.emptyList()));
    }

    @OnThread(value=Tag.FXPlatform)
    public Pane getDragTargetCursorPane() {
        return this.getParent().getDragCursorPane();
    }

    @OnThread(value=Tag.FXPlatform)
    public void compiled() {
        if (this.getTopLevelFrame() != null) {
            this.getTopLevelFrame().getAllFrames().forEach(Frame::compiled);
        }
        this.updateDisplays();
    }

    public void ensureImportsVisible() {
        if (this.getTopLevelFrame() != null) {
            this.getTopLevelFrame().ensureImportCanvasShowing();
        }
    }

    @OnThread(value=Tag.FXPlatform)
    void ignoreEdits(FXPlatformRunnable during) {
        this.loading = true;
        during.run();
        this.loading = false;
    }

    @OnThread(value=Tag.FXPlatform)
    public void updateCatalog(FrameCursor f) {
        this.getParent().scheduleUpdateCatalogue(this, f, FXTabbedEditor.CodeCompletionState.NOT_POSSIBLE, !this.selection.getSelected().isEmpty(), this.getView(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    List<Menu> getMenus() {
        return this.menuManager.getMenus();
    }

    public WindowOverlayPane getWindowOverlayPane() {
        return this.windowOverlayPane;
    }

    public CodeOverlayPane getCodeOverlayPane() {
        return this.codeOverlayPane;
    }

    public Observable getObservableScroll() {
        return this.observableScroll;
    }

    public DoubleExpression getObservableViewportHeight() {
        return this.viewportHeight;
    }

    Frame.View getView() {
        return (Frame.View)this.viewProperty.get();
    }

    public ReadOnlyObjectProperty<Frame.View> viewProperty() {
        return this.viewProperty;
    }

    public FrameCursor getFocusedCursor() {
        if (this.focusedItem.get() == null) {
            return null;
        }
        return ((CursorOrSlot)this.focusedItem.get()).getCursor();
    }

    public Observable focusedItemObservable() {
        return this.focusedItem;
    }

    @OnThread(value=Tag.FXPlatform)
    public void updateErrorOverviewBar() {
        JavaFXUtil.runAfter((Duration)Duration.millis((double)500.0), () -> this.updateErrorOverviewBar(false));
    }

    public Paint getHighlightColor() {
        return (Paint)this.contentRoot.cssHighlightColorProperty().get();
    }

    public void focusMethod(String methodName) {
        if (this.getTopLevelFrame() != null) {
            for (NormalMethodFrame normalMethodFrame : this.getTopLevelFrame().getMethods()) {
                if (!normalMethodFrame.getName().equals(methodName)) continue;
                normalMethodFrame.focusName();
            }
        } else {
            Debug.message((String)"focusMethod @ FrameEditorTab: class frame is null!");
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setParent(FXTabbedEditor parent, boolean partOfMove) {
        if (!partOfMove && parent != null) {
            this.editor.getWatcher().recordOpen();
        } else if (!partOfMove && parent == null) {
            this.editor.getWatcher().recordClose();
        }
        this.parent.set((Object)parent);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    FXTabbedEditor getParent() {
        return (FXTabbedEditor)this.parent.get();
    }

    public ObservableValue<FXTabbedEditor> windowProperty() {
        return this.parent;
    }

    Project getProject() {
        return this.project;
    }

    @Override
    public ObservableStringValue windowTitleProperty() {
        return this.nameProperty();
    }

    @Override
    String getWebAddress() {
        return null;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void notifySelected() {
        this.editor.getWatcher().recordSelected();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void notifyUnselected() {
        this.cancelFreshState();
    }

    @OnThread(value=Tag.Any)
    public FrameEditor getFrameEditor() {
        return this.editor;
    }

    @OnThread(value=Tag.FXPlatform)
    public Class loadClass(String className) {
        return this.project.loadClass(className);
    }

    @OnThread(value=Tag.FXPlatform)
    public void recordEdits(StrideEditReason reason) {
        this.editor.recordEdits(reason);
    }

    @OnThread(value=Tag.FXPlatform)
    public void recordCodeCompletionStarted(SlotFragment element, int index, String stem, int codeCompletionId) {
        this.recordEdits(StrideEditReason.FLUSH);
        this.editor.getWatcher().recordCodeCompletionStarted(null, null, this.getLocationMap().locationFor((JavaFragment)element), index, stem, codeCompletionId);
    }

    @OnThread(value=Tag.FXPlatform)
    public void recordCodeCompletionEnded(SlotFragment element, int index, String stem, String replacement, int codeCompletionId) {
        this.recordEdits(StrideEditReason.CODE_COMPLETION);
        this.editor.getWatcher().recordCodeCompletionEnded(null, null, this.getLocationMap().locationFor((JavaFragment)element), index, stem, replacement, codeCompletionId);
    }

    @OnThread(value=Tag.FXPlatform)
    public void recordUnknownCommandKey(Frame enclosingFrame, int cursorIndex, char key) {
        if (key < ' ' || key == '\u007f') {
            return;
        }
        this.recordEdits(StrideEditReason.FLUSH);
        this.editor.getWatcher().recordUnknownCommandKey(this.getXPath(enclosingFrame), cursorIndex, key);
    }

    @OnThread(value=Tag.FXPlatform)
    public void recordShowHideFrameCatalogue(boolean show, FrameCatalogue.ShowReason reason) {
        FrameCursor focusedCursor = this.getFocusedCursor();
        this.editor.getWatcher().recordShowHideFrameCatalogue(focusedCursor != null ? this.getXPath(focusedCursor.getEnclosingFrame()) : null, focusedCursor != null ? focusedCursor.getCursorIndex() : -1, show, reason);
    }

    @OnThread(value=Tag.FX)
    public ImageView makeClassImageView() {
        return FrameEditorTab.makeClassGraphicIcon(this.imageProperty, 48, true);
    }

    @OnThread(value=Tag.FXPlatform)
    public void recordViewChange(Frame.View oldView, Frame.View newView, Frame.ViewChangeReason reason) {
        FrameCursor focusedCursor = this.getFocusedCursor();
        this.editor.getWatcher().recordViewModeChange(focusedCursor != null ? this.getXPath(focusedCursor.getEnclosingFrame()) : null, focusedCursor != null ? focusedCursor.getCursorIndex() : -1, oldView, newView, reason);
    }

    @OnThread(value=Tag.FXPlatform)
    public void recordErrorIndicatorShown(int identifier) {
        this.editor.getWatcher().recordShowErrorIndicators(Collections.singletonList(identifier));
    }

    public void showUndoDeleteBanner(int totalEffort) {
        if (totalEffort >= 15 && !this.undoBannerShowing) {
            this.undoBannerShowing = true;
            final CircleCountdown countdown = new CircleCountdown(40.0, Color.BLACK, Duration.seconds((double)15.0));
            TextFlow bannerText = new TextFlow();
            final BorderPane banner = new BorderPane((Node)bannerText);
            BorderPane.setAlignment((Node)bannerText, (Pos)Pos.TOP_LEFT);
            final FrameState restoreTarget = this.undoRedoManager.getCurrent();
            this.undoRedoManager.addListener(new FXRunnable(){

                public void run() {
                    if (!FrameEditorTab.this.undoRedoManager.canUndoToReference(restoreTarget, 2)) {
                        FrameEditorTab.this.undoRedoManager.removeListener((FXRunnable)this);
                        countdown.stop();
                        FrameEditorTab.this.bannerPane.getChildren().remove((Object)banner);
                        FrameEditorTab.this.undoBannerShowing = false;
                    }
                }
            });
            JavaFXUtil.addStyleClass((Styleable)bannerText, (String[])new String[]{"banner-undo-delete-text"});
            Button undoButton = new Button(Config.getString((String)"frame.undobanner.button"));
            JavaFXUtil.addStyleClass((Styleable)undoButton, (String[])new String[]{"banner-undo-delete-button"});
            undoButton.setOnAction(e -> {
                while (this.undoRedoManager.canUndoToReference(restoreTarget, 3)) {
                    this.undo();
                }
            });
            bannerText.getChildren().addAll((Object[])new Node[]{new Text(Config.getString((String)"frame.undobanner.text") + " "), undoButton});
            Button close = new Button(Config.getString((String)"frame.undobanner.close"));
            JavaFXUtil.addStyleClass((Styleable)close, (String[])new String[]{"banner-undo-delete-close"});
            countdown.addOnFinished(() -> {
                this.bannerPane.getChildren().remove((Object)banner);
                this.undoBannerShowing = false;
            });
            banner.setRight((Node)new VBox(new Node[]{close, countdown}));
            JavaFXUtil.addStyleClass((Styleable)banner, (String[])new String[]{"banner-undo-delete"});
            banner.styleProperty().bind((ObservableValue)new ReadOnlyStringWrapper("-fx-font-size:").concat((Object)PrefMgr.strideFontSizeProperty().asString()).concat((Object)"pt;"));
            this.bannerPane.getChildren().add(0, (Object)banner);
            close.setOnAction(e -> {
                countdown.stop();
                this.bannerPane.getChildren().remove((Object)banner);
                this.undoBannerShowing = false;
                this.focusWhenShown();
            });
        }
    }

    private String getXPath(Frame frame) {
        return frame instanceof CodeFrame ? this.getLocationMap().locationFor(((CodeFrame)frame).getCode()) : null;
    }

    private LocatableElement.LocationMap getLocationMap() {
        return ((TopLevelCodeElement)this.getTopLevelFrame().getCode()).toXML().buildLocationMap();
    }

    protected void setHeaderImage(Image image) {
        this.imageProperty.set((Object)image);
    }

    private static class WeakFontSizeUpdater
    implements ChangeListener<Number> {
        private final WeakReference<FrameEditorTab> editorRef;

        public WeakFontSizeUpdater(FrameEditorTab ed) {
            this.editorRef = new WeakReference<FrameEditorTab>(ed);
        }

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            FrameEditorTab ed = (FrameEditorTab)this.editorRef.get();
            if (ed == null) {
                observable.removeListener((ChangeListener)this);
            } else {
                JavaFXUtil.runPlatformLater(() -> ed.updateFontSize());
            }
        }
    }

    @OnThread(value=Tag.Any)
    private static enum ShowVars {
        NONE,
        FIELDS;


        public String toString() {
            if (this == NONE) {
                return "None";
            }
            return "Fields";
        }
    }
}

