/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.editor.flow.Document;

public class TrackedPosition {
    int position;
    final Document.Bias bias;
    private final Document document;

    public TrackedPosition(Document document, int initialPosition, Document.Bias bias) {
        this.document = document;
        this.position = initialPosition;
        this.bias = bias;
    }

    void updateTrackedPosition(int removedStartCharIncl, int removedEndCharExcl, int insertedLength) {
        if (this.position > removedStartCharIncl || this.position == removedStartCharIncl && this.bias == Document.Bias.FORWARD) {
            this.position = this.position < removedEndCharExcl || this.position == removedEndCharExcl && this.bias != Document.Bias.FORWARD ? removedStartCharIncl : (this.position += insertedLength - (removedEndCharExcl - removedStartCharIncl));
        }
    }

    public int getLine() {
        return this.document.getLineFromPosition(this.position);
    }

    public int getColumn() {
        return this.document.getColumnFromPosition(this.position);
    }

    public int getPosition() {
        return this.position;
    }

    public void moveBy(int amount) {
        this.position = amount <= 0 ? Math.max(0, this.position + amount) : Math.min(this.position + amount, this.document.getLength());
    }

    public void moveTo(int target) {
        this.moveBy(target - this.position);
    }

    public void moveToLineColumn(int line, int column) {
        this.moveTo(this.document.getLineStart(line) + column);
    }
}

