/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.editor.flow.Document;
import bluej.editor.flow.DocumentListener;
import bluej.editor.flow.TrackedPosition;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SlowDocument
implements Document {
    private String content = "";
    private final List<TrackedPosition> trackedPositions = new ArrayList<TrackedPosition>();
    private final List<DocumentListener> listeners = new ArrayList<DocumentListener>();

    @Override
    public void replaceText(int startCharIncl, int endCharExcl, String text) {
        int linesRemoved = this.getLineFromPosition(endCharExcl) - this.getLineFromPosition(startCharIncl);
        String prev = this.content.substring(startCharIncl, endCharExcl);
        this.content = this.content.substring(0, startCharIncl) + text + this.content.substring(endCharExcl);
        for (TrackedPosition trackedPosition : this.trackedPositions) {
            trackedPosition.updateTrackedPosition(startCharIncl, endCharExcl, text.length());
        }
        int linesAdded = this.getLineFromPosition(startCharIncl + text.length()) - this.getLineFromPosition(startCharIncl);
        for (DocumentListener listener : this.listeners) {
            listener.textReplaced(startCharIncl, prev, text, linesRemoved, linesAdded);
        }
    }

    @Override
    public String getFullContent() {
        return this.content;
    }

    @Override
    public int getLength() {
        return this.content.length();
    }

    @Override
    public int getLineFromPosition(int position) {
        int line = 0;
        for (int i = 0; i < position; ++i) {
            if (this.content.charAt(i) != '\n') continue;
            ++line;
        }
        return line;
    }

    @Override
    public int getColumnFromPosition(int position) {
        int column = 0;
        for (int i = 0; i < position; ++i) {
            if (this.content.charAt(i) == '\n') {
                column = 0;
                continue;
            }
            ++column;
        }
        return column;
    }

    @Override
    public int getLineStart(int lineNumber) {
        int line = 0;
        for (int i = 0; i < this.content.length(); ++i) {
            if (line == lineNumber) {
                return i;
            }
            if (this.content.charAt(i) != '\n') continue;
            ++line;
        }
        return this.content.length();
    }

    @Override
    public int getLineEnd(int lineNumber) {
        int start = this.getLineStart(lineNumber);
        int nextNewLine = this.content.indexOf(10, start);
        return nextNewLine == -1 ? this.getLength() : nextNewLine;
    }

    @Override
    public List<CharSequence> getLines() {
        return Arrays.asList(this.content.split("\n", -1));
    }

    @Override
    public TrackedPosition trackPosition(int position, Document.Bias bias) {
        TrackedPosition trackedPosition = new TrackedPosition(this, position, bias);
        this.trackedPositions.add(trackedPosition);
        return trackedPosition;
    }

    @Override
    public void addListener(boolean atStart, DocumentListener listener) {
        if (atStart) {
            this.listeners.add(0, listener);
        } else {
            this.listeners.add(listener);
        }
    }

    @Override
    public String getContent(int startCharIncl, int endCharExcl) {
        return this.content.substring(startCharIncl, endCharExcl);
    }

    @Override
    public Reader makeReader(int startPos, int endPos) {
        return new StringReader(this.getContent(startPos, endPos));
    }
}

