/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.Config;
import bluej.pkgmgr.Package;
import bluej.prefmgr.PrefMgr;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

public class PrintDialog
extends Dialog<PrintChoices> {
    private final BooleanExpression cannotPrint;

    public PrintDialog(Window owner, Package pkg, boolean largePrintJob) {
        CheckBox checkReadme;
        CheckBox checkDiagram;
        CheckBox checkSource;
        this.setTitle(Config.getString((String)"editor.printDialog.title"));
        this.initOwner(owner);
        this.initModality(Modality.WINDOW_MODAL);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        ComboBox comboSize = new ComboBox(FXCollections.observableArrayList((Object[])PrefMgr.PrintSize.values()));
        comboSize.getSelectionModel().select((Object)PrefMgr.getPrintFontSize());
        HBox sizeRow = new HBox(new Node[]{new Label(Config.getString((String)"editor.printDialog.fontSize")), comboSize});
        sizeRow.setAlignment(Pos.BASELINE_LEFT);
        sizeRow.setSpacing(10.0);
        CheckBox checkLineNumbers = new CheckBox(Config.getString((String)"editor.printDialog.printLineNumbers"));
        checkLineNumbers.setSelected(PrefMgr.getFlag((String)"bluej.print.lineNumbers"));
        CheckBox checkHighlighting = new CheckBox(Config.getString((String)"editor.printDialog.printHighlighting"));
        checkHighlighting.setSelected(PrefMgr.getFlag((String)"bluej.print.scopeHighlighting"));
        HBox checkHighlightingWrapper = new HBox(new Node[]{checkHighlighting});
        Tooltip.install((Node)checkHighlightingWrapper, (Tooltip)new Tooltip(Config.getString((String)"editor.printDialog.printHighlighting.tooltip")));
        if (largePrintJob) {
            checkHighlighting.setSelected(false);
            checkHighlighting.setDisable(true);
        }
        VBox vBox = new VBox(new Node[]{sizeRow, checkLineNumbers, checkHighlightingWrapper});
        vBox.setSpacing(8.0);
        if (pkg != null) {
            checkSource = new CheckBox(Config.getString((String)"pkgmgr.printDialog.printSource"));
            checkLineNumbers.disableProperty().bind((ObservableValue)checkSource.selectedProperty().not());
            checkHighlighting.disableProperty().bind((ObservableValue)checkSource.selectedProperty().not());
            checkSource.setSelected(PrefMgr.getFlag((String)"bluej.packagePrint.source"));
            vBox.getChildren().add(0, (Object)checkSource);
            checkDiagram = new CheckBox(Config.getString((String)"pkgmgr.printDialog.printDiagram"));
            checkDiagram.setSelected(PrefMgr.getFlag((String)"bluej.packagePrint.diagram"));
            if (pkg.isUnnamedPackage()) {
                checkReadme = new CheckBox(Config.getString((String)"pkgmgr.printDialog.printReadme"));
                checkReadme.setSelected(PrefMgr.getFlag((String)"bluej.packagePrint.readme"));
                vBox.getChildren().add(0, (Object)checkReadme);
                this.cannotPrint = Bindings.createBooleanBinding(() -> !checkSource.isSelected() && !checkDiagram.isSelected() && !checkReadme.isSelected(), (Observable[])new Observable[]{checkSource.selectedProperty(), checkDiagram.selectedProperty(), checkReadme.selectedProperty()});
            } else {
                checkReadme = null;
                this.cannotPrint = Bindings.createBooleanBinding(() -> !checkSource.isSelected() && !checkDiagram.isSelected(), (Observable[])new Observable[]{checkSource.selectedProperty(), checkDiagram.selectedProperty()});
            }
            vBox.getChildren().add(0, (Object)checkDiagram);
        } else {
            checkReadme = null;
            checkDiagram = null;
            checkSource = null;
            this.cannotPrint = new ReadOnlyBooleanWrapper(false);
        }
        this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().bind((ObservableValue)this.cannotPrint);
        this.getDialogPane().setContent((Node)vBox);
        this.setResultConverter(bt -> {
            if (bt == ButtonType.OK) {
                if (checkDiagram != null) {
                    PrefMgr.setFlag((String)"bluej.packagePrint.diagram", (boolean)checkDiagram.isSelected());
                }
                if (checkReadme != null) {
                    PrefMgr.setFlag((String)"bluej.packagePrint.readme", (boolean)checkReadme.isSelected());
                }
                if (checkSource != null) {
                    PrefMgr.setFlag((String)"bluej.packagePrint.source", (boolean)checkSource.isSelected());
                }
                PrefMgr.setFlag((String)"bluej.print.lineNumbers", (boolean)checkLineNumbers.isSelected());
                PrefMgr.setFlag((String)"bluej.print.scopeHighlighting", (boolean)checkHighlighting.isSelected());
                PrefMgr.setPrintFontSize((PrefMgr.PrintSize)((PrefMgr.PrintSize)comboSize.getValue()));
                return new PrintChoices(checkDiagram == null ? false : checkDiagram.isSelected(), checkReadme == null ? false : checkReadme.isSelected(), checkSource == null ? false : checkSource.isSelected(), (PrefMgr.PrintSize)comboSize.getValue(), checkLineNumbers.isSelected(), checkHighlighting.isSelected());
            }
            return null;
        });
    }

    @OnThread(value=Tag.Any)
    public static class PrintChoices {
        public final boolean printDiagram;
        public final boolean printReadme;
        public final boolean printSource;
        public final PrefMgr.PrintSize printSize;
        public final boolean printLineNumbers;
        public final boolean printHighlighting;

        public PrintChoices(boolean printDiagram, boolean printReadme, boolean printSource, PrefMgr.PrintSize printSize, boolean printLineNumbers, boolean printHighlighting) {
            this.printDiagram = printDiagram;
            this.printReadme = printReadme;
            this.printSource = printSource;
            this.printSize = printSize;
            this.printLineNumbers = printLineNumbers;
            this.printHighlighting = printHighlighting;
        }
    }
}

