/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.Config;
import bluej.editor.flow.FlowActions;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefPanelListener;
import bluej.utility.DialogManager;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformSupplier;
import bluej.utility.javafx.JavaFXUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javafx.animation.RotateTransition;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Window;
import javafx.util.Duration;
import javafx.util.StringConverter;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class KeyBindingsPanel
extends GridPane
implements PrefPanelListener {
    static final String title = Config.getString((String)"editor.functions.title");
    static final String close = Config.getString((String)"close");
    static final String defaultsLabel = Config.getString((String)"editor.functions.defaults");
    static final String categoriesLabel = Config.getString((String)"editor.functions.categories");
    static final String keyLabel = Config.getString((String)"editor.functions.keys");
    static final String addKeyLabel = Config.getString((String)"editor.functions.addkey");
    static final String delKeyLabel = Config.getString((String)"editor.functions.delkey");
    private final FXPlatformSupplier<Window> parent;
    private final Button defaultsButton;
    private final Button addKeyButton;
    private final Button delKeyButton;
    private final ComboBox<FlowActions.Category> categoryMenu;
    private final ListView<String> functionList;
    private final ListView<KeyCodeCombination> keyList;
    private final Text helpLabel;
    private FlowActions actions;
    private Properties help;
    private List<ActionInfo> functions;
    private static Label errorLabel;

    public void categoryMenuChanged() {
        FlowActions.Category selected = (FlowActions.Category)((Object)this.categoryMenu.getSelectionModel().getSelectedItem());
        this.functionList.getItems().setAll((Collection)this.functions.stream().filter(a -> a.category == selected).map(a -> a.name).collect(Collectors.toList()));
        this.clearKeyList();
        this.clearHelpText();
        this.addKeyButton.setDisable(true);
        this.delKeyButton.setDisable(true);
    }

    public KeyBindingsPanel(FXPlatformSupplier<Window> parent) {
        this.parent = parent;
        this.actions = new FlowActions(null);
        this.functions = Utility.mapList(this.actions.getAllActions(), ActionInfo::new);
        ColumnConstraints c = new ColumnConstraints();
        c.setPercentWidth(50.0);
        this.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{c, c});
        JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"prefmgr-key-panel"});
        BorderPane funcPanel = new BorderPane();
        this.functionList = new ListView();
        this.functionList.setEditable(false);
        funcPanel.setCenter(this.functionList);
        Label label = new Label(categoriesLabel + " ");
        this.categoryMenu = new ComboBox();
        HBox categoryHBox = new HBox(new Node[]{label, this.categoryMenu});
        categoryHBox.setAlignment(Pos.BASELINE_CENTER);
        BorderPane.setAlignment((Node)categoryHBox, (Pos)Pos.BASELINE_CENTER);
        funcPanel.setTop((Node)categoryHBox);
        BorderPane controlPanel = new BorderPane();
        BorderPane keyPanel = new BorderPane();
        Label kLabel = new Label(keyLabel);
        JavaFXUtil.addStyleClass((Styleable)kLabel, (String[])new String[]{"key-header-label"});
        keyPanel.setTop((Node)kLabel);
        this.keyList = new ListView();
        this.keyList.setCellFactory(lv -> new TextFieldListCell((StringConverter)new StringConverter<KeyCodeCombination>(){

            public String toString(KeyCodeCombination object) {
                return object.getDisplayText();
            }

            public KeyCodeCombination fromString(String string) {
                return null;
            }
        }));
        this.keyList.setEditable(false);
        keyPanel.setCenter(this.keyList);
        HBox keyButtonPanel = new HBox();
        keyButtonPanel.setAlignment(Pos.BASELINE_CENTER);
        JavaFXUtil.addStyleClass((Styleable)keyButtonPanel, (String[])new String[]{"key-bindings-buttons"});
        this.addKeyButton = new Button(addKeyLabel);
        keyButtonPanel.getChildren().add((Object)this.addKeyButton);
        this.delKeyButton = new Button(delKeyLabel);
        keyButtonPanel.getChildren().add((Object)this.delKeyButton);
        this.defaultsButton = new Button(defaultsLabel);
        controlPanel.setTop((Node)this.defaultsButton);
        BorderPane.setAlignment((Node)this.defaultsButton, (Pos)Pos.BASELINE_RIGHT);
        keyPanel.setBottom((Node)keyButtonPanel);
        controlPanel.setCenter((Node)keyPanel);
        this.helpLabel = new Text();
        TextFlow textFlow = new TextFlow(new Node[]{this.helpLabel});
        textFlow.setMinHeight(80.0);
        controlPanel.setBottom((Node)textFlow);
        JavaFXUtil.addStyleClass((Styleable)funcPanel, (String[])new String[]{"key-bindings-column"});
        JavaFXUtil.addStyleClass((Styleable)controlPanel, (String[])new String[]{"key-bindings-column"});
        this.add((Node)funcPanel, 0, 0);
        this.add((Node)controlPanel, 1, 0);
        this.updateDisplay();
    }

    @OnThread(value=Tag.FXPlatform)
    public void beginEditing(Project project) {
    }

    @OnThread(value=Tag.FXPlatform)
    public void commitEditing(Project project) {
        this.handleClose();
    }

    @OnThread(value=Tag.FXPlatform)
    public void revertEditing(Project project) {
    }

    public void updateDisplay() {
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.categoryMenu.getSelectionModel().selectedIndexProperty(), i -> this.categoryMenuChanged());
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.functionList.getSelectionModel().selectedIndexProperty(), i -> this.handleFuncListSelect());
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.keyList.getSelectionModel().selectedIndexProperty(), i -> this.handleKeyListSelect());
        this.defaultsButton.setOnAction(e -> this.handleDefaults());
        this.addKeyButton.setOnAction(e -> this.handleAddKey());
        this.delKeyButton.setOnAction(e -> this.handleDelKey());
        this.openHelpFile();
        this.categoryMenu.getItems().setAll((Object[])FlowActions.Category.values());
        this.categoryMenu.getSelectionModel().selectFirst();
    }

    private void handleDefaults() {
        int answer = DialogManager.askQuestionFX((Window)((Window)this.parent.get()), (String)"default-keys");
        if (answer == 0) {
            this.actions.setDefaultKeyBindings();
            this.handleFuncListSelect();
        }
    }

    private void handleFuncListSelect() {
        int index = this.functionList.getSelectionModel().getSelectedIndex();
        if (index == -1) {
            return;
        }
        String currentAction = (String)this.functionList.getSelectionModel().getSelectedItem();
        this.updateKeyList(currentAction);
        String helpText = this.getHelpText(currentAction);
        this.helpLabel.setText(helpText);
    }

    private void handleKeyListSelect() {
        this.delKeyButton.setDisable(false);
    }

    private void handleClose() {
        if (!this.actions.save()) {
            DialogManager.showErrorFX((Window)((Window)this.parent.get()), (String)"cannot-save-keys");
        }
    }

    private void handleAddKey() {
        String action;
        Optional newKey = new KeyCaptureDialog().showAndWait();
        if (newKey.equals(Optional.of(ButtonType.CANCEL))) {
            return;
        }
        if (newKey.isPresent() && (action = (String)this.functionList.getSelectionModel().getSelectedItem()) != null) {
            FlowActions.addKeyCombinationForActionToAllEditors((KeyCodeCombination)newKey.get(), action);
            this.updateKeyList(action);
        }
    }

    private void handleDelKey() {
        int index = this.keyList.getSelectionModel().getSelectedIndex();
        if (index == -1) {
            return;
        }
        String action = (String)this.functionList.getSelectionModel().getSelectedItem();
        if (action != null) {
            FlowActions.removeKeyCombinationForActionToAllEditors((KeyCodeCombination)this.keyList.getSelectionModel().getSelectedItem(), action);
            this.updateKeyList(action);
        }
    }

    private void updateKeyList(String action) {
        List<KeyCodeCombination> currentKeys = this.actions.getKeyStrokesForAction(action);
        if (currentKeys == null) {
            this.clearKeyList();
        } else {
            this.keyList.getItems().setAll(currentKeys);
            this.delKeyButton.setDisable(true);
        }
        this.addKeyButton.setDisable(false);
    }

    private void clearKeyList() {
        this.keyList.getItems().clear();
    }

    private void clearHelpText() {
        this.helpLabel.setText(null);
    }

    private void openHelpFile() {
        this.help = Config.getFlowHelp();
    }

    private String getHelpText(String function) {
        if (this.help == null) {
            return null;
        }
        String helpText = this.help.getProperty(function);
        if (helpText != null && helpText.length() > 0) {
            helpText = helpText.replaceAll("\n", "");
            helpText = helpText.trim();
        }
        return helpText;
    }

    @OnThread(value=Tag.FXPlatform)
    private static class KeyCaptureDialog
    extends Dialog<KeyCodeCombination> {
        public KeyCaptureDialog() {
            TextField textField = new TextField();
            errorLabel = (Label)JavaFXUtil.withStyleClass((Styleable)new Label(), (String[])new String[]{"dialog-error-label"});
            errorLabel.setText("");
            textField.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
                if (e.getCode() != KeyCode.ESCAPE && e.getCode() != KeyCode.SHIFT && e.getCode() != KeyCode.CONTROL && e.getCode() != KeyCode.ALT && e.getCode() != KeyCode.ALT_GRAPH && e.getCode() != KeyCode.META && e.getCode() != KeyCode.COMMAND) {
                    if (!(!e.getCode().isLetterKey() || e.isShiftDown() || e.isControlDown() || e.isAltDown() || e.isMetaDown())) {
                        errorLabel.setText("Single Character is not allowed");
                        RotateTransition animation = null;
                        animation = new RotateTransition(Duration.millis((double)70.0), (Node)errorLabel);
                        animation.setByAngle(5.0);
                        animation.setAutoReverse(true);
                        animation.setCycleCount(4);
                        animation.play();
                        return;
                    }
                    JavaFXUtil.runAfterCurrent(() -> {
                        this.setResult(new KeyCodeCombination(e.getCode(), KeyCaptureDialog.mod(e.isShiftDown()), KeyCaptureDialog.mod(e.isControlDown()), KeyCaptureDialog.mod(e.isAltDown()), KeyCaptureDialog.mod(e.isMetaDown()), KeyCombination.ModifierValue.ANY));
                        this.hide();
                    });
                    e.consume();
                }
            });
            VBox mainPanel = new VBox(new Node[]{new Label("Press a key, or Escape to cancel"), textField});
            this.getDialogPane().setContent((Node)mainPanel);
            this.setOnShown(e -> textField.requestFocus());
            Config.addDialogStylesheets((Pane)this.getDialogPane());
            this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CANCEL});
            mainPanel.getChildren().add((Object)errorLabel);
        }

        private static KeyCombination.ModifierValue mod(boolean down) {
            return down ? KeyCombination.ModifierValue.DOWN : KeyCombination.ModifierValue.UP;
        }
    }

    private static class ActionInfo {
        private final String name;
        private final FlowActions.Category category;

        public ActionInfo(FlowActions.FlowAbstractAction action) {
            this.name = action.getName();
            this.category = action.getCategory();
        }
    }
}

