/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.editor.flow.BackgroundItem;
import bluej.editor.flow.Document;
import bluej.editor.flow.FlowEditorPane;
import bluej.editor.flow.LineDisplay;
import bluej.editor.flow.ReparseRecord;
import bluej.editor.flow.ScopeColors;
import bluej.editor.flow.TextLine;
import bluej.parser.Token;
import bluej.parser.entity.EntityResolver;
import bluej.parser.nodes.NodeStructureListener;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedCUNode;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.RBTreeNode;
import bluej.parser.nodes.ReparseableDocument;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Stack;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class JavaSyntaxView
implements ReparseableDocument,
LineDisplay.LineDisplayListener {
    private static final int MAX_PARSE_PIECE = 8000;
    private static final boolean PAINT_METHOD_INNER = false;
    private static final int LEFT_INNER_SCOPE_MARGIN = 0;
    private static final int LEFT_OUTER_SCOPE_MARGIN = 0;
    private static final int RIGHT_SCOPE_MARGIN = 4;
    private static final int CURVED_CORNER_SIZE = 4;
    private static final int PARAGRAPH_MARGIN = 0;
    private static final @OnThread(value=Tag.FX) int[][] CORNER_TEMPLATE = new int[][]{{0, 0, 1, 1}, {0, 1, 2, 2}, {1, 2, 2, 2}, {1, 2, 2, 2}};
    protected final Document document;
    private final EntityResolver parentResolver;
    private ParsedCUNode rootNode;
    private NodeTree<ReparseRecord> reparseRecordTree;
    private final ScopeColors scopeColors;
    private final BooleanExpression syntaxHighlighting;
    private final Display display;
    private Color BK;
    private Color C1;
    private Color C2;
    private Color C3;
    private Color M1;
    private Color M2;
    private Color S1;
    private Color S2;
    private Color I1;
    private Color I2;
    private final List<Double> cachedSpaceSizes = new ArrayList<Double>();
    private FlowReparseRunner reparseRunner;
    private int latestRenderStartIncl = 0;
    private int latestRenderEndIncl = 2146483647;
    private final Map<Integer, Integer> linesToRecalculateAfterLayout = new HashMap<Integer, Integer>();
    private boolean scheduledRecalculateAfterLayout = false;
    private final ObservableMap<ParsedNode, Integer> nodeIndents = FXCollections.observableHashMap();
    private final Map<Integer, List<SingleNestedScope>> pendingScopeBackgrounds = new HashMap<Integer, List<SingleNestedScope>>();
    private final Map<Integer, List<TextLine.StyledSegment>> styledLines = new HashMap<Integer, List<TextLine.StyledSegment>>();
    private final LiveScopeBackgrounds scopeBackgrounds;
    private boolean duringUpdate;
    private static int EDIT_INSERT = 0;
    private static int EDIT_DELETE = 1;
    private List<EditEvent> recentEdits = new LinkedList<EditEvent>();

    public Map<Integer, List<BackgroundItem>> getScopeBackgrounds() {
        return this.scopeBackgrounds.scopeBackgrounds;
    }

    public EntityResolver getEntityResolver() {
        return this.parentResolver;
    }

    public JavaSyntaxView(Document document, Display display, ScopeColors scopeColors, EntityResolver parentResolver, BooleanExpression syntaxHighlighting) {
        this.parentResolver = parentResolver;
        this.scopeBackgrounds = new LiveScopeBackgrounds();
        this.nodeIndents.addListener((MapChangeListener)this.scopeBackgrounds);
        this.document = document;
        this.display = display;
        this.syntaxHighlighting = syntaxHighlighting;
        this.scopeColors = scopeColors;
        this.resetColors();
        if (this.display != null) {
            this.display.addLineDisplayListener(this);
            this.display.setLineStyler(this::getTokenStylesFor);
            JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.display.widthProperty(), w -> JavaFXUtil.runAfter((Duration)Duration.millis((double)500.0), () -> {
                this.recalculateAllScopes();
                this.applyPendingScopeBackgrounds();
            }));
            JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.display.heightProperty(), h -> JavaFXUtil.runAfter((Duration)Duration.millis((double)500.0), () -> {
                this.recalculateAllScopes();
                this.applyPendingScopeBackgrounds();
            }));
        }
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)PrefMgr.getScopeHighlightStrength(), str -> {
            this.resetColors();
            this.recalculateAndApplyAllScopes();
        });
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.syntaxHighlighting, syn -> this.recalculateAndApplyAllScopes());
        JavaFXUtil.addChangeListenerPlatform(scopeColors.scopeClassColorProperty(), str -> JavaFXUtil.runAfterCurrent(() -> {
            this.resetColors();
            this.recalculateAllScopes();
        }));
    }

    @OnThread(value=Tag.FXPlatform)
    public void enableParser(boolean force) {
        if (this.rootNode == null) {
            this.rootNode = new ParsedCUNode(this.parentResolver);
            this.reparseRecordTree = new NodeTree();
            this.rootNode.textInserted((ReparseableDocument)this, 0, 0, this.document.getLength(), (NodeStructureListener)new SyntaxEvent(0, this.document.getLength(), true, false));
            this.document.addListener(true, (start, oldText, newText, linesRemoved, linesAdded) -> {
                if (oldText.length() != 0) {
                    this.scopeBackgrounds.linesRemoved(this.document.getLineFromPosition(start), linesRemoved);
                    this.fireRemoveUpdate(start, oldText.length());
                }
                if (newText.length() != 0) {
                    this.scopeBackgrounds.linesAdded(this.document.getLineFromPosition(start), linesAdded);
                    this.fireInsertUpdate(start, newText.length());
                }
                this.scheduleReparseRunner();
            });
            this.scheduleReparseRunner();
        }
    }

    private void recalculateAllScopes() {
        this.scopeBackgrounds.clear();
        this.recalculateScopes(0, this.document.getLineCount() - 1);
    }

    public void recalculateAndApplyAllScopes() {
        this.recalculateAllScopes();
        this.applyPendingScopeBackgrounds();
    }

    private final List<TextLine.StyledSegment> getTokenStylesFor(int lineIndex, CharSequence lineContent) {
        if (!this.syntaxHighlighting.get() || this.rootNode == null) {
            return Collections.singletonList(new TextLine.StyledSegment(Collections.emptyList(), lineContent.toString()));
        }
        List<TextLine.StyledSegment> cached = this.styledLines.get(lineIndex);
        if (cached != null && lineContent.equals(this.asCharSequence(cached))) {
            return cached;
        }
        ArrayList<TextLine.StyledSegment> lineStyle = new ArrayList<TextLine.StyledSegment>();
        int curPosInLine = 0;
        Token nextToken = this.rootNode.getMarkTokensFor(this.document.getLineStart(lineIndex), lineContent.length(), 0, (ReparseableDocument)this);
        while (nextToken.id != Token.TokenType.END) {
            String tokenContent = lineContent.subSequence(curPosInLine, curPosInLine + nextToken.length).toString();
            List<String> tokenStyle = Collections.singletonList(nextToken.id.getCSSClass());
            lineStyle.add(new TextLine.StyledSegment(tokenStyle, tokenContent));
            curPosInLine += nextToken.length;
            nextToken = nextToken.next;
        }
        if (lineStyle.isEmpty()) {
            lineStyle.add(new TextLine.StyledSegment(Collections.emptyList(), ""));
        }
        this.styledLines.put(lineIndex, lineStyle);
        return lineStyle;
    }

    private CharSequence asCharSequence(final List<TextLine.StyledSegment> styledSegments) {
        final int length = styledSegments.stream().mapToInt(s -> s.getText().length()).sum();
        return new CharSequence(){
            int lastSegmentIndex = 0;
            int lastSegmentStart = 0;

            @Override
            public int length() {
                return length;
            }

            @Override
            public char charAt(int index) {
                if (index < this.lastSegmentStart) {
                    this.lastSegmentIndex = 0;
                    this.lastSegmentStart = 0;
                }
                do {
                    String lastSegmentText;
                    if (index - this.lastSegmentStart < (lastSegmentText = ((TextLine.StyledSegment)styledSegments.get(this.lastSegmentIndex)).getText()).length()) {
                        return lastSegmentText.charAt(index - this.lastSegmentStart);
                    }
                    this.lastSegmentStart += lastSegmentText.length();
                    ++this.lastSegmentIndex;
                } while (this.lastSegmentIndex < styledSegments.size());
                throw new StringIndexOutOfBoundsException(index);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void recalculateScopes(int firstLineIncl, int lastLineIncl) {
        if (this.display == null) {
            return;
        }
        this.recalcScopeMarkers((int)this.display.getTextDisplayWidth(), firstLineIncl, lastLineIncl, 0);
    }

    protected void recalcScopeMarkers(int fullWidth, int firstLine, int lastLine, int attemptCount) {
        if (this.rootNode == null) {
            return;
        }
        int aboveLine = firstLine - 1;
        LinkedList<NodeTree.NodeAndPosition<ParsedNode>> prevScopeStack = new LinkedList<NodeTree.NodeAndPosition<ParsedNode>>();
        int curLine = firstLine;
        ThreeLines lines = new ThreeLines();
        lines.aboveLineEl = null;
        if (aboveLine >= 0) {
            lines.aboveLineEl = new Element(aboveLine);
        }
        lines.belowLineEl = null;
        if (firstLine + 1 < this.document.getLineCount()) {
            lines.belowLineEl = new Element(firstLine + 1);
        }
        lines.thisLineEl = new Element(firstLine);
        this.getScopeStackAfter((ParsedNode)this.rootNode, 0, lines.thisLineEl.getStartOffset(), prevScopeStack);
        while (curLine <= lastLine && !prevScopeStack.isEmpty()) {
            DrawInfo scope = this.drawScopes(fullWidth, lines, prevScopeStack, 0);
            if (scope.someMissing) {
                this.rescheduleCalculateAfterNextLayout(fullWidth, curLine, attemptCount);
            } else {
                this.pendingScopeBackgrounds.put(curLine, scope.scopes);
            }
            if (++curLine > lastLine) continue;
            lines.aboveLineEl = lines.thisLineEl;
            lines.thisLineEl = lines.belowLineEl;
            if (curLine + 1 < this.document.getLineCount()) {
                lines.belowLineEl = new Element(curLine + 1);
                continue;
            }
            lines.belowLineEl = null;
        }
    }

    private void rescheduleCalculateAfterNextLayout(int fullWidth, int line, int attemptCount) {
        this.linesToRecalculateAfterLayout.put(line, attemptCount);
        if (!this.scheduledRecalculateAfterLayout) {
            this.scheduledRecalculateAfterLayout = true;
            JavaFXUtil.runAfterNextLayout((Scene)((Scene)this.display.sceneProperty().get()), () -> {
                this.scheduledRecalculateAfterLayout = false;
                HashMap<Integer, Integer> toProcess = new HashMap<Integer, Integer>(this.linesToRecalculateAfterLayout);
                this.linesToRecalculateAfterLayout.clear();
                for (Map.Entry<Integer, Integer> entry : toProcess.entrySet()) {
                    if (entry.getValue() < 5) {
                        this.recalcScopeMarkers(fullWidth, entry.getKey(), entry.getKey(), entry.getValue() + 1);
                        continue;
                    }
                    Debug.message((String)("Giving up on line #" + entry.getKey()));
                }
                this.applyPendingScopeBackgrounds();
            });
        }
    }

    private DrawInfo drawScopes(int fullWidth, ThreeLines lines, List<NodeTree.NodeAndPosition<ParsedNode>> prevScopeStack, int nodeDepth) {
        Color[] colors;
        int rbound;
        int napEnd;
        int napPos;
        NodeTree.NodeAndPosition nap;
        int rightMargin = 2;
        ListIterator<NodeTree.NodeAndPosition<ParsedNode>> li = prevScopeStack.listIterator();
        DrawInfo drawInfo = new DrawInfo(lines);
        while (li.hasNext()) {
            nap = li.next();
            napPos = nap.getPosition();
            napEnd = nap.getEnd();
            if (napPos >= lines.thisLineEl.getEndOffset()) {
                return drawInfo;
            }
            if (!this.drawNode(drawInfo, nap)) continue;
            if (this.nodeSkipsEnd(napPos, napEnd, lines.thisLineEl)) {
                ++nodeDepth;
                break;
            }
            OptionalInt xpos = this.getNodeIndent(nap, lines.thisLineEl);
            if (xpos != null && xpos.isPresent() && xpos.getAsInt() <= fullWidth) {
                boolean starts = this.nodeSkipsStart(nap, lines.aboveLineEl);
                boolean ends = this.nodeSkipsEnd(napPos, napEnd, lines.belowLineEl);
                rbound = this.getNodeRBound(nap, fullWidth - rightMargin, nodeDepth, lines.thisLineEl);
                drawInfo.node = (ParsedNode)nap.getNode();
                drawInfo.starts = starts;
                drawInfo.ends = ends;
                colors = this.colorsForNode(drawInfo.node);
                drawInfo.color1 = colors[0];
                drawInfo.color2 = colors[1];
                drawInfo.addNestedScope(xpos.getAsInt(), rbound);
            } else if (xpos != null && xpos.isEmpty()) {
                drawInfo.someMissing = true;
            }
            ++nodeDepth;
        }
        --nodeDepth;
        li = prevScopeStack.listIterator(prevScopeStack.size());
        nap = li.previous();
        napPos = nap.getPosition();
        napEnd = napPos + nap.getSize();
        while (napEnd <= lines.thisLineEl.getEndOffset()) {
            li.remove();
            if (this.drawNode(drawInfo, nap)) {
                --nodeDepth;
            }
            if (!li.hasPrevious()) {
                return drawInfo;
            }
            NodeTree.NodeAndPosition<ParsedNode> napParent = li.previous();
            li.next();
            NodeTree.NodeAndPosition nextNap = nap.nextSibling();
            napPos = napParent.getPosition();
            napEnd = napPos + napParent.getSize();
            nap = napParent;
            while (nextNap != null) {
                li.add((NodeTree.NodeAndPosition<ParsedNode>)nextNap);
                li.previous();
                li.next();
                napPos = nextNap.getPosition();
                napEnd = napPos + nextNap.getSize();
                if (napPos < lines.thisLineEl.getEndOffset() && !this.nodeSkipsStart((NodeTree.NodeAndPosition<ParsedNode>)nextNap, lines.thisLineEl) && this.drawNode(drawInfo, (NodeTree.NodeAndPosition<ParsedNode>)nextNap)) {
                    OptionalInt xpos = this.getNodeIndent((NodeTree.NodeAndPosition<ParsedNode>)nextNap, lines.thisLineEl);
                    rbound = this.getNodeRBound((NodeTree.NodeAndPosition<ParsedNode>)nextNap, fullWidth - rightMargin, ++nodeDepth, lines.thisLineEl);
                    drawInfo.node = (ParsedNode)nextNap.getNode();
                    colors = this.colorsForNode(drawInfo.node);
                    drawInfo.color1 = colors[0];
                    drawInfo.color2 = colors[1];
                    drawInfo.starts = this.nodeSkipsStart((NodeTree.NodeAndPosition<ParsedNode>)nextNap, lines.aboveLineEl);
                    drawInfo.ends = this.nodeSkipsEnd(napPos, napEnd, lines.belowLineEl);
                    if (xpos != null && xpos.isPresent() && xpos.getAsInt() <= fullWidth) {
                        drawInfo.addNestedScope(xpos.getAsInt(), rbound);
                    } else if (xpos != null && xpos.isEmpty()) {
                        drawInfo.someMissing = true;
                    }
                }
                nap = nextNap;
                nextNap = ((ParsedNode)nextNap.getNode()).findNodeAtOrAfter(napPos, napPos);
            }
        }
        return drawInfo;
    }

    private OptionalInt getLeftEdge(int startOffset) {
        if (this.display == null) {
            return OptionalInt.empty();
        }
        while (this.cachedSpaceSizes.size() < 8) {
            String spaces = "        ";
            double indent = this.display.getWidthOfText(spaces.substring(0, this.cachedSpaceSizes.size()));
            if (!(indent >= (double)(this.cachedSpaceSizes.size() * 2))) continue;
            this.cachedSpaceSizes.add(indent);
        }
        int column = this.document.getColumnFromPosition(startOffset);
        if (column == 0) {
            return OptionalInt.of(0);
        }
        int line = this.document.getLineFromPosition(startOffset);
        CharSequence lineText = new Element(line).getText();
        boolean allSpaces = lineText.subSequence(0, column).codePoints().allMatch(n -> n == 32);
        if (!(this.display.isLineVisible(line) || allSpaces && this.cachedSpaceSizes.size() > 4)) {
            if (this.isPrinting()) {
                TextField field = new TextField();
                Scene s = new Scene((Parent)new BorderPane((Node)field));
                field.applyCss();
                double singleSpaceWidth = JavaFXUtil.measureString((TextInputControl)field, (String)"          ", (boolean)false, (boolean)false) / 10.0;
                int positionSpaceWidth = (int)(singleSpaceWidth * (double)column * 1.05);
                return OptionalInt.of(positionSpaceWidth + 0);
            }
            return OptionalInt.empty();
        }
        if (allSpaces) {
            int numberOfSpaces = column;
            if (numberOfSpaces >= this.cachedSpaceSizes.size()) {
                if (this.cachedSpaceSizes.size() >= 4) {
                    int highestSpaces = this.cachedSpaceSizes.size() - 1;
                    double highestWidth = this.cachedSpaceSizes.get(highestSpaces) - this.cachedSpaceSizes.get(0);
                    return OptionalInt.of((int)(highestWidth / (double)highestSpaces * (double)numberOfSpaces + this.cachedSpaceSizes.get(0)));
                }
                return OptionalInt.empty();
            }
            return OptionalInt.of(this.cachedSpaceSizes.get(numberOfSpaces).intValue());
        }
        try {
            Optional<Object> leftEdge = Optional.empty();
            if (!this.duringUpdate) {
                leftEdge = this.display.getLeftEdgeX(startOffset);
            }
            if (leftEdge.isPresent()) {
                double indent = (Double)leftEdge.get();
                return OptionalInt.of((int)indent);
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Debug.reportError((Throwable)e);
        }
        return OptionalInt.empty();
    }

    private boolean drawNode(DrawInfo info, NodeTree.NodeAndPosition<ParsedNode> nap) {
        int napEnd;
        int napPos = nap.getPosition();
        if (napPos == (napEnd = napPos + nap.getSize())) {
            return false;
        }
        if (napPos >= info.lines.thisLineEl.getEndOffset()) {
            return false;
        }
        if (!((ParsedNode)nap.getNode()).isContainer() && !((ParsedNode)nap.getNode()).isInner()) {
            return false;
        }
        if (this.nodeSkipsStart(nap, info.lines.thisLineEl)) {
            return false;
        }
        return !this.nodeSkipsEnd(napPos, napEnd, info.lines.thisLineEl);
    }

    private Color getBackgroundColor() {
        return this.BK;
    }

    private Color[] colorsForNode(ParsedNode node) {
        if (node.isInner()) {
            return new Color[]{this.C3, this.getBackgroundColor()};
        }
        if (node.getNodeType() == 2) {
            return new Color[]{this.M1, this.M2};
        }
        if (node.getNodeType() == 3) {
            return new Color[]{this.I1, this.I2};
        }
        if (node.getNodeType() == 4 || node.getNodeType() == 0) {
            return new Color[]{this.S1, this.S2};
        }
        return new Color[]{this.C1, this.C2};
    }

    private int getNodeRBound(NodeTree.NodeAndPosition<ParsedNode> nap, int fullWidth, int nodeDepth, Element lineEl) {
        int napEnd = nap.getEnd();
        int rbound = fullWidth - (nodeDepth + 1) / 2 * 4;
        if (lineEl == null || napEnd >= lineEl.getEndOffset()) {
            return rbound;
        }
        if (napEnd < lineEl.getStartOffset()) {
            return rbound;
        }
        int nwsb = this.findNonWhitespaceComment(nap, lineEl, napEnd - lineEl.getStartOffset());
        if (nwsb != -1) {
            OptionalInt eboundsX = this.getLeftEdge(napEnd);
            if (eboundsX.isPresent()) {
                return Math.min(rbound, eboundsX.getAsInt());
            }
            return rbound;
        }
        return rbound;
    }

    private boolean nodeSkipsStart(NodeTree.NodeAndPosition<ParsedNode> nap, Element lineEl) {
        if (lineEl == null) {
            return true;
        }
        int napPos = nap.getPosition();
        int napEnd = nap.getEnd();
        if (napPos > lineEl.getStartOffset() && napEnd > lineEl.getEndOffset()) {
            if (napPos >= lineEl.getEndOffset()) {
                return true;
            }
            int nws = this.findNonWhitespaceComment(nap, lineEl, napPos - lineEl.getStartOffset());
            if (nws == -1) {
                return true;
            }
        }
        return false;
    }

    private boolean nodeSkipsEnd(int napPos, int napEnd, Element lineEl) {
        if (lineEl == null) {
            return true;
        }
        if (napEnd < lineEl.getEndOffset() && napPos < lineEl.getStartOffset()) {
            if (napEnd <= lineEl.getStartOffset()) {
                return true;
            }
            if (napEnd >= lineEl.getEndOffset()) {
                return false;
            }
            int nws = this.findNonWhitespace(lineEl, 0);
            if (nws == -1 || lineEl.getStartOffset() + nws >= napEnd) {
                return true;
            }
        }
        return false;
    }

    private OptionalInt getNodeIndent(NodeTree.NodeAndPosition<ParsedNode> nap, Element lineEl) {
        OptionalInt lboundsX;
        int nws;
        if (lineEl == null) {
            return OptionalInt.of(Integer.MAX_VALUE);
        }
        int napPos = nap.getPosition();
        int napEnd = nap.getEnd();
        if (napPos >= lineEl.getEndOffset()) {
            return OptionalInt.of(Integer.MAX_VALUE);
        }
        if (napEnd <= lineEl.getStartOffset()) {
            return OptionalInt.of(Integer.MAX_VALUE);
        }
        if (this.nodeSkipsStart(nap, lineEl) || this.nodeSkipsEnd(napPos, napEnd, lineEl)) {
            return OptionalInt.of(Integer.MAX_VALUE);
        }
        OptionalInt indent = JavaSyntaxView.ofNullableInteger((Integer)this.nodeIndents.get((Object)nap.getNode()));
        if (indent.isEmpty()) {
            if (this.display != null && (this.display.isLineVisible(this.document.getLineFromPosition(lineEl.getStartOffset())) || this.isPrinting())) {
                indent = this.calculateNodeIndent(nap);
                if (indent.isPresent()) {
                    this.nodeIndents.put((Object)((ParsedNode)nap.getNode()), (Object)indent.getAsInt());
                }
            } else {
                return null;
            }
        }
        OptionalInt xpos = indent;
        if (napPos > lineEl.getStartOffset() && (nws = this.findNonWhitespaceBwards(lineEl, napPos - lineEl.getStartOffset() - 1, 0)) != -1 && (lboundsX = this.getLeftEdge(lineEl.getStartOffset() + nws + 1)).isPresent()) {
            xpos = OptionalInt.of(Math.max(xpos.isPresent() ? xpos.getAsInt() : Integer.MIN_VALUE, lboundsX.getAsInt() - 0));
        }
        return xpos;
    }

    private static OptionalInt ofNullableInteger(Integer intOrNull) {
        return intOrNull == null ? OptionalInt.empty() : OptionalInt.of(intOrNull);
    }

    private boolean isPrinting() {
        return this.display != null && this.display.isPrinting();
    }

    private OptionalInt calculateNodeIndent(NodeTree.NodeAndPosition<ParsedNode> nap) {
        try {
            OptionalInt indent = OptionalInt.of(Integer.MAX_VALUE);
            int curpos = nap.getPosition();
            int napEnd = nap.getEnd();
            Stack<Object> scopeStack = new Stack<Object>();
            scopeStack.add(nap);
            block2: while (curpos < napEnd) {
                NodeTree.NodeAndPosition top = (NodeTree.NodeAndPosition)scopeStack.get(scopeStack.size() - 1);
                while (top.getEnd() <= curpos) {
                    scopeStack.remove(scopeStack.size() - 1);
                    top = (NodeTree.NodeAndPosition)scopeStack.get(scopeStack.size() - 1);
                }
                NodeTree.NodeAndPosition nextChild = ((ParsedNode)top.getNode()).findNodeAt(curpos + 1, top.getPosition());
                while (nextChild != null && nextChild.getPosition() <= curpos) {
                    if (((ParsedNode)nextChild.getNode()).isInner()) {
                        curpos = nextChild.getEnd();
                        continue block2;
                    }
                    scopeStack.add(nextChild);
                    top = nextChild;
                    nextChild = ((ParsedNode)top.getNode()).findNodeAt(curpos + 1, top.getPosition());
                }
                int line = this.document.getLineFromPosition(curpos);
                Element lineEl = new Element(line);
                int lineOffset = curpos - lineEl.getStartOffset();
                int nws = lineEl.getStartOffset() < nap.getPosition() && ((ParsedNode)nap.getNode()).isInner() ? this.findNonWhitespaceComment(nap, lineEl, lineOffset) : this.findNonWhitespace(lineEl, lineOffset);
                if (nws == lineOffset) {
                    OptionalInt cboundsX = this.getLeftEdge(curpos);
                    indent = cboundsX.isPresent() ? OptionalInt.of(Math.min(indent.isPresent() ? indent.getAsInt() : Integer.MAX_VALUE, cboundsX.getAsInt() - 0)) : OptionalInt.empty();
                    curpos = lineEl.getEndOffset();
                    continue;
                }
                if (nws == -1) {
                    curpos = lineEl.getEndOffset();
                    continue;
                }
                curpos += nws - lineOffset;
            }
            return indent;
        }
        catch (IndexOutOfBoundsException e) {
            return OptionalInt.empty();
        }
    }

    private int[] reassessIndentsAdd(int dmgStart, int dmgEnd) {
        NodeTree.NodeAndPosition top;
        ParsedCUNode pcuNode = this.rootNode;
        if (pcuNode == null) {
            return new int[]{dmgStart, dmgEnd};
        }
        int ls = this.document.getLineFromPosition(dmgStart);
        int le = this.document.getLineFromPosition(dmgEnd);
        int[] dmgRange = new int[]{dmgStart, dmgEnd};
        int i = ls;
        LinkedList<NodeTree.NodeAndPosition> scopeStack = new LinkedList<NodeTree.NodeAndPosition>();
        int lineEndPos = new Element(le).getEndOffset();
        Element lineEl = new Element(ls);
        for (top = pcuNode.findNodeAtOrAfter(lineEl.getStartOffset(), 0); top != null && top.getEnd() == lineEl.getStartOffset(); top = top.nextSibling()) {
        }
        if (top == null) {
            return dmgRange;
        }
        if (top.getPosition() >= lineEl.getEndOffset() && (i = this.document.getLineFromPosition(top.getPosition())) > le) {
            return dmgRange;
        }
        scopeStack.add(top);
        NodeTree.NodeAndPosition nap = ((ParsedNode)top.getNode()).findNodeAtOrAfter(lineEl.getStartOffset() + 1, top.getPosition());
        while (nap != null) {
            scopeStack.add(nap);
            nap = ((ParsedNode)nap.getNode()).findNodeAtOrAfter(lineEl.getStartOffset() + 1, nap.getPosition());
        }
        block2: while (true) {
            Integer oindent;
            int nws = this.findNonWhitespace(lineEl, 0);
            while (nws == -1) {
                if (++i > le) break block2;
                lineEl = new Element(i);
                nws = this.findNonWhitespace(lineEl, 0);
            }
            int curpos = lineEl.getStartOffset() + nws;
            ListIterator j = scopeStack.listIterator(scopeStack.size());
            NodeTree.NodeAndPosition topNap = null;
            while ((nap = (NodeTree.NodeAndPosition)j.previous()).getEnd() <= curpos) {
                topNap = nap;
                j.remove();
                if (j.hasPrevious()) continue;
            }
            if (topNap != null) {
                while ((topNap = topNap.nextSibling()) != null && topNap.getEnd() <= curpos) {
                }
                while (topNap != null && topNap.getPosition() < lineEndPos) {
                    scopeStack.add(topNap);
                    topNap = ((ParsedNode)topNap.getNode()).findNodeAtOrAfter(curpos + 1, topNap.getPosition());
                }
            }
            if (scopeStack.isEmpty()) break;
            OptionalInt cboundsX = this.getLeftEdge(lineEl.getStartOffset() + nws);
            int indent = cboundsX.orElse(0);
            j = scopeStack.listIterator(scopeStack.size());
            while (j.hasPrevious()) {
                NodeTree.NodeAndPosition next = (NodeTree.NodeAndPosition)j.previous();
                if (next.getPosition() <= curpos) {
                    this.updateNodeIndent((NodeTree.NodeAndPosition<ParsedNode>)next, indent - 0, (Integer)this.nodeIndents.get((Object)next.getNode()), dmgRange);
                } else {
                    if (next.getPosition() >= lineEl.getEndOffset()) continue;
                    nws = this.findNonWhitespace(lineEl, next.getPosition() - lineEl.getStartOffset());
                    oindent = (Integer)this.nodeIndents.get((Object)next.getNode());
                    if (oindent != null && nws != -1) {
                        cboundsX = this.getLeftEdge(lineEl.getStartOffset() + nws);
                        indent = cboundsX.orElse(0);
                        this.updateNodeIndent((NodeTree.NodeAndPosition<ParsedNode>)next, indent - 0, oindent, dmgRange);
                    }
                }
                if (!((ParsedNode)next.getNode()).isInner()) continue;
                break;
            }
            j = scopeStack.listIterator(scopeStack.size());
            while (j.hasPrevious() && (nap = (NodeTree.NodeAndPosition)j.previous()).getEnd() <= lineEl.getEndOffset()) {
                nap = nap.nextSibling();
                j.remove();
                if (nap == null) continue;
                do {
                    scopeStack.add(nap);
                    if (nap.getPosition() >= lineEl.getEndOffset()) continue;
                    int spos = nap.getPosition() - lineEl.getStartOffset();
                    nws = this.findNonWhitespace(lineEl, spos);
                    oindent = (Integer)this.nodeIndents.get((Object)nap.getNode());
                    if (oindent == null || nws == -1) continue;
                    cboundsX = this.getLeftEdge(lineEl.getStartOffset() + nws);
                    indent = cboundsX.orElse(0);
                    this.updateNodeIndent((NodeTree.NodeAndPosition<ParsedNode>)nap, indent - 0, oindent, dmgRange);
                } while ((nap = ((ParsedNode)nap.getNode()).findNodeAtOrAfter(nap.getPosition(), nap.getPosition())) != null);
                j = scopeStack.listIterator(scopeStack.size());
            }
            if (++i > le) break;
            lineEl = new Element(i);
        }
        return dmgRange;
    }

    private int[] reassessIndentsRemove(int dmgPoint, boolean multiLine) {
        NodeTree.NodeAndPosition top;
        ParsedCUNode pcuNode = this.rootNode;
        int[] dmgRange = new int[]{dmgPoint, dmgPoint};
        if (pcuNode == null) {
            return dmgRange;
        }
        int ls = this.document.getLineFromPosition(dmgPoint);
        Element lineEl = new Element(ls);
        for (top = pcuNode.findNodeAtOrAfter(lineEl.getStartOffset(), 0); top != null && top.getEnd() == lineEl.getStartOffset(); top = top.nextSibling()) {
        }
        if (top == null) {
            return dmgRange;
        }
        if (top.getPosition() >= lineEl.getEndOffset()) {
            return dmgRange;
        }
        LinkedList<NodeTree.NodeAndPosition<ParsedNode>> rscopeStack = new LinkedList<NodeTree.NodeAndPosition<ParsedNode>>();
        this.getScopeStackAfter((ParsedNode)this.rootNode, 0, dmgPoint, rscopeStack);
        rscopeStack.remove(0);
        boolean doContinue = true;
        OptionalInt cboundsX = this.getLeftEdge(dmgPoint);
        int dpI = cboundsX.orElse(0) - 0;
        block1: while (doContinue && !rscopeStack.isEmpty()) {
            NodeTree.NodeAndPosition rtop = (NodeTree.NodeAndPosition)rscopeStack.remove(rscopeStack.size() - 1);
            while (rtop != null && rtop.getPosition() < lineEl.getEndOffset()) {
                Integer cachedIndent;
                if (rtop.getPosition() <= dmgPoint && rtop.getEnd() >= lineEl.getEndOffset()) {
                    doContinue &= !((ParsedNode)rtop.getNode()).isInner();
                }
                if ((cachedIndent = (Integer)this.nodeIndents.get((Object)rtop.getNode())) == null) {
                    rtop = rtop.nextSibling();
                    continue;
                }
                if (!multiLine && cachedIndent < dpI) {
                    rtop = rtop.nextSibling();
                    continue;
                }
                if (this.nodeSkipsStart((NodeTree.NodeAndPosition<ParsedNode>)rtop, lineEl)) {
                    if (rtop.getPosition() > dmgPoint) continue block1;
                    this.nodeIndents.remove((Object)rtop.getNode());
                    dmgRange[0] = Math.min(dmgRange[0], rtop.getPosition());
                    dmgRange[1] = Math.max(dmgRange[1], rtop.getEnd());
                    continue block1;
                }
                int nwsP = Math.max(lineEl.getStartOffset(), rtop.getPosition());
                int nws = this.findNonWhitespace(lineEl, nwsP - lineEl.getStartOffset());
                if (nws == -1 || nws + lineEl.getStartOffset() >= rtop.getEnd()) {
                    if (rtop.getPosition() <= dmgPoint) {
                        this.nodeIndents.remove((Object)rtop.getNode());
                        dmgRange[0] = Math.min(dmgRange[0], rtop.getPosition());
                        dmgRange[1] = Math.max(dmgRange[1], rtop.getEnd());
                    }
                    rtop = rtop.nextSibling();
                    continue;
                }
                cboundsX = this.getLeftEdge(nws + lineEl.getStartOffset());
                int newIndent = cboundsX.orElse(0) - 0;
                if (newIndent < cachedIndent) {
                    this.nodeIndents.put((Object)((ParsedNode)rtop.getNode()), (Object)newIndent);
                    dmgRange[0] = Math.min(dmgRange[0], rtop.getPosition());
                    dmgRange[1] = Math.max(dmgRange[1], rtop.getEnd());
                } else if (newIndent > cachedIndent && rtop.getPosition() <= dmgPoint) {
                    this.nodeIndents.remove((Object)rtop.getNode());
                    dmgRange[0] = Math.min(dmgRange[0], rtop.getPosition());
                    dmgRange[1] = Math.max(dmgRange[1], rtop.getEnd());
                }
                rtop = rtop.nextSibling();
            }
        }
        return dmgRange;
    }

    private void updateNodeIndent(NodeTree.NodeAndPosition<ParsedNode> nap, int indent, Integer oindent, int[] dmgRange) {
        int dmgStart = dmgRange[0];
        int dmgEnd = dmgRange[1];
        if (oindent != null) {
            int noindent = oindent;
            if (indent < noindent) {
                this.nodeIndents.put((Object)((ParsedNode)nap.getNode()), (Object)indent);
            } else if (indent != noindent) {
                this.nodeIndents.remove((Object)nap.getNode());
            }
            if (indent != noindent) {
                dmgStart = Math.min(dmgStart, nap.getPosition());
                dmgEnd = Math.max(dmgEnd, nap.getEnd());
                dmgRange[0] = dmgStart;
                dmgRange[1] = dmgEnd;
            }
        }
    }

    private void getScopeStackAfter(ParsedNode root, int rootPos, int position, List<NodeTree.NodeAndPosition<ParsedNode>> list) {
        list.add((NodeTree.NodeAndPosition<ParsedNode>)new NodeTree.NodeAndPosition((RBTreeNode)root, 0, root.getSize()));
        int curpos = rootPos;
        NodeTree.NodeAndPosition nap = root.findNodeAtOrAfter(position + 1, curpos);
        while (nap != null) {
            list.add((NodeTree.NodeAndPosition<ParsedNode>)nap);
            curpos = nap.getPosition();
            nap = ((ParsedNode)nap.getNode()).findNodeAtOrAfter(position + 1, curpos);
        }
    }

    private int findNonWhitespace(Element element, int startPos) {
        CharSequence text = element.getText();
        for (int i = startPos; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return i;
        }
        return -1;
    }

    private int findNonWhitespaceComment(NodeTree.NodeAndPosition<ParsedNode> nap, Element lineEl, int startPos) {
        int nws = this.findNonWhitespace(lineEl, startPos);
        if (nws != -1) {
            NodeTree.NodeAndPosition nnap;
            NodeTree.NodeAndPosition inNap;
            int pos = nws + lineEl.getStartOffset();
            if (nap.getEnd() > pos ? (inNap = ((ParsedNode)nap.getNode()).findNodeAt(pos, nap.getPosition())) != null && ((ParsedNode)inNap.getNode()).getNodeType() == 7 && inNap.getPosition() == pos && inNap.getEnd() == lineEl.getEndOffset() - 1 : (nnap = nap.nextSibling()) != null && ((ParsedNode)nnap.getNode()).getNodeType() == 7 && nnap.getPosition() == pos && nnap.getEnd() == lineEl.getEndOffset() - 1) {
                return -1;
            }
        }
        return nws;
    }

    private int findNonWhitespaceBwards(Element element, int startPos, int endPos) {
        CharSequence text = element.getText();
        for (int i = startPos; i > endPos; --i) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return i;
        }
        return endPos - 1;
    }

    protected void updateDamage(SyntaxEvent changes) {
        int[] r;
        int[] r2;
        ParsedNode parent;
        if (changes == null) {
            this.nodeIndents.clear();
            this.recalculateAllScopes();
            return;
        }
        int damageStart = this.document.getLength();
        int damageEnd = 0;
        SyntaxEvent mse = changes;
        for (NodeTree.NodeAndPosition<ParsedNode> nap : mse.getAddedNodes()) {
            for (parent = ((ParsedNode)nap.getNode()).getParentNode(); parent != null; parent = parent.getParentNode()) {
                this.nodeIndents.remove((Object)parent);
            }
            int[] r3 = this.clearNap(nap, this.document, damageStart, damageEnd);
            damageStart = r3[0];
            damageEnd = r3[1];
        }
        for (NodeTree.NodeAndPosition<ParsedNode> node : mse.getRemovedNodes()) {
            for (parent = ((ParsedNode)node.getNode()).getParentNode(); parent != null; parent = parent.getParentNode()) {
                this.nodeIndents.remove((Object)parent);
            }
            damageStart = Math.min(damageStart, node.getPosition());
            damageEnd = Math.max(damageEnd, node.getEnd());
            NodeTree.NodeAndPosition<ParsedNode> nap = node;
            r2 = this.clearNap(nap, this.document, damageStart, damageEnd);
            damageStart = r2[0];
            damageEnd = r2[1];
        }
        for (SyntaxEvent.NodeChangeRecord record : mse.getChangedNodes()) {
            NodeTree.NodeAndPosition<ParsedNode> nap = record.nap;
            this.nodeIndents.remove((Object)nap.getNode());
            for (ParsedNode parent2 = ((ParsedNode)nap.getNode()).getParentNode(); parent2 != null; parent2 = parent2.getParentNode()) {
                this.nodeIndents.remove((Object)parent2);
            }
            damageStart = Math.min(damageStart, nap.getPosition());
            damageStart = Math.min(damageStart, record.originalPos);
            damageEnd = Math.max(damageEnd, nap.getEnd());
            damageEnd = Math.max(damageEnd, record.originalPos + record.originalSize);
            r2 = this.clearNap(nap, this.document, damageStart, damageEnd);
            damageStart = r2[0];
            damageEnd = r2[1];
        }
        if (changes.isInsert()) {
            damageStart = Math.min(damageStart, changes.getOffset());
            damageEnd = Math.max(damageEnd, changes.getOffset() + changes.getLength());
            r = this.reassessIndentsAdd(damageStart, damageEnd);
            damageStart = r[0];
            damageEnd = r[1];
        } else if (changes.isRemove()) {
            damageStart = Math.min(damageStart, changes.getOffset());
            r = this.reassessIndentsRemove(damageStart, true);
            damageStart = r[0];
            damageEnd = r[1];
        }
        if (damageStart < damageEnd) {
            int line = this.document.getLineFromPosition(damageStart);
            int lastline = this.document.getLineFromPosition(damageEnd - 1);
            this.recalculateScopes(line, lastline);
        }
    }

    private int[] clearNap(NodeTree.NodeAndPosition<ParsedNode> nap, Document document, int damageStart, int damageEnd) {
        if (((ParsedNode)nap.getNode()).isInner()) {
            LinkedList<NodeTree.NodeAndPosition> list = new LinkedList<NodeTree.NodeAndPosition>();
            NodeTree.NodeAndPosition top = new NodeTree.NodeAndPosition((RBTreeNode)this.rootNode, 0, document.getLength());
            while (top != null && top.getNode() != nap.getNode()) {
                if (((ParsedNode)top.getNode()).isInner()) {
                    list.clear();
                }
                list.add(top);
                top = ((ParsedNode)top.getNode()).findNodeAt(nap.getEnd(), top.getPosition());
            }
            for (NodeTree.NodeAndPosition cnap : list) {
                damageStart = Math.min(damageStart, cnap.getPosition());
                damageEnd = Math.max(damageEnd, cnap.getEnd());
                this.nodeIndents.remove((Object)cnap.getNode());
            }
        }
        return new int[]{damageStart, damageEnd};
    }

    private void nodeRemoved(ParsedNode node) {
        this.nodeIndents.remove((Object)node);
    }

    void resetColors() {
        this.BK = (Color)this.scopeColors.scopeBackgroundColorProperty().get();
        this.C1 = this.getReducedColor(this.scopeColors.scopeClassOuterColorProperty());
        this.C2 = this.getReducedColor(this.scopeColors.scopeClassColorProperty());
        this.C3 = this.getReducedColor(this.scopeColors.scopeClassInnerColorProperty());
        this.M1 = this.getReducedColor(this.scopeColors.scopeMethodOuterColorProperty());
        this.M2 = this.getReducedColor(this.scopeColors.scopeMethodColorProperty());
        this.S1 = this.getReducedColor(this.scopeColors.scopeSelectionOuterColorProperty());
        this.S2 = this.getReducedColor(this.scopeColors.scopeSelectionColorProperty());
        this.I1 = this.getReducedColor(this.scopeColors.scopeIterationOuterColorProperty());
        this.I2 = this.getReducedColor(this.scopeColors.scopeIterationColorProperty());
    }

    private Color getReducedColor(ObjectExpression<Color> c) {
        return (Color)this.scopeColors.getReducedColor(c, PrefMgr.getScopeHighlightStrength()).getValue();
    }

    public static List<SingleNestedScope> withModified(List<SingleNestedScope> originalScopes, ParsedNode key, int lhs) {
        ArrayList<SingleNestedScope> r = new ArrayList<SingleNestedScope>();
        for (SingleNestedScope nestedScope : originalScopes) {
            if (nestedScope.lhsFrom == key) {
                r.add(new SingleNestedScope(nestedScope.lhsFrom, lhs, nestedScope.rhs, nestedScope.starts, nestedScope.ends, nestedScope.fillColor, nestedScope.edgeColor));
                continue;
            }
            r.add(nestedScope);
        }
        return r;
    }

    public void scheduleReparse(int pos, int size) {
        NodeTree.NodeAndPosition existing = this.reparseRecordTree.findNodeAtOrAfter(pos);
        if (existing != null) {
            if (existing.getPosition() > pos && existing.getPosition() <= pos + size) {
                ((ReparseRecord)existing.getNode()).slideStart(pos - existing.getPosition());
                return;
            }
            if (existing.getPosition() <= pos) {
                int nsize = pos + size - existing.getPosition();
                if (nsize > existing.getSize()) {
                    NodeTree.NodeAndPosition next = existing.nextSibling();
                    while (next != null && next.getPosition() <= pos + size) {
                        nsize = Math.max(nsize, next.getEnd() - pos);
                        NodeTree.NodeAndPosition nnext = next.nextSibling();
                        ((ReparseRecord)next.getNode()).remove();
                        next = nnext;
                    }
                    ((ReparseRecord)existing.getNode()).setSize(nsize);
                }
                return;
            }
        }
        ReparseRecord rr = new ReparseRecord();
        this.reparseRecordTree.insertNode((RBTreeNode)rr, pos, size);
    }

    public void flushReparseQueue() {
        while (this.pollReparseQueue(this.document.getLength())) {
        }
        this.applyPendingScopeBackgrounds();
    }

    private void applyPendingScopeBackgrounds() {
        this.pendingScopeBackgrounds.forEach((line, info) -> {
            this.scopeBackgrounds.removeAllScopesForLine((int)line);
            this.scopeBackgrounds.storeSource((Integer)line, (List<SingleNestedScope>)info);
            for (SingleNestedScope nestedScope : info) {
                CornerRadii radii = null;
                Insets bodyInsets = null;
                double singleRadius = 5.0;
                if (nestedScope.starts && nestedScope.ends) {
                    radii = new CornerRadii(singleRadius, false);
                    bodyInsets = new Insets(1.0);
                } else if (nestedScope.starts) {
                    radii = new CornerRadii(singleRadius, singleRadius, 0.0, 0.0, false);
                    bodyInsets = new Insets(1.0, 1.0, 0.0, 1.0);
                } else if (nestedScope.ends) {
                    radii = new CornerRadii(0.0, 0.0, singleRadius, singleRadius, false);
                    bodyInsets = new Insets(0.0, 1.0, 1.0, 1.0);
                } else {
                    bodyInsets = new Insets(0.0, 1.0, 0.0, 1.0);
                }
                BackgroundItem rectangle = new BackgroundItem(nestedScope.lhs, nestedScope.rhs - nestedScope.lhs, new BackgroundFill((Paint)nestedScope.edgeColor, radii, null), new BackgroundFill((Paint)nestedScope.fillColor, radii, bodyInsets));
                this.scopeBackgrounds.addScopeBox((Integer)line, rectangle);
            }
        });
        this.pendingScopeBackgrounds.clear();
        if (this.display != null) {
            this.display.applyScopeBackgrounds(this.scopeBackgrounds.scopeBackgrounds);
        }
    }

    public boolean pollReparseQueue() {
        return this.pollReparseQueue(8000);
    }

    @OnThread(value=Tag.FXPlatform)
    private boolean pollReparseQueue(int maxParse) {
        try {
            if (this.reparseRecordTree == null) {
                return false;
            }
            NodeTree.NodeAndPosition nap = this.reparseRecordTree.findNodeAtOrAfter(0);
            if (nap != null) {
                int pos = nap.getPosition();
                ParsedCUNode pn = this.rootNode;
                int ppos = 0;
                if (pn != null) {
                    NodeTree.NodeAndPosition cn;
                    for (cn = pn.findNodeAt(pos, ppos); cn != null && cn.getEnd() == pos; cn = cn.nextSibling()) {
                    }
                    while (cn != null && cn.getPosition() <= pos) {
                        ppos = cn.getPosition();
                        pn = (ParsedNode)cn.getNode();
                        for (cn = pn.findNodeAt(nap.getPosition(), ppos); cn != null && cn.getEnd() == pos; cn = cn.nextSibling()) {
                        }
                    }
                    SyntaxEvent mse = new SyntaxEvent(-1, -1, false, false);
                    pn.reparse((ReparseableDocument)this, ppos, pos, maxParse, (NodeStructureListener)mse);
                    this.updateDamage(mse);
                    return true;
                }
            }
            return false;
        }
        catch (RuntimeException e) {
            Debug.message((String)"Exception during incremental parsing. Recent edits:");
            for (EditEvent event : this.recentEdits) {
                Object eventStr = event.type == EDIT_INSERT ? "insert " : "delete ";
                eventStr = (String)eventStr + "offset=" + event.offset + " length=" + event.length;
                Debug.message((String)eventStr);
            }
            Debug.message((String)"--- Source code ---");
            Debug.message((String)this.document.getFullContent());
            Debug.message((String)"--- Source ends ---");
            Debug.reportError((Throwable)e);
            throw e;
        }
    }

    public ReparseableDocument.Element getDefaultRootElement() {
        return new ReparseableDocument.Element(){

            public ReparseableDocument.Element getElement(int index) {
                int[] lineStarts = new int[JavaSyntaxView.this.document.getLineCount()];
                for (int i = 0; i < lineStarts.length; ++i) {
                    lineStarts[i] = JavaSyntaxView.this.document.getLineStart(i);
                }
                if (index >= lineStarts.length) {
                    return null;
                }
                boolean lastPara = index == lineStarts.length - 1;
                final int paraLength = lastPara ? JavaSyntaxView.this.document.getLength() - lineStarts[index] : lineStarts[index + 1] - lineStarts[index];
                final int pos = lineStarts[index];
                return new ReparseableDocument.Element(){

                    public ReparseableDocument.Element getElement(int index) {
                        return null;
                    }

                    public int getStartOffset() {
                        return pos;
                    }

                    public int getEndOffset() {
                        return pos + paraLength;
                    }

                    public int getElementIndex(int offset) {
                        return -1;
                    }

                    public int getElementCount() {
                        return 0;
                    }
                };
            }

            public int getStartOffset() {
                return 0;
            }

            public int getEndOffset() {
                return JavaSyntaxView.this.document.getLength();
            }

            public int getElementIndex(int offset) {
                return JavaSyntaxView.this.document.getLineFromPosition(offset);
            }

            public int getElementCount() {
                return JavaSyntaxView.this.document.getLineCount();
            }
        };
    }

    public Reader makeReader(int startPos, int endPos) {
        return this.document.makeReader(startPos, endPos);
    }

    public int getLength() {
        return this.document.getLength();
    }

    public void markSectionParsed(int pos, int size) {
        this.repaintLines(pos, size, true);
        NodeTree.NodeAndPosition existing = this.reparseRecordTree.findNodeAtOrAfter(pos);
        while (existing != null && existing.getPosition() <= pos) {
            NodeTree.NodeAndPosition next = existing.nextSibling();
            int rsize = existing.getEnd() - pos;
            if ((rsize = Math.min(rsize, size)) == existing.getSize()) {
                ((ReparseRecord)existing.getNode()).remove();
            } else {
                if (existing.getPosition() == pos) {
                    existing.slideStart(rsize);
                    existing = next;
                    break;
                }
                int existingEnd = existing.getEnd();
                existing.setSize(pos - existing.getPosition());
                if (existingEnd > pos + size) {
                    this.scheduleReparse(pos + size, existingEnd - (pos + size));
                    return;
                }
            }
            existing = next;
        }
        while (existing != null && existing.getPosition() < pos + size) {
            int rsize = pos + size - existing.getPosition();
            if (rsize < existing.getSize()) {
                existing.slideStart(rsize);
                return;
            }
            NodeTree.NodeAndPosition next = existing.nextSibling();
            ((ReparseRecord)existing.getNode()).remove();
            existing = next;
        }
    }

    private void repaintLines(int offset, int length, boolean restyle) {
        int startLine = this.document.getLineFromPosition(offset);
        int endLine = this.document.getLineFromPosition(offset + length);
        this.recalculateScopes(startLine, endLine);
        this.restyleLines(startLine, endLine);
    }

    @Override
    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void renderedLines(int fromLineIndexIncl, int toLineIndexIncl) {
        int newBeforeStartIncl = fromLineIndexIncl;
        int newBeforeEndIncl = this.latestRenderStartIncl - 1;
        int newAfterStartIncl = this.latestRenderEndIncl + 1;
        int newAfterEndIncl = toLineIndexIncl;
        if (newBeforeStartIncl <= newBeforeEndIncl || newAfterStartIncl <= newAfterEndIncl) {
            if (newBeforeStartIncl <= newBeforeEndIncl) {
                this.recalculateScopes(Math.min(newBeforeStartIncl, this.document.getLineCount() - 1), Math.min(newBeforeEndIncl, this.document.getLineCount() - 1));
            }
            if (newAfterStartIncl <= newAfterEndIncl) {
                this.recalculateScopes(Math.min(newAfterStartIncl, this.document.getLineCount() - 1), Math.min(newAfterEndIncl, this.document.getLineCount() - 1));
            }
            this.applyPendingScopeBackgrounds();
            if (this.display != null) {
                this.display.requestLayout();
            }
        }
        this.latestRenderStartIncl = fromLineIndexIncl;
        this.latestRenderEndIncl = toLineIndexIncl;
    }

    private void scheduleReparseRunner() {
        if (this.reparseRunner == null && !this.isPrinting() && this.display != null) {
            if (this.display.sceneProperty().get() == null) {
                JavaFXUtil.onceNotNull(this.display.sceneProperty(), s -> this.scheduleReparseRunner());
            } else {
                this.reparseRunner = new FlowReparseRunner();
                JavaFXUtil.runAfterNextLayout((Scene)((Scene)this.display.sceneProperty().get()), (FXPlatformRunnable)this.reparseRunner);
                this.display.requestLayout();
            }
        } else if (this.isPrinting() || this.display == null) {
            this.flushReparseQueue();
        }
    }

    public ParsedCUNode getParser() {
        return this.rootNode;
    }

    protected void fireInsertUpdate(int offset, int length) {
        NodeTree.NodeAndPosition napRr;
        this.duringUpdate = true;
        if (this.reparseRecordTree != null && (napRr = this.reparseRecordTree.findNodeAtOrAfter(offset)) != null) {
            if (napRr.getPosition() <= offset) {
                ((ReparseRecord)napRr.getNode()).resize(napRr.getSize() + length);
            } else {
                ((ReparseRecord)napRr.getNode()).slide(length);
            }
        }
        this.restyleLines(this.document.getLineFromPosition(offset), this.document.getLineFromPosition(offset + length));
        SyntaxEvent mse = new SyntaxEvent(offset, length, true, false);
        if (this.rootNode != null) {
            this.rootNode.textInserted((ReparseableDocument)this, 0, offset, length, (NodeStructureListener)mse);
        }
        this.fireChangedUpdate(mse);
        this.recordEvent(mse);
        this.duringUpdate = false;
    }

    protected void fireRemoveUpdate(int offset, int length) {
        this.duringUpdate = true;
        NodeTree.NodeAndPosition napRr = this.reparseRecordTree != null ? this.reparseRecordTree.findNodeAtOrAfter(offset) : null;
        int rpos = offset;
        int rlen = length;
        if (napRr != null && napRr.getEnd() == rpos) {
            napRr = napRr.nextSibling();
        }
        while (napRr != null && rlen > 0) {
            if (napRr.getPosition() < rpos) {
                if (napRr.getEnd() >= rpos + rlen) {
                    ((ReparseRecord)napRr.getNode()).resize(napRr.getSize() - rlen);
                    break;
                }
                int reduction = napRr.getEnd() - rpos;
                ((ReparseRecord)napRr.getNode()).resize(napRr.getSize() - reduction);
                rlen -= reduction;
                napRr = napRr.nextSibling();
                continue;
            }
            if (napRr.getPosition() == rpos) {
                if (napRr.getEnd() > rpos + rlen) {
                    ((ReparseRecord)napRr.getNode()).resize(napRr.getSize() - rlen);
                    break;
                }
                ((ReparseRecord)napRr.getNode()).remove();
                napRr = this.reparseRecordTree.findNodeAtOrAfter(offset);
                continue;
            }
            if (napRr.getPosition() >= rpos + rlen) {
                napRr.slide(-rlen);
                break;
            }
            if (napRr.getEnd() <= rpos + rlen) {
                NodeTree.NodeAndPosition nextRr = napRr.nextSibling();
                ((ReparseRecord)napRr.getNode()).remove();
                napRr = nextRr;
                continue;
            }
            int ramount = rpos + rlen - napRr.getPosition();
            napRr.slideStart(ramount);
            napRr.slide(-rlen);
            break;
        }
        this.restyleLines(this.document.getLineFromPosition(offset), this.document.getLineFromPosition(offset + length));
        SyntaxEvent mse = new SyntaxEvent(offset, length, false, true);
        if (this.rootNode != null) {
            this.rootNode.textRemoved((ReparseableDocument)this, 0, offset, length, (NodeStructureListener)mse);
        }
        this.fireChangedUpdate(mse);
        this.recordEvent(mse);
        this.duringUpdate = false;
    }

    public void fontSizeChanged() {
        this.cachedSpaceSizes.clear();
        this.nodeIndents.clear();
        this.scopeBackgrounds.clear();
        if (this.display != null) {
            JavaFXUtil.runAfterNextLayout((Scene)((Scene)this.display.sceneProperty().get()), () -> this.recalculateAndApplyAllScopes());
        }
    }

    public void fireChangedUpdate(SyntaxEvent mse) {
        this.updateDamage(mse);
        if (mse == null) {
            this.applyPendingScopeBackgrounds();
        }
    }

    public void restyleLines(int start, int end) {
        for (int i = start; i <= end; ++i) {
            this.styledLines.remove(i);
        }
    }

    private void recordEvent(SyntaxEvent event) {
        int type;
        if (event.isInsert()) {
            type = EDIT_INSERT;
        } else if (event.isRemove()) {
            type = EDIT_DELETE;
        } else {
            return;
        }
        EditEvent eevent = new EditEvent();
        eevent.type = type;
        eevent.offset = event.getOffset();
        eevent.length = event.getLength();
        this.recentEdits.add(eevent);
        if (this.recentEdits.size() > 10) {
            this.recentEdits.remove(0);
        }
    }

    public String getFullText() {
        return this.document.getFullContent();
    }

    @OnThread(value=Tag.Any)
    public static class SyntaxEvent
    implements NodeStructureListener {
        private final int offset;
        private final int length;
        private final List<NodeTree.NodeAndPosition<ParsedNode>> addedNodes = new ArrayList<NodeTree.NodeAndPosition<ParsedNode>>();
        private final List<NodeTree.NodeAndPosition<ParsedNode>> removedNodes = new ArrayList<NodeTree.NodeAndPosition<ParsedNode>>();
        private final Map<ParsedNode, NodeChangeRecord> changedNodes = new HashMap<ParsedNode, NodeChangeRecord>();
        private final boolean insert;
        private final boolean remove;

        public SyntaxEvent(int offset, int length, boolean isInsert, boolean isRemove) {
            this.offset = offset;
            this.length = length;
            this.insert = isInsert;
            this.remove = isRemove;
        }

        public List<NodeTree.NodeAndPosition<ParsedNode>> getAddedNodes() {
            return this.addedNodes;
        }

        public List<NodeTree.NodeAndPosition<ParsedNode>> getRemovedNodes() {
            return this.removedNodes;
        }

        public Collection<NodeChangeRecord> getChangedNodes() {
            return this.changedNodes.values();
        }

        public void nodeAdded(NodeTree.NodeAndPosition<ParsedNode> node) {
            this.addedNodes.add(node);
        }

        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        public void nodeRemoved(NodeTree.NodeAndPosition<ParsedNode> node) {
            this.removedNodes.add(node);
            this.changedNodes.remove(node.getNode());
        }

        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        public void nodeChangedLength(NodeTree.NodeAndPosition<ParsedNode> nap, int oldPos, int oldSize) {
            NodeChangeRecord r = this.changedNodes.get(nap.getNode());
            if (r == null) {
                if (nap.getPosition() != oldPos || nap.getSize() != oldSize) {
                    r = new NodeChangeRecord();
                    r.nap = nap;
                    r.originalPos = oldPos;
                    r.originalSize = oldSize;
                    this.changedNodes.put((ParsedNode)nap.getNode(), r);
                }
            } else if (nap.getPosition() == r.originalPos && nap.getSize() == r.originalSize) {
                this.changedNodes.remove(nap.getNode());
            } else {
                r.nap = nap;
            }
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public boolean isInsert() {
            return this.insert;
        }

        public boolean isRemove() {
            return this.remove;
        }

        @OnThread(value=Tag.Any)
        public class NodeChangeRecord {
            public int originalPos;
            public int originalSize;
            public NodeTree.NodeAndPosition<ParsedNode> nap;
        }
    }

    public static interface Display {
        public ReadOnlyObjectProperty<Scene> sceneProperty();

        public ReadOnlyDoubleProperty widthProperty();

        public ReadOnlyDoubleProperty heightProperty();

        public void requestLayout();

        default public boolean isPrinting() {
            return false;
        }

        public boolean isLineVisible(int var1);

        public Optional<Double> getLeftEdgeX(int var1);

        public void addLineDisplayListener(LineDisplay.LineDisplayListener var1);

        public void setLineStyler(FlowEditorPane.LineStyler var1);

        public double getTextDisplayWidth();

        public void applyScopeBackgrounds(Map<Integer, List<BackgroundItem>> var1);

        public void repaint();

        public double getWidthOfText(String var1);
    }

    @OnThread(value=Tag.Any)
    public static class EditEvent {
        int type;
        int offset;
        int length;
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    private class FlowReparseRunner
    implements FXPlatformRunnable {
        private int procTime = 15;

        public void run() {
            long begin = System.currentTimeMillis();
            if (JavaSyntaxView.this.document != null && JavaSyntaxView.this.pollReparseQueue()) {
                while (System.currentTimeMillis() - begin < (long)this.procTime && JavaSyntaxView.this.pollReparseQueue()) {
                }
                JavaFXUtil.runPlatformLater((FXPlatformRunnable)this);
            } else {
                JavaSyntaxView.this.applyPendingScopeBackgrounds();
                JavaSyntaxView.this.display.repaint();
                JavaSyntaxView.this.reparseRunner = null;
            }
        }
    }

    private static class SingleNestedScope {
        private final ParsedNode lhsFrom;
        private final int lhs;
        private final int rhs;
        private final boolean starts;
        private final boolean ends;
        private final Color fillColor;
        private final Color edgeColor;

        public SingleNestedScope(ParsedNode lhsFrom, int lhs, int rhs, boolean starts, boolean ends, Color fillColor, Color edgeColor) {
            this.lhsFrom = lhsFrom;
            this.lhs = Math.max(0, lhs -= lhsFrom.isInner() ? 0 : 0);
            this.rhs = rhs;
            this.starts = starts;
            this.ends = ends;
            this.fillColor = fillColor;
            this.edgeColor = edgeColor;
        }
    }

    private class DrawInfo {
        final ArrayList<SingleNestedScope> scopes = new ArrayList();
        final ThreeLines lines;
        ParsedNode node;
        boolean starts;
        boolean ends;
        Color color1;
        Color color2;
        boolean someMissing = false;

        private DrawInfo(ThreeLines lines) {
            this.lines = lines;
        }

        private void addNestedScope(int xpos, int rbound) {
            this.scopes.add(new SingleNestedScope(this.node, xpos, rbound, this.starts, this.ends, this.color2, this.color1));
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public class Element {
        private final int lineIndex;
        private CharSequence cachedContent;

        private Element(int lineIndex) {
            this.lineIndex = lineIndex;
        }

        public int getStartOffset() {
            return JavaSyntaxView.this.document.getLineStart(this.lineIndex);
        }

        public int getEndOffset() {
            return this.lineIndex == JavaSyntaxView.this.document.getLineCount() - 1 ? JavaSyntaxView.this.document.getLength() : JavaSyntaxView.this.document.getLineStart(this.lineIndex + 1);
        }

        public CharSequence getText() {
            if (this.cachedContent == null) {
                this.cachedContent = JavaSyntaxView.this.document.getContent(this.getStartOffset(), this.getEndOffset());
            }
            return this.cachedContent;
        }
    }

    private class ThreeLines {
        Element aboveLineEl;
        Element thisLineEl;
        Element belowLineEl;

        private ThreeLines() {
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private class LiveScopeBackgrounds
    implements MapChangeListener<ParsedNode, Integer> {
        private final Map<Integer, List<SingleNestedScope>> sourceInfo = new HashMap<Integer, List<SingleNestedScope>>();
        private final Map<Integer, List<BackgroundItem>> scopeBackgrounds = new HashMap<Integer, List<BackgroundItem>>();

        private LiveScopeBackgrounds() {
        }

        public void storeSource(Integer line, List<SingleNestedScope> info) {
            this.sourceInfo.put(line, info);
        }

        public void clear() {
            this.scopeBackgrounds.clear();
            this.sourceInfo.clear();
        }

        public void addScopeBox(Integer line, BackgroundItem rectangle) {
            this.scopeBackgrounds.computeIfAbsent(line, k -> new ArrayList()).add(rectangle);
        }

        public void removeAllScopesForLine(int line) {
            this.scopeBackgrounds.remove(line);
            this.sourceInfo.remove(line);
        }

        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        public void onChanged(MapChangeListener.Change<? extends ParsedNode, ? extends Integer> change) {
            if (change.wasAdded()) {
                this.sourceInfo.forEach((line, info) -> {
                    if (info.stream().anyMatch(single -> single.lhsFrom == change.getKey())) {
                        JavaSyntaxView.this.pendingScopeBackgrounds.putIfAbsent((Integer)line, JavaSyntaxView.withModified(info, (ParsedNode)change.getKey(), (Integer)change.getValueAdded()));
                    }
                });
                JavaSyntaxView.this.pendingScopeBackgrounds.replaceAll((line, info) -> {
                    if (info.stream().anyMatch(single -> single.lhsFrom == change.getKey())) {
                        return JavaSyntaxView.withModified(info, (ParsedNode)change.getKey(), (Integer)change.getValueAdded());
                    }
                    return info;
                });
            }
        }

        public void linesRemoved(int firstRemovedLineIndex, int removedCount) {
            HashMap newScope = new HashMap();
            HashMap newSource = new HashMap();
            this.scopeBackgrounds.forEach((l, rs) -> {
                if (l < firstRemovedLineIndex) {
                    newScope.put(l, rs);
                } else if (l >= firstRemovedLineIndex + removedCount) {
                    newScope.put(l - removedCount, rs);
                }
            });
            this.sourceInfo.forEach((l, rs) -> {
                if (l < firstRemovedLineIndex) {
                    newSource.put(l, rs);
                } else if (l >= firstRemovedLineIndex + removedCount) {
                    newSource.put(l - removedCount, rs);
                }
            });
            this.scopeBackgrounds.clear();
            this.scopeBackgrounds.putAll(newScope);
            this.sourceInfo.clear();
            this.sourceInfo.putAll(newSource);
        }

        public void linesAdded(int lineIndex, int addedCount) {
            HashMap newScope = new HashMap();
            HashMap newSource = new HashMap();
            this.scopeBackgrounds.forEach((l, rs) -> {
                if (l < lineIndex) {
                    newScope.put(l, rs);
                } else {
                    newScope.put(l + addedCount, rs);
                }
            });
            this.sourceInfo.forEach((l, rs) -> {
                if (l < lineIndex) {
                    newSource.put(l, rs);
                } else {
                    newSource.put(l + addedCount, rs);
                }
            });
            this.scopeBackgrounds.clear();
            this.scopeBackgrounds.putAll(newScope);
            this.sourceInfo.clear();
            this.sourceInfo.putAll(newSource);
        }
    }

    public static enum ParagraphAttribute {
        STEP_MARK("bj-step-mark"),
        BREAKPOINT("bj-breakpoint"),
        ERROR("bj-error");

        private final String pseudoClass;

        private ParagraphAttribute(String pseudoClass) {
            this.pseudoClass = pseudoClass;
        }

        public String getPseudoclass() {
            return this.pseudoClass;
        }
    }
}

