/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.Config;
import bluej.editor.flow.BackgroundItem;
import bluej.editor.flow.Document;
import bluej.editor.flow.HoleDocument;
import bluej.editor.flow.JavaSyntaxView;
import bluej.editor.flow.LineDisplay;
import bluej.editor.flow.MarginAndTextLine;
import bluej.editor.flow.ScopeColors;
import bluej.editor.flow.TextLine;
import bluej.editor.flow.TrackedPosition;
import bluej.prefmgr.PrefMgr;
import bluej.utility.javafx.FXFunction;
import bluej.utility.javafx.FXSupplier;
import bluej.utility.javafx.JavaFXUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Stream;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexRange;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform, ignoreParent=true)
public class FlowEditorPane
extends Region
implements JavaSyntaxView.Display {
    public static final Duration SCROLL_DELAY = Duration.millis((double)50.0);
    private final LineDisplay lineDisplay;
    private final FlowEditorPaneListener listener;
    private final HoleDocument document;
    private final TrackedPosition anchor;
    private final TrackedPosition caret;
    private int targetColumnForVerticalMovement;
    private final Path caretShape;
    private LineStyler lineStyler = (i, s) -> Collections.singletonList(new TextLine.StyledSegment(Collections.emptyList(), s.toString()));
    private ErrorQuery errorQuery = () -> Collections.emptyList();
    private final LineContainer lineContainer;
    private final ScrollBar verticalScroll;
    private final ScrollBar horizontalScroll;
    private boolean updatingScrollBarDirectly = false;
    private boolean allowScrollBars = true;
    private final ArrayList<SelectionListener> selectionListeners = new ArrayList();
    private boolean postScrollRenderQueued = false;
    private boolean editable = true;
    private boolean forceCaretShow = false;
    private double pendingScrollY;
    private boolean caretUpdateScheduled;
    private boolean caretUpdateEnsureVisible;
    private boolean justAddedOpeningCurlyBracket;
    private boolean isDragScrollScheduled = false;
    private DragScroll offScreenDragScroll = null;
    private double offScreenDragX = 0.0;
    private double offScreenDragY = 0.0;

    public FlowEditorPane(String content, FlowEditorPaneListener listener) {
        this.listener = listener;
        this.setSnapToPixel(true);
        this.document = new HoleDocument();
        this.document.replaceText(0, 0, content);
        this.caret = this.document.trackPosition(0, Document.Bias.FORWARD);
        this.anchor = this.document.trackPosition(0, Document.Bias.FORWARD);
        this.caretShape = new Path();
        this.caretShape.getStyleClass().add((Object)"flow-caret");
        this.caretShape.setStroke((Paint)Color.RED);
        this.caretShape.setMouseTransparent(true);
        this.caretShape.setManaged(false);
        this.verticalScroll = new ScrollBar();
        this.verticalScroll.setOrientation(Orientation.VERTICAL);
        this.verticalScroll.setVisible(false);
        this.horizontalScroll = new ScrollBar();
        this.horizontalScroll.setOrientation(Orientation.HORIZONTAL);
        this.horizontalScroll.setVisible(false);
        this.lineDisplay = new LineDisplay((FXSupplier<Double>)((FXSupplier)this::getLineContainerHeight), (DoubleExpression)this.horizontalScroll.valueProperty(), PrefMgr.getEditorFontCSS((boolean)true), listener);
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.horizontalScroll.valueProperty(), v -> {
            if (!this.updatingScrollBarDirectly) {
                this.updateRender(false);
            }
        });
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.verticalScroll.valueProperty(), v -> {
            if (!this.updatingScrollBarDirectly) {
                this.lineDisplay.scrollTo(v.intValue(), (v.doubleValue() - (double)v.intValue()) * -1.0 * this.lineDisplay.getLineHeight());
                this.updateRender(false);
            }
        });
        this.lineContainer = new LineContainer(this.lineDisplay, false);
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)this.lineContainer.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.lineContainer.heightProperty());
        this.lineContainer.setClip((Node)clip);
        this.getChildren().setAll((Object[])new Node[]{this.lineContainer, this.verticalScroll, this.horizontalScroll});
        this.updateRender(false);
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.lineContainer.heightProperty(), h -> JavaFXUtil.runAfterCurrent(() -> this.updateRender(false)));
        this.setAccessibleRole(AccessibleRole.TEXT_AREA);
        this.selectionListeners.add(new SelectionListener(){
            int oldCaretPos = 0;
            int oldAnchorPos = 0;

            @Override
            public void selectionChanged(int caretPosition, int anchorPosition) {
                if (caretPosition != this.oldCaretPos) {
                    FlowEditorPane.this.notifyAccessibleAttributeChanged(AccessibleAttribute.CARET_OFFSET);
                }
                if (Math.min(caretPosition, anchorPosition) != Math.min(this.oldCaretPos, this.oldAnchorPos)) {
                    FlowEditorPane.this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTION_START);
                }
                if (Math.max(caretPosition, anchorPosition) != Math.max(this.oldCaretPos, this.oldAnchorPos)) {
                    FlowEditorPane.this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTION_END);
                }
                this.oldAnchorPos = anchorPosition;
                this.oldCaretPos = caretPosition;
            }
        });
        this.document.addListener(false, (origStartIncl, replaced, replacement, linesRemoved, linesAdded) -> this.notifyAccessibleAttributeChanged(AccessibleAttribute.TEXT));
        Nodes.addInputMap((Node)this, (InputMap)InputMap.sequence((InputMap[])new InputMap[]{InputMap.consume((EventType)KeyEvent.KEY_TYPED, this::keyTyped), InputMap.consume((EventType)MouseEvent.MOUSE_PRESSED, this::mousePressed), InputMap.consume((EventType)MouseEvent.MOUSE_DRAGGED, this::mouseDragged), InputMap.consume((EventType)MouseEvent.MOUSE_RELEASED, this::mouseReleased), InputMap.consume((EventType)MouseEvent.MOUSE_MOVED, this::mouseMoved)}));
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.widthProperty(), w -> this.updateRender(false));
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.heightProperty(), h -> this.updateRender(false));
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.focusedProperty(), f -> this.updateCaretVisibility());
    }

    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objects) {
        switch (accessibleAttribute) {
            case EDITABLE: {
                return true;
            }
            case TEXT: {
                return this.getDocument().getFullContent();
            }
            case CARET_OFFSET: {
                return this.caret.position;
            }
            case SELECTION_START: {
                return this.getSelectionStart();
            }
            case SELECTION_END: {
                return this.getSelectionEnd();
            }
            case LINE_FOR_OFFSET: {
                return this.document.getLineFromPosition((Integer)objects[0]);
            }
            case LINE_START: {
                return this.document.getLineStart((Integer)objects[0]);
            }
            case LINE_END: {
                return this.document.getLineEnd((Integer)objects[0]);
            }
            case BOUNDS_FOR_RANGE: {
                return this.lineDisplay.getBoundsForRange(this.document, (Integer)objects[0], (Integer)objects[1]);
            }
            case OFFSET_AT_POINT: {
                Point2D screenPoint = (Point2D)objects[0];
                return this.getCaretPositionForLocalPoint(this.screenToLocal(screenPoint));
            }
            case HELP: {
                String err = this.listener.getErrorAtPosition(this.caret.position);
                if (err == null) break;
                return "Error: " + err;
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objects);
    }

    private double getLineContainerHeight() {
        return this.lineContainer.getHeight();
    }

    private void keyTyped(KeyEvent event) {
        if (!this.editable) {
            return;
        }
        String character = event.getCharacter();
        if (character.length() == 0) {
            return;
        }
        if ((event.isControlDown() || event.isAltDown() || Config.isMacOS() && event.isMetaDown()) && (!event.isControlDown() && !Config.isMacOS() || !event.isAltDown())) {
            return;
        }
        if (character.charAt(0) > '\u001f' && character.charAt(0) != '\u007f' && !event.isMetaDown()) {
            this.replaceSelection(character);
            JavaFXUtil.runAfterCurrent(() -> this.scheduleCaretUpdate(true));
            this.justAddedOpeningCurlyBracket = character.equals("{");
        }
    }

    private void mousePressed(MouseEvent e) {
        this.requestFocus();
        if (e.getButton() == MouseButton.PRIMARY) {
            boolean setAnchor = !e.isShiftDown();
            this.getCaretPositionForMouseEvent(e).ifPresent(setAnchor ? this::positionCaret : p -> this.moveCaret(p, true));
            this.updateRender(true);
        }
    }

    OptionalInt getCaretPositionForMouseEvent(MouseEvent e) {
        return this.getCaretPositionForLocalPoint(new Point2D(e.getX(), e.getY()));
    }

    OptionalInt getCaretPositionForLocalPoint(Point2D localPoint) {
        int[] position = this.lineDisplay.getCaretPositionForLocalPoint(localPoint);
        if (position != null) {
            return OptionalInt.of(this.document.getLineStart(position[0]) + position[1]);
        }
        return OptionalInt.empty();
    }

    private void mouseMoved(MouseEvent event) {
        this.getCaretPositionForMouseEvent(event).ifPresent(pos -> this.listener.showErrorPopupForCaretPos(pos, true));
    }

    private void mouseDragged(MouseEvent e) {
        if (e.getButton() == MouseButton.PRIMARY) {
            double y = e.getY();
            int fastDistance = 30;
            if (y > this.getHeight()) {
                this.offScreenDragScroll = y - this.getHeight() > (double)fastDistance ? DragScroll.DOWN_FAST : DragScroll.DOWN;
                y = this.getHeight() - 1.0;
            } else if (y < 0.0) {
                this.offScreenDragScroll = y < (double)(-fastDistance) ? DragScroll.UP_FAST : DragScroll.UP;
                y = 0.0;
            } else {
                this.offScreenDragScroll = null;
            }
            this.offScreenDragX = e.getX();
            this.offScreenDragY = y;
            this.getCaretPositionForLocalPoint(new Point2D(e.getX(), y)).ifPresent(p -> this.moveCaret(p, false));
            if (this.offScreenDragScroll != null && !this.isDragScrollScheduled) {
                JavaFXUtil.runAfter((Duration)Duration.millis((double)50.0), this::doDragScroll);
                this.isDragScrollScheduled = true;
            }
        }
    }

    private void mouseReleased(MouseEvent e) {
        this.offScreenDragScroll = null;
    }

    private void doDragScroll() {
        this.isDragScrollScheduled = false;
        if (this.offScreenDragScroll != null) {
            int amount = 0;
            switch (this.offScreenDragScroll) {
                case UP_FAST: {
                    amount = 50;
                    break;
                }
                case UP: {
                    amount = 15;
                    break;
                }
                case DOWN: {
                    amount = -15;
                    break;
                }
                case DOWN_FAST: {
                    amount = -50;
                }
            }
            this.scroll(0.0, amount);
            this.getCaretPositionForLocalPoint(new Point2D(this.offScreenDragX, this.offScreenDragY)).ifPresent(p -> this.moveCaret(p, false));
            JavaFXUtil.runAfter((Duration)SCROLL_DELAY, this::doDragScroll);
            this.isDragScrollScheduled = true;
        }
    }

    public void textChanged() {
        this.updateRender(false);
        this.targetColumnForVerticalMovement = -1;
        this.callSelectionListeners();
    }

    private void updateRender(boolean ensureCaretVisible) {
        if (ensureCaretVisible) {
            this.lineDisplay.ensureLineVisible(this.caret.getLine());
        }
        double width = this.lineDisplay.calculateLineWidth(this.document.getLongestLine());
        int EXTRA_WIDTH = 100;
        this.horizontalScroll.setMax(width + (double)EXTRA_WIDTH - this.getWidth());
        if (this.horizontalScroll.getValue() > this.horizontalScroll.getMax()) {
            this.updatingScrollBarDirectly = true;
            this.horizontalScroll.setValue(Math.max(Math.min(this.horizontalScroll.getValue(), this.horizontalScroll.getMax()), this.horizontalScroll.getMin()));
            this.updatingScrollBarDirectly = false;
        }
        this.horizontalScroll.setVisibleAmount(this.getWidth() / (this.horizontalScroll.getMax() + this.getWidth()) * this.horizontalScroll.getMax());
        this.horizontalScroll.setVisible(this.allowScrollBars && width + (double)EXTRA_WIDTH >= this.getWidth());
        ArrayList<MarginAndTextLine> prospectiveChildren = new ArrayList<MarginAndTextLine>();
        StyledLines styledLines = new StyledLines(this.document, this.lineStyler);
        prospectiveChildren.addAll(this.lineDisplay.recalculateVisibleLines(styledLines, (FXFunction<Double, Double>)((FXFunction)arg_0 -> ((FlowEditorPane)this).snapSizeY(arg_0)), -this.horizontalScroll.getValue(), this.lineContainer.getWidth(), this.lineContainer.getHeight(), false));
        prospectiveChildren.add((MarginAndTextLine)this.caretShape);
        this.verticalScroll.setVisible(this.allowScrollBars && this.lineDisplay.getVisibleLineCount() < this.document.getLineCount());
        double visibleLinesEstimate = this.getHeight() / this.lineDisplay.getLineHeight();
        this.verticalScroll.setMax((double)this.document.getLineCount() - visibleLinesEstimate);
        this.verticalScroll.setVisibleAmount(visibleLinesEstimate / (double)this.document.getLineCount() * this.verticalScroll.getMax());
        this.updatingScrollBarDirectly = true;
        this.verticalScroll.setValue((double)this.lineDisplay.getLineRangeVisible()[0] - this.lineDisplay.getFirstVisibleLineOffset() / this.lineDisplay.getLineHeight());
        this.updatingScrollBarDirectly = false;
        boolean needToChangeLinesAndCaret = false;
        for (int i = 0; i < prospectiveChildren.size(); ++i) {
            if (i < this.lineContainer.getChildren().size() && prospectiveChildren.get(i) == this.lineContainer.getChildren().get(i)) continue;
            needToChangeLinesAndCaret = true;
            break;
        }
        if (needToChangeLinesAndCaret) {
            this.lineContainer.getChildren().setAll(prospectiveChildren);
        } else if (this.lineContainer.getChildren().size() > prospectiveChildren.size()) {
            this.lineContainer.getChildren().subList(prospectiveChildren.size(), this.lineContainer.getChildren().size()).clear();
        }
        if (this.getScene() != null) {
            this.scheduleCaretUpdate(ensureCaretVisible);
            String lineText = this.getDocument().getLines().get(this.document.getLineFromPosition(this.caret.position)).toString();
            this.setAccessibleText(lineText);
        }
        this.updateCaretVisibility();
        HashSet<Integer> linesWithSelectionSet = new HashSet<Integer>();
        if (this.caret.position != this.anchor.position) {
            TrackedPosition endPos;
            TrackedPosition startPos = this.caret.position < this.anchor.position ? this.caret : this.anchor;
            TrackedPosition trackedPosition = endPos = this.caret.position < this.anchor.position ? this.anchor : this.caret;
            if (startPos.getLine() == endPos.getLine() && this.lineDisplay.isLineVisible(startPos.getLine())) {
                TextLine caretLine = this.lineDisplay.getVisibleLine((int)startPos.getLine()).textLine;
                caretLine.showSelection(startPos.getColumn(), endPos.getColumn(), false);
                linesWithSelectionSet.add(startPos.getLine());
            } else {
                for (int line = startPos.getLine(); line < endPos.getLine(); ++line) {
                    int startOnThisLine;
                    int n = startOnThisLine = line == startPos.getLine() ? startPos.getColumn() : 0;
                    if (!this.lineDisplay.isLineVisible(line)) continue;
                    TextLine textLine = this.lineDisplay.getVisibleLine((int)line).textLine;
                    textLine.showSelection(startOnThisLine, this.document.getLineStart(line + 1) - this.document.getLineStart(line), true);
                    linesWithSelectionSet.add(line);
                }
                if (this.lineDisplay.isLineVisible(endPos.getLine())) {
                    this.lineDisplay.getVisibleLine((int)endPos.getLine()).textLine.showSelection(0, endPos.getColumn(), false);
                    linesWithSelectionSet.add(endPos.getLine());
                }
            }
        }
        int[] visibleLineRange = this.lineDisplay.getLineRangeVisible();
        for (int line = visibleLineRange[0]; line <= visibleLineRange[1]; ++line) {
            if (linesWithSelectionSet.contains(line)) continue;
            this.lineDisplay.getVisibleLine((int)line).textLine.hideSelection();
        }
        if (this.errorQuery != null) {
            for (IndexRange indexRange : this.errorQuery.getErrorUnderlines()) {
                this.addErrorUnderline(indexRange.getStart(), indexRange.getEnd());
            }
        }
        this.lineContainer.requestLayout();
        this.requestLayout();
    }

    private void scheduleCaretUpdate(boolean ensureCaretVisibleRequestedThisTime) {
        this.caretUpdateEnsureVisible = this.caretUpdateEnsureVisible || ensureCaretVisibleRequestedThisTime;
        Scene scene = this.getScene();
        if (scene == null || this.caretUpdateScheduled) {
            return;
        }
        JavaFXUtil.runAfterNextLayout((Scene)scene, () -> {
            boolean ensureCaretVisible = this.caretUpdateEnsureVisible;
            this.caretUpdateScheduled = false;
            this.caretUpdateEnsureVisible = false;
            if (this.lineDisplay.isLineVisible(this.caret.getLine())) {
                MarginAndTextLine line = this.lineDisplay.getVisibleLine(this.caret.getLine());
                if (line.textLine.isNeedsLayout()) {
                    this.scheduleCaretUpdate(ensureCaretVisible);
                    return;
                }
                this.caretShape.getElements().setAll((Object[])line.textLine.caretShape(this.caret.getColumn(), true));
                this.caretShape.layoutXProperty().bind((ObservableValue)line.layoutXProperty());
                if (ensureCaretVisible) {
                    Bounds caretBounds = this.caretShape.getBoundsInLocal();
                    double maxScroll = Math.max(0.0, caretBounds.getCenterX() - 8.0);
                    double minScroll = Math.max(0.0, caretBounds.getCenterX() - (this.getWidth() - 27.0 - this.verticalScroll.prefWidth(-1.0) - 6.0));
                    this.horizontalScroll.setValue(Math.min(maxScroll, Math.max(minScroll, this.horizontalScroll.getValue())));
                }
                this.caretShape.translateXProperty().set(27.0 - this.horizontalScroll.getValue());
                this.caretShape.layoutYProperty().bind((ObservableValue)line.layoutYProperty());
                this.caretShape.setVisible(true);
            } else {
                this.caretShape.getElements().clear();
                this.caretShape.layoutXProperty().unbind();
                this.caretShape.layoutYProperty().unbind();
                this.caretShape.setLayoutX(0.0);
                this.caretShape.setLayoutY(0.0);
                this.caretShape.setVisible(false);
            }
        });
        this.caretUpdateScheduled = true;
    }

    private void updateCaretVisibility() {
        boolean focused = this.isFocused();
        boolean lineVisible = this.lineDisplay.isLineVisible(this.caret.getLine());
        this.caretShape.setVisible(lineVisible && (focused || this.forceCaretShow));
    }

    @Override
    public boolean isLineVisible(int line) {
        return this.lineDisplay.isLineVisible(line);
    }

    int[] getLineRangeVisible() {
        return this.lineDisplay.getLineRangeVisible();
    }

    double getLineHeight() {
        return this.lineDisplay.getLineHeight();
    }

    private PathElement[] keepBottom(PathElement[] rangeShape) {
        if (rangeShape.length % 5 == 0) {
            for (int i = 0; i < rangeShape.length; i += 5) {
                if (!(rangeShape[0] instanceof MoveTo) || !(rangeShape[1] instanceof LineTo) || !(rangeShape[2] instanceof LineTo) || !(rangeShape[3] instanceof LineTo) || !(rangeShape[4] instanceof LineTo)) continue;
                rangeShape[1] = this.lineToMove(rangeShape[1]);
                rangeShape[2] = this.lineToMove(rangeShape[2]);
                rangeShape[4] = this.lineToMove(rangeShape[4]);
            }
        }
        return rangeShape;
    }

    private PathElement lineToMove(PathElement pathElement) {
        LineTo lineTo = (LineTo)pathElement;
        return new MoveTo(lineTo.getX(), lineTo.getY());
    }

    public int getTargetColumnForVerticalMove() {
        return this.targetColumnForVerticalMovement;
    }

    public void setTargetColumnForVerticalMove(int targetColumn) {
        this.targetColumnForVerticalMovement = targetColumn;
    }

    private void addErrorUnderline(int startPos, int endPos) {
        int lineIndex = this.document.getLineFromPosition(startPos);
        int startColumn = this.document.getColumnFromPosition(startPos);
        int endColumn = Math.min(this.document.getLineEnd(lineIndex), endPos - this.document.getLineStart(lineIndex));
        if (this.lineDisplay.isLineVisible(lineIndex)) {
            this.lineDisplay.getVisibleLine((int)lineIndex).textLine.showError(startColumn, endColumn);
        }
    }

    void showHighlights(TextLine.HighlightType highlightType, List<int[]> results) {
        HashMap resultsByLine = new HashMap();
        for (int[] result : results) {
            int lineIndex = this.document.getLineFromPosition(result[0]);
            int startColumn = this.document.getColumnFromPosition(result[0]);
            int endColumn = Math.min(this.document.getLineEnd(lineIndex), result[1] - this.document.getLineStart(lineIndex));
            resultsByLine.computeIfAbsent(lineIndex, n -> new ArrayList()).add(new int[]{startColumn, endColumn});
        }
        int[] visibleLines = this.lineDisplay.getLineRangeVisible();
        for (int line = visibleLines[0]; line <= visibleLines[1]; ++line) {
            this.lineDisplay.getVisibleLine((int)line).textLine.showHighlight(highlightType, resultsByLine.getOrDefault(line, List.of()));
        }
    }

    public void setErrorQuery(ErrorQuery errorQuery) {
        this.errorQuery = errorQuery;
    }

    @Override
    public void applyScopeBackgrounds(Map<Integer, List<BackgroundItem>> scopeBackgrounds) {
        HashMap<Integer, List<BackgroundItem>> withOverlays = new HashMap<Integer, List<BackgroundItem>>();
        Set<Integer> breakpointLines = this.listener.getBreakpointLines();
        int stepLine = this.listener.getStepLine();
        scopeBackgrounds.forEach((line, scopes) -> {
            if (breakpointLines.contains(line) || line == stepLine) {
                ArrayList<BackgroundItem> regions = new ArrayList<BackgroundItem>((Collection<BackgroundItem>)scopes);
                BackgroundItem region = new BackgroundItem(0.0, this.getWidth() - 27.0, new BackgroundFill((Paint)(line == stepLine ? this.listener.stepMarkOverlayColorProperty() : this.listener.breakpointOverlayColorProperty()).get(), null, null));
                regions.add(region);
                withOverlays.put((Integer)line, (List<BackgroundItem>)regions);
            } else {
                withOverlays.put((Integer)line, (List<BackgroundItem>)scopes);
            }
        });
        this.lineDisplay.applyScopeBackgrounds(withOverlays);
    }

    public void ensureCaretShowing() {
        this.updateRender(true);
    }

    public void setLineMarginGraphics(int lineIndex, EnumSet<MarginAndTextLine.MarginDisplay> marginDisplays) {
        if (this.lineDisplay.isLineVisible(lineIndex)) {
            this.lineDisplay.getVisibleLine(lineIndex).setMarginGraphics(marginDisplays);
        }
    }

    public void fontSizeChanged() {
        this.lineDisplay.fontSizeChanged();
        this.updateRender(false);
    }

    public void select(int start, int end) {
        this.positionAnchor(start);
        this.moveCaret(end);
    }

    public void setFakeCaret(boolean fakeOn) {
        this.forceCaretShow = fakeOn;
        this.updateCaretVisibility();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void write(Writer writer) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        bufferedWriter.write(this.document.getFullContent());
        bufferedWriter.flush();
    }

    public void hideAllErrorUnderlines() {
        this.lineDisplay.hideAllErrorUnderlines();
    }

    @Override
    public double getTextDisplayWidth() {
        return this.lineContainer.getWidth() - 27.0;
    }

    protected void layoutChildren() {
        double horizScrollHeight = this.horizontalScroll.isVisible() ? this.horizontalScroll.prefHeight(-1.0) : 0.0;
        this.horizontalScroll.resizeRelocate(0.0, this.getHeight() - horizScrollHeight, this.getWidth(), horizScrollHeight);
        double vertScrollWidth = this.verticalScroll.isVisible() ? this.verticalScroll.prefWidth(-1.0) : 0.0;
        this.verticalScroll.resizeRelocate(this.getWidth() - vertScrollWidth, 0.0, vertScrollWidth, this.getHeight() - horizScrollHeight);
        this.lineContainer.resizeRelocate(0.0, 0.0, this.getWidth() - vertScrollWidth, this.getHeight() - horizScrollHeight);
    }

    public HoleDocument getDocument() {
        return this.document;
    }

    public void scrollTo(int lineIndex) {
        this.lineDisplay.scrollTo(lineIndex, 0.0);
        this.updateRender(false);
    }

    public void scrollEventOnTextLine(ScrollEvent scrollEvent) {
        this.scroll(scrollEvent.getDeltaX(), scrollEvent.getDeltaY());
    }

    private void scroll(double deltaX, double deltaY) {
        this.updatingScrollBarDirectly = true;
        this.horizontalScroll.setValue(Math.max(this.horizontalScroll.getMin(), Math.min(this.horizontalScroll.getMax(), this.horizontalScroll.getValue() - deltaX)));
        this.updatingScrollBarDirectly = false;
        this.pendingScrollY += deltaY;
        if (!this.postScrollRenderQueued) {
            this.postScrollRenderQueued = true;
            JavaFXUtil.runAfter((Duration)SCROLL_DELAY, () -> {
                this.postScrollRenderQueued = false;
                this.lineDisplay.scrollBy(this.pendingScrollY, this.document.getLineCount());
                this.pendingScrollY = 0.0;
                this.updateRender(false);
            });
        }
    }

    @Override
    public Optional<Double> getLeftEdgeX(int leftOfCharIndex) {
        return FlowEditorPane.getLeftEdgeX(leftOfCharIndex, this.document, this.lineDisplay);
    }

    static Optional<Double> getLeftEdgeX(int leftOfCharIndex, Document document, LineDisplay lineDisplay) {
        int lineIndex = document.getLineFromPosition(leftOfCharIndex);
        if (lineDisplay.isLineVisible(lineIndex)) {
            TextLine line = lineDisplay.getVisibleLine((int)lineIndex).textLine;
            if (line.isNeedsLayout()) {
                return Optional.empty();
            }
            Font curFont = line.getChildren().stream().flatMap(n -> n instanceof Text ? Stream.of(((Text)n).getFont()) : Stream.empty()).findFirst().orElse(null);
            if (curFont != null && !curFont.getFamily().equals(PrefMgr.getEditorFontFamily())) {
                return Optional.empty();
            }
            int posInLine = leftOfCharIndex - document.getLineStart(lineIndex);
            PathElement[] elements = line.caretShape(posInLine, true);
            Path path = new Path(elements);
            Bounds bounds = path.getBoundsInLocal();
            if (posInLine > 0 && bounds.getMaxX() < 2.0) {
                return Optional.empty();
            }
            return Optional.of((bounds.getMinX() + bounds.getMaxX()) / 2.0);
        }
        return Optional.empty();
    }

    public Optional<Bounds> getCaretBoundsOnScreen(int position) {
        int lineIndex = this.document.getLineFromPosition(position);
        if (this.lineDisplay.isLineVisible(lineIndex)) {
            TextLine line = this.lineDisplay.getVisibleLine((int)lineIndex).textLine;
            PathElement[] elements = line.caretShape(position - this.document.getLineStart(lineIndex), true);
            Path path = new Path(elements);
            Bounds bounds = line.localToScreen(path.getBoundsInLocal());
            return Optional.of(bounds);
        }
        return Optional.empty();
    }

    public Optional<double[]> getTopAndBottom(int lineIndex) {
        if (this.lineDisplay.isLineVisible(lineIndex)) {
            MarginAndTextLine line = this.lineDisplay.getVisibleLine(lineIndex);
            Bounds bounds = line.getLayoutBounds();
            return Optional.of(new double[]{line.getLayoutY() + bounds.getMinY(), line.getLayoutY() + bounds.getMaxY()});
        }
        return Optional.empty();
    }

    public Rectangle2D getLineBoundsOnScreen(int line, Point2D windowPos, double renderScaleX, double renderScaleY) {
        if (this.lineDisplay.isLineVisible(line)) {
            MarginAndTextLine marginAndTextLine = this.lineDisplay.getVisibleLine(line);
            Bounds bounds = marginAndTextLine.textLine.localToScene(marginAndTextLine.textLine.getBoundsInLocal());
            double sceneX = marginAndTextLine.getScene().getX();
            double sceneY = marginAndTextLine.getScene().getY();
            double windowX = windowPos.getX();
            double windowY = windowPos.getY();
            return new Rectangle2D((bounds.getMinX() + sceneX + windowX) * renderScaleX, (bounds.getMinY() + sceneY + windowY) * renderScaleY, bounds.getWidth() * renderScaleX, bounds.getHeight() * renderScaleY);
        }
        return null;
    }

    public double getFontSizeInPixels() {
        return this.lineDisplay.getFontSizeInPixels();
    }

    public void positionCaret(int position) {
        this.caret.moveTo(position);
        this.anchor.moveTo(position);
        this.targetColumnForVerticalMovement = -1;
        this.justAddedOpeningCurlyBracket = false;
        this.updateRender(true);
        this.callSelectionListeners();
    }

    public void positionCaretWithoutScrolling(int position) {
        this.caret.moveTo(position);
        this.anchor.moveTo(position);
        this.targetColumnForVerticalMovement = -1;
        this.justAddedOpeningCurlyBracket = false;
        this.updateRender(false);
        this.callSelectionListeners();
    }

    public void moveCaret(int position) {
        this.moveCaret(position, true);
    }

    private void moveCaret(int position, boolean ensureCaretVisible) {
        this.caret.moveTo(position);
        this.targetColumnForVerticalMovement = -1;
        this.justAddedOpeningCurlyBracket = false;
        this.updateRender(ensureCaretVisible);
        this.callSelectionListeners();
    }

    public void positionAnchor(int position) {
        this.anchor.moveTo(position);
        this.justAddedOpeningCurlyBracket = false;
        this.updateRender(false);
        this.callSelectionListeners();
    }

    public int getCaretPosition() {
        return this.caret.position;
    }

    public int getAnchorPosition() {
        return this.anchor.position;
    }

    @Override
    public void addLineDisplayListener(LineDisplay.LineDisplayListener lineDisplayListener) {
        this.lineDisplay.addLineDisplayListener(lineDisplayListener);
    }

    @Override
    public void repaint() {
        this.updateRender(false);
    }

    public void replaceSelection(String text) {
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        this.document.replaceText(start, end, text);
        this.positionCaret(start + text.length());
    }

    public int getSelectionEnd() {
        return Math.max(this.caret.position, this.anchor.position);
    }

    public int getSelectionStart() {
        return Math.min(this.caret.position, this.anchor.position);
    }

    public String getSelectedText() {
        return this.document.getContent(this.getSelectionStart(), this.getSelectionEnd()).toString();
    }

    @Override
    public void setLineStyler(LineStyler lineStyler) {
        this.lineStyler = lineStyler;
    }

    public void setAllowScrollBars(boolean allowScrollBars) {
        this.allowScrollBars = allowScrollBars;
        this.updateRender(false);
    }

    public boolean hasJustAddedCurlyBracket() {
        return this.justAddedOpeningCurlyBracket;
    }

    @Override
    public double getWidthOfText(String content) {
        return this.lineDisplay.calculateLineWidth(content);
    }

    private void callSelectionListeners() {
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.selectionChanged(this.caret.position, this.anchor.position);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    static class StyledLines
    extends AbstractList<List<TextLine.StyledSegment>> {
        private final LineStyler lineStyler;
        private final List<CharSequence> documentLines;

        public StyledLines(Document document, LineStyler lineStyler) {
            this.documentLines = document.getLines();
            this.lineStyler = lineStyler;
        }

        @Override
        public int size() {
            return this.documentLines.size();
        }

        @Override
        public List<TextLine.StyledSegment> get(int lineIndex) {
            return this.lineStyler.getLineForDisplay(lineIndex, this.documentLines.get(lineIndex));
        }
    }

    public static interface FlowEditorPaneListener
    extends ScopeColors {
        public boolean marginClickedForLine(int var1);

        public Set<Integer> getBreakpointLines();

        public int getStepLine();

        public void showErrorPopupForCaretPos(int var1, boolean var2);

        public String getErrorAtPosition(int var1);

        public ContextMenu getContextMenuToShow();

        public void scrollEventOnTextLine(ScrollEvent var1);
    }

    public static interface SelectionListener {
        public void selectionChanged(int var1, int var2);
    }

    @OnThread(value=Tag.FXPlatform)
    public static interface LineStyler {
        public List<TextLine.StyledSegment> getLineForDisplay(int var1, CharSequence var2);
    }

    public static interface ErrorQuery {
        public List<IndexRange> getErrorUnderlines();
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public static class LineContainer
    extends Region {
        private final LineDisplay lineDisplay;
        private final boolean lineWrapping;

        public LineContainer(LineDisplay lineDisplay, boolean lineWrapping) {
            this.lineDisplay = lineDisplay;
            this.lineWrapping = lineWrapping;
            JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"line-container"});
        }

        protected void layoutChildren() {
            double y = this.snapPositionY(this.lineDisplay.getFirstVisibleLineOffset());
            if (!this.lineWrapping) {
                double height = this.snapSizeY(this.lineDisplay.calculateLineHeight());
                for (Node child : this.getChildren()) {
                    if (!(child instanceof MarginAndTextLine)) continue;
                    double nextY = this.snapPositionY(y + height);
                    child.resizeRelocate(0.0, y, Math.max(this.getWidth(), child.prefWidth(-1.0)), nextY - y);
                    y = nextY;
                }
            } else {
                for (Node child : this.getChildren()) {
                    if (!(child instanceof MarginAndTextLine)) continue;
                    MarginAndTextLine line = (MarginAndTextLine)child;
                    double height = this.snapSizeY(child.prefHeight(this.getWidth()));
                    double nextY = this.snapPositionY(y + height);
                    child.resizeRelocate(0.0, y, this.getWidth(), nextY - y);
                    y = nextY;
                }
            }
        }

        @OnThread(value=Tag.FX)
        protected ObservableList<Node> getChildren() {
            return super.getChildren();
        }
    }

    private static enum DragScroll {
        UP_FAST,
        UP,
        DOWN,
        DOWN_FAST;

    }
}

