/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.Config;
import bluej.debugger.gentype.JavaType;
import bluej.editor.flow.Document;
import bluej.editor.flow.FlowEditor;
import bluej.editor.flow.FlowEditorPane;
import bluej.editor.flow.FlowIndent;
import bluej.parser.SourceLocation;
import bluej.parser.entity.JavaEntity;
import bluej.parser.nodes.CommentNode;
import bluej.parser.nodes.MethodNode;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.ReparseableDocument;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.FXAbstractAction;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javax.swing.KeyStroke;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import threadchecker.OnThread;
import threadchecker.Tag;

public final class FlowActions {
    private static final String KEYS_FILE = "editor.keys";
    private static final String KEYS_FILE_FX = "editor_fx.keys";
    private static final int tabSize = Config.getPropInteger((String)"bluej.editor.tabsize", (int)4);
    private static final String spaces = "                                        ";
    private static final char TAB_CHAR = '\t';
    private static final KeyCombination.Modifier SHORTCUT_MASK = KeyCombination.SHORTCUT_DOWN;
    private static final KeyCombination.Modifier[] SHIFT_SHORTCUT_MASK = new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN};
    private static final WeakHashMap<FlowEditor, FlowActions> allActions = new WeakHashMap();
    private final FlowEditor editor;
    public FlowAbstractAction compileOrNextErrorAction;
    private HashMap<String, FlowAbstractAction> actions;
    private final ObservableMap<KeyCodeCombination, FlowAbstractAction> builtInKeymap = FXCollections.observableHashMap();
    private final ObservableMap<KeyCodeCombination, FlowAbstractAction> keymap = FXCollections.observableMap(new LinkedHashMap());
    private InputMap<KeyEvent> curKeymap;
    private boolean lastActionWasCut;

    public FlowActions(final FlowEditor editor) {
        this.editor = editor;
        this.createActionTable();
        if (!this.load()) {
            this.setDefaultKeyBindings();
        }
        this.lastActionWasCut = false;
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.HOME, new KeyCombination.Modifier[0]), (Object)this.actions.get("caret-begin-line"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.END, new KeyCombination.Modifier[0]), (Object)this.actions.get("caret-end-line"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.PAGE_UP, new KeyCombination.Modifier[0]), (Object)this.actions.get("page-up"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.PAGE_DOWN, new KeyCombination.Modifier[0]), (Object)this.actions.get("page-down"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.LEFT, new KeyCombination.Modifier[0]), (Object)this.actions.get("caret-backward"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.RIGHT, new KeyCombination.Modifier[0]), (Object)this.actions.get("caret-forward"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.UP, new KeyCombination.Modifier[0]), (Object)this.actions.get("caret-up"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.DOWN, new KeyCombination.Modifier[0]), (Object)this.actions.get("caret-down"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.HOME, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-begin-line"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.END, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-end-line"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.PAGE_UP, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-page-up"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.PAGE_DOWN, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-page-down"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.LEFT, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-backward"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.RIGHT, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-forward"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.UP, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-up"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.DOWN, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-down"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.END, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), (Object)this.actions.get("caret-end"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.END, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-end"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.HOME, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), (Object)this.actions.get("caret-begin"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.HOME, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-begin"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.BACK_SPACE, new KeyCombination.Modifier[0]), (Object)this.actions.get("delete-previous"));
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.DELETE, new KeyCombination.Modifier[0]), (Object)this.actions.get("delete-next"));
        if (Config.isMacOS()) {
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.LEFT, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), (Object)this.actions.get("caret-previous-word"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.RIGHT, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), (Object)this.actions.get("caret-next-word"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.LEFT, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN, KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-previous-word"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.RIGHT, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN, KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-next-word"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.LEFT, new KeyCombination.Modifier[]{KeyCombination.META_DOWN}), (Object)this.actions.get("caret-begin-line"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.RIGHT, new KeyCombination.Modifier[]{KeyCombination.META_DOWN}), (Object)this.actions.get("caret-end-line"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.LEFT, new KeyCombination.Modifier[]{KeyCombination.META_DOWN, KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-begin-line"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.RIGHT, new KeyCombination.Modifier[]{KeyCombination.META_DOWN, KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-end-line"));
        } else {
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.LEFT, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}), (Object)this.actions.get("caret-previous-word"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.RIGHT, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}), (Object)this.actions.get("caret-next-word"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.LEFT, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN, KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-previous-word"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.RIGHT, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN, KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-next-word"));
        }
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.A, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), (Object)new FlowAbstractAction("select-all", Category.EDIT){

            public void actionPerformed(boolean viaContextMenu) {
                editor.getSourcePane().select(0, editor.getTextLength());
            }
        });
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.X, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), null);
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), null);
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), null);
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), null);
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.Y, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), null);
        this.updateKeymap();
        if (this.getTextComponent() != null) {
            Nodes.addInputMap((Node)this.getTextComponent(), (InputMap)InputMap.sequence((InputMap[])new InputMap[]{InputMap.consume((EventType)MouseEvent.MOUSE_CLICKED, e -> {
                if (e.getButton() == MouseButton.PRIMARY && editor.getSourcePane().getCaretPositionForMouseEvent((MouseEvent)e).isPresent()) {
                    if (e.getClickCount() == 2) {
                        this.selectWordAction().actionPerformed(false);
                    } else if (e.getClickCount() == 3) {
                        this.selectWholeLine();
                    }
                }
            })}));
        }
        this.actions.values().forEach(flowAction -> allActions.put(editor, this));
    }

    void updateKeymap() {
        if (this.getTextComponent() != null) {
            if (this.curKeymap != null) {
                Nodes.removeInputMap((Node)this.getTextComponent(), this.curKeymap);
            }
            Stream joinedKeyMapStream = Stream.concat(this.builtInKeymap.entrySet().stream(), this.keymap.entrySet().stream().filter(e -> !((FlowAbstractAction)((Object)((Object)e.getValue()))).hasMenuItemWithAccelerator((KeyCombination)e.getKey())));
            HashMap all = new HashMap();
            joinedKeyMapStream.forEach(kv -> all.put((KeyCodeCombination)kv.getKey(), (FlowAbstractAction)((Object)((Object)kv.getValue()))));
            joinedKeyMapStream = all.entrySet().stream();
            this.curKeymap = InputMap.sequence((InputMap[])((InputMap[])joinedKeyMapStream.map(e -> {
                if (e.getValue() == null) {
                    return InputMap.ignore((EventPattern)EventPattern.keyPressed((KeyCombination)((KeyCombination)e.getKey())));
                }
                return InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)((KeyCombination)e.getKey())), ev -> ((FlowAbstractAction)((Object)((Object)((Object)e.getValue())))).actionPerformed(false));
            }).toArray(InputMap[]::new)));
            Nodes.addInputMap((Node)this.getTextComponent(), this.curKeymap);
        }
    }

    private static int findWordLimit(FlowEditorPane c, int pos, boolean forwards) {
        int maxLen = c.getDocument().getLength();
        if (forwards && pos >= maxLen) {
            return maxLen;
        }
        if (!forwards && pos <= 0) {
            return 0;
        }
        char curChar = c.getDocument().getContent(pos, pos + 1).charAt(0);
        if (Character.isWhitespace(curChar)) {
            while (Character.isWhitespace(curChar)) {
                pos = forwards ? ++pos : --pos;
                if (pos == maxLen) {
                    return pos;
                }
                if (pos == 0) {
                    return 0;
                }
                curChar = c.getDocument().getContent(pos, pos + 1).charAt(0);
            }
            return forwards ? pos : pos + 1;
        }
        if (Character.isJavaIdentifierPart(curChar)) {
            while (Character.isJavaIdentifierPart(curChar)) {
                pos = forwards ? ++pos : --pos;
                if (pos == maxLen) {
                    return pos;
                }
                if (pos < 0) {
                    return 0;
                }
                curChar = c.getDocument().getContent(pos, pos + 1).charAt(0);
            }
            return forwards ? pos : pos + 1;
        }
        return forwards ? pos + 1 : pos;
    }

    private static boolean haveSelection(FlowEditor ed) {
        FlowEditorPane textPane = ed.getSourcePane();
        return textPane.getCaretPosition() != textPane.getAnchorPosition();
    }

    private int getCurrentColumn() {
        int pos = this.getClearedEditor().getSourcePane().getSelectionStart();
        return this.getClearedEditor().getSourcePane().getDocument().getColumnFromPosition(pos);
    }

    private int getCurrentLineIndex() {
        ReparseableDocument document = this.getClearedEditor().getSourceDocument();
        return document.getDefaultRootElement().getElementIndex(this.getClearedEditor().getSourcePane().getCaretPosition());
    }

    private static boolean isNewCommentStart(String s, ReparseableDocument doc, Document doc2, int lineStart) {
        if ((s = s.trim()).endsWith("/**") || s.endsWith("/*")) {
            NodeTree.NodeAndPosition curNode = doc.getParser().findNodeAt(lineStart, 0);
            while (curNode != null && !(curNode.getNode() instanceof CommentNode)) {
                curNode = ((ParsedNode)curNode.getNode()).findNodeAt(lineStart, curNode.getPosition());
            }
            if (curNode == null) {
                return true;
            }
            String comment = FlowActions.getNodeContents(doc2, (NodeTree.NodeAndPosition<ParsedNode>)curNode);
            comment = comment.substring(2);
            return comment.contains("/*");
        }
        return false;
    }

    private static void completeNewCommentBlock(FlowEditorPane textPane, String indentString) {
        String nextIndent = indentString.substring(0, indentString.length() - 2);
        textPane.replaceSelection(nextIndent + " * ");
        int pos = textPane.getCaretPosition();
        textPane.replaceSelection("\n");
        textPane.replaceSelection(nextIndent + " */");
        textPane.positionCaret(pos);
    }

    private static boolean isOpenBrace(String s) {
        int index = s.lastIndexOf(123);
        if (index == -1) {
            return false;
        }
        return s.indexOf(125, index + 1) == -1;
    }

    private static String nextIndent(String s, boolean openBrace, boolean commentEndOnly) {
        if (openBrace) {
            return s + spaces.substring(0, tabSize);
        }
        if (commentEndOnly) {
            return s.substring(0, s.length() - 1);
        }
        if (s.endsWith("/*")) {
            return s.substring(0, s.length() - 2) + " * ";
        }
        return s;
    }

    private void insertSpacedTab() {
        int numSpaces = tabSize - this.getCurrentColumn() % tabSize;
        this.getClearedEditor().getSourcePane().replaceSelection(spaces.substring(0, numSpaces));
    }

    private void removeTab() {
        int col = this.getCurrentColumn();
        if (col > 0) {
            int remove = col % tabSize;
            if (remove == 0) {
                remove = tabSize;
            }
            int pos = this.getClearedEditor().getSourcePane().getCaretPosition();
            this.getClearedEditor().getSourcePane().getDocument().replaceText(pos - remove, pos, "");
            this.getClearedEditor().getSourcePane().positionCaret(pos - remove);
        }
    }

    private static String expandTab(String s, int idx) {
        int numSpaces = tabSize - idx % tabSize;
        return s.substring(0, idx) + spaces.substring(0, numSpaces) + s.substring(idx + 1);
    }

    private void insertTemplate(String templateName) {
        try {
            FlowEditorPane textPane = this.getTextComponent();
            File template = Config.getTemplateFile((String)templateName);
            FileInputStream fileStream = new FileInputStream(template);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fileStream, StandardCharsets.UTF_8));
            int addedTextLength = 0;
            String line = in.readLine();
            while (line != null) {
                while (line.length() > 0 && line.charAt(0) == '\t') {
                    line = line.substring(1);
                }
                addedTextLength += line.length() + 1;
                textPane.replaceSelection(line);
                textPane.replaceSelection("\n");
                line = in.readLine();
            }
            int caretPos = this.editor.getSourcePane().getCaretPosition();
            FlowIndent.AutoIndentInformation info = FlowIndent.calculateIndentsAndApply(this.editor.getSourceDocument(), this.editor.getSourcePane().getDocument(), caretPos);
            this.editor.getSourcePane().positionCaret(info.getNewCaretPosition());
            in.close();
        }
        catch (IOException exc) {
            Debug.reportError((String)"Could not read method template.");
            Debug.reportError((String)("Exception: " + exc));
        }
    }

    private static void blockAction(FlowEditor editor, LineAction lineAction) {
        int selectionEnd;
        int selectionStart = editor.getSourcePane().getAnchorPosition();
        if (selectionStart > (selectionEnd = editor.getSourcePane().getCaretPosition())) {
            int tmp = selectionStart;
            selectionStart = selectionEnd;
            selectionEnd = tmp;
        }
        if (selectionStart != selectionEnd) {
            --selectionEnd;
        }
        ReparseableDocument doc = editor.getSourceDocument();
        ReparseableDocument.Element text = doc.getDefaultRootElement();
        int firstLineIndex = editor.getLineColumnFromOffset(selectionStart).getLine() - 1;
        int lastLineIndex = editor.getLineColumnFromOffset(selectionEnd).getLine() - 1;
        for (int i = firstLineIndex; i <= lastLineIndex; ++i) {
            ReparseableDocument.Element line = text.getElement(i);
            lineAction.apply(line, editor.getSourcePane().getDocument());
        }
    }

    private static String getNodeContents(Document doc, NodeTree.NodeAndPosition<ParsedNode> nap) {
        return doc.getContent(nap.getPosition(), nap.getPosition() + nap.getSize()).toString();
    }

    public static void addKeyCombinationForActionToAllEditors(KeyCodeCombination key, String actionName) {
        allActions.values().forEach(flowAction -> flowAction.addKeyCombinationForAction(key, actionName));
    }

    private void addKeyCombinationForAction(KeyCodeCombination key, String actionName) {
        FlowAbstractAction action = this.actions.get(actionName);
        if (action != null) {
            this.keymap.put((Object)key, (Object)action);
            this.updateKeymap();
        }
    }

    public static void removeKeyCombinationForActionToAllEditors(KeyCodeCombination key, String actionName) {
        allActions.values().forEach(flowAction -> flowAction.removeKeyCombinationForAction(key, actionName));
    }

    private void removeKeyCombinationForAction(KeyCodeCombination key, String actionName) {
        FlowAbstractAction action = this.actions.get(actionName);
        if (action != null) {
            this.keymap.remove((Object)key, (Object)action);
            this.updateKeymap();
        }
    }

    public FlowAbstractAction getActionByName(String name) {
        return this.actions.get(name);
    }

    public void removeKeyStrokeBinding(KeyCombination key) {
        this.keymap.remove((Object)key);
    }

    public boolean save() {
        try {
            File file = Config.getUserConfigFile((String)KEYS_FILE_FX);
            ArrayList<Object> lines = new ArrayList<Object>();
            lines.add("version 400");
            lines.add("# ALT CTRL META SHIFT SHORT KEYCODE ACTION");
            for (Map.Entry binding : this.keymap.entrySet()) {
                KeyCodeCombination k = (KeyCodeCombination)binding.getKey();
                lines.add(k.getAlt().name() + " " + k.getControl().name() + " " + k.getMeta() + " " + k.getShift() + " " + k.getShortcut() + " " + k.getCode().name() + " " + ((FlowAbstractAction)((Object)binding.getValue())).getName());
            }
            Files.write(file.toPath(), lines, Charset.forName("UTF-8"), new OpenOption[0]);
            return true;
        }
        catch (Exception exc) {
            Debug.message((String)("Cannot save key bindings: " + exc));
            return false;
        }
    }

    public boolean load() {
        try {
            File file = Config.getUserConfigFile((String)KEYS_FILE_FX);
            if (file.exists()) {
                List lines = Files.readAllLines(file.toPath(), Charset.forName("UTF-8")).stream().filter(l -> !l.startsWith("#") && !l.trim().isEmpty()).collect(Collectors.toList());
                if (lines.isEmpty() || !((String)lines.get(0)).startsWith("version")) {
                    return false;
                }
                try {
                    for (int i = 1; i < lines.size(); ++i) {
                        String line = (String)lines.get(i);
                        String[] split = line.split(" +");
                        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.valueOf((String)split[5]), KeyCombination.ModifierValue.valueOf((String)split[3]), KeyCombination.ModifierValue.valueOf((String)split[1]), KeyCombination.ModifierValue.valueOf((String)split[0]), KeyCombination.ModifierValue.valueOf((String)split[2]), KeyCombination.ModifierValue.valueOf((String)split[4])), split[6]);
                    }
                    return true;
                }
                catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
                    Debug.reportError((Throwable)e);
                    return false;
                }
            }
            file = Config.getUserConfigFile((String)KEYS_FILE);
            FileInputStream istream = new FileInputStream(file);
            ObjectInputStream stream = new ObjectInputStream(istream);
            int version = 0;
            int count = stream.readInt();
            if (count > 100) {
                version = count;
                count = stream.readInt();
            }
            if (Config.isMacOS() && version < 140) {
                istream.close();
                return false;
            }
            for (int i = 0; i < count; ++i) {
                String actionName;
                Object keyBinding = stream.readObject();
                KeyCodeCombination keyCombination = null;
                if (keyBinding instanceof KeyStroke) {
                    keyCombination = FlowActions.convertSwingBindingToFX((KeyStroke)keyBinding);
                }
                if ((actionName = (String)stream.readObject()) == null || keyCombination == null) continue;
                this.addKeyCombinationForAction(keyCombination, actionName);
            }
            istream.close();
            if (version < 252) {
                this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.EQUALS, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), "increase-font");
                this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.MINUS, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), "decrease-font");
            }
            if (version < 300) {
                this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.SPACE, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}), "code-completion");
                this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.I, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN}), "autoindent");
            }
            if (version < 320) {
                this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.K, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), "compile");
            }
            if (version < 330) {
                this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.COMMA, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), "preferences");
            }
            if (version < 400) {
                this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.DIGIT0, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), "reset-font");
            }
            return true;
        }
        catch (IOException | ClassNotFoundException exc) {
            return false;
        }
    }

    private static KeyCodeCombination convertSwingBindingToFX(KeyStroke swing) {
        KeyCode code;
        ArrayList<KeyCombination.Modifier> modifiers = new ArrayList<KeyCombination.Modifier>();
        if ((swing.getModifiers() & 2) != 0) {
            modifiers.add(KeyCombination.CONTROL_DOWN);
        }
        if ((swing.getModifiers() & 1) != 0) {
            modifiers.add(KeyCombination.SHIFT_DOWN);
        }
        if ((swing.getModifiers() & 4) != 0) {
            modifiers.add(KeyCombination.META_DOWN);
        }
        if ((swing.getModifiers() & 8) != 0) {
            modifiers.add(KeyCombination.ALT_DOWN);
        }
        if ((code = JavaFXUtil.awtKeyCodeToFX((int)swing.getKeyCode())) != null) {
            return new KeyCodeCombination(code, modifiers.toArray(new KeyCombination.Modifier[0]));
        }
        return null;
    }

    public void userAction() {
        this.lastActionWasCut = false;
    }

    public void closingBrace(int offset) {
        int lineStart = this.getDocument().getLineStart(this.getDocument().getLineFromPosition(offset));
        String prefix = this.getDocument().getContent(lineStart, offset).toString();
        if (prefix.trim().length() == 0) {
            this.editor.getSourcePane().positionCaret(lineStart);
            this.doIndent();
            this.editor.getSourcePane().positionCaret(this.editor.getSourcePane().getCaretPosition() + 1);
        }
    }

    public static void addSelectionToClipboard(FlowEditor ed) {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        String clipContent = clipboard.getString();
        if (clipContent == null) {
            clipContent = "";
        }
        clipboard.setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, clipContent + ed.getSourcePane().getSelectedText()));
    }

    private void doIndent() {
        int caretColumn;
        FlowEditorPane textPane = this.editor.getSourcePane();
        int lineIndex = this.getCurrentLineIndex();
        if (lineIndex == 0) {
            return;
        }
        ReparseableDocument doc = this.editor.getSourceDocument();
        ReparseableDocument.Element line = doc.getDefaultRootElement().getElement(lineIndex);
        int lineStart = line.getStartOffset();
        int pos = textPane.getCaretPosition();
        boolean isOpenBrace = false;
        boolean isColonOperatorDelimiter = false;
        boolean isCommentEnd = false;
        boolean isCommentEndOnly = false;
        String prefix = textPane.getDocument().getContent(lineStart, pos).toString();
        if (prefix.trim().length() > 0) {
            this.insertSpacedTab();
            return;
        }
        boolean foundLine = false;
        int lineOffset = 1;
        String prevLineText = "";
        while (lineIndex - lineOffset >= 0 && !foundLine) {
            ReparseableDocument.Element prevline = doc.getDefaultRootElement().getElement(lineIndex - lineOffset);
            int prevLineStart = prevline.getStartOffset();
            int prevLineEnd = prevline.getEndOffset();
            prevLineText = textPane.getDocument().getContent(prevLineStart, prevLineEnd).toString();
            if (!FlowIndent.isWhiteSpaceOnly(prevLineText)) {
                foundLine = true;
                continue;
            }
            ++lineOffset;
        }
        if (!foundLine) {
            return;
        }
        if (FlowActions.isOpenBrace(prevLineText)) {
            isOpenBrace = true;
        } else {
            isCommentEnd = prevLineText.trim().endsWith("*/");
            isCommentEndOnly = prevLineText.trim().equals("*/");
            isColonOperatorDelimiter = prevLineText.trim().matches("^\\s*(case\\s+[^:]*|default\\s*):$");
        }
        int indentPos = FlowIndent.findFirstNonIndentChar(prevLineText, isCommentEnd);
        String indent = prevLineText.substring(0, indentPos);
        if (isOpenBrace || isColonOperatorDelimiter) {
            indentPos += tabSize;
        }
        if ((caretColumn = this.getCurrentColumn()) >= indentPos) {
            return;
        }
        if (FlowActions.isNewCommentStart(indent, doc, textPane.getDocument(), lineStart)) {
            FlowActions.completeNewCommentBlock(textPane, indent);
            return;
        }
        int lineEnd = line.getEndOffset();
        String lineText = textPane.getDocument().getContent(lineStart, lineEnd).toString();
        indentPos = FlowIndent.findFirstNonIndentChar(lineText, true);
        char firstChar = lineText.isEmpty() ? (char)'\u0000' : lineText.charAt(indentPos);
        textPane.getDocument().replaceText(lineStart, lineStart + indentPos, "");
        String newIndent = FlowActions.nextIndent(indent, isOpenBrace || isColonOperatorDelimiter, isCommentEndOnly);
        if (firstChar == '*') {
            newIndent = newIndent.replace('*', ' ');
        }
        textPane.getDocument().replaceText(lineStart, lineStart, newIndent);
        if (firstChar == '}') {
            this.removeTab();
        }
    }

    private void doBlockIndent(FlowEditor editor) {
        editor.undoManager.compoundEdit(() -> FlowActions.blockAction(editor, new IndentLineAction()));
    }

    private void doBlockDeIndent(FlowEditor editor) {
        editor.undoManager.compoundEdit(() -> FlowActions.blockAction(editor, new DeindentLineAction()));
    }

    private void createActionTable() {
        this.compileOrNextErrorAction = this.compileOrNextErrorAction();
        List<Function> selectionActions = List.of(x$0 -> new EndDocumentAction((boolean)x$0), x$0 -> new EndLineAction((boolean)x$0), x$0 -> new EndWordAction((boolean)x$0), x$0 -> new HomeDocumentAction((boolean)x$0), x$0 -> new HomeLineAction((boolean)x$0), x$0 -> new BeginWordAction((boolean)x$0), x$0 -> new NextCharAction((boolean)x$0), x$0 -> new NextLineAction((boolean)x$0), x$0 -> new NextPageAction((boolean)x$0), x$0 -> new NextWordAction((boolean)x$0), x$0 -> new PrevCharAction((boolean)x$0), x$0 -> new PrevLineAction((boolean)x$0), x$0 -> new PrevPageAction((boolean)x$0), x$0 -> new PrevWordAction((boolean)x$0));
        FlowAbstractAction[] myActions = new FlowAbstractAction[]{new DeletePrevCharAction(), new DeleteNextCharAction(), this.deleteWordAction(), this.selectWordAction(), this.saveAction(), this.printAction(), this.closeAction(), this.undoAction(), this.redoAction(), this.commentBlockAction(), this.uncommentBlockAction(), this.autoIndentAction(), this.indentBlockAction(), this.deindentBlockAction(), this.insertMethodAction(), this.addJavadocAction(), this.indentAction(), this.deIndentAction(), this.newLineAction(), this.cutAction(), this.copyAction(), this.pasteAction(), this.copyLineAction(), this.cutLineAction(), this.cutEndOfLineAction(), this.cutWordAction(), this.cutEndOfWordAction(), this.findAction(), this.findNextAction(), this.findPrevAction(), this.replaceAction(), this.compileOrNextErrorAction, this.goToLineAction(), this.toggleInterfaceAction(), this.toggleBreakPointAction(), this.keyBindingsAction(), this.preferencesAction(), this.increaseFontAction(), this.decreaseFontAction(), this.resetFontAction(), this.contentAssistAction()};
        this.actions = new LinkedHashMap<String, FlowAbstractAction>();
        for (Function selectionAction : selectionActions) {
            for (boolean withSelection : new boolean[]{false, true}) {
                FlowAbstractAction action = (FlowAbstractAction)((Object)selectionAction.apply(withSelection));
                this.actions.put(action.getName(), action);
            }
        }
        for (FlowAbstractAction action : myActions) {
            this.actions.put(action.getName(), action);
        }
    }

    public List<FlowAbstractAction> getAllActions() {
        return new ArrayList<FlowAbstractAction>(this.actions.values());
    }

    public List<KeyCodeCombination> getKeyStrokesForAction(String actionName) {
        return this.keymap.entrySet().stream().filter(e -> Objects.equals(((FlowAbstractAction)((Object)((Object)e.getValue()))).getName(), actionName)).map(e -> (KeyCodeCombination)e.getKey()).collect(Collectors.toList());
    }

    public void makeAllUnavailableExcept(String ... actionNames) {
        HashSet<String> keepEnabled = new HashSet<String>(Arrays.asList(actionNames));
        for (Map.Entry<String, FlowAbstractAction> action : this.actions.entrySet()) {
            action.getValue().setAvailable(keepEnabled.contains(action.getKey()));
        }
    }

    public void makeAllAvailable() {
        for (Map.Entry<String, FlowAbstractAction> action : this.actions.entrySet()) {
            action.getValue().setAvailable(true);
        }
    }

    private FlowEditor getClearedEditor() {
        if (this.editor != null) {
            this.editor.clearMessage();
        }
        return this.editor;
    }

    public void setDefaultKeyBindings() {
        this.keymap.clear();
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "save");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "print");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "close");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "undo");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.Y, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "redo");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.F8, new KeyCombination.Modifier[0]), "comment-block");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.F7, new KeyCombination.Modifier[0]), "uncomment-block");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.F6, new KeyCombination.Modifier[0]), "indent-block");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.F5, new KeyCombination.Modifier[0]), "deindent-block");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.M, new KeyCombination.Modifier[]{SHORTCUT_MASK, KeyCombination.SHIFT_DOWN}), "insert-method");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.TAB, new KeyCombination.Modifier[0]), "indent");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.TAB, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN}), "de-indent");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.I, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "insert-tab");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[0]), "new-line");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN}), "insert-break");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.F, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "find");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.G, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "find-next");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.G, new KeyCombination.Modifier[]{SHORTCUT_MASK, KeyCombination.SHIFT_DOWN}), "find-next-backward");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "replace");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.L, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "go-to-line");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.K, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "compile");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.J, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "toggle-interface-view");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.B, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "toggle-breakpoint");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.COMMA, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "preferences");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.D, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "describe-key");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "copy-to-clipboard");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.X, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "cut-to-clipboard");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "paste-from-clipboard");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.F2, new KeyCombination.Modifier[0]), "copy-line");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.F3, new KeyCombination.Modifier[0]), "paste-from-clipboard");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.F4, new KeyCombination.Modifier[0]), "cut-line");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.EQUALS, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "increase-font");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.MINUS, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "decrease-font");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.SUBTRACT, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), "decrease-font");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.DIGIT0, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "reset-font");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.NUMPAD0, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "reset-font");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.SPACE, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}), "code-completion");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.I, SHIFT_SHORTCUT_MASK), "autoindent");
    }

    private FlowAbstractAction action(String name, Category category, final FXPlatformRunnable action) {
        return new FlowAbstractAction(name, category){

            @OnThread(value=Tag.FXPlatform)
            public void actionPerformed(boolean viaContextMenu) {
                action.run();
            }
        };
    }

    private FlowAbstractAction contextSensitiveAction(String name, Category category, final FXPlatformConsumer<Boolean> action) {
        return new FlowAbstractAction(name, category){

            @OnThread(value=Tag.FXPlatform)
            public void actionPerformed(boolean viaContextMenu) {
                action.accept((Object)viaContextMenu);
            }
        };
    }

    private FlowAbstractAction saveAction() {
        return this.action("save", Category.CLASS, () -> this.getClearedEditor().cancelFreshState());
    }

    private FlowAbstractAction printAction() {
        return this.action("print", Category.CLASS, () -> this.getClearedEditor().print());
    }

    private FlowAbstractAction closeAction() {
        return this.action("close", Category.CLASS, () -> this.getClearedEditor().close());
    }

    private FlowAbstractAction undoAction() {
        FlowAbstractAction action = this.action("undo", Category.MISC, () -> {
            FlowEditor editor = this.getClearedEditor();
            editor.undoManager.undo();
        });
        action.bindDisabled(this.editor == null ? null : this.editor.undoManager.cannotUndo());
        return action;
    }

    private FlowAbstractAction redoAction() {
        FlowAbstractAction action = this.action("redo", Category.MISC, () -> {
            FlowEditor editor = this.getClearedEditor();
            editor.undoManager.redo();
        });
        action.bindDisabled(this.editor == null ? null : this.editor.undoManager.cannotRedo());
        return action;
    }

    private FlowAbstractAction commentBlockAction() {
        return this.action("comment-block", Category.EDIT, () -> {
            FlowEditor editor = this.getClearedEditor();
            editor.undoManager.compoundEdit(() -> FlowActions.blockAction(editor, new CommentLineAction()));
        });
    }

    private FlowAbstractAction uncommentBlockAction() {
        return this.action("uncomment-block", Category.EDIT, () -> {
            FlowEditor editor = this.getClearedEditor();
            editor.undoManager.compoundEdit(() -> FlowActions.blockAction(editor, new UncommentLineAction()));
        });
    }

    private FlowAbstractAction indentBlockAction() {
        return this.action("indent-block", Category.EDIT, () -> this.doBlockIndent(this.getClearedEditor()));
    }

    private FlowAbstractAction deindentBlockAction() {
        return this.action("deindent-block", Category.EDIT, () -> this.doBlockDeIndent(this.getClearedEditor()));
    }

    private FlowAbstractAction autoIndentAction() {
        return this.action("autoindent", Category.EDIT, () -> {
            FlowEditor editor = this.getClearedEditor();
            ReparseableDocument doc = editor.getSourceDocument();
            if (editor.getParsedNode() == null) {
                return;
            }
            int prevCaretPos = editor.getSourcePane().getCaretPosition();
            editor.undoManager.compoundEdit(() -> {
                FlowIndent.AutoIndentInformation info = FlowIndent.calculateIndentsAndApply(doc, editor.getSourcePane().getDocument(), prevCaretPos);
                editor.getSourcePane().positionCaret(info.getNewCaretPosition());
                if (info.isPerfect()) {
                    editor.writeMessage(Config.getString((String)"editor.info.perfectIndent"));
                }
            });
        });
    }

    private FlowAbstractAction insertMethodAction() {
        return this.action("insert-method", Category.EDIT, () -> {
            FlowEditor editor = this.getClearedEditor();
            if (!editor.containsSourceCode()) {
                return;
            }
            editor.undoManager.compoundEdit(() -> this.insertTemplate("method"));
        });
    }

    private FlowAbstractAction addJavadocAction() {
        return this.action("add-javadoc", Category.EDIT, () -> {
            FlowEditor editor = this.getClearedEditor();
            if (!editor.containsSourceCode()) {
                return;
            }
            int caretPos = editor.getSourcePane().getCaretPosition();
            NodeTree.NodeAndPosition node = editor.getParsedNode().findNodeAt(caretPos, 0);
            while (node != null && ((ParsedNode)node.getNode()).getNodeType() != 2) {
                node = ((ParsedNode)node.getNode()).findNodeAt(caretPos, node.getPosition());
            }
            if (node == null || !(node.getNode() instanceof MethodNode)) {
                editor.writeMessage(Config.getString((String)"editor.addjavadoc.notAMethod"));
            } else {
                MethodNode methodNode = (MethodNode)node.getNode();
                boolean hasJavadocComment = false;
                Iterator it = methodNode.getChildren(node.getPosition());
                while (it.hasNext()) {
                    ParsedNode subNode = (ParsedNode)((NodeTree.NodeAndPosition)it.next()).getNode();
                    if (!(subNode instanceof CommentNode)) continue;
                    hasJavadocComment = hasJavadocComment || ((CommentNode)subNode).isJavadocComment();
                }
                if (hasJavadocComment) {
                    editor.writeMessage(Config.getString((String)"editor.addjavadoc.hasJavadoc"));
                } else {
                    JavaType retType;
                    StringBuilder indent = new StringBuilder();
                    int column = editor.getLineColumnFromOffset(node.getPosition()).getColumn();
                    for (int i = 0; i < column - 1; ++i) {
                        indent.append(' ');
                    }
                    StringBuilder newComment = new StringBuilder();
                    newComment.append("/**\n");
                    JavaEntity retTypeEntity = methodNode.getReturnType();
                    if (retTypeEntity == null) {
                        newComment.append((CharSequence)indent).append(" * ").append(methodNode.getName()).append(" ");
                        newComment.append(Config.getString((String)"editor.addjavadoc.constructor")).append("\n");
                    } else {
                        newComment.append((CharSequence)indent).append(" * ").append(Config.getString((String)"editor.addjavadoc.method"));
                        newComment.append(" ").append(methodNode.getName()).append("\n");
                    }
                    newComment.append((CharSequence)indent).append(" *\n");
                    for (String s : methodNode.getParamNames()) {
                        newComment.append((CharSequence)indent).append(" * @param ").append(s).append(" ");
                        newComment.append(Config.getString((String)"editor.addjavadoc.parameter")).append("\n");
                    }
                    if (retTypeEntity != null && (retType = retTypeEntity.resolveAsType().getType()) != null && !retType.isVoid()) {
                        newComment.append((CharSequence)indent).append(" * @return ");
                        newComment.append(Config.getString((String)"editor.addjavadoc.returnValue")).append("\n");
                    }
                    newComment.append((CharSequence)indent).append(" */\n").append((CharSequence)indent);
                    NodeTree.NodeAndPosition nodeFinal = node;
                    editor.undoManager.compoundEdit(() -> {
                        editor.getSourcePane().positionCaret(nodeFinal.getPosition());
                        editor.getSourcePane().replaceSelection(newComment.toString());
                        editor.getSourcePane().positionCaret(caretPos + newComment.length());
                    });
                }
            }
        });
    }

    private FlowAbstractAction indentAction() {
        return this.action("indent", Category.EDIT, () -> {
            FlowEditor editor = this.getClearedEditor();
            int caretPos = editor.getSourcePane().getCaretPosition();
            int caretLine = this.getDocument().getLineFromPosition(caretPos);
            if (caretLine != this.getDocument().getLineFromPosition(editor.getSourcePane().getAnchorPosition())) {
                this.doBlockIndent(editor);
            } else {
                int lineStart = this.getDocument().getLineStart(caretLine);
                String prefix = this.getDocument().getContent(lineStart, caretPos).toString();
                if (prefix.trim().length() > 0) {
                    this.insertSpacedTab();
                } else {
                    this.doBlockIndent(editor);
                }
            }
        });
    }

    private FlowAbstractAction deIndentAction() {
        return this.action("de-indent", Category.EDIT, () -> this.doBlockDeIndent(this.getClearedEditor()));
    }

    private FlowEditorPane getTextComponent() {
        return this.getClearedEditor() == null ? null : this.getClearedEditor().getSourcePane();
    }

    private FlowAbstractAction newLineAction() {
        return this.action("new-line", Category.EDIT, () -> {
            if (this.editor.hasQuickFixShown() && this.editor.hasQuickFixSelected()) {
                this.editor.executeQuickFix();
            } else {
                if (this.editor.isReadOnly()) {
                    return;
                }
                boolean addSmartBracket = this.editor.getSourcePane().hasJustAddedCurlyBracket();
                SourceLocation leavingLine = this.editor.getCaretLocation();
                this.getClearedEditor().getSourcePane().replaceSelection("\n");
                this.editor.getSourcePane().ensureCaretShowing();
                if (PrefMgr.getFlag((String)"bluej.editor.autoIndent")) {
                    this.doIndent();
                }
                if (PrefMgr.getFlag((String)"bluej.editor.autoAddClosingCurly") && addSmartBracket) {
                    int openCurlyLineIndent = FlowIndent.findFirstNonIndentChar(this.editor.getText(new SourceLocation(leavingLine.getLine(), 1), leavingLine), true);
                    int position = this.editor.getSourcePane().getCaretPosition();
                    StringBuilder addition = new StringBuilder("\n");
                    for (int i = 0; i < openCurlyLineIndent; ++i) {
                        addition.append(' ');
                    }
                    addition.append('}');
                    this.editor.getSourcePane().replaceSelection(addition.toString());
                    this.editor.getSourcePane().positionCaret(position);
                }
            }
        });
    }

    private FlowAbstractAction cutAction() {
        return this.contextSensitiveAction("cut-to-clipboard", Category.EDIT, (FXPlatformConsumer<Boolean>)((FXPlatformConsumer)viaContextMenu -> {
            if (this.editor.isReadOnly()) {
                return;
            }
            if (viaContextMenu.booleanValue() || this.editor.getSourcePane().isFocused()) {
                this.copySelectionToClipboard();
                this.editor.getSourcePane().replaceSelection("");
                if (viaContextMenu.booleanValue()) {
                    this.editor.getSourcePane().requestFocus();
                }
            }
        }));
    }

    private FlowAbstractAction copyAction() {
        return this.contextSensitiveAction("copy-to-clipboard", Category.EDIT, (FXPlatformConsumer<Boolean>)((FXPlatformConsumer)viaContextMenu -> {
            if (viaContextMenu.booleanValue() || this.editor.getSourcePane().isFocused()) {
                this.copySelectionToClipboard();
                if (viaContextMenu.booleanValue()) {
                    this.editor.getSourcePane().requestFocus();
                }
            }
        }));
    }

    private void copySelectionToClipboard() {
        Clipboard.getSystemClipboard().setContent(Map.of(DataFormat.PLAIN_TEXT, this.editor.getSourcePane().getSelectedText()));
    }

    private FlowAbstractAction pasteAction() {
        return this.contextSensitiveAction("paste-from-clipboard", Category.EDIT, (FXPlatformConsumer<Boolean>)((FXPlatformConsumer)viaContextMenu -> {
            if (this.editor.isReadOnly()) {
                return;
            }
            if (viaContextMenu.booleanValue() || this.editor.getSourcePane().isFocused()) {
                String toPaste = Clipboard.getSystemClipboard().getString();
                if (toPaste != null) {
                    toPaste = toPaste.replace("\r", "");
                    this.editor.getSourcePane().replaceSelection(toPaste);
                }
                if (viaContextMenu.booleanValue()) {
                    this.editor.getSourcePane().requestFocus();
                }
                this.editor.getSourcePane().ensureCaretShowing();
            }
        }));
    }

    private FlowAbstractAction copyLineAction() {
        return this.action("copy-line", Category.EDIT, () -> {
            boolean addToClipboard = this.lastActionWasCut;
            this.selectWholeLine();
            if (addToClipboard) {
                FlowActions.addSelectionToClipboard(this.editor);
            } else {
                this.copySelectionToClipboard();
            }
            this.lastActionWasCut = true;
        });
    }

    private void selectWholeLine() {
        int curLine = this.getDocument().getLineFromPosition(this.getTextComponent().getCaretPosition());
        this.getTextComponent().positionAnchor(this.getDocument().getLineStart(curLine));
        this.getTextComponent().moveCaret(this.getDocument().getLineEnd(curLine));
        if (this.getTextComponent().getCaretPosition() < this.getTextComponent().getDocument().getLength()) {
            this.getTextComponent().moveCaret(this.getTextComponent().getCaretPosition() + 1);
        }
    }

    private FlowAbstractAction cutLineAction() {
        return this.action("cut-line", Category.EDIT, () -> {
            boolean addToClipboard = this.lastActionWasCut;
            this.selectWholeLine();
            if (addToClipboard) {
                FlowActions.addSelectionToClipboard(this.editor);
            } else {
                this.copySelectionToClipboard();
            }
            this.editor.getSourcePane().replaceSelection("");
            this.lastActionWasCut = true;
        });
    }

    private FlowAbstractAction increaseFontAction() {
        return this.action("increase-font", Category.MISC, () -> Utility.increaseFontSize((IntegerProperty)PrefMgr.getEditorFontSize()));
    }

    private FlowAbstractAction decreaseFontAction() {
        return this.action("decrease-font", Category.MISC, () -> Utility.decreaseFontSize((IntegerProperty)PrefMgr.getEditorFontSize()));
    }

    private FlowAbstractAction resetFontAction() {
        return this.action("reset-font", Category.MISC, () -> PrefMgr.getEditorFontSize().set(10));
    }

    private FlowAbstractAction cutEndOfLineAction() {
        return this.action("cut-end-of-line", Category.EDIT, () -> {
            boolean addToClipboard = this.lastActionWasCut;
            this.getTextComponent().positionAnchor(this.getTextComponent().getCaretPosition());
            this.getTextComponent().moveCaret(this.getTextComponent().getDocument().getLineEnd(this.getTextComponent().getDocument().getLineFromPosition(this.getTextComponent().getCaretPosition())));
            if (this.getTextComponent().getCaretPosition() < this.getTextComponent().getDocument().getLength()) {
                this.getTextComponent().moveCaret(this.getTextComponent().getCaretPosition() + 1);
            }
            if (addToClipboard) {
                FlowActions.addSelectionToClipboard(this.editor);
            } else {
                this.copySelectionToClipboard();
            }
            this.getTextComponent().replaceSelection("");
            this.lastActionWasCut = true;
        });
    }

    private FlowAbstractAction cutWordAction() {
        return this.action("cut-word", Category.EDIT, () -> {
            boolean addToClipboard = this.lastActionWasCut;
            this.getActionByName("caret-previous-word").actionPerformed(false);
            this.getActionByName("selection-next-word").actionPerformed(false);
            if (addToClipboard) {
                FlowActions.addSelectionToClipboard(this.editor);
                this.getActionByName("delete-previous").actionPerformed(false);
            } else {
                this.getActionByName("cut-to-clipboard").actionPerformed(false);
            }
            this.lastActionWasCut = true;
        });
    }

    private FlowAbstractAction contentAssistAction() {
        return this.action("code-completion", Category.MISC, () -> {
            FlowEditor editor = this.getClearedEditor();
            if (Config.getPropBoolean((String)"bluej.editor.codecompletion", (boolean)true)) {
                editor.createContentAssist();
            }
        });
    }

    private FlowAbstractAction cutEndOfWordAction() {
        return this.action("cut-end-of-word", Category.EDIT, () -> {
            boolean addToClipboard = this.lastActionWasCut;
            this.getActionByName("selection-next-word").actionPerformed(false);
            if (addToClipboard) {
                FlowActions.addSelectionToClipboard(this.editor);
                this.getActionByName("delete-previous").actionPerformed(false);
            } else {
                this.getActionByName("cut-to-clipboard").actionPerformed(false);
            }
            this.lastActionWasCut = true;
        });
    }

    private Document getDocument() {
        return this.getTextComponent().getDocument();
    }

    private FlowAbstractAction deleteWordAction() {
        return this.action("delete-previous-word", Category.EDIT, () -> {
            FlowEditorPane c = this.getTextComponent();
            FlowAbstractAction prevWordAct = this.actions.get("caret-previous-word");
            int end = c.getCaretPosition();
            prevWordAct.actionPerformed(false);
            c.positionAnchor(end);
            c.replaceSelection("");
        });
    }

    private FlowAbstractAction selectWordAction() {
        return this.action("select-word", Category.MOVE_SCROLL, () -> {
            FlowEditorPane c = this.getTextComponent();
            int origPos = c.getCaretPosition();
            int newStart = FlowActions.findWordLimit(c, origPos, false);
            int newEnd = FlowActions.findWordLimit(c, origPos, true);
            c.positionAnchor(newStart);
            c.moveCaret(newEnd);
        });
    }

    private FlowAbstractAction findAction() {
        return this.action("find", Category.MISC, () -> this.getClearedEditor().initFindPanel());
    }

    private FlowAbstractAction findNextAction() {
        return this.action("find-next", Category.MISC, () -> this.getClearedEditor().findNext(false));
    }

    private FlowAbstractAction findPrevAction() {
        return this.action("find-next-backward", Category.MISC, () -> this.getClearedEditor().findNext(true));
    }

    private FlowAbstractAction replaceAction() {
        return this.action("replace", Category.MISC, () -> {
            FlowEditor editor = this.getClearedEditor();
            editor.showReplacePanel();
            if (editor.getSourcePane().getSelectedText() != null) {
                editor.setFindTextfield(editor.getSourcePane().getSelectedText());
            }
        });
    }

    private FlowAbstractAction compileOrNextErrorAction() {
        return this.action("compile", Category.MISC, () -> this.getClearedEditor().compileOrShowNextError());
    }

    private FlowAbstractAction toggleInterfaceAction() {
        return this.action("toggle-interface-view", Category.MISC, () -> this.getClearedEditor().toggleInterface());
    }

    private FlowAbstractAction toggleBreakPointAction() {
        return this.action("toggle-breakpoint", Category.MISC, () -> this.getClearedEditor().toggleBreakpoint());
    }

    private FlowAbstractAction keyBindingsAction() {
        return this.action("key-bindings", Category.MISC, () -> this.getClearedEditor().showPreferences(1));
    }

    private FlowAbstractAction preferencesAction() {
        return this.action("preferences", Category.MISC, () -> this.getClearedEditor().showPreferences(0));
    }

    private FlowAbstractAction goToLineAction() {
        return this.action("go-to-line", Category.MISC, () -> this.getClearedEditor().goToLine());
    }

    class DeindentLineAction
    implements LineAction {
        DeindentLineAction() {
        }

        @Override
        public void apply(ReparseableDocument.Element line, Document doc) {
            int lineStart = line.getStartOffset();
            int lineEnd = line.getEndOffset();
            try {
                String lineText = doc.getContent(lineStart, lineEnd).toString();
                String spacedTab = FlowActions.spaces.substring(0, tabSize);
                if (lineText.startsWith(spacedTab)) {
                    doc.replaceText(lineStart, lineStart + tabSize, "");
                } else if (lineText.charAt(0) == '\t') {
                    doc.replaceText(lineStart, lineStart + 1, "");
                } else {
                    int cnt = 0;
                    while (lineText.charAt(cnt) == ' ') {
                        ++cnt;
                    }
                    doc.replaceText(lineStart, lineStart + cnt, "");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class IndentLineAction
    implements LineAction {
        IndentLineAction() {
        }

        @Override
        public void apply(ReparseableDocument.Element line, Document doc) {
            int lineStart = line.getStartOffset();
            doc.replaceText(lineStart, lineStart, FlowActions.spaces.substring(0, tabSize));
        }
    }

    class UncommentLineAction
    implements LineAction {
        UncommentLineAction() {
        }

        @Override
        public void apply(ReparseableDocument.Element line, Document doc) {
            int lineStart = line.getStartOffset();
            int lineEnd = line.getEndOffset();
            try {
                String lineText = doc.getContent(lineStart, lineEnd).toString();
                if (lineText.trim().startsWith("//")) {
                    int cnt = 0;
                    while (lineText.charAt(cnt) != '/') {
                        ++cnt;
                    }
                    if (lineText.charAt(cnt + 2) == ' ') {
                        doc.replaceText(lineStart + cnt, lineStart + cnt + 3, "");
                    } else {
                        doc.replaceText(lineStart + cnt, lineStart + cnt + 2, "");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class CommentLineAction
    implements LineAction {
        CommentLineAction() {
        }

        @Override
        public void apply(ReparseableDocument.Element line, Document doc) {
            int lineEnd;
            int lineStart = line.getStartOffset();
            String lineText = doc.getContent(lineStart, lineEnd = line.getEndOffset()).toString();
            if (lineText.trim().length() > 0) {
                int textStart = FlowIndent.findFirstNonIndentChar(lineText, true);
                doc.replaceText(lineStart + textStart, lineStart + textStart, "// ");
            }
        }
    }

    class BeginWordAction
    extends FlowActionWithOrWithoutSelection {
        public BeginWordAction(boolean withSelection) {
            super(withSelection ? "selection-begin-word" : "caret-begin-word", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            FlowEditorPane c = FlowActions.this.getTextComponent();
            int origPos = c.getCaretPosition();
            int start = FlowActions.findWordLimit(c, origPos, false);
            this.moveCaret(start);
        }
    }

    class EndWordAction
    extends FlowActionWithOrWithoutSelection {
        public EndWordAction(boolean withSelection) {
            super(withSelection ? "selection-end-word" : "caret-end-word", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            FlowEditorPane c = FlowActions.this.getTextComponent();
            int origPos = c.getCaretPosition();
            int end = FlowActions.findWordLimit(c, origPos, true);
            this.moveCaret(end);
        }
    }

    class PrevWordAction
    extends FlowActionWithOrWithoutSelection {
        public PrevWordAction(boolean withSelection) {
            super(withSelection ? "selection-previous-word" : "caret-previous-word", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            FlowEditorPane c = FlowActions.this.getTextComponent();
            int origPos = c.getCaretPosition();
            if (origPos == 0) {
                return;
            }
            if (Character.isWhitespace(c.getDocument().getContent(origPos - 1, origPos).charAt(0))) {
                int startOfWS = FlowActions.findWordLimit(c, origPos - 1, false);
                int startOfPrevWord = FlowActions.findWordLimit(c, startOfWS - 1, false);
                this.moveCaret(startOfPrevWord);
            } else {
                int startOfWord = FlowActions.findWordLimit(c, origPos - 1, false);
                this.moveCaret(startOfWord);
            }
        }
    }

    class NextWordAction
    extends FlowActionWithOrWithoutSelection {
        public NextWordAction(boolean withSelection) {
            super(withSelection ? "selection-next-word" : "caret-next-word", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            int origPos;
            FlowEditorPane c = FlowActions.this.getTextComponent();
            int end = FlowActions.findWordLimit(c, origPos = c.getCaretPosition(), true);
            if (end < c.getDocument().getLength() && Character.isWhitespace(c.getDocument().getContent(end, end + 1).charAt(0))) {
                int endOfWS = FlowActions.findWordLimit(c, end, true);
                this.moveCaret(endOfWS);
            } else {
                this.moveCaret(end);
            }
        }
    }

    private class DeleteNextCharAction
    extends FlowAbstractAction {
        public DeleteNextCharAction() {
            super("delete-next", Category.EDIT);
        }

        public void actionPerformed(boolean viaContextMenu) {
            if (FlowActions.this.getTextComponent().getCaretPosition() == FlowActions.this.getTextComponent().getAnchorPosition()) {
                FlowActions.this.getTextComponent().moveCaret(Math.min(FlowActions.this.getDocument().getLength(), FlowActions.this.getTextComponent().getCaretPosition() + 1));
            }
            FlowActions.this.getTextComponent().replaceSelection("");
        }
    }

    private class DeletePrevCharAction
    extends FlowAbstractAction {
        public DeletePrevCharAction() {
            super("delete-previous", Category.EDIT);
        }

        public void actionPerformed(boolean viaContextMenu) {
            if (FlowActions.this.getTextComponent().getCaretPosition() == FlowActions.this.getTextComponent().getAnchorPosition()) {
                int lineIndex = FlowActions.this.getCurrentLineIndex();
                ReparseableDocument doc = FlowActions.this.editor.getSourceDocument();
                ReparseableDocument.Element line = doc.getDefaultRootElement().getElement(lineIndex);
                int lineStart = line.getStartOffset();
                String textBeforeCaret = FlowActions.this.getTextComponent().getDocument().getContent(lineStart, FlowActions.this.getTextComponent().getCaretPosition()).toString();
                if (Pattern.compile("[    ]+[ ]*").matcher(textBeforeCaret).matches()) {
                    int exceedingSpaces = textBeforeCaret.length() % 4;
                    FlowActions.this.getTextComponent().select(FlowActions.this.getTextComponent().getCaretPosition(), FlowActions.this.getTextComponent().getCaretPosition() - (exceedingSpaces == 0 ? 4 : exceedingSpaces));
                } else {
                    FlowActions.this.getTextComponent().moveCaret(Math.max(0, FlowActions.this.getTextComponent().getCaretPosition() - 1));
                }
            }
            FlowActions.this.getTextComponent().replaceSelection("");
        }
    }

    private class NextCharAction
    extends FlowActionWithOrWithoutSelection {
        public NextCharAction(boolean withSelection) {
            super(withSelection ? "selection-forward" : "caret-forward", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            this.moveCaret(Math.min(FlowActions.this.getTextComponent().getDocument().getLength(), FlowActions.this.getTextComponent().getCaretPosition() + 1));
        }
    }

    private class PrevCharAction
    extends FlowActionWithOrWithoutSelection {
        public PrevCharAction(boolean withSelection) {
            super(withSelection ? "selection-backward" : "caret-backward", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            this.moveCaret(Math.max(0, FlowActions.this.getTextComponent().getCaretPosition() - 1));
        }
    }

    private class NextLineAction
    extends FlowActionWithOrWithoutSelection {
        public NextLineAction(boolean withSelection) {
            super(withSelection ? "selection-down" : "caret-down", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            if (FlowActions.this.editor.hasQuickFixShown()) {
                FlowActions.this.editor.changeQuickFixSelection(true);
            } else {
                SourceLocation pos = FlowActions.this.getTextComponent().getDocument().makeSourceLocation(FlowActions.this.getTextComponent().getCaretPosition());
                int targetColumn = FlowActions.this.getTextComponent().getTargetColumnForVerticalMove();
                if (pos.getLine() == FlowActions.this.getTextComponent().getDocument().getLineCount()) {
                    this.moveCaret(FlowActions.this.getTextComponent().getDocument().getLength());
                } else {
                    if (targetColumn == -1) {
                        targetColumn = pos.getColumn();
                    }
                    this.moveCaret(FlowActions.this.getTextComponent().getDocument().getPosition(new SourceLocation(pos.getLine() + 1, targetColumn)));
                }
                FlowActions.this.getTextComponent().setTargetColumnForVerticalMove(targetColumn);
            }
        }
    }

    private class PrevLineAction
    extends FlowActionWithOrWithoutSelection {
        public PrevLineAction(boolean withSelection) {
            super(withSelection ? "selection-up" : "caret-up", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            if (FlowActions.this.editor.hasQuickFixShown()) {
                FlowActions.this.editor.changeQuickFixSelection(false);
            } else {
                SourceLocation pos = FlowActions.this.getTextComponent().getDocument().makeSourceLocation(FlowActions.this.getTextComponent().getCaretPosition());
                int targetColumn = FlowActions.this.getTextComponent().getTargetColumnForVerticalMove();
                if (pos.getLine() == 1) {
                    this.moveCaret(0);
                } else {
                    if (targetColumn == -1) {
                        targetColumn = pos.getColumn();
                    }
                    this.moveCaret(FlowActions.this.getTextComponent().getDocument().getPosition(new SourceLocation(pos.getLine() - 1, targetColumn)));
                }
                FlowActions.this.getTextComponent().setTargetColumnForVerticalMove(targetColumn);
            }
        }
    }

    private class NextPageAction
    extends FlowActionWithOrWithoutSelection {
        public NextPageAction(boolean withSelection) {
            super(withSelection ? "selection-page-down" : "page-down", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            int[] range = FlowActions.this.getTextComponent().getLineRangeVisible();
            int pageSize = range[1] - range[0];
            SourceLocation pos = FlowActions.this.getTextComponent().getDocument().makeSourceLocation(FlowActions.this.getTextComponent().getCaretPosition());
            int targetColumn = FlowActions.this.getTextComponent().getTargetColumnForVerticalMove();
            if (pos.getLine() - 1 + pageSize >= FlowActions.this.getTextComponent().getDocument().getLineCount()) {
                this.moveCaret(FlowActions.this.getTextComponent().getDocument().getLength());
            } else {
                if (targetColumn == -1) {
                    targetColumn = pos.getColumn();
                }
                this.moveCaret(FlowActions.this.getTextComponent().getDocument().getPosition(new SourceLocation(pos.getLine() + pageSize, targetColumn)));
            }
            FlowActions.this.getTextComponent().setTargetColumnForVerticalMove(targetColumn);
        }
    }

    private class PrevPageAction
    extends FlowActionWithOrWithoutSelection {
        public PrevPageAction(boolean withSelection) {
            super(withSelection ? "selection-page-up" : "page-up", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            int[] range = FlowActions.this.getTextComponent().getLineRangeVisible();
            int pageSize = range[1] - range[0];
            SourceLocation pos = FlowActions.this.getTextComponent().getDocument().makeSourceLocation(FlowActions.this.getTextComponent().getCaretPosition());
            int targetColumn = FlowActions.this.getTextComponent().getTargetColumnForVerticalMove();
            if (pos.getLine() - 1 <= pageSize) {
                this.moveCaret(0);
            } else {
                if (targetColumn == -1) {
                    targetColumn = pos.getColumn();
                }
                this.moveCaret(FlowActions.this.getTextComponent().getDocument().getPosition(new SourceLocation(pos.getLine() - pageSize, targetColumn)));
            }
            FlowActions.this.getTextComponent().setTargetColumnForVerticalMove(targetColumn);
        }
    }

    private class HomeDocumentAction
    extends FlowActionWithOrWithoutSelection {
        public HomeDocumentAction(boolean withSelection) {
            super(withSelection ? "selection-begin" : "caret-begin", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            this.moveCaret(0);
        }
    }

    private class HomeLineAction
    extends FlowActionWithOrWithoutSelection {
        public HomeLineAction(boolean withSelection) {
            super(withSelection ? "selection-begin-line" : "caret-begin-line", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            Document document = FlowActions.this.getDocument();
            int curLine = document.getLineFromPosition(FlowActions.this.getTextComponent().getCaretPosition());
            if (curLine == 0) {
                this.moveCaret(0);
            } else {
                int lineStart;
                int contentStart;
                int lineEnd = document.getLineEnd(curLine);
                for (contentStart = lineStart = document.getLineStart(curLine); Character.isWhitespace(FlowActions.this.getTextComponent().getDocument().getContent(contentStart, contentStart + 1).charAt(0)) && contentStart < lineEnd; ++contentStart) {
                }
                if (FlowActions.this.getTextComponent().getCaretPosition() == contentStart) {
                    this.moveCaret(lineStart);
                } else {
                    this.moveCaret(contentStart);
                }
            }
        }
    }

    private class EndDocumentAction
    extends FlowActionWithOrWithoutSelection {
        public EndDocumentAction(boolean withSelection) {
            super(withSelection ? "selection-end" : "caret-end", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            this.moveCaret(FlowActions.this.getDocument().getLength());
        }
    }

    private class EndLineAction
    extends FlowActionWithOrWithoutSelection {
        public EndLineAction(boolean withSelection) {
            super(withSelection ? "selection-end-line" : "caret-end-line", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            Document document = FlowActions.this.getDocument();
            int curLine = document.getLineFromPosition(FlowActions.this.getTextComponent().getCaretPosition());
            if (curLine >= document.getLineCount() - 1) {
                this.moveCaret(document.getLength());
            } else {
                this.moveCaret(document.getLineStart(curLine + 1) - 1);
            }
        }
    }

    private abstract class FlowActionWithOrWithoutSelection
    extends FlowAbstractAction {
        protected final boolean withSelection;

        protected FlowActionWithOrWithoutSelection(String actionName, Category category, boolean withSelection) {
            super(actionName, category);
            this.withSelection = withSelection;
        }

        protected void moveCaret(int pos) {
            if (this.withSelection) {
                FlowActions.this.getTextComponent().moveCaret(pos);
            } else {
                FlowActions.this.getTextComponent().positionCaret(pos);
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public abstract class FlowAbstractAction
    extends FXAbstractAction {
        private final Category category;

        public FlowAbstractAction(String name, Category category) {
            super(name);
            this.accelerator.bind((ObservableValue)Bindings.createObjectBinding(() -> FlowActions.this.keymap.entrySet().stream().filter(e -> ((FlowAbstractAction)((Object)((Object)((Object)e.getValue())))).equals((Object)this)).map(e -> (KeyCodeCombination)e.getKey()).findFirst().orElse(null), (Observable[])new Observable[]{FlowActions.this.keymap}));
            this.category = category;
        }

        public Category getCategory() {
            return this.category;
        }
    }

    static interface LineAction {
        public void apply(ReparseableDocument.Element var1, Document var2);
    }

    public static enum Category {
        EDIT("editor.functions.editFunctions"),
        MOVE_SCROLL("editor.functions.moveScroll"),
        CLASS("editor.functions.classFunctions"),
        MISC("editor.functions.misc");

        private final String label;

        private Category(String labelKey) {
            this.label = Config.getString((String)labelKey);
        }

        @OnThread(value=Tag.Any)
        public String toString() {
            return this.label;
        }
    }
}

