/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.editor.flow.Document;
import bluej.editor.flow.DocumentListener;
import bluej.utility.javafx.FXPlatformRunnable;
import java.util.ArrayList;
import java.util.List;

public class DocumentUndoStack
implements DocumentListener {
    private final Document document;
    private final ArrayList<ArrayList<Change>> rememberedChanges = new ArrayList();
    private int changeIndex = 0;
    private boolean changeByUs = false;
    private boolean inCompoundEdit = false;
    private FXPlatformRunnable stateListener = null;

    public DocumentUndoStack(Document document) {
        this.document = document;
        document.addListener(false, this);
    }

    @Override
    public void textReplaced(int origStartIncl, String original, String replacement, int linesRemoved, int linesAdded) {
        if (!this.changeByUs) {
            if (this.changeIndex != this.rememberedChanges.size()) {
                this.rememberedChanges.subList(this.changeIndex, this.rememberedChanges.size()).clear();
            }
            if (!this.inCompoundEdit) {
                this.rememberedChanges.add(new ArrayList());
                ++this.changeIndex;
            }
            this.rememberedChanges.get(this.changeIndex - 1).add(new Change(origStartIncl, original, replacement));
            if (!this.inCompoundEdit && this.stateListener != null) {
                this.stateListener.run();
            }
        }
    }

    public int canUndoCount() {
        return this.changeIndex;
    }

    public int canRedoCount() {
        return this.rememberedChanges.size() - this.changeIndex;
    }

    public int undo() {
        if (this.changeIndex > 0) {
            this.changeByUs = true;
            --this.changeIndex;
            List changesToUndo = this.rememberedChanges.get(this.changeIndex);
            int latestPos = -1;
            for (int i = changesToUndo.size() - 1; i >= 0; --i) {
                Change change = (Change)changesToUndo.get(i);
                this.document.replaceText(change.targetStartIncl, change.targetStartIncl + change.replacement.length(), change.replaced);
                latestPos = change.targetStartIncl + change.replaced.length();
            }
            this.changeByUs = false;
            if (this.stateListener != null) {
                this.stateListener.run();
            }
            return latestPos;
        }
        return -1;
    }

    public int redo() {
        if (this.changeIndex < this.rememberedChanges.size()) {
            this.changeByUs = true;
            List changes = this.rememberedChanges.get(this.changeIndex);
            ++this.changeIndex;
            int latestPos = -1;
            for (Change change : changes) {
                this.document.replaceText(change.targetStartIncl, change.targetStartIncl + change.replaced.length(), change.replacement);
                latestPos = change.targetStartIncl + change.replacement.length();
            }
            this.changeByUs = false;
            if (this.stateListener != null) {
                this.stateListener.run();
            }
            return latestPos;
        }
        return -1;
    }

    public void setStateListener(FXPlatformRunnable stateListener) {
        this.stateListener = stateListener;
    }

    public void clear() {
        this.rememberedChanges.clear();
        this.changeIndex = 0;
        if (this.stateListener != null) {
            this.stateListener.run();
        }
    }

    public void compoundEdit(FXPlatformRunnable editAction) {
        if (this.changeIndex != this.rememberedChanges.size()) {
            this.rememberedChanges.subList(this.changeIndex, this.rememberedChanges.size()).clear();
        }
        this.inCompoundEdit = true;
        ArrayList compoundChanges = new ArrayList();
        this.rememberedChanges.add(compoundChanges);
        ++this.changeIndex;
        editAction.run();
        this.inCompoundEdit = false;
        if (compoundChanges.isEmpty()) {
            this.rememberedChanges.remove(this.rememberedChanges.size() - 1);
            --this.changeIndex;
        } else if (this.stateListener != null) {
            this.stateListener.run();
        }
    }

    private static class Change {
        private final int targetStartIncl;
        private final String replaced;
        private final String replacement;

        public Change(int targetStartIncl, String replaced, String replacement) {
            this.targetStartIncl = targetStartIncl;
            this.replaced = replaced;
            this.replacement = replacement;
        }
    }
}

