/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.fixes;

import bluej.editor.fixes.SuggestionList;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.JavaFXUtil;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import threadchecker.OnThread;
import threadchecker.Tag;

class SuggestionCell
extends ListCell<SuggestionList.SuggestionListItem>
implements ChangeListener<Object> {
    private final Label special = new Label();
    private final Label type = new Label();
    private final Label prefix;
    private final Label matching;
    private final Label next;
    private final Label suffix;
    private final Label fixedPostSuffix;
    private final BorderPane pane;
    private final HBox hbox;

    public SuggestionCell(DoubleExpression typeWidth, FXPlatformConsumer<SuggestionList.SuggestionListItem> clickListener) {
        this.type.minWidthProperty().bind((ObservableValue)typeWidth);
        this.type.maxWidthProperty().bind((ObservableValue)typeWidth);
        this.type.setEllipsisString("\u2026");
        this.prefix = new Label();
        this.matching = new Label();
        this.next = new Label();
        this.suffix = new Label();
        this.fixedPostSuffix = new Label();
        JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"suggestion-cell"});
        JavaFXUtil.addStyleClass((Styleable)this.type, (String[])new String[]{"suggestion-type"});
        JavaFXUtil.addStyleClass((Styleable)this.prefix, (String[])new String[]{"suggestion-prefix"});
        JavaFXUtil.addStyleClass((Styleable)this.matching, (String[])new String[]{"suggestion-matching"});
        JavaFXUtil.addStyleClass((Styleable)this.next, (String[])new String[]{"suggestion-next"});
        JavaFXUtil.addStyleClass((Styleable)this.suffix, (String[])new String[]{"suggestion-suffix"});
        this.prefix.setMinWidth(Double.NEGATIVE_INFINITY);
        this.matching.setMinWidth(Double.NEGATIVE_INFINITY);
        this.next.setMinWidth(Double.NEGATIVE_INFINITY);
        this.suffix.setMinWidth(0.0);
        this.fixedPostSuffix.setMinWidth(0.0);
        this.special.setMaxWidth(9999.0);
        this.special.setText("Related:");
        JavaFXUtil.addStyleClass((Styleable)this.special, (String[])new String[]{"suggestion-similar-heading"});
        this.hbox = new HBox();
        this.hbox.getChildren().addAll((Object[])new Node[]{this.type, this.prefix, this.matching, this.next, this.suffix, this.fixedPostSuffix});
        this.hbox.setSpacing(0.0);
        this.pane = new BorderPane();
        this.pane.setCenter((Node)this.hbox);
        JavaFXUtil.addStyleClass((Styleable)this.pane, (String[])new String[]{"suggestion"});
        this.pane.setOnMouseClicked(e -> clickListener.accept((Object)((SuggestionList.SuggestionListItem)this.itemProperty().get())));
        this.itemProperty().addListener((_obs, oldItem, item) -> {
            if (oldItem != null) {
                oldItem.eligibleAt.removeListener((ChangeListener)this);
                oldItem.eligibleLength.removeListener((ChangeListener)this);
                oldItem.eligibleCanTab.removeListener((ChangeListener)this);
                oldItem.highlighted.removeListener((ChangeListener)this);
            }
            JavaFXUtil.runNowOrLater(() -> this.update((SuggestionList.SuggestionListItem)item));
            if (item != null) {
                item.eligibleAt.addListener((ChangeListener)this);
                item.eligibleLength.addListener((ChangeListener)this);
                item.eligibleCanTab.addListener((ChangeListener)this);
                item.highlighted.addListener((ChangeListener)this);
            }
        });
        this.setGraphic((Node)this.pane);
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    private void update(SuggestionList.SuggestionListItem item) {
        if (item != null && item.index == -1) {
            this.pane.setCenter((Node)this.special);
            this.pane.setRight(null);
        } else {
            this.pane.setCenter((Node)this.hbox);
        }
        if (item != null && item.index != -1) {
            this.update(item.getDetails().choice, item.getDetails().suffix, item.getDetails().type, item.typeMatch, item.direct, item.eligibleAt.get(), item.eligibleLength.get(), item.eligibleCanTab.get(), item.highlighted.get());
        } else {
            this.update("", "", "", false, true, 0, 0, false, false);
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    private void update(String text, String unmatchableSuffix, String type, boolean typeMatch, boolean direct, int at, int len, boolean canTab, boolean highlighted) {
        this.type.setText(type);
        JavaFXUtil.setPseudoclass((String)"bj-match", (boolean)typeMatch, (Node[])new Node[]{this.type});
        if (text.length() >= 1) {
            this.next.setText(text.substring(0, 1));
            this.suffix.setText(text.substring(1));
        } else {
            this.next.setText("");
            this.suffix.setText("");
        }
        this.fixedPostSuffix.setText(unmatchableSuffix);
        JavaFXUtil.setPseudoclass((String)"bj-suggestion-similar", (!direct ? 1 : 0) != 0, (Node[])new Node[]{this.pane});
        JavaFXUtil.setPseudoclass((String)"bj-suggestion-highlight", (boolean)highlighted, (Node[])new Node[]{this.pane});
        this.prefix.setText(text.substring(0, at));
        int end = Math.min(at + len, text.length());
        this.matching.setText(text.substring(at, end));
        String rest = text.substring(end);
        if (rest.length() >= 1) {
            this.next.setText(rest.substring(0, 1));
            this.suffix.setText(rest.substring(1));
        } else {
            this.next.setText("");
            this.suffix.setText("");
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void changed(ObservableValue<?> observable, Object oldValue, Object newValue) {
        this.update((SuggestionList.SuggestionListItem)this.itemProperty().get());
    }
}

