/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javax.net.ssl.HttpsURLConnection;
import org.bluej.extensions.submitter.Stat;
import org.bluej.extensions.submitter.UserPasswordDialog;
import org.bluej.extensions.submitter.transport.SocketSession;
import org.bluej.extensions.submitter.transport.TransportSession;
import threadchecker.OnThread;
import threadchecker.Tag;

public class HttpSession
extends TransportSession {
    private static final String VAR_fileNamePrefix = "file";
    private final String boundaryString;
    private OutputStream out = null;
    private int fileCounter = 0;
    private HttpURLConnection connection;

    public HttpSession(URL url, Properties environment, Stat stat) throws UnsupportedEncodingException {
        super(url, environment, stat);
        Object boundary = "";
        Random random = new Random();
        for (int i = 0; i < 30; ++i) {
            boundary = (String)boundary + (char)SocketSession.encode((byte)random.nextInt(62));
        }
        this.boundaryString = "---------------------------" + (String)boundary;
    }

    @Override
    public void connect() throws IOException {
        this.fileCounter = 0;
        String s = this.url.toString();
        int position = s.indexOf(63);
        if (position > -1) {
            s = s.substring(0, position);
        }
        URL temp = new URL(s);
        this.connection = this.url.getProtocol().equals("https") ? (HttpsURLConnection)temp.openConnection() : (HttpURLConnection)temp.openConnection();
        this.connection.setDoOutput(true);
        this.connection.setAllowUserInteraction(true);
        this.reportEvent("Creating message...");
        this.connection.setRequestProperty("Accept", "text/html");
        this.connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundaryString);
        this.connection.setRequestProperty("Connection", "Close");
        this.out = this.connection.getOutputStream();
        Enumeration<Object> e = this.urlProps.keys();
        while (e.hasMoreElements()) {
            String field = (String)e.nextElement();
            String value = this.urlProps.getProperty(field);
            this.addMimeField(field, value);
        }
        Authenticator.setDefault(new HttpUserAuthenticator());
    }

    @Override
    public void send(InputStream is, String name, boolean binary) throws IOException {
        this.addMimeFile(is, name, binary, ++this.fileCounter);
    }

    @Override
    public void disconnect() throws IOException {
        this.addBoundary(true);
        this.reportEvent("Sending message...");
        this.result = this.send();
    }

    private void addMimeFile(InputStream is, String name, boolean binary, int index) throws IOException {
        this.addBoundary(false);
        this.addMessage("Content-Disposition: form-data; name=\"file" + index + "\"; filename=\"" + name + "\"");
        if (binary) {
            this.addMessage("Content-Type: application/octet-stream");
            this.reportLog("Adding binary file " + name);
        } else {
            this.addMessage("Content-Type: text/plain");
            this.reportLog("Adding text file " + name);
        }
        this.addMessage(null);
        this.addStream(is);
        this.addMessage(null);
    }

    private void addMimeField(String field, String value) throws IOException {
        this.addBoundary(false);
        this.addMessage("Content-Disposition: form-data; name=\"" + field + "\"");
        this.addMessage(null);
        this.addMessage(value);
    }

    private String send() throws IOException {
        int b;
        this.reportEvent("Waiting for response...");
        this.out.close();
        this.connection.connect();
        StringWriter sr = new StringWriter();
        InputStream is = this.connection.getInputStream();
        while ((b = is.read()) != -1) {
            sr.write(b);
        }
        is.close();
        String response = sr.toString();
        this.reportEvent("Sent OK");
        return response;
    }

    private void addBoundary(boolean end) throws IOException {
        this.addMessage("--" + this.boundaryString + (end ? "--" : ""));
    }

    private String formatMessage(String message) {
        int l;
        Object end;
        if (message == null) {
            message = "";
        }
        if (((String)(end = (l = ((String)message).length()) == 0 ? "" : (l == 1 ? message : ((String)message).substring(l - 2, l)))).indexOf(13) == -1) {
            message = (String)message + "\r";
        }
        if (((String)end).indexOf(10) == -1) {
            message = (String)message + "\n";
        }
        return message;
    }

    private void sendMessage(String message) throws IOException {
        this.out.write(this.formatMessage(message).getBytes());
    }

    private void addMessage(String message) throws IOException {
        String toSend = this.formatMessage(message);
        this.out.write(toSend.getBytes(), 0, toSend.length());
    }

    private void addStream(InputStream is) throws IOException {
        int read;
        byte[] input = new byte[1024];
        while ((read = is.read(input)) > 0) {
            this.out.write(input, 0, read);
        }
    }

    private class HttpUserAuthenticator
    extends Authenticator {
        @Override
        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        protected @OnThread(value=Tag.FXPlatform, ignoreParent=true) PasswordAuthentication getPasswordAuthentication() {
            String title = HttpSession.this.stat.bluej.getLabel("authentication.dialog.title") + " ";
            String mainPrompt = HttpSession.this.stat.bluej.getLabel("authentication.dialog.label");
            String usernamePrompt = HttpSession.this.stat.bluej.getLabel("authentication.dialog.label.username");
            String passwordPrompt = HttpSession.this.stat.bluej.getLabel("authentication.dialog.label.password");
            VBox box = new VBox();
            String s = HttpSession.this.stat.bluej.getExtensionPropertyString("username", System.getProperty("user.name", ""));
            TextField username = new TextField(s);
            username.setPrefColumnCount(20);
            PasswordField password = new PasswordField();
            password.setPrefColumnCount(20);
            box.getChildren().add((Object)new Label(mainPrompt + "  \"" + this.getRequestingPrompt() + "\""));
            box.getChildren().add((Object)new Label(usernamePrompt));
            box.getChildren().add((Object)username);
            box.getChildren().add((Object)new Label(passwordPrompt));
            box.getChildren().add((Object)password);
            String dialogTitle = title + this.getRequestingProtocol() + "://" + this.getRequestingHost();
            CompletableFuture pwdAuthFuture = new CompletableFuture();
            UserPasswordDialog dlg = new UserPasswordDialog(HttpSession.this.stat, dialogTitle, (Node)box);
            Optional result = dlg.showAndWait();
            if (((ButtonType)result.get()).getButtonData() == ButtonBar.ButtonData.OK_DONE) {
                return new PasswordAuthentication(username.getText(), password.getText().toCharArray());
            }
            return null;
        }
    }
}

