/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter;

import bluej.extensions2.BlueJ;
import bluej.extensions2.Extension;
import bluej.extensions2.MenuGenerator;
import bluej.extensions2.PreferenceGenerator;
import bluej.extensions2.event.ApplicationEvent;
import bluej.extensions2.event.ApplicationListener;
import java.net.URL;
import javafx.stage.Window;
import org.bluej.extensions.submitter.GlobalProp;
import org.bluej.extensions.submitter.MenuBuilder;
import org.bluej.extensions.submitter.PrefPanel;
import org.bluej.extensions.submitter.Stat;
import org.bluej.extensions.submitter.SubmitDialog;
import org.bluej.extensions.submitter.properties.SchemeData;
import org.bluej.utility.Flexdbg;
import org.bluej.utility.Utility;

public class Submitter
extends Extension
implements ApplicationListener {
    private Stat stat;
    private static String cssStyleFile;

    public void startup(BlueJ i_bluej) {
        i_bluej.addApplicationListener((ApplicationListener)this);
        this.stat = new Stat();
        this.stat.bluej = i_bluej;
        this.stat.aDbg = new Flexdbg();
        int debugLevel = Utility.convStringToInt(this.stat.bluej.getExtensionPropertyString("debug.level", ""), 3);
        this.stat.aDbg.setDebugLevel(debugLevel);
        this.stat.aDbg.setServiceMask(-1);
        this.stat.aDbg.trace(1, "Submitter.startup: CALLED");
        this.stat.globalProp = new GlobalProp();
        this.stat.schemeData = new SchemeData(this.stat);
        this.stat.bluej.setMenuGenerator((MenuGenerator)new MenuBuilder(this.stat));
    }

    public boolean isCompatible() {
        return Extension.getExtensionsAPIVersionMajor() >= 2;
    }

    public String getVersion() {
        return "2.0.0";
    }

    public String getName() {
        if (this.stat != null && this.stat.bluej != null) {
            return this.stat.bluej.getLabel("Submitter");
        }
        return "Submitter";
    }

    public String getDescription() {
        if (this.stat != null && this.stat.bluej != null) {
            return this.stat.bluej.getLabel("description");
        }
        return "Submit a BlueJ project to a remote location";
    }

    public URL getURL() {
        try {
            return new URL("http://www.bluej.org/extensions/submitter/submitter.html");
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static String getCSSStyleFilePath() {
        return cssStyleFile;
    }

    public void blueJReady(ApplicationEvent event) {
        cssStyleFile = ((Object)((Object)this)).getClass().getResource("/lib/style.css").toExternalForm();
        this.stat.bluej.setPreferenceGenerator((PreferenceGenerator)new PrefPanel(this.stat));
        this.stat.submitDialog = new SubmitDialog(this.stat, (Window)this.stat.bluej.getCurrentWindow());
    }
}

