/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter;

import bluej.extensions2.PreferenceGenerator;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.bluej.extensions.submitter.Stat;
import org.bluej.extensions.submitter.Submitter;
import org.bluej.utility.Utility;

public class PrefPanel
implements PreferenceGenerator {
    private Stat stat;
    private Pane thePanel;
    private TextField host;
    private TextField sender;
    private TextField user;
    private TextField port;
    private TextField authUser;
    private RadioButton sslConnection;
    private RadioButton tlsConnection;
    private RadioButton insecureConnection;
    private CheckBox auth;
    private String authString;
    private String sslString;
    private String tlsString;
    private String noSecString;
    private String smtpDetailsString;
    private Label hostLabel;
    private Label senderLabel;
    private Label userLabel;
    private Label portLabel;
    private Label secConnLabel;
    private Label defaultPortLabel;
    private Label authUserLabel;
    private static final String DEFAULT_PORT = "25";

    public PrefPanel(Stat i_stat) {
        this.stat = i_stat;
        this.setLanguageDependentLabels();
        this.thePanel = new Pane();
        this.thePanel.getStylesheets().add((Object)Submitter.getCSSStyleFilePath());
        VBox containerBox = new VBox();
        Utility.applyStyle((Node)containerBox, "pref-content");
        GridPane topGrid = new GridPane();
        Utility.applyStyle((Node)topGrid, "pref-credentials-grid");
        ColumnConstraints leftCol = new ColumnConstraints();
        leftCol.setHalignment(HPos.RIGHT);
        ColumnConstraints rightCol = new ColumnConstraints();
        rightCol.setFillWidth(true);
        rightCol.setHgrow(Priority.ALWAYS);
        topGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{leftCol, rightCol});
        topGrid.add((Node)this.userLabel, 0, 0);
        topGrid.add((Node)this.senderLabel, 0, 1);
        this.user = new TextField();
        topGrid.add((Node)this.user, 1, 0);
        this.sender = new TextField();
        topGrid.add((Node)this.sender, 1, 1);
        VBox smtpDetails = new VBox();
        HBox rowOne = new HBox();
        rowOne.getChildren().add((Object)this.hostLabel);
        this.host = new TextField();
        rowOne.getChildren().add((Object)this.host);
        rowOne.getChildren().add((Object)this.portLabel);
        this.port = new TextField();
        rowOne.getChildren().add((Object)this.port);
        this.port.setOnKeyTyped(event -> this.textfieldValueChanged());
        rowOne.getChildren().add((Object)this.defaultPortLabel);
        HBox rowTwo = new HBox();
        this.auth = new CheckBox(this.authString);
        rowTwo.getChildren().add((Object)this.auth);
        rowTwo.getChildren().add((Object)this.authUserLabel);
        this.authUser = new TextField();
        rowTwo.getChildren().add((Object)this.authUser);
        this.auth.setOnAction(event -> {
            this.authUser.setDisable(!this.auth.isSelected());
            this.authUserLabel.setDisable(!this.auth.isSelected());
        });
        HBox rowThree = new HBox();
        rowThree.getChildren().add((Object)this.secConnLabel);
        this.insecureConnection = new RadioButton(this.noSecString);
        rowThree.getChildren().add((Object)this.insecureConnection);
        this.sslConnection = new RadioButton(this.sslString);
        rowThree.getChildren().add((Object)this.sslConnection);
        this.tlsConnection = new RadioButton(this.tlsString);
        rowThree.getChildren().add((Object)this.tlsConnection);
        Utility.applyStyle((Node)smtpDetails, "smtp-details-vbox");
        Utility.applyStyle((Node)rowOne, "submitter-hbox");
        Utility.applyStyle((Node)rowTwo, "submitter-hbox");
        Utility.applyStyle((Node)rowThree, "submitter-hbox");
        boolean b = !this.sslConnection.isSelected() && !this.tlsConnection.isSelected();
        this.insecureConnection.setSelected(b);
        ToggleGroup btg = new ToggleGroup();
        this.sslConnection.setToggleGroup(btg);
        this.tlsConnection.setToggleGroup(btg);
        this.insecureConnection.setToggleGroup(btg);
        smtpDetails.getChildren().add((Object)rowOne);
        smtpDetails.getChildren().add((Object)rowTwo);
        smtpDetails.getChildren().add((Object)rowThree);
        TitledPane smtpDetailsContainer = new TitledPane(this.smtpDetailsString, (Node)smtpDetails);
        rowOne.setAlignment(Pos.BASELINE_LEFT);
        rowTwo.setAlignment(Pos.BASELINE_LEFT);
        rowThree.setAlignment(Pos.BASELINE_LEFT);
        smtpDetails.setAlignment(Pos.BASELINE_LEFT);
        containerBox.getChildren().add((Object)topGrid);
        containerBox.getChildren().add((Object)smtpDetailsContainer);
        this.thePanel.getChildren().add((Object)containerBox);
        this.loadValues();
    }

    private void textfieldValueChanged() {
        if (this.port.getText().trim().equals("")) {
            this.port.setText(DEFAULT_PORT);
        }
    }

    public Pane getWindow() {
        return this.thePanel;
    }

    public void saveValues() {
        if (this.port.getText().trim().equals("")) {
            this.port.setText(DEFAULT_PORT);
        }
        this.saveOneValue("smtphost", this.host.getText());
        this.saveOneValue("useraddr", this.sender.getText());
        this.saveOneValue("username", this.user.getText());
        this.saveOneValue("port", this.port.getText());
        this.saveOneValue("authenticate", Boolean.toString(this.auth.isSelected()));
        this.saveOneValue("smtpauthuser", this.authUser.getText());
        this.saveOneValue("ssl", Boolean.toString(this.sslConnection.isSelected()));
        this.saveOneValue("tls", Boolean.toString(this.tlsConnection.isSelected()));
    }

    private void saveOneValue(String propKey, String propVal) {
        this.stat.bluej.setExtensionPropertyString(propKey, propVal);
        this.stat.globalProp.setProperty(propKey, propVal);
    }

    public void loadValues() {
        String saslRealm;
        String propVal = this.stat.bluej.getExtensionPropertyString("smtphost", "");
        this.host.setText(propVal);
        this.stat.globalProp.setProperty("smtphost", propVal);
        propVal = this.stat.bluej.getExtensionPropertyString("useraddr", System.getProperty("user.name", "") + "@");
        this.sender.setText(propVal);
        this.stat.globalProp.setProperty("useraddr", propVal);
        propVal = this.stat.bluej.getExtensionPropertyString("username", System.getProperty("user.name", ""));
        this.user.setText(propVal);
        this.stat.globalProp.setProperty("username", propVal);
        propVal = this.stat.bluej.getExtensionPropertyString("port", DEFAULT_PORT);
        this.port.setText(propVal.trim());
        this.stat.globalProp.setProperty("port", propVal);
        propVal = this.stat.bluej.getExtensionPropertyString("authenticate", "false");
        this.auth.setSelected(Boolean.parseBoolean(propVal));
        this.stat.globalProp.setProperty("authenticate", propVal);
        this.auth.fireEvent((Event)new ActionEvent());
        propVal = this.stat.bluej.getExtensionPropertyString("smtpauthuser", System.getProperty("user.name", ""));
        this.authUser.setText(propVal);
        this.stat.globalProp.setProperty("smtpauthuser", propVal);
        propVal = this.stat.bluej.getExtensionPropertyString("ssl", "false");
        this.sslConnection.setSelected(Boolean.parseBoolean(propVal));
        this.stat.globalProp.setProperty("ssl", propVal);
        propVal = this.stat.bluej.getExtensionPropertyString("tls", "false");
        this.tlsConnection.setSelected(Boolean.parseBoolean(propVal));
        this.stat.globalProp.setProperty("tls", propVal);
        if (this.port.getText().equals("")) {
            this.port.setText(DEFAULT_PORT);
        }
        if ((saslRealm = this.stat.bluej.getExtensionPropertyString("saslrealm", "invalid.bluej.org")).equals("invalid.bluej.org")) {
            this.stat.bluej.setExtensionPropertyString("saslrealm", "");
        }
    }

    private void setLanguageDependentLabels() {
        String s = "preferences.label.";
        this.hostLabel = new Label(this.stat.bluej.getLabel(s + "smtphost"));
        this.senderLabel = new Label(this.stat.bluej.getLabel(s + "useraddr"));
        this.userLabel = new Label(this.stat.bluej.getLabel(s + "username"));
        this.portLabel = new Label(this.stat.bluej.getLabel(s + "port"));
        this.authUserLabel = new Label(this.stat.bluej.getLabel(s + "smtpauthuser"));
        this.secConnLabel = new Label(this.stat.bluej.getLabel("preferences.label.connection"));
        this.defaultPortLabel = new Label(this.stat.bluej.getLabel(s + "default") + ": 25");
        this.authString = this.stat.bluej.getLabel(s + "authenticate");
        this.sslString = this.stat.bluej.getLabel(s + "ssl");
        this.tlsString = this.stat.bluej.getLabel(s + "tls");
        this.noSecString = this.stat.bluej.getLabel("preferences.label.insecureconnection");
        this.smtpDetailsString = this.stat.bluej.getLabel("preferences.label.smtpdetailstitle");
    }
}

