/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.text.BreakIterator;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.Caret;
import org.fxmisc.richtext.CaretNode;
import org.fxmisc.richtext.NavigationActions;
import org.fxmisc.richtext.Selection;

public interface CaretSelectionBind<PS, SEG, S>
extends Selection<PS, SEG, S>,
Caret {
    public CaretNode getUnderlyingCaret();

    public Selection<PS, SEG, S> getUnderlyingSelection();

    public int getAnchorPosition();

    public ObservableValue<Integer> anchorPositionProperty();

    public int getAnchorParIndex();

    public ObservableValue<Integer> anchorParIndexProperty();

    public int getAnchorColPosition();

    public ObservableValue<Integer> anchorColPositionProperty();

    @Override
    default public void moveTo(int position) {
        this.moveTo(position, NavigationActions.SelectionPolicy.CLEAR);
    }

    @Override
    default public void moveTo(int paragraphIndex, int columnPosition) {
        this.moveTo(paragraphIndex, columnPosition, NavigationActions.SelectionPolicy.CLEAR);
    }

    @Override
    default public void moveToParStart() {
        this.moveToParStart(NavigationActions.SelectionPolicy.CLEAR);
    }

    @Override
    default public void moveToParEnd() {
        this.moveToParEnd(NavigationActions.SelectionPolicy.CLEAR);
    }

    @Override
    default public void moveToAreaStart() {
        this.moveToAreaStart(NavigationActions.SelectionPolicy.CLEAR);
    }

    @Override
    default public void moveToAreaEnd() {
        this.moveToAreaEnd(NavigationActions.SelectionPolicy.CLEAR);
    }

    @Override
    default public void moveToPrevChar() {
        this.moveToPrevChar(NavigationActions.SelectionPolicy.CLEAR);
    }

    @Override
    default public void moveToNextChar() {
        this.moveToNextChar(NavigationActions.SelectionPolicy.CLEAR);
    }

    @Override
    public void moveBreaksForwards(int var1, BreakIterator var2);

    @Override
    public void moveBreaksBackwards(int var1, BreakIterator var2);

    @Override
    public void selectRange(int var1, int var2, int var3, int var4);

    @Override
    public void selectRange(int var1, int var2);

    @Override
    public void updateStartBy(int var1, Selection.Direction var2);

    @Override
    public void updateEndBy(int var1, Selection.Direction var2);

    @Override
    public void updateStartTo(int var1);

    @Override
    public void updateStartTo(int var1, int var2);

    @Override
    public void updateStartByBreaksForward(int var1, BreakIterator var2);

    @Override
    public void updateStartByBreaksBackward(int var1, BreakIterator var2);

    @Override
    public void updateEndTo(int var1);

    @Override
    public void updateEndTo(int var1, int var2);

    @Override
    public void updateEndByBreaksForward(int var1, BreakIterator var2);

    @Override
    public void updateEndByBreaksBackward(int var1, BreakIterator var2);

    @Override
    public void selectAll();

    @Override
    public void selectParagraph(int var1);

    @Override
    public void selectWord(int var1);

    @Override
    public void deselect();

    public void selectRangeExpl(int var1, int var2, int var3, int var4);

    public void selectRangeExpl(int var1, int var2);

    default public void moveTo(int pos, NavigationActions.SelectionPolicy selectionPolicy) {
        switch (selectionPolicy) {
            case CLEAR: {
                this.selectRange(pos, pos);
                break;
            }
            case ADJUST: {
                this.selectRange(this.getAnchorPosition(), pos);
                break;
            }
            case EXTEND: {
                IndexRange sel = this.getRange();
                int anchor = pos <= sel.getStart() ? sel.getEnd() : (pos >= sel.getEnd() ? sel.getStart() : this.getAnchorPosition());
                this.selectRangeExpl(anchor, pos);
            }
        }
    }

    public void moveTo(int var1, int var2, NavigationActions.SelectionPolicy var3);

    public void moveToPrevChar(NavigationActions.SelectionPolicy var1);

    public void moveToNextChar(NavigationActions.SelectionPolicy var1);

    public void moveToParStart(NavigationActions.SelectionPolicy var1);

    public void moveToParEnd(NavigationActions.SelectionPolicy var1);

    public void moveToAreaStart(NavigationActions.SelectionPolicy var1);

    public void moveToAreaEnd(NavigationActions.SelectionPolicy var1);

    default public void selectParagraph() {
        this.moveToParStart(NavigationActions.SelectionPolicy.CLEAR);
        this.moveToParEnd(NavigationActions.SelectionPolicy.ADJUST);
    }

    default public void selectWord() {
        this.selectWord(this.getPosition());
    }

    public void displaceCaret(int var1);

    public void displaceSelection(int var1, int var2);
}

