/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.wellbehaved.event.template;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.Node;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputHandler;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import org.fxmisc.wellbehaved.event.template.InputHandlerTemplate;
import org.fxmisc.wellbehaved.event.template.InputHandlerTemplateMap;
import org.fxmisc.wellbehaved.event.template.InputMapTemplateInstance;
import org.fxmisc.wellbehaved.event.template.PatternActionTemplate;
import org.fxmisc.wellbehaved.event.template.TemplateChain;

public abstract class InputMapTemplate<S, E extends Event> {
    private InputHandlerTemplateMap<S, E> inputHandlerTemplates = null;

    public final void forEachEventType(HandlerTemplateConsumer<S, ? super E> f) {
        if (this.inputHandlerTemplates == null) {
            this.inputHandlerTemplates = this.getInputHandlerTemplateMap();
        }
        this.inputHandlerTemplates.forEach(f);
    }

    public final InputMapTemplate<S, E> orElse(InputMapTemplate<S, ? extends E> that) {
        return InputMapTemplate.sequence(this, that);
    }

    public final InputMap<E> instantiate(S target) {
        return new InputMapTemplateInstance(this, target);
    }

    protected abstract InputHandlerTemplateMap<S, E> getInputHandlerTemplateMap();

    static <S, E extends Event> InputMapTemplate<S, E> upCast(InputMapTemplate<S, ? extends E> imt) {
        InputMapTemplate<S, ? extends E> res = imt;
        return res;
    }

    @SafeVarargs
    public static <S, E extends Event> InputMapTemplate<S, E> sequence(InputMapTemplate<S, ? extends E> ... templates) {
        return new TemplateChain<S, E>(templates);
    }

    public static <S, T extends Event, U extends T> InputMapTemplate<S, U> process(EventPattern<? super T, ? extends U> eventPattern, BiFunction<? super S, ? super U, InputHandler.Result> action) {
        return new PatternActionTemplate<S, T, U>(eventPattern, action);
    }

    public static <S, T extends Event> InputMapTemplate<S, T> process(EventType<? extends T> eventType, BiFunction<? super S, ? super T, InputHandler.Result> action) {
        return InputMapTemplate.process(EventPattern.eventType(eventType), action);
    }

    public InputMapTemplate<S, E> ifConsumed(final BiConsumer<? super S, ? super E> postConsumption) {
        return new InputMapTemplate<S, E>(){

            @Override
            protected InputHandlerTemplateMap<S, E> getInputHandlerTemplateMap() {
                return InputMapTemplate.this.getInputHandlerTemplateMap().map(iht -> (s, evt) -> {
                    InputHandler.Result res = iht.process(s, evt);
                    if (res == InputHandler.Result.CONSUME) {
                        postConsumption.accept(s, evt);
                    }
                    return res;
                });
            }
        };
    }

    public static <S, T extends Event, U extends T> InputMapTemplate<S, U> consume(EventPattern<? super T, ? extends U> eventPattern, BiConsumer<? super S, ? super U> action) {
        return InputMapTemplate.process(eventPattern, (? super S s, ? super U u) -> {
            action.accept((Object)s, (Object)u);
            return InputHandler.Result.CONSUME;
        });
    }

    public static <S, T extends Event> InputMapTemplate<S, T> consume(EventType<? extends T> eventType, BiConsumer<? super S, ? super T> action) {
        return InputMapTemplate.consume(EventPattern.eventType(eventType), action);
    }

    public static <S, T extends Event, U extends T> InputMapTemplate<S, U> consume(EventPattern<? super T, ? extends U> eventPattern) {
        return InputMapTemplate.process(eventPattern, (? super S s, ? super U u) -> InputHandler.Result.CONSUME);
    }

    public static <S, T extends Event> InputMapTemplate<S, T> consume(EventType<? extends T> eventType) {
        return InputMapTemplate.consume(EventPattern.eventType(eventType));
    }

    public static <S, T extends Event, U extends T> InputMapTemplate<S, U> consumeWhen(EventPattern<? super T, ? extends U> eventPattern, Predicate<? super S> condition, BiConsumer<? super S, ? super U> action) {
        return InputMapTemplate.process(eventPattern, (? super S s, ? super U u) -> {
            if (condition.test((Object)s)) {
                action.accept((Object)s, (Object)u);
                return InputHandler.Result.CONSUME;
            }
            return InputHandler.Result.PROCEED;
        });
    }

    public static <S, T extends Event> InputMapTemplate<S, T> consumeWhen(EventType<? extends T> eventType, Predicate<? super S> condition, BiConsumer<? super S, ? super T> action) {
        return InputMapTemplate.consumeWhen(EventPattern.eventType(eventType), condition, action);
    }

    public static <S, T extends Event, U extends T> InputMapTemplate<S, U> consumeUnless(EventPattern<? super T, ? extends U> eventPattern, Predicate<? super S> condition, BiConsumer<? super S, ? super U> action) {
        return InputMapTemplate.consumeWhen(eventPattern, condition.negate(), action);
    }

    public static <S, T extends Event> InputMapTemplate<S, T> consumeUnless(EventType<? extends T> eventType, Predicate<? super S> condition, BiConsumer<? super S, ? super T> action) {
        return InputMapTemplate.consumeUnless(EventPattern.eventType(eventType), condition, action);
    }

    public static <S, T extends Event, U extends T> InputMapTemplate<S, U> ignore(EventPattern<? super T, ? extends U> eventPattern) {
        return new PatternActionTemplate<Object, T, Object>(eventPattern, PatternActionTemplate.CONST_IGNORE);
    }

    public static <S, T extends Event> InputMapTemplate<S, T> ignore(EventType<? extends T> eventType) {
        return InputMapTemplate.ignore(EventPattern.eventType(eventType));
    }

    public static <S, T extends Event> InputMapTemplate<S, T> when(final Predicate<? super S> condition, final InputMapTemplate<S, T> imt) {
        return new InputMapTemplate<S, T>(){

            @Override
            protected InputHandlerTemplateMap<S, T> getInputHandlerTemplateMap() {
                return imt.getInputHandlerTemplateMap().map(h -> (s, evt) -> condition.test(s) ? h.process(s, evt) : InputHandler.Result.PROCEED);
            }
        };
    }

    public static <S, T extends Event> InputMapTemplate<S, T> unless(Predicate<? super S> condition, InputMapTemplate<S, T> imt) {
        return InputMapTemplate.when(condition.negate(), imt);
    }

    public static <S, T, E extends Event> InputMapTemplate<S, E> lift(final InputMapTemplate<T, E> imt, final Function<? super S, ? extends T> f) {
        return new InputMapTemplate<S, E>(){

            @Override
            protected InputHandlerTemplateMap<S, E> getInputHandlerTemplateMap() {
                return imt.getInputHandlerTemplateMap().map(h -> (s, evt) -> h.process(f.apply(s), evt));
            }
        };
    }

    public static <S extends Node, E extends Event> void installOverride(InputMapTemplate<S, E> imt, S node) {
        Nodes.addInputMap(node, imt.instantiate(node));
    }

    public static <S, N extends Node, E extends Event> void installOverride(InputMapTemplate<S, E> imt, S target, Function<? super S, ? extends N> getNode) {
        Nodes.addInputMap((Node)getNode.apply(target), imt.instantiate(target));
    }

    public static <S extends Node, E extends Event> void installFallback(InputMapTemplate<S, E> imt, S node) {
        Nodes.addFallbackInputMap(node, imt.instantiate(node));
    }

    public static <S, N extends Node, E extends Event> void installFallback(InputMapTemplate<S, E> imt, S target, Function<? super S, ? extends N> getNode) {
        Nodes.addFallbackInputMap((Node)getNode.apply(target), imt.instantiate(target));
    }

    public static <S extends Node, E extends Event> void uninstall(InputMapTemplate<S, E> imt, S node) {
        Nodes.removeInputMap(node, imt.instantiate(node));
    }

    public static <S, N extends Node, E extends Event> void uninstall(InputMapTemplate<S, E> imt, S target, Function<? super S, ? extends N> getNode) {
        Nodes.removeInputMap((Node)getNode.apply(target), imt.instantiate(target));
    }

    @FunctionalInterface
    public static interface HandlerTemplateConsumer<S, E extends Event> {
        public <F extends E> void accept(EventType<? extends F> var1, InputHandlerTemplate<S, ? super F> var2);

        public static <S, E extends Event> HandlerTemplateConsumer<S, E> from(final InputMap.HandlerConsumer<E> hc, final S target) {
            return new HandlerTemplateConsumer<S, E>(){

                @Override
                public <F extends E> void accept(EventType<? extends F> t, InputHandlerTemplate<S, ? super F> h) {
                    hc.accept(t, (? super F evt) -> h.process((Object)target, (Object)evt));
                }
            };
        }
    }
}

