/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.undo;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.fxmisc.undo.UndoManager;
import org.fxmisc.undo.impl.FixedSizeChangeQueue;
import org.fxmisc.undo.impl.UndoManagerImpl;
import org.fxmisc.undo.impl.UnlimitedChangeQueue;
import org.fxmisc.undo.impl.ZeroSizeChangeQueue;
import org.reactfx.EventStream;

public interface UndoManagerFactory {
    public <C> UndoManager create(EventStream<C> var1, Function<? super C, ? extends C> var2, Consumer<C> var3);

    public <C> UndoManager create(EventStream<C> var1, Function<? super C, ? extends C> var2, Consumer<C> var3, BiFunction<C, C, Optional<C>> var4);

    public static <C> UndoManager unlimitedHistoryUndoManager(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply) {
        UnlimitedChangeQueue queue = new UnlimitedChangeQueue();
        BiFunction<Object, Object, Optional> merge = (c1, c2) -> Optional.empty();
        return new UndoManagerImpl<Object>(queue, invert, apply, merge, changeStream);
    }

    public static <C> UndoManager unlimitedHistoryUndoManager(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge) {
        UnlimitedChangeQueue queue = new UnlimitedChangeQueue();
        return new UndoManagerImpl<C>(queue, invert, apply, merge, changeStream);
    }

    public static UndoManagerFactory unlimitedHistoryFactory() {
        return new UndoManagerFactory(){

            @Override
            public <C> UndoManager create(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply) {
                return UndoManagerFactory.unlimitedHistoryUndoManager(changeStream, invert, apply);
            }

            @Override
            public <C> UndoManager create(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge) {
                return UndoManagerFactory.unlimitedHistoryUndoManager(changeStream, invert, apply, merge);
            }
        };
    }

    public static <C> UndoManager fixedSizeHistoryUndoManager(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, int capacity) {
        FixedSizeChangeQueue queue = new FixedSizeChangeQueue(capacity);
        BiFunction<Object, Object, Optional> merge = (c1, c2) -> Optional.empty();
        return new UndoManagerImpl<Object>(queue, invert, apply, merge, changeStream);
    }

    public static <C> UndoManager fixedSizeHistoryUndoManager(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, int capacity) {
        FixedSizeChangeQueue queue = new FixedSizeChangeQueue(capacity);
        return new UndoManagerImpl<C>(queue, invert, apply, merge, changeStream);
    }

    public static UndoManagerFactory fixedSizeHistoryFactory(final int capacity) {
        return new UndoManagerFactory(){

            @Override
            public <C> UndoManager create(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply) {
                return UndoManagerFactory.fixedSizeHistoryUndoManager(changeStream, invert, apply, capacity);
            }

            @Override
            public <C> UndoManager create(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge) {
                return UndoManagerFactory.fixedSizeHistoryUndoManager(changeStream, invert, apply, merge, capacity);
            }
        };
    }

    public static <C> UndoManager zeroHistoryUndoManager(EventStream<C> changeStream) {
        ZeroSizeChangeQueue queue = new ZeroSizeChangeQueue();
        return new UndoManagerImpl<Object>(queue, c -> c, c -> {}, (c1, c2) -> Optional.empty(), changeStream);
    }

    public static UndoManagerFactory zeroHistoryFactory() {
        return new UndoManagerFactory(){

            @Override
            public <C> UndoManager create(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply) {
                return UndoManagerFactory.zeroHistoryUndoManager(changeStream);
            }

            @Override
            public <C> UndoManager create(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge) {
                return UndoManagerFactory.zeroHistoryUndoManager(changeStream);
            }
        };
    }
}

