/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.Objects;
import java.util.Optional;

public abstract class TextChange<S, Self extends TextChange<S, Self>> {
    protected final int position;
    protected final S removed;
    protected final S inserted;
    protected final MergeType mergeType;

    public TextChange(int position, S removed, S inserted) {
        this.position = position;
        this.removed = removed;
        this.inserted = inserted;
        this.mergeType = this.insertedLength() == 0 ? (this.removedLength() != 0 ? MergeType.DELETION : MergeType.NONE) : (this.removedLength() == 0 ? MergeType.INSERTION : MergeType.NONE);
    }

    public int getPosition() {
        return this.position;
    }

    public S getRemoved() {
        return this.removed;
    }

    public S getInserted() {
        return this.inserted;
    }

    public Self invert() {
        return this.create(this.position, this.inserted, this.removed);
    }

    public int getRemovalEnd() {
        return this.position + this.removedLength();
    }

    public int getInsertionEnd() {
        return this.position + this.insertedLength();
    }

    public final MergeType getMergeType() {
        return this.mergeType;
    }

    protected abstract int removedLength();

    protected abstract int insertedLength();

    protected abstract S concat(S var1, S var2);

    protected abstract S sub(S var1, int var2, int var3);

    protected abstract Self create(int var1, S var2, S var3);

    public Optional<Self> mergeWith(Self latter) {
        if ((this.mergeType == MergeType.INSERTION || this.mergeType == MergeType.DELETION) && this.mergeType == ((TextChange)latter).mergeType && this.getInsertionEnd() == ((TextChange)latter).position) {
            S removedText = this.concat(this.removed, ((TextChange)latter).removed);
            S addedText = this.concat(this.inserted, ((TextChange)latter).inserted);
            return Optional.of(this.create(this.position, removedText, addedText));
        }
        return Optional.empty();
    }

    public boolean equals(Object other) {
        if (other instanceof TextChange) {
            TextChange that = (TextChange)other;
            return Objects.equals(this.position, that.position) && Objects.equals(this.removed, that.removed) && Objects.equals(this.inserted, that.inserted);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.position, this.removed, this.inserted);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "{\n\tposition: " + this.position + "\n\tmergeType: " + (Object)((Object)this.mergeType) + "\n\tremoved: " + this.removed + "\n\tinserted: " + this.inserted + "\n}";
    }

    public static enum MergeType {
        INSERTION,
        DELETION,
        NONE;

    }
}

