/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import org.fxmisc.richtext.model.StyleSpan;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBase;
import org.fxmisc.richtext.model.TwoDimensional;

class SubSpans<S>
extends StyleSpansBase<S> {
    private final StyleSpans<S> original;
    private final int firstIdxInOrig;
    private final int spanCount;
    private final StyleSpan<S> firstSpan;
    private final StyleSpan<S> lastSpan;
    int length = -1;

    public SubSpans(StyleSpans<S> original, TwoDimensional.Position from, TwoDimensional.Position to) {
        this.original = original;
        this.firstIdxInOrig = from.getMajor();
        this.spanCount = to.getMajor() - from.getMajor() + 1;
        if (this.spanCount == 1) {
            StyleSpan<S> span = original.getStyleSpan(this.firstIdxInOrig);
            int len = to.getMinor() - from.getMinor();
            this.lastSpan = new StyleSpan<S>(span.getStyle(), len);
            this.firstSpan = this.lastSpan;
        } else {
            StyleSpan<S> startSpan = original.getStyleSpan(this.firstIdxInOrig);
            int len = startSpan.getLength() - from.getMinor();
            this.firstSpan = new StyleSpan<S>(startSpan.getStyle(), len);
            StyleSpan<S> endSpan = original.getStyleSpan(to.getMajor());
            this.lastSpan = new StyleSpan<S>(endSpan.getStyle(), to.getMinor());
        }
    }

    @Override
    public int length() {
        if (this.length == -1) {
            this.length = 0;
            for (StyleSpan span : this) {
                this.length += span.getLength();
            }
        }
        return this.length;
    }

    @Override
    public int getSpanCount() {
        return this.spanCount;
    }

    @Override
    public StyleSpan<S> getStyleSpan(int index) {
        if (index == 0) {
            return this.firstSpan;
        }
        if (index == this.spanCount - 1) {
            return this.lastSpan;
        }
        if (index < 0 || index >= this.spanCount) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.original.getStyleSpan(this.firstIdxInOrig + index);
    }
}

