/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.fxmisc.richtext.model.Codec;
import org.fxmisc.richtext.model.TextOps;

public class StyledText<S> {
    private final String text;
    private final S style;

    public static <S> TextOps<StyledText<S>, S> textOps() {
        return new TextOps<StyledText<S>, S>(){
            private final StyledText<S> emptySeg = new StyledText<Object>("", null);

            @Override
            public int length(StyledText<S> styledText) {
                return styledText.getText().length();
            }

            @Override
            public char charAt(StyledText<S> styledText, int index) {
                return styledText == this.emptySeg ? (char)'\u0000' : styledText.getText().charAt(index);
            }

            @Override
            public String getText(StyledText<S> styledText) {
                return styledText.getText();
            }

            @Override
            public StyledText<S> subSequence(StyledText<S> styledText, int start, int end) {
                return styledText == this.emptySeg ? this.emptySeg : new StyledText(styledText.getText().substring(start, end), styledText.getStyle());
            }

            @Override
            public StyledText<S> subSequence(StyledText<S> styledText, int start) {
                return styledText == this.emptySeg ? this.emptySeg : new StyledText(styledText.getText().substring(start), styledText.getStyle());
            }

            @Override
            public S getStyle(StyledText<S> styledText) {
                return styledText.getStyle();
            }

            @Override
            public StyledText<S> setStyle(StyledText<S> seg, S style) {
                return seg == this.emptySeg ? this.emptySeg : seg.setStyle(style);
            }

            @Override
            public Optional<StyledText<S>> join(StyledText<S> left, StyledText<S> right) {
                return Objects.equals(left.getStyle(), right.getStyle()) ? Optional.of(new StyledText(left.getText() + right.getText(), left.getStyle())) : Optional.empty();
            }

            @Override
            public StyledText<S> createEmpty() {
                return this.emptySeg;
            }

            @Override
            public StyledText<S> create(String text, S style) {
                return new StyledText(text, style);
            }
        };
    }

    public static <S> Codec<StyledText<S>> codec(final Codec<S> styleCodec) {
        return new Codec<StyledText<S>>(){

            @Override
            public String getName() {
                return "styled-text";
            }

            @Override
            public void encode(DataOutputStream os, StyledText<S> t) throws IOException {
                Codec.STRING_CODEC.encode(os, t.text);
                styleCodec.encode(os, t.style);
            }

            @Override
            public StyledText<S> decode(DataInputStream is) throws IOException {
                String text = Codec.STRING_CODEC.decode(is);
                Object style = styleCodec.decode(is);
                return new StyledText(text, style);
            }
        };
    }

    public String getText() {
        return this.text;
    }

    public S getStyle() {
        return this.style;
    }

    public StyledText<S> setStyle(S style) {
        return new StyledText<S>(this.text, style);
    }

    public StyledText(String text, S style) {
        this.text = text;
        this.style = style;
    }

    public String toString() {
        return String.format("StyledText[text=\"%s\", style=%s]", this.text, this.style);
    }

    public boolean equals(Object obj) {
        if (obj instanceof StyledText) {
            StyledText that = (StyledText)obj;
            return Objects.equals(this.text, that.text) && Objects.equals(this.style, that.style);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.text, this.style);
    }
}

