/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.TextEditingArea;

public interface EditActions<PS, SEG, S>
extends TextEditingArea<PS, SEG, S> {
    default public void appendText(String text) {
        this.insertText(this.getLength(), text);
    }

    default public void append(StyledDocument<PS, SEG, S> document) {
        this.insert(this.getLength(), document);
    }

    default public void insertText(int index, String text) {
        this.replaceText(index, index, text);
    }

    default public void insertText(int paragraphIndex, int columnIndex, String text) {
        int index = this.getAbsolutePosition(paragraphIndex, columnIndex);
        this.replaceText(index, index, text);
    }

    default public void insert(int index, StyledDocument<PS, SEG, S> document) {
        this.replace(index, index, document);
    }

    default public void insert(int paragraphIndex, int columnIndex, StyledDocument<PS, SEG, S> document) {
        int index = this.getAbsolutePosition(paragraphIndex, columnIndex);
        this.replace(index, index, document);
    }

    default public void deleteText(IndexRange range) {
        this.deleteText(range.getStart(), range.getEnd());
    }

    default public void deleteText(int start, int end) {
        this.replaceText(start, end, "");
    }

    default public void deleteText(int startParagraph, int startColumn, int endParagraph, int endColumn) {
        int start = this.getAbsolutePosition(startParagraph, startColumn);
        int end = this.getAbsolutePosition(endParagraph, endColumn);
        this.replaceText(start, end, "");
    }

    default public void deletePreviousChar() {
        int end = this.getCaretPosition();
        if (end > 0) {
            int start = Character.offsetByCodePoints(this.getText(), end, -1);
            this.deleteText(start, end);
        }
    }

    default public void deleteNextChar() {
        int start = this.getCaretPosition();
        if (start < this.getLength()) {
            int end = Character.offsetByCodePoints(this.getText(), start, 1);
            this.deleteText(start, end);
        }
    }

    default public void clear() {
        this.replaceText(0, this.getLength(), "");
    }

    default public void replaceText(String replacement) {
        this.replaceText(0, this.getLength(), replacement);
    }

    default public void replace(StyledDocument<PS, SEG, S> replacement) {
        this.replace(0, this.getLength(), replacement);
    }

    default public void replaceSelection(String replacement) {
        this.replaceText(this.getSelection(), replacement);
    }

    default public void replaceSelection(StyledDocument<PS, SEG, S> replacement) {
        this.replace(this.getSelection(), replacement);
    }

    default public void moveSelectedText(int pos) {
        IndexRange sel = this.getSelection();
        if (pos >= sel.getStart() && pos <= sel.getEnd() || sel.equals((Object)GenericStyledArea.EMPTY_RANGE)) {
            this.selectRange(pos, pos);
        } else {
            StyledDocument text = this.subDocument(sel.getStart(), sel.getEnd());
            if (pos > sel.getEnd()) {
                pos -= sel.getLength();
            }
            this.deleteText(sel);
            this.insert(pos, text);
        }
    }
}

