/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.scene.text.HitInfo;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.text.PrismTextLayout;
import com.sun.javafx.text.TextLine;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.text.TextFlow;
import org.fxmisc.richtext.CharacterHit;
import org.fxmisc.richtext.model.TwoDimensional;
import org.fxmisc.richtext.model.TwoLevelNavigator;

class TextFlowExt
extends TextFlow {
    private static Method mGetTextLayout;
    private static Method mGetLines;
    private static Method mGetLineIndex;
    private static Method mGetCharCount;

    TextFlowExt() {
    }

    private static Object invoke(Method m, Object obj, Object ... args) {
        try {
            return m.invoke(obj, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    int getLineCount() {
        return this.getLines().length;
    }

    int getLineStartPosition(int charIdx) {
        TextLine[] lines = this.getLines();
        TwoLevelNavigator navigator = new TwoLevelNavigator(() -> lines.length, i -> lines[i].getLength());
        int currentLineIndex = navigator.offsetToPosition(charIdx, TwoDimensional.Bias.Forward).getMajor();
        return navigator.position(currentLineIndex, 0).toOffset();
    }

    int getLineEndPosition(int charIdx) {
        TextLine[] lines = this.getLines();
        TwoLevelNavigator navigator = new TwoLevelNavigator(() -> lines.length, i -> lines[i].getLength());
        int currentLineIndex = navigator.offsetToPosition(charIdx, TwoDimensional.Bias.Forward).getMajor();
        int minor = currentLineIndex == lines.length - 1 ? 0 : -1;
        return navigator.position(currentLineIndex + 1, minor).toOffset();
    }

    int getLineOfCharacter(int charIdx) {
        TextLine[] lines = this.getLines();
        TwoLevelNavigator navigator = new TwoLevelNavigator(() -> lines.length, i -> lines[i].getLength());
        return navigator.offsetToPosition(charIdx, TwoDimensional.Bias.Forward).getMajor();
    }

    PathElement[] getCaretShape(int charIdx, boolean isLeading) {
        return this.textLayout().getCaretShape(charIdx, isLeading, 0.0f, 0.0f);
    }

    PathElement[] getRangeShape(int from, int to) {
        return this.textLayout().getRange(from, to, 1, 0.0f, 0.0f);
    }

    PathElement[] getUnderlineShape(int from, int to) {
        PathElement[] shape = this.textLayout().getRange(from, to, 2, 0.0f, 0.0f);
        ArrayList<PathElement> result = new ArrayList<PathElement>();
        boolean collect = false;
        for (PathElement elem : shape) {
            if (elem instanceof MoveTo) {
                result.add(elem);
                collect = true;
                continue;
            }
            if (!(elem instanceof LineTo) || !collect) continue;
            result.add(elem);
            collect = false;
        }
        return result.toArray(new PathElement[0]);
    }

    CharacterHit hitLine(double x, int lineIndex) {
        return this.hit(x, this.getLineCenter(lineIndex));
    }

    CharacterHit hit(double x, double y) {
        HitInfo hit = this.textLayout().getHitInfo((float)x, (float)y);
        int charIdx = hit.getCharIndex();
        int lineIdx = this.getLineIndex((float)y);
        if (lineIdx >= this.getLineCount()) {
            return CharacterHit.insertionAt(this.getCharCount());
        }
        TextLine line = this.getLines()[lineIdx];
        RectBounds lineBounds = line.getBounds();
        if (x < (double)lineBounds.getMinX() || x > (double)lineBounds.getMaxX()) {
            if (hit.isLeading()) {
                return CharacterHit.insertionAt(charIdx);
            }
            return CharacterHit.insertionAt(charIdx + 1);
        }
        if (hit.isLeading()) {
            return CharacterHit.leadingHalfOf(charIdx);
        }
        return CharacterHit.trailingHalfOf(charIdx);
    }

    private float getLineY(int index) {
        TextLine[] lines = this.getLines();
        float spacing = (float)this.getLineSpacing();
        float lineY = 0.0f;
        for (int i = 0; i < index; ++i) {
            lineY += lines[i].getBounds().getHeight() + spacing;
        }
        return lineY;
    }

    private float getLineCenter(int index) {
        return this.getLineY(index) + this.getLines()[index].getBounds().getHeight() / 2.0f;
    }

    private TextLine[] getLines() {
        return (TextLine[])TextFlowExt.invoke(mGetLines, this.textLayout(), new Object[0]);
    }

    private int getLineIndex(float y) {
        return (Integer)TextFlowExt.invoke(mGetLineIndex, this.textLayout(), Float.valueOf(y));
    }

    private int getCharCount() {
        return (Integer)TextFlowExt.invoke(mGetCharCount, this.textLayout(), new Object[0]);
    }

    private TextLayout textLayout() {
        return (TextLayout)TextFlowExt.invoke(mGetTextLayout, (Object)this, new Object[0]);
    }

    static {
        try {
            mGetTextLayout = TextFlow.class.getDeclaredMethod("getTextLayout", new Class[0]);
            mGetLines = PrismTextLayout.class.getDeclaredMethod("getLines", new Class[0]);
            mGetLineIndex = PrismTextLayout.class.getDeclaredMethod("getLineIndex", Float.TYPE);
            mGetCharCount = PrismTextLayout.class.getDeclaredMethod("getCharCount", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        mGetTextLayout.setAccessible(true);
        mGetLines.setAccessible(true);
        mGetLineIndex.setAccessible(true);
        mGetCharCount.setAccessible(true);
    }
}

