/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.function.BiConsumer;
import javafx.beans.NamedArg;
import javafx.beans.value.ObservableValue;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.text.TextFlow;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.TextExt;
import org.fxmisc.richtext.model.EditableStyledDocument;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.SimpleEditableStyledDocument;
import org.fxmisc.richtext.model.StyledText;

public class StyledTextArea<PS, S>
extends GenericStyledArea<PS, StyledText<S>, S> {
    public StyledTextArea(@NamedArg(value="initialParagraphStyle") PS initialParagraphStyle, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> applyParagraphStyle, @NamedArg(value="initialTextStyle") S initialTextStyle, @NamedArg(value="applyStyle") BiConsumer<? super TextExt, S> applyStyle, @NamedArg(value="document") EditableStyledDocument<PS, StyledText<S>, S> document, @NamedArg(value="preserveStyle") boolean preserveStyle) {
        super(initialParagraphStyle, applyParagraphStyle, initialTextStyle, document, StyledText.textOps(), preserveStyle, seg -> StyledTextArea.createStyledTextNode(seg, StyledText.textOps(), applyStyle));
    }

    public StyledTextArea(@NamedArg(value="initialParagraphStyle") PS initialParagraphStyle, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> applyParagraphStyle, @NamedArg(value="initialTextStyle") S initialTextStyle, @NamedArg(value="applyStyle") BiConsumer<? super TextExt, S> applyStyle, @NamedArg(value="document") EditableStyledDocument<PS, StyledText<S>, S> document) {
        this(initialParagraphStyle, applyParagraphStyle, initialTextStyle, applyStyle, document, true);
    }

    public StyledTextArea(@NamedArg(value="initialParagraphStyle") PS initialParagraphStyle, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> applyParagraphStyle, @NamedArg(value="initialTextStyle") S initialTextStyle, @NamedArg(value="applyStyle") BiConsumer<? super TextExt, S> applyStyle, @NamedArg(value="preserveStyle") boolean preserveStyle) {
        this(initialParagraphStyle, applyParagraphStyle, initialTextStyle, applyStyle, new SimpleEditableStyledDocument<PS, S>(initialParagraphStyle, initialTextStyle), preserveStyle);
    }

    public StyledTextArea(@NamedArg(value="initialParagraphStyle") PS initialParagraphStyle, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> applyParagraphStyle, @NamedArg(value="initialTextStyle") S initialTextStyle, @NamedArg(value="applyStyle") BiConsumer<? super TextExt, S> applyStyle) {
        this(initialParagraphStyle, applyParagraphStyle, initialTextStyle, applyStyle, true);
    }

    public static <S> Node createStyledTextNode(StyledText<S> seg, SegmentOps<StyledText<S>, S> segOps, BiConsumer<? super TextExt, S> applyStyle) {
        TextExt t = new TextExt(segOps.getText(seg));
        t.setTextOrigin(VPos.TOP);
        t.getStyleClass().add((Object)"text");
        applyStyle.accept(t, segOps.getStyle(seg));
        t.impl_selectionFillProperty().bind((ObservableValue)t.fillProperty());
        return t;
    }
}

