/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeLineCap;
import org.fxmisc.richtext.StyledTextArea;
import org.fxmisc.richtext.TextExt;
import org.fxmisc.richtext.TextFlowExt;
import org.fxmisc.richtext.model.Paragraph;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

class ParagraphText<PS, SEG, S>
extends TextFlowExt {
    private final ObjectProperty<Paint> highlightTextFill = new SimpleObjectProperty((Object)Color.WHITE);
    private final Var<Integer> caretPosition = Var.newSimpleVar(0);
    private final Val<Integer> clampedCaretPosition;
    private final ObjectProperty<IndexRange> selection = new SimpleObjectProperty((Object)StyledTextArea.EMPTY_RANGE);
    private final Paragraph<PS, SEG, S> paragraph;
    private final Path caretShape = new Path();
    private final Path selectionShape = new Path();
    private final List<Path> backgroundShapes = new ArrayList<Path>();
    private final List<Path> underlineShapes = new ArrayList<Path>();
    private final Var<Boolean> caretVisible = Var.newSimpleVar(false);

    public ObjectProperty<Paint> highlightTextFillProperty() {
        return this.highlightTextFill;
    }

    public Var<Integer> caretPositionProperty() {
        return this.caretPosition;
    }

    public void setCaretPosition(int pos) {
        this.caretPosition.setValue(pos);
    }

    public ObjectProperty<IndexRange> selectionProperty() {
        return this.selection;
    }

    public void setSelection(IndexRange sel) {
        this.selection.set((Object)sel);
    }

    ParagraphText(Paragraph<PS, SEG, S> par, Function<SEG, Node> nodeFactory) {
        this.caretShape.visibleProperty().bind(this.caretVisible);
        this.paragraph = par;
        this.getStyleClass().add((Object)"paragraph-text");
        int parLen = this.paragraph.length();
        this.clampedCaretPosition = this.caretPosition.map(i -> Math.min(i, parLen));
        this.clampedCaretPosition.addListener((ChangeListener<Integer>)((ChangeListener)(obs, oldPos, newPos) -> this.requestLayout()));
        this.selection.addListener((obs, old, sel) -> this.requestLayout());
        Val<Double> leftInset = Val.map(this.insetsProperty(), Insets::getLeft);
        Val<Double> topInset = Val.map(this.insetsProperty(), Insets::getTop);
        this.selectionShape.setManaged(false);
        this.selectionShape.setFill((Paint)Color.DODGERBLUE);
        this.selectionShape.setStrokeWidth(0.0);
        this.selectionShape.layoutXProperty().bind(leftInset);
        this.selectionShape.layoutYProperty().bind(topInset);
        this.getChildren().add((Object)this.selectionShape);
        this.caretShape.getStyleClass().add((Object)"caret");
        this.caretShape.setManaged(false);
        this.caretShape.setStrokeWidth(1.0);
        this.caretShape.layoutXProperty().bind(leftInset);
        this.caretShape.layoutYProperty().bind(topInset);
        this.getChildren().add((Object)this.caretShape);
        for (SEG segment : par.getSegments()) {
            Node fxNode = nodeFactory.apply(segment);
            this.getChildren().add((Object)fxNode);
            Path backgroundShape = new Path();
            backgroundShape.setManaged(false);
            backgroundShape.setStrokeWidth(0.0);
            backgroundShape.layoutXProperty().bind(leftInset);
            backgroundShape.layoutYProperty().bind(topInset);
            this.backgroundShapes.add(backgroundShape);
            this.getChildren().add(0, (Object)backgroundShape);
            Path underlineShape = new Path();
            underlineShape.setManaged(false);
            underlineShape.setStrokeWidth(0.0);
            underlineShape.layoutXProperty().bind(leftInset);
            underlineShape.layoutYProperty().bind(topInset);
            this.underlineShapes.add(underlineShape);
            this.getChildren().add((Object)underlineShape);
        }
    }

    public Paragraph<PS, SEG, S> getParagraph() {
        return this.paragraph;
    }

    public Var<Boolean> caretVisibleProperty() {
        return this.caretVisible;
    }

    public ObjectProperty<Paint> highlightFillProperty() {
        return this.selectionShape.fillProperty();
    }

    public double getCaretOffsetX() {
        this.layout();
        Bounds bounds = this.caretShape.getLayoutBounds();
        return (bounds.getMinX() + bounds.getMaxX()) / 2.0;
    }

    public Bounds getCaretBounds() {
        this.layout();
        return this.caretShape.getBoundsInParent();
    }

    public Bounds getCaretBoundsOnScreen() {
        this.layout();
        Bounds localBounds = this.caretShape.getBoundsInLocal();
        return this.caretShape.localToScreen(localBounds);
    }

    public Bounds getRangeBoundsOnScreen(int from, int to) {
        this.layout();
        Object[] rangeShape = this.getRangeShape(from, to);
        ArrayList selShape = new ArrayList(this.selectionShape.getElements());
        this.selectionShape.getElements().setAll(rangeShape);
        Bounds localBounds = this.selectionShape.getBoundsInLocal();
        Bounds rangeBoundsOnScreen = this.selectionShape.localToScreen(localBounds);
        this.selectionShape.getElements().setAll(selShape);
        return rangeBoundsOnScreen;
    }

    public Optional<Bounds> getSelectionBoundsOnScreen() {
        if (((IndexRange)this.selection.get()).getLength() == 0) {
            return Optional.empty();
        }
        this.layout();
        Bounds localBounds = this.selectionShape.getBoundsInLocal();
        return Optional.ofNullable(this.selectionShape.localToScreen(localBounds));
    }

    public int getCurrentLineStartPosition() {
        return this.getLineStartPosition((Integer)this.clampedCaretPosition.getValue());
    }

    public int getCurrentLineEndPosition() {
        return this.getLineEndPosition((Integer)this.clampedCaretPosition.getValue());
    }

    public int currentLineIndex() {
        return this.getLineOfCharacter((Integer)this.clampedCaretPosition.getValue());
    }

    private void updateCaretShape() {
        Object[] shape = this.getCaretShape((Integer)this.clampedCaretPosition.getValue(), true);
        this.caretShape.getElements().setAll(shape);
    }

    private void updateSelectionShape() {
        int start = ((IndexRange)this.selection.get()).getStart();
        int end = ((IndexRange)this.selection.get()).getEnd();
        Object[] shape = this.getRangeShape(start, end);
        this.selectionShape.getElements().setAll(shape);
    }

    private void updateBackgroundShapes() {
        int index = 0;
        int start = 0;
        FilteredList nodeList = this.getChildren().filtered(node -> node instanceof TextExt);
        for (Node node2 : nodeList) {
            TextExt text = (TextExt)node2;
            int end = start + text.getText().length();
            this.updateBackground(text, start, end, index);
            this.updateUnderline(text, start, end, index);
            start = end;
            ++index;
        }
    }

    private void updateBackground(TextExt text, int start, int end, int index) {
        Paint paint = (Paint)text.backgroundColorProperty().get();
        if (paint != null) {
            Path backgroundShape = this.backgroundShapes.get(index);
            backgroundShape.setFill(paint);
            Object[] shape = this.getRangeShape(start, end);
            backgroundShape.getElements().setAll(shape);
        }
    }

    private void updateUnderline(TextExt text, int start, int end, int index) {
        Number underlineWidth = (Number)text.underlineWidthProperty().get();
        if (underlineWidth != null && underlineWidth.doubleValue() > 0.0) {
            Path underlineShape = this.underlineShapes.get(index);
            underlineShape.setStrokeWidth(underlineWidth.doubleValue());
            Paint underlineColor = (Paint)text.underlineColorProperty().get();
            Object[] underlineDashArray = null;
            Object underlineDashArrayProp = text.underlineDashArrayProperty().get();
            if (underlineDashArrayProp != null) {
                if (underlineDashArrayProp.getClass().isArray()) {
                    Number[] numberArray = (Number[])underlineDashArrayProp;
                    underlineDashArray = new Double[numberArray.length];
                    int idx = 0;
                    for (Number d : numberArray) {
                        underlineDashArray[idx++] = (Double)d;
                    }
                } else {
                    underlineDashArray = new Double[]{(double)((Double)underlineDashArrayProp)};
                }
            }
            StrokeLineCap underlineCap = (StrokeLineCap)text.underlineCapProperty().get();
            if (underlineColor != null) {
                underlineShape.setStroke(underlineColor);
            }
            if (underlineDashArray != null) {
                underlineShape.getStrokeDashArray().addAll(underlineDashArray);
            }
            if (underlineCap != null) {
                underlineShape.setStrokeLineCap(underlineCap);
            }
            Object[] shape = this.getUnderlineShape(start, end);
            underlineShape.getElements().setAll(shape);
        }
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.updateCaretShape();
        this.updateSelectionShape();
        this.updateBackgroundShapes();
    }
}

