/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import org.bluej.extensions.submitter.MessageHandler;
import org.bluej.extensions.submitter.Stat;
import threadchecker.OnThread;
import threadchecker.Tag;

class UrlRewrite {
    private Stat stat;
    private URL url;
    private boolean isMessage;

    @OnThread(value=Tag.Any)
    UrlRewrite(Stat i_stat) {
        this.stat = i_stat;
    }

    @OnThread(value=Tag.SwingIsFX)
    boolean process(Window parent) throws UnsupportedEncodingException {
        Collection urlStrings = this.stat.treeData.getProps(".transport");
        if (urlStrings.isEmpty()) {
            this.stat.submitDialog.statusWriteln(this.stat.bluej.getLabel("message.notransport"));
            return false;
        }
        String urlString = (String)urlStrings.iterator().next();
        this.isMessage = urlString.startsWith("message:");
        ArrayList<JTextComponent> userInfo = new ArrayList<JTextComponent>();
        JPanel body = new JPanel(new GridBagLayout());
        GridBagConstraints left = new GridBagConstraints();
        left.gridx = 0;
        left.ipadx = 10;
        GridBagConstraints right = new GridBagConstraints();
        right.gridx = 1;
        right.fill = 2;
        body.setBorder(new EmptyBorder(5, 5, 5, 5));
        DecimalFormat digits = new DecimalFormat("00");
        if (!this.isMessage) {
            while (true) {
                int start = urlString.indexOf(60);
                int end = urlString.indexOf(62);
                if (start == -1 && end == -1) break;
                if (start == -1 || start > end) {
                    this.stat.submitDialog.statusWriteln(this.stat.bluej.getLabel("message.badurlrequest") + " " + urlString);
                    return false;
                }
                String sub = urlString.substring(start + 1, end);
                int equal = sub.indexOf(61);
                int colon = sub.indexOf(58);
                if (equal != -1 && colon > equal) {
                    this.stat.submitDialog.statusWriteln(this.stat.bluej.getLabel("message.invalidparm") + ": " + sub);
                    return false;
                }
                String param = sub.substring(equal + 1);
                String replace = null;
                if (param.length() > 0) {
                    if (param.equals("username")) {
                        replace = URLEncoder.encode(this.stat.globalProp.getProperty("username", ""), "UTF-8");
                    } else if (param.equals("title")) {
                        replace = URLEncoder.encode(this.stat.globalProp.getProperty("title", ""), "UTF-8");
                    } else if (param.equals("simpletitle")) {
                        replace = URLEncoder.encode(this.stat.globalProp.getProperty("simpletitle", ""), "UTF-8");
                    } else if (param.equals("address")) {
                        replace = URLEncoder.encode(this.stat.globalProp.getProperty("useraddr", ""), "UTF-8");
                    } else if (param.equals("date")) {
                        replace = URLEncoder.encode(this.stat.globalProp.getProperty("date", ""), "UTF-8");
                    } else if (param.equals("isodate")) {
                        replace = URLEncoder.encode(this.stat.globalProp.getProperty("isodate", ""), "UTF-8");
                    } else if (param.length() == 2 && Character.isDigit(param.charAt(0)) && Character.isDigit(param.charAt(1))) {
                        replace = "{" + param + "}";
                    } else if (colon == -1 || equal != -1) {
                        this.stat.submitDialog.statusWriteln(this.stat.bluej.getLabel("message.unknownparm") + ": " + param);
                        return false;
                    }
                }
                if (colon != -1) {
                    JTextComponent tc;
                    String message;
                    String action = sub.substring(0, colon);
                    String string = message = equal == -1 ? sub.substring(colon + 1) : sub.substring(colon + 1, equal);
                    if (action.equals("field")) {
                        tc = new JTextField(20);
                    } else if (action.equals("area")) {
                        tc = new JTextArea(4, 20);
                    } else if (action.equals("password")) {
                        tc = new JPasswordField(20);
                    } else if (action.equals("show")) {
                        tc = new JTextField(20);
                        tc.setEnabled(false);
                    } else {
                        this.stat.submitDialog.statusWriteln(this.stat.bluej.getLabel("message.unknownaction") + ": " + action);
                        return false;
                    }
                    if (replace != null) {
                        tc.setText(URLDecoder.decode(replace, "UTF-8"));
                    }
                    body.add((Component)new JLabel(message), left);
                    body.add((Component)new JScrollPane(tc), right);
                    replace = "{" + digits.format(userInfo.size()) + "}";
                    userInfo.add(tc);
                }
                if (replace == null) {
                    this.stat.submitDialog.statusWriteln(this.stat.bluej.getLabel(this.stat.bluej.getLabel("message.unknwonparm") + ": " + sub));
                    return false;
                }
                urlString = urlString.substring(0, start) + replace + urlString.substring(end + 1);
            }
        }
        if (!userInfo.isEmpty()) {
            int id = JOptionPane.showConfirmDialog(parent, body, this.stat.bluej.getLabel("dialog.parameters.title"), 2, -1);
            if (id == 2) {
                return false;
            }
            int i = 0;
            for (JTextComponent tc : userInfo) {
                int loc;
                while ((loc = urlString.indexOf("{" + digits.format(i) + "}")) != -1) {
                    String value = URLEncoder.encode(tc.getText(), "UTF-8");
                    urlString = urlString.substring(0, loc) + value + urlString.substring(loc + 4);
                }
                ++i;
            }
        }
        try {
            this.url = this.isMessage ? new URL(null, urlString, new MessageHandler(urlString.substring(8))) : new URL(urlString);
        }
        catch (MalformedURLException ex) {
            SwingUtilities.invokeLater(() -> this.stat.submitDialog.statusWriteln(ex.toString()));
            return false;
        }
        return true;
    }

    URL getURL() {
        return this.url;
    }

    @OnThread(value=Tag.Any)
    public boolean isMessage() {
        return this.isMessage;
    }
}

