/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.bluej.extensions.submitter.Stat;

class TreeDialog
implements ActionListener {
    private Stat stat;
    private JButton okButton;
    private JButton cancelButton;
    private JDialog thisDialog;
    private JTree workJTree;

    public TreeDialog(Stat i_stat, JFrame thisParent) {
        this.stat = i_stat;
        this.workJTree = this.getJTree();
        JScrollPane scrollPane = new JScrollPane(this.workJTree);
        Dimension treeDim = new Dimension(300, 200);
        scrollPane.setPreferredSize(treeDim);
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton(this.stat.bluej.getLabel("okay"));
        this.okButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        this.cancelButton = new JButton(this.stat.bluej.getLabel("cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.cancelButton);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)scrollPane, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        this.thisDialog = new JDialog(thisParent, this.stat.bluej.getLabel("message.selectscheme"), true);
        this.thisDialog.setContentPane(mainPanel);
        this.thisDialog.pack();
        this.thisDialog.setLocation(100, 100);
    }

    public void setVisible(boolean status) {
        this.thisDialog.setVisible(status);
    }

    private JTree getJTree() {
        JTree risul = new JTree(this.stat.treeData.getTreeModel());
        risul.getSelectionModel().setSelectionMode(1);
        risul.setRootVisible(false);
        risul.putClientProperty("JTree.lineStyle", "Angled");
        risul.setExpandsSelectedPaths(true);
        return risul;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.okButton) {
            TreePath path = this.workJTree.getSelectionPath();
            if (path == null) {
                return;
            }
            String showPath = this.stat.treeData.getPathAsString(path);
            this.stat.submitDialog.schemeSelectedSet(showPath);
            this.thisDialog.dispose();
            return;
        }
        if (source == this.cancelButton) {
            this.thisDialog.dispose();
        }
    }
}

