/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreePath;
import org.bluej.extensions.submitter.AbortOperationException;
import org.bluej.extensions.submitter.FileHandler;
import org.bluej.extensions.submitter.ResultDialog;
import org.bluej.extensions.submitter.Stat;
import org.bluej.extensions.submitter.SubmitterProgressBar;
import org.bluej.extensions.submitter.TreeDialog;
import org.bluej.extensions.submitter.UrlRewrite;
import org.bluej.extensions.submitter.transport.TransportReport;
import org.bluej.extensions.submitter.transport.TransportSession;
import org.bluej.utility.Utility;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.SwingIsFX)
public class SubmitDialog
implements ActionListener {
    private static final String SELECTED_NODE_PROPERTY = "selectedNode";
    private static final String PROPERTIES_FILENAME = "submitter.properties";
    private final @OnThread(value=Tag.Any) Stat stat;
    private JFrame mainFrame;
    private JTextField schemeSelected;
    private JButton browseButton;
    private JTextArea statusArea;
    private JTextArea logArea;
    private JButton submitButton;
    private JButton cancelButton;
    private SubmitterProgressBar progressBar;
    private ResultDialog resultDialog;
    private TreeDialog treeDialog;
    private @OnThread(value=Tag.Any) File curProjectRootDir;
    private @OnThread(value=Tag.Any) String curProjectName;
    private Thread backgroundThread;

    public SubmitDialog(Stat i_stat) {
        this.stat = i_stat;
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BoxLayout(aPanel, 1));
        aPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        aPanel.add(this.getWorkPanel());
        aPanel.add(this.getLoggingPanel());
        this.mainFrame = new JFrame("Submitter");
        this.mainFrame.addWindowListener(new onWindowClosing());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("World.gif"));
        this.mainFrame.setIconImage(icon.getImage());
        this.mainFrame.getContentPane().add(aPanel);
        this.mainFrame.setLocation(50, 50);
        this.resultDialog = new ResultDialog(this.stat, this.mainFrame);
        this.treeDialog = new TreeDialog(this.stat, this.mainFrame);
    }

    public void submitThis(File pRootDir, String pName) {
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
        if (this.backgroundThread != null && this.backgroundThread.isAlive()) {
            this.statusWriteln("ERROR: Background Task still running");
            return;
        }
        this.curProjectRootDir = pRootDir;
        this.curProjectName = pName;
        this.statusArea.setText("");
        this.logArea.setText("");
        this.resultDialog.showResult("");
        this.backgroundThread = new TreeLoadThread();
        this.backgroundThread.start();
    }

    public void statusWriteln(String aMessage) {
        this.statusArea.append(aMessage);
        this.statusArea.setCaretPosition(this.statusArea.getText().length());
        this.statusArea.append("\n");
    }

    public void logWriteln(String aMessage) {
        this.logArea.append(aMessage);
        this.logArea.setCaretPosition(this.logArea.getText().length());
        this.logArea.append("\n");
    }

    @OnThread(value=Tag.Any)
    public void schemeSelectedSet(String curScheme) {
        this.stat.globalProp.setProperty("title", curScheme);
        String simpleScheme = curScheme;
        int index = curScheme.lastIndexOf(47);
        if (index >= 0 && index + 1 < curScheme.length()) {
            simpleScheme = curScheme.substring(index + 1);
        }
        this.stat.globalProp.setProperty("simpletitle", simpleScheme);
        SwingUtilities.invokeLater(() -> this.schemeSelected.setText(curScheme));
    }

    public String schemeSelectedGet() {
        return this.schemeSelected.getText();
    }

    private JPanel getWorkPanel() {
        this.progressBar = new SubmitterProgressBar();
        this.progressBar.setPreferredSize(new Dimension(400, 10));
        this.progressBar.setBorderPainted(false);
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BoxLayout(aPanel, 1));
        aPanel.setBorder(new EtchedBorder(0));
        aPanel.setMaximumSize(new Dimension(2000, 100));
        aPanel.add(this.getSubmitPanel());
        aPanel.add(this.progressBar);
        aPanel.add(this.getButtonPanel());
        return aPanel;
    }

    private JPanel getSubmitPanel() {
        JPanel submitPanel = new JPanel(new FlowLayout());
        JLabel schemeLabel = new JLabel(this.stat.bluej.getLabel("dialog.scheme"));
        submitPanel.add(schemeLabel);
        this.schemeSelected = new JTextField();
        this.schemeSelected.setPreferredSize(new Dimension(350, 26));
        this.schemeSelected.addActionListener(this);
        this.schemeSelected.getDocument().addDocumentListener(new onFieldChange());
        submitPanel.add(this.schemeSelected);
        this.browseButton = new JButton(this.stat.bluej.getLabel("button.browse"));
        this.browseButton.addActionListener(this);
        submitPanel.add(this.browseButton);
        return submitPanel;
    }

    private JTabbedPane getLoggingPanel() {
        this.statusArea = new JTextArea();
        this.statusArea.setLineWrap(true);
        this.statusArea.setEditable(false);
        JScrollPane statusPane = new JScrollPane(this.statusArea);
        statusPane.setHorizontalScrollBarPolicy(31);
        this.logArea = new JTextArea();
        this.logArea.setEditable(false);
        this.logArea.setLineWrap(true);
        JScrollPane logPane = new JScrollPane(this.logArea);
        logPane.setHorizontalScrollBarPolicy(31);
        JTabbedPane tabbed = new JTabbedPane();
        tabbed.setPreferredSize(new Dimension(400, 60));
        tabbed.add("Status", statusPane);
        tabbed.add("Log", logPane);
        return tabbed;
    }

    private JPanel getButtonPanel() {
        JPanel risulPanel = new JPanel();
        this.submitButton = new JButton(this.stat.bluej.getLabel("button.submit"));
        this.submitButton.addActionListener(this);
        risulPanel.add(this.submitButton);
        this.cancelButton = new JButton(this.stat.bluej.getLabel("cancel"));
        this.cancelButton.addActionListener(this);
        risulPanel.add(this.cancelButton);
        return risulPanel;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event == null) {
            return;
        }
        Object eventObject = event.getSource();
        if (eventObject == null) {
            return;
        }
        if (eventObject == this.browseButton) {
            this.treeDialog.setVisible(true);
        }
        if (eventObject == this.cancelButton) {
            if (this.backgroundThread != null && this.backgroundThread.isAlive()) {
                this.backgroundThread.interrupt();
            } else {
                this.mainFrame.setVisible(false);
            }
        }
        if (eventObject == this.submitButton) {
            if (this.backgroundThread != null && this.backgroundThread.isAlive()) {
                this.statusWriteln("ERROR: Background task running");
            } else {
                this.backgroundThread = new SubmitThread(this.schemeSelectedGet());
                this.backgroundThread.setContextClassLoader(this.getClass().getClassLoader());
                this.backgroundThread.start();
            }
        }
    }

    @OnThread(value=Tag.Unique)
    private String sendFiles(UrlRewrite urlProps) {
        TransportSession ts = null;
        File[] files = new File[]{};
        try {
            CompletableFuture fhFuture = new CompletableFuture();
            SwingUtilities.invokeLater(() -> fhFuture.complete(new FileHandler(this.stat.bluej, this.curProjectRootDir, this.stat.treeData)));
            FileHandler fh = (FileHandler)fhFuture.get();
            files = fh.getFiles();
            if (files == null) {
                SwingUtilities.invokeLater(() -> this.statusWriteln("sendFiles: NOTICE: no files to send"));
                return null;
            }
            CompletableFuture jarNamesFuture = new CompletableFuture();
            SwingUtilities.invokeLater(() -> jarNamesFuture.complete(this.stat.treeData.getProps(".file.jar")));
            Collection jarNames = (Collection)jarNamesFuture.get();
            String jarName = null;
            if (jarNames.isEmpty()) {
                ts = TransportSession.createTransportSession(urlProps.getURL(), this.stat.globalProp, this.stat.bluej);
            } else {
                jarName = (String)jarNames.iterator().next();
                ts = TransportSession.createJarTransportSession(urlProps.getURL(), this.stat.globalProp, jarName, this.stat.bluej);
            }
            ts.setTransportReport(new transportReport());
            ts.connect();
            String projNamePrefix = null;
            String tsProtocol = ts.getProtocol();
            if (tsProtocol.equals("ftp") || tsProtocol.equals("file") || jarName != null) {
                projNamePrefix = this.curProjectName;
            }
            for (int index = 0; index < files.length; ++index) {
                boolean binary = FileHandler.isBinary(files[index]);
                FileInputStream fis = new FileInputStream(files[index]);
                String name = fh.getSubName(files[index]);
                if (projNamePrefix != null) {
                    name = projNamePrefix + File.separator + name;
                }
                String nameFinal = name = name.replace(File.separatorChar, '/');
                SwingUtilities.invokeLater(() -> this.statusWriteln(this.stat.bluej.getLabel("message.sending") + " " + nameFinal));
                ts.send(fis, name, binary);
                Utility.inputStreamClose(fis);
            }
            ts.disconnect();
        }
        catch (Exception ex) {
            SwingUtilities.invokeLater(() -> {
                this.logWriteln("sendFiles Exception=" + ex.toString());
                this.statusWriteln(this.translateException(ex));
            });
            return null;
        }
        int filesLength = files.length;
        SwingUtilities.invokeLater(() -> this.statusWriteln(filesLength + " " + this.stat.bluej.getLabel("message.filessent")));
        return ts.getResult();
    }

    private String translateException(Throwable ex) {
        if (ex instanceof AbortOperationException) {
            return ((AbortOperationException)ex).getMessage(this.stat.bluej);
        }
        if (ex instanceof UnknownHostException) {
            return this.getLabelInsert("exception.unknownhost", ex.getMessage());
        }
        if (ex instanceof NoRouteToHostException) {
            return this.stat.bluej.getLabel("exception.notroutetohost");
        }
        if (ex instanceof ProtocolException) {
            return ex.getMessage();
        }
        if (ex instanceof FileNotFoundException) {
            return this.getLabelInsert("exception.filenotfound", ex.getMessage());
        }
        if (ex instanceof IllegalArgumentException && ex.getMessage().equals("SMTP Host has not been set")) {
            return this.stat.bluej.getLabel("exception.hostnotset");
        }
        if (ex instanceof IllegalArgumentException && ex.getMessage().equals("User Email address invalid")) {
            return this.stat.bluej.getLabel("exception.addrnotset");
        }
        return ex.getMessage();
    }

    public String getLabelInsert(String id, String replacement) {
        String label = this.stat.bluej.getLabel(id);
        int p = label.indexOf(36);
        if (p == -1) {
            label = label + " $";
            p = label.indexOf(36);
        }
        label = label.substring(0, p) + replacement + label.substring(p + 1);
        return label;
    }

    @OnThread(value=Tag.Unique)
    private String sendMessage(UrlRewrite urlProps) {
        try {
            TransportSession ts = TransportSession.createTransportSession(urlProps.getURL(), this.stat.globalProp, this.stat.bluej);
            ts.connect();
            ts.disconnect();
            return ts.getResult();
        }
        catch (Exception exc) {
            SwingUtilities.invokeLater(() -> this.statusWriteln("sendMessage: Exception=" + exc.toString()));
            return null;
        }
    }

    @OnThread(value=Tag.Unique)
    private void submitWork() {
        String result = null;
        UrlRewrite urlProps = new UrlRewrite(this.stat);
        AtomicBoolean guiResult = new AtomicBoolean(false);
        try {
            SwingUtilities.invokeAndWait(() -> {
                try {
                    guiResult.set(urlProps.process(this.mainFrame));
                }
                catch (UnsupportedEncodingException e) {
                    this.statusWriteln("Unsupported encoding scheme exception = " + e.toString());
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            SwingUtilities.invokeLater(() -> this.statusWriteln("Internal error: " + e.toString()));
        }
        if (!guiResult.get()) {
            return;
        }
        result = urlProps.isMessage() ? this.sendMessage(urlProps) : this.sendFiles(urlProps);
        String resultFinal = result;
        SwingUtilities.invokeLater(() -> this.resultDialog.showResult(resultFinal));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Unique)
    private void loadDefaultScheme() {
        this.schemeSelectedSet("");
        File projectDefsFile = new File(this.curProjectRootDir, PROPERTIES_FILENAME);
        if (!projectDefsFile.canRead()) {
            return;
        }
        Properties projProps = new Properties();
        FileInputStream iStream = null;
        try {
            iStream = new FileInputStream(projectDefsFile);
            projProps.load(iStream);
        }
        catch (Exception exc) {
            try {
                SwingUtilities.invokeLater(() -> this.statusWriteln("loadDefaultScheme: No defaultScheme on project " + projectDefsFile));
            }
            catch (Throwable throwable) {
                Utility.inputStreamClose(iStream);
                throw throwable;
            }
            Utility.inputStreamClose(iStream);
            return;
        }
        Utility.inputStreamClose(iStream);
        this.schemeSelectedSet(projProps.getProperty(SELECTED_NODE_PROPERTY, ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Unique)
    private void saveDefaultScheme(String curScheme) {
        TreePath path = this.stat.treeData.getPathFromString(curScheme);
        if (path == null) {
            return;
        }
        Properties projProps = new Properties();
        projProps.setProperty(SELECTED_NODE_PROPERTY, curScheme);
        File projectDefsFile = new File(this.curProjectRootDir, PROPERTIES_FILENAME);
        FileOutputStream oStream = null;
        try {
            oStream = new FileOutputStream(projectDefsFile);
            projProps.store(oStream, "Submitter per project properties");
        }
        catch (Exception exc) {
            try {
                SwingUtilities.invokeLater(() -> this.logWriteln("setDefaultScheme: Cannot write properties to file=" + projectDefsFile.toString()));
            }
            catch (Throwable throwable) {
                Utility.outputStreamClose(oStream);
                throw throwable;
            }
            Utility.outputStreamClose(oStream);
            return;
        }
        Utility.outputStreamClose(oStream);
    }

    private void checkSubmitButton() {
        TreePath possiblePath = this.stat.treeData.getPathFromString(this.schemeSelectedGet());
        if (possiblePath == null) {
            this.submitButton.setEnabled(false);
        } else {
            this.submitButton.setEnabled(true);
        }
    }

    class onFieldChange
    implements DocumentListener {
        onFieldChange() {
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
            SubmitDialog.this.checkSubmitButton();
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            SubmitDialog.this.checkSubmitButton();
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            SubmitDialog.this.checkSubmitButton();
        }
    }

    class onWindowClosing
    extends WindowAdapter {
        onWindowClosing() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SubmitDialog.this.mainFrame.setVisible(false);
        }
    }

    class SubmitThread
    extends Thread {
        private final String selectedScheme;

        public SubmitThread(String selectedScheme) {
            this.selectedScheme = selectedScheme;
        }

        @Override
        @OnThread(value=Tag.Unique, ignoreParent=true)
        public void run() {
            SwingUtilities.invokeLater(() -> SubmitDialog.this.progressBar.setRunning(true));
            SubmitDialog.this.saveDefaultScheme(this.selectedScheme);
            SubmitDialog.this.submitWork();
            SwingUtilities.invokeLater(() -> SubmitDialog.this.progressBar.setRunning(false));
        }
    }

    class TreeLoadThread
    extends Thread {
        TreeLoadThread() {
        }

        @Override
        @OnThread(value=Tag.Unique, ignoreParent=true)
        public void run() {
            SwingUtilities.invokeLater(() -> SubmitDialog.this.progressBar.setRunning(true));
            ((SubmitDialog)SubmitDialog.this).stat.treeData.loadTree(SubmitDialog.this.curProjectRootDir);
            SubmitDialog.this.loadDefaultScheme();
            SwingUtilities.invokeLater(() -> {
                SubmitDialog.this.statusWriteln("Loading Done");
                SubmitDialog.this.progressBar.setRunning(false);
            });
        }
    }

    @OnThread(value=Tag.Any)
    class transportReport
    implements TransportReport {
        transportReport() {
        }

        @Override
        @OnThread(value=Tag.Any)
        public void reportEvent(String message) {
            SwingUtilities.invokeLater(() -> SubmitDialog.this.statusWriteln(message));
        }

        @Override
        @OnThread(value=Tag.Any)
        public void reportLog(String message) {
            SwingUtilities.invokeLater(() -> SubmitDialog.this.logWriteln(message));
        }
    }
}

