/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter;

import bluej.extensions.BlueJ;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import org.bluej.extensions.submitter.AbortOperationException;
import org.bluej.extensions.submitter.properties.TreeData;
import threadchecker.OnThread;
import threadchecker.Tag;

class FileHandler {
    private final BlueJ bj;
    private final TreeData sp;
    private final Collection essentials;
    private final Collection include;
    private final Collection exclude;
    private File projectDir;

    @OnThread(value=Tag.SwingIsFX)
    public FileHandler(BlueJ bj, File pDir, TreeData sp) {
        this.bj = bj;
        this.sp = sp;
        this.essentials = sp.getProps(".file.essential");
        this.include = sp.getProps(".file.include");
        this.exclude = sp.getProps(".file.exclude");
        this.projectDir = pDir;
    }

    public File[] getFiles() throws AbortOperationException {
        return this.wantedFiles().toArray(new File[0]);
    }

    public String getSubName(File file) throws AbortOperationException, IOException {
        String parent;
        String path = file.getCanonicalPath();
        if (!path.startsWith(parent = this.projectDir.getCanonicalPath())) {
            throw new AbortOperationException("message.filenotinpath");
        }
        path = path.substring(parent.length() + 1);
        return path;
    }

    private String commaList(Collection list) {
        String commaList = "";
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String item = (String)it.next();
            commaList = commaList + item;
            if (!it.hasNext()) continue;
            commaList = commaList + ", ";
        }
        return commaList;
    }

    private static boolean match(String item, Collection search) {
        for (Object obj : search) {
            if (obj instanceof String && FileHandler.match(item, (String)obj)) {
                return true;
            }
            if (!(obj instanceof File) || !FileHandler.match(((File)obj).getName(), item)) continue;
            return true;
        }
        return false;
    }

    private static boolean match(String item, String pattern) {
        boolean pend;
        boolean iend;
        if (item == null || pattern == null) {
            return item == pattern;
        }
        int i = 0;
        int p = 0;
        Stack<Integer> stars = new Stack<Integer>();
        boolean star = false;
        while (!(iend = i >= item.length()) | !(pend = p >= pattern.length() || pattern.charAt(p) == ';')) {
            char pc;
            char ic = iend ? (char)'\u0000' : item.charAt(i);
            char c = pc = pend ? (char)'\u0000' : pattern.charAt(p);
            if (star && !pend && !iend) {
                if (pc == ic) {
                    star = false;
                    ++i;
                    ++p;
                    continue;
                }
                ++i;
                continue;
            }
            if (pc == '?') {
                ++i;
                ++p;
                continue;
            }
            if (pc == '*') {
                stars.push(new Integer(++p));
                star = true;
                continue;
            }
            if (ic == pc) {
                ++i;
                ++p;
                continue;
            }
            if (stars.empty() || pend || iend) {
                while (++p < pattern.length() && pattern.charAt(p) != ';') {
                }
                if (p >= pattern.length()) break;
                ++p;
                i = 0;
                star = false;
                continue;
            }
            p = (Integer)stars.pop();
            star = true;
        }
        return iend && pend || pend && star;
    }

    private Collection wantedFiles() throws AbortOperationException {
        String checkName;
        Iterator it;
        ArrayList wantedFiles = new ArrayList();
        FileHandler.recurseDirectory(wantedFiles, this.projectDir);
        if (!this.include.isEmpty()) {
            it = wantedFiles.iterator();
            while (it.hasNext()) {
                checkName = ((File)it.next()).getName();
                if (FileHandler.match(checkName, this.essentials) || FileHandler.match(checkName, this.include)) continue;
                it.remove();
            }
        }
        if (!this.exclude.isEmpty()) {
            it = wantedFiles.iterator();
            while (it.hasNext()) {
                checkName = ((File)it.next()).getName();
                if (!FileHandler.match(checkName, this.exclude)) continue;
                it.remove();
            }
        }
        ArrayList unsatisfied = new ArrayList(this.essentials);
        Iterator it2 = unsatisfied.iterator();
        while (it2.hasNext()) {
            if (!FileHandler.match((String)it2.next(), wantedFiles)) continue;
            it2.remove();
        }
        if (!unsatisfied.isEmpty()) {
            throw new AbortOperationException("message.filesmissing", " " + this.commaList(unsatisfied));
        }
        if (wantedFiles.isEmpty()) {
            throw new AbortOperationException("message.nofilestosend");
        }
        return wantedFiles;
    }

    public static void recurseDirectory(Collection bag, File dir) {
        File[] list = dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].isDirectory()) {
                FileHandler.recurseDirectory(bag, list[i]);
                continue;
            }
            bag.add(list[i]);
        }
    }

    public static boolean isBinary(File file) throws IOException {
        int read;
        boolean isBinary = false;
        FileInputStream fis = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        block0: while ((read = fis.read(buffer)) > 0) {
            for (int i = 0; i < read; ++i) {
                byte b = buffer[i];
                if (b <= 126 && (b >= 32 || b == 10 || b == 13 || b == 9)) continue;
                isBinary = true;
                continue block0;
            }
        }
        fis.close();
        return isBinary;
    }
}

