/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions.editor;

import bluej.editor.TextEditor;
import bluej.extensions.editor.TextLocation;
import bluej.parser.SourceLocation;
import java.io.IOException;
import javax.swing.text.BadLocationException;

public class Editor {
    private TextEditor bjEditor;

    Editor(TextEditor bjEditor) {
        this.bjEditor = bjEditor;
    }

    bluej.editor.Editor getEditor() {
        return this.bjEditor;
    }

    public void saveFile() {
        try {
            this.bjEditor.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadFile() {
        this.bjEditor.reloadFile();
    }

    public void setVisible(boolean visible) {
        this.bjEditor.setEditorVisible(visible);
    }

    public boolean isVisible() {
        return this.bjEditor.isOpen();
    }

    public TextLocation getCaretLocation() {
        return this.convertLocation(this.bjEditor.getCaretLocation());
    }

    public void setCaretLocation(TextLocation location) {
        this.bjEditor.setCaretLocation(this.convertLocation(location));
    }

    public void showMessage(String message) {
        this.bjEditor.writeMessage(message);
    }

    public TextLocation getSelectionBegin() {
        return this.convertLocation(this.bjEditor.getSelectionBegin());
    }

    public TextLocation getSelectionEnd() {
        return this.convertLocation(this.bjEditor.getSelectionEnd());
    }

    public String getText(TextLocation begin, TextLocation end) {
        return this.bjEditor.getText(this.convertLocation(begin), this.convertLocation(end));
    }

    public void setText(TextLocation begin, TextLocation end, String newText) {
        try {
            this.bjEditor.setText(this.convertLocation(begin), this.convertLocation(end), newText);
        }
        catch (BadLocationException exc) {
            throw new IllegalArgumentException(exc.getMessage());
        }
    }

    public void setSelection(TextLocation begin, TextLocation end) {
        this.bjEditor.setSelection(this.convertLocation(begin), this.convertLocation(end));
    }

    public void setReadOnly(boolean readOnly) {
        this.bjEditor.setReadOnly(readOnly);
    }

    public boolean isReadOnly() {
        return this.bjEditor.isReadOnly();
    }

    public Object getProperty(String propertyKey) {
        return this.bjEditor.getProperty(propertyKey);
    }

    public void setProperty(String propertyKey, Object value) {
        this.bjEditor.setProperty(propertyKey, value);
    }

    public int getOffsetFromTextLocation(TextLocation location) {
        return this.bjEditor.getOffsetFromLineColumn(this.convertLocation(location));
    }

    public TextLocation getTextLocationFromOffset(int offset) {
        return this.convertLocation(this.bjEditor.getLineColumnFromOffset(offset));
    }

    public int getLineLength(int line) {
        return this.bjEditor.getLineLength(line);
    }

    public int getLineCount() {
        return this.bjEditor.numberOfLines();
    }

    public int getTextLength() {
        return this.bjEditor.getTextLength();
    }

    private SourceLocation convertLocation(TextLocation location) {
        if (location == null) {
            return null;
        }
        return new SourceLocation(location.getLine() + 1, location.getColumn() + 1);
    }

    private TextLocation convertLocation(SourceLocation location) {
        if (location == null) {
            return null;
        }
        return new TextLocation(location.getLine() - 1, location.getColumn() - 1);
    }

    public void cancelFreshState() {
        this.bjEditor.cancelFreshState();
    }
}

