/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions;

import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.compiler.JobQueue;
import bluej.extensions.BClassTarget;
import bluej.extensions.BConstructor;
import bluej.extensions.BField;
import bluej.extensions.BMethod;
import bluej.extensions.BPackage;
import bluej.extensions.ClassNotFoundException;
import bluej.extensions.CompilationNotStartedException;
import bluej.extensions.ExtensionException;
import bluej.extensions.Identifier;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.extensions.SourceType;
import bluej.extensions.editor.Editor;
import bluej.extensions.editor.EditorBridge;
import bluej.parser.symtab.ClassInfo;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.Target;
import bluej.utility.JavaNames;
import bluej.views.ConstructorView;
import bluej.views.FieldView;
import bluej.views.MethodView;
import bluej.views.View;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;

public class BClass {
    private static Map<Identifier, BClass> externalClasses = new WeakHashMap<Identifier, BClass>();
    private Identifier classId;

    BClass(Identifier thisClassId) {
        this.classId = thisClassId;
    }

    static synchronized BClass getBClass(Identifier classId) {
        BClass r = externalClasses.get(classId);
        if (r == null) {
            r = new BClass(classId);
            externalClasses.put(classId, r);
        }
        return r;
    }

    void nameChanged(String newName) {
        try {
            Project proj = this.classId.getBluejProject();
            Package pkg = this.classId.getBluejPackage();
            this.classId = new Identifier(proj, pkg, newName);
        }
        catch (ProjectNotOpenException projectNotOpenException) {
        }
        catch (PackageNotFoundException packageNotFoundException) {
            // empty catch block
        }
    }

    public final String getName() {
        return this.classId.getClassName();
    }

    public void remove() throws ProjectNotOpenException, PackageNotFoundException, ClassNotFoundException {
        ClassTarget bluejClass = this.classId.getClassTarget();
        if (bluejClass == null) {
            throw new ClassNotFoundException("Can't find class: " + this.classId.getClassName());
        }
        bluejClass.remove();
    }

    public void convertStrideToJava() throws ProjectNotOpenException, PackageNotFoundException, ClassNotFoundException {
        ClassTarget bluejClass = this.classId.getClassTarget();
        if (bluejClass == null) {
            throw new ClassNotFoundException("Can't find class: " + this.classId.getClassName());
        }
        bluejClass.convertStrideToJava();
    }

    public void convertJavaToStride() throws ProjectNotOpenException, PackageNotFoundException, ClassNotFoundException {
        ClassTarget bluejClass = this.classId.getClassTarget();
        if (bluejClass == null) {
            throw new ClassNotFoundException("Can't find class: " + this.classId.getClassName());
        }
        bluejClass.promptAndConvertJavaToStride();
    }

    public Class<?> getJavaClass() throws ProjectNotOpenException, ClassNotFoundException {
        return this.classId.getJavaClass();
    }

    public BPackage getPackage() throws ProjectNotOpenException, PackageNotFoundException {
        Package bluejPkg = this.classId.getBluejPackage();
        return bluejPkg.getBPackage();
    }

    public Editor getEditor() throws ProjectNotOpenException, PackageNotFoundException {
        ClassTarget aTarget = this.classId.getClassTarget();
        if (aTarget == null) {
            return null;
        }
        return EditorBridge.newEditor(aTarget);
    }

    public SourceType getSourceType() throws ProjectNotOpenException, PackageNotFoundException {
        ClassTarget aTarget = this.classId.getClassTarget();
        if (aTarget != null) {
            return aTarget.getSourceType();
        }
        return null;
    }

    public boolean isCompiled() throws ProjectNotOpenException, PackageNotFoundException {
        ClassTarget aTarget = this.classId.getClassTarget();
        return aTarget == null || aTarget.isCompiled();
    }

    public void compile(boolean waitCompileEnd) throws ProjectNotOpenException, PackageNotFoundException, CompilationNotStartedException {
        this.compile(waitCompileEnd, false);
    }

    public void compile(boolean waitCompileEnd, boolean forceQuiet) throws ProjectNotOpenException, PackageNotFoundException, CompilationNotStartedException {
        Package bluejPkg = this.classId.getBluejPackage();
        ClassTarget aTarget = this.classId.getClassTarget();
        if (aTarget == null) {
            throw new CompilationNotStartedException("Class target does not (any longer) exist");
        }
        if (!bluejPkg.isDebuggerIdle()) {
            throw new CompilationNotStartedException("BlueJ is currently executing Java code");
        }
        bluejPkg.compile(aTarget, forceQuiet, null, CompileReason.EXTENSION, CompileType.EXTENSION);
        if (waitCompileEnd) {
            JobQueue.getJobQueue().waitForEmptyQueue();
        }
    }

    private String findPkgName(String fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            return "";
        }
        int dotIndex = fullyQualifiedName.lastIndexOf(".");
        if (dotIndex < 0) {
            return "";
        }
        return fullyQualifiedName.substring(0, dotIndex);
    }

    public BClass getSuperclass() throws ProjectNotOpenException, PackageNotFoundException, ClassNotFoundException {
        Target aTarget;
        Project bluejPrj = this.classId.getBluejProject();
        ClassTarget ct = this.classId.getClassTarget();
        if (ct != null && !ct.isCompiled()) {
            ClassInfo info = ct.getSourceInfo().getInfo(this.getJavaFile(), ct.getPackage());
            if (info != null) {
                Target sct;
                String superClass = info.getSuperclass();
                superClass = superClass == null ? "" : superClass;
                String pkgString = JavaNames.getPrefix((String)superClass);
                Package bjPkg = bluejPrj.getPackage(pkgString);
                if (bjPkg != null && (sct = bjPkg.getTarget(JavaNames.getBase((String)superClass))) instanceof ClassTarget) {
                    return ((ClassTarget)sct).getBClass();
                }
                Identifier sid = new Identifier(bluejPrj, null, superClass);
                return BClass.getBClass(sid);
            }
            return null;
        }
        View bluejView = this.classId.getBluejView();
        View superView = bluejView.getSuper();
        if (superView == null) {
            return null;
        }
        Class aTest = bluejPrj.loadClass(superView.getQualifiedName());
        if (aTest == null) {
            return null;
        }
        String classPkgName = this.findPkgName(superView.getQualifiedName());
        Package bluejPkg = bluejPrj.getPackage(classPkgName);
        if (bluejPkg != null && (aTarget = bluejPkg.getTarget(superView.getBaseName())) instanceof ClassTarget) {
            ClassTarget classTarget = (ClassTarget)aTarget;
            return classTarget.getBClass();
        }
        Identifier id = new Identifier(bluejPrj, null, superView.getQualifiedName());
        return BClass.getBClass(id);
    }

    public BConstructor[] getConstructors() throws ProjectNotOpenException, ClassNotFoundException {
        View bluejView = this.classId.getBluejView();
        ConstructorView[] constructorViews = bluejView.getConstructors();
        BConstructor[] result = new BConstructor[constructorViews.length];
        for (int index = 0; index < constructorViews.length; ++index) {
            result[index] = new BConstructor(this.classId, constructorViews[index]);
        }
        return result;
    }

    public BConstructor getConstructor(Class<?>[] signature) throws ProjectNotOpenException, ClassNotFoundException {
        View bluejView = this.classId.getBluejView();
        ConstructorView[] constructorViews = bluejView.getConstructors();
        for (int index = 0; index < constructorViews.length; ++index) {
            BConstructor aConstr = new BConstructor(this.classId, constructorViews[index]);
            if (!aConstr.matches(signature)) continue;
            return aConstr;
        }
        return null;
    }

    public BMethod[] getDeclaredMethods() throws ProjectNotOpenException, ClassNotFoundException {
        View bluejView = this.classId.getBluejView();
        MethodView[] methodView = bluejView.getDeclaredMethods();
        BMethod[] methods = new BMethod[methodView.length];
        for (int index = 0; index < methods.length; ++index) {
            methods[index] = new BMethod(this.classId, methodView[index]);
        }
        return methods;
    }

    public BMethod getDeclaredMethod(String methodName, Class<?>[] params) throws ProjectNotOpenException, ClassNotFoundException {
        View bluejView = this.classId.getBluejView();
        MethodView[] methodView = bluejView.getDeclaredMethods();
        for (int index = 0; index < methodView.length; ++index) {
            BMethod aResul = new BMethod(this.classId, methodView[index]);
            if (!aResul.matches(methodName, params)) continue;
            return aResul;
        }
        return null;
    }

    public BMethod[] getMethods() throws ProjectNotOpenException, ClassNotFoundException {
        View bluejView = this.classId.getBluejView();
        MethodView[] methodView = bluejView.getAllMethods();
        BMethod[] methods = new BMethod[methodView.length];
        for (int index = 0; index < methods.length; ++index) {
            methods[index] = new BMethod(this.classId, methodView[index]);
        }
        return methods;
    }

    public BMethod getMethod(String methodName, Class<?>[] params) throws ProjectNotOpenException, ClassNotFoundException {
        View bluejView = this.classId.getBluejView();
        MethodView[] methodView = bluejView.getAllMethods();
        for (int index = 0; index < methodView.length; ++index) {
            BMethod aResul = new BMethod(this.classId, methodView[index]);
            if (!aResul.matches(methodName, params)) continue;
            return aResul;
        }
        return null;
    }

    public BField[] getFields() throws ProjectNotOpenException, ClassNotFoundException {
        View bluejView = this.classId.getBluejView();
        FieldView[] fieldView = bluejView.getAllFields();
        BField[] bFields = new BField[fieldView.length];
        for (int index = 0; index < fieldView.length; ++index) {
            bFields[index] = new BField(this.classId, fieldView[index]);
        }
        return bFields;
    }

    public BField getField(String fieldName) throws ProjectNotOpenException, ClassNotFoundException {
        if (fieldName == null) {
            return null;
        }
        View bluejView = this.classId.getBluejView();
        FieldView[] fieldView = bluejView.getAllFields();
        for (int index = 0; index < fieldView.length; ++index) {
            BField result = new BField(this.classId, fieldView[index]);
            if (!result.getName().equals(fieldName)) continue;
            return result;
        }
        return null;
    }

    public BClassTarget getClassTarget() throws ProjectNotOpenException, PackageNotFoundException {
        ClassTarget classTarget = this.classId.getClassTarget();
        return classTarget != null ? classTarget.getBClassTarget() : null;
    }

    public File getClassFile() throws ProjectNotOpenException, PackageNotFoundException {
        ClassTarget aTarget = this.classId.getClassTarget();
        if (aTarget == null) {
            return null;
        }
        return aTarget.getClassFile();
    }

    public File getJavaFile() throws ProjectNotOpenException, PackageNotFoundException {
        bluej.editor.Editor anEditor;
        ClassTarget aTarget = this.classId.getClassTarget();
        if (aTarget == null) {
            return null;
        }
        if (aTarget.editorOpen() && (anEditor = aTarget.getEditor()) != null) {
            try {
                anEditor.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return aTarget.getJavaSourceFile();
    }

    public void beginChangeSource() throws ProjectNotOpenException, PackageNotFoundException {
        ClassTarget aTarget = this.classId.getClassTarget();
        if (aTarget == null) {
            return;
        }
        bluej.editor.Editor anEditor = aTarget.getEditor();
        if (anEditor == null) {
            return;
        }
        try {
            anEditor.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        anEditor.setReadOnly(true);
    }

    public void endChangeSource() throws ProjectNotOpenException, PackageNotFoundException {
        ClassTarget aTarget = this.classId.getClassTarget();
        if (aTarget == null) {
            return;
        }
        bluej.editor.Editor anEditor = aTarget.getEditor();
        if (anEditor == null) {
            return;
        }
        anEditor.reloadFile();
        anEditor.setReadOnly(false);
    }

    public String toString() {
        try {
            Class<?> javaClass = this.classId.getJavaClass();
            return "BClass: " + javaClass.getName();
        }
        catch (ExtensionException exc) {
            return "BClass: INVALID";
        }
    }
}

