/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx.dialog;

import bluej.Config;
import bluej.utility.DialogManager;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.dialog.DialogPaneAnimateError;
import java.util.Optional;
import javafx.application.Platform;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Window;

public abstract class InputDialog<R> {
    private final Dialog<R> dialog = new Dialog();
    private final TextField field;
    private final Label prompt;
    private final Label error;
    private final DialogPaneAnimateError dialogPane;

    protected InputDialog(String title, String label, String prompt, String styleClass, String labelAfterField) {
        this.dialog.initModality(Modality.WINDOW_MODAL);
        this.dialog.setTitle(title);
        VBox content = new VBox();
        this.prompt = new Label(label);
        this.field = new TextField();
        this.field.setPromptText(prompt);
        this.field.setOnKeyPressed(e -> {
            if (e.getCode() == KeyCode.ESCAPE && this.dialog.getDialogPane().getButtonTypes().contains((Object)ButtonType.CANCEL)) {
                this.dialog.hide();
                e.consume();
            }
        });
        this.error = new Label();
        if (labelAfterField == null) {
            content.getChildren().addAll((Object[])new Node[]{this.prompt, this.field, this.error});
        } else {
            HBox hbox = new HBox(new Node[]{this.field, new Label(labelAfterField)});
            content.getChildren().addAll((Object[])new Node[]{this.prompt, hbox, this.error});
        }
        this.dialogPane = new DialogPaneAnimateError(this.error, () -> this.validate(this.field.getText(), this.field.getText()));
        this.dialog.setDialogPane((DialogPane)this.dialogPane);
        this.dialog.getDialogPane().setContent((Node)content);
        this.dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        Config.addDialogStylesheets(this.dialog.getDialogPane());
        if (styleClass != null) {
            JavaFXUtil.addStyleClass((Styleable)content, styleClass);
        }
        JavaFXUtil.addStyleClass((Styleable)content, "input-dialog-content");
        JavaFXUtil.addStyleClass((Styleable)this.prompt, "input-dialog-prompt");
        JavaFXUtil.addStyleClass((Styleable)this.field, "input-dialog-field");
        JavaFXUtil.addStyleClass((Styleable)this.error, "dialog-error-label");
        this.field.setTextFormatter(new TextFormatter(change -> {
            if (!change.getControlText().equals(change.getControlNewText()) && !this.validate(change.getControlText(), change.getControlNewText())) {
                change.setRange(0, change.getControlText().length());
                change.setText(change.getControlText());
            }
            return change;
        }));
        this.dialog.setResultConverter(buttonType -> {
            if (buttonType == ButtonType.OK) {
                return this.convert(this.field.getText());
            }
            return null;
        });
    }

    private static String getDetail(String msgID, boolean getTitle) {
        String message = DialogManager.getMessage(msgID, new String[0]);
        if (message != null) {
            int defaultTextIndex = message.lastIndexOf("\n");
            int titleIndex = message.lastIndexOf("\n", defaultTextIndex - 1);
            String defaultText = message.substring(defaultTextIndex + 1);
            String title = message.substring(titleIndex + 1, defaultTextIndex);
            message = message.substring(0, titleIndex);
            if ("null".equals(defaultText)) {
                defaultText = null;
            }
            return getTitle ? title : message;
        }
        return "";
    }

    protected InputDialog(String title, String label, String prompt, String styleClass) {
        this(title, label, prompt, styleClass, null);
    }

    protected InputDialog(String dialogMsgID, String prompt, String styleClass) {
        this(InputDialog.getDetail(dialogMsgID, true), InputDialog.getDetail(dialogMsgID, false).replace("\n", " "), prompt, styleClass);
    }

    public void initOwner(Window parent) {
        this.dialog.initOwner(parent);
    }

    protected void setPrompt(String s) {
        this.prompt.setText(s);
    }

    public Optional<R> showAndWait() {
        Platform.runLater(() -> ((TextField)this.field).requestFocus());
        return this.dialog.showAndWait();
    }

    protected void setErrorText(String errorText) {
        this.error.setText(errorText);
        JavaFXUtil.setPseudoclass("bj-dialog-error", !errorText.equals(""), new Node[]{this.field});
    }

    protected void setOKEnabled(boolean okEnabled) {
        this.dialogPane.getOKButton().setDisable(!okEnabled);
    }

    protected abstract R convert(String var1);

    protected boolean validate(String oldInput, String newInput) {
        return true;
    }
}

