/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.TriangleArrow;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.Styleable;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class UntitledCollapsiblePane
extends Pane {
    private final ArrowLocation arrowLocation;
    private final TriangleArrow arrow;
    private final BorderPane arrowWrapper;
    protected final double arrowPadding = 1.0;
    private final DoubleProperty transitionProperty = new SimpleDoubleProperty(1.0){

        protected void invalidated() {
            UntitledCollapsiblePane.this.requestLayout();
        }
    };
    private final Node content;
    private final Rectangle clipRect;
    private final BooleanProperty expanded = new SimpleBooleanProperty();
    private FXPlatformRunnable cancelHover;
    private Animation animation;

    public UntitledCollapsiblePane(Node content, ArrowLocation arrowLocation, boolean startCollapsed) {
        this.content = content;
        this.arrowLocation = arrowLocation;
        this.arrow = new TriangleArrow(this.isVertical() ? Orientation.VERTICAL : Orientation.HORIZONTAL);
        this.arrowWrapper = new BorderPane((Node)this.arrow);
        this.arrowWrapper.setPadding(new Insets(1.0));
        this.clipRect = new Rectangle();
        this.getChildren().addAll((Object[])new Node[]{this.arrowWrapper, content});
        content.setClip((Node)this.clipRect);
        if (this.isVertical()) {
            this.clipRect.widthProperty().bind((ObservableValue)this.widthProperty());
        } else {
            this.clipRect.heightProperty().bind((ObservableValue)this.heightProperty());
        }
        JavaFXUtil.addStyleClass((Styleable)this, "untitled-pane");
        this.expanded.set(!startCollapsed);
        this.arrowWrapper.setOnMouseClicked(e -> this.expanded.set(!this.expanded.get()));
        this.arrowWrapper.setOnMouseEntered(e -> {
            if (this.cancelHover != null) {
                this.cancelHover.run();
            }
            this.cancelHover = JavaFXUtil.runAfter(Duration.millis((double)200.0), () -> JavaFXUtil.setPseudoclass("bj-hover-long", true, new Node[]{this.arrowWrapper}));
        });
        this.arrowWrapper.setOnMouseExited(e -> {
            if (this.cancelHover != null) {
                this.cancelHover.run();
                this.cancelHover = null;
            }
            JavaFXUtil.setPseudoclass("bj-hover-long", false, new Node[]{this.arrowWrapper});
        });
        if (startCollapsed) {
            this.transitionProperty.set(0.0);
            this.arrow.scaleProperty().set(1.0);
        } else {
            this.transitionProperty.set(1.0);
            this.arrow.scaleProperty().set(-1.0);
        }
        JavaFXUtil.addChangeListener(this.expanded, this::runAnimation);
    }

    public UntitledCollapsiblePane(Node content, ArrowLocation arrowLocation, boolean startCollapsed, FXPlatformConsumer<? super Boolean> listener) {
        this(content, arrowLocation, startCollapsed);
        this.arrowWrapper.setOnMouseClicked(e -> {
            this.expanded.set(!this.expanded.get());
            listener.accept(this.expanded.get());
        });
    }

    private boolean isVertical() {
        return this.arrowLocation == ArrowLocation.TOP;
    }

    private void runAnimation(boolean toExpanded) {
        if (this.animation != null) {
            this.animation.stop();
        }
        double dest = toExpanded ? 1.0 : 0.0;
        double destScale = toExpanded ? -1.0 : 1.0;
        this.animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)300.0), new KeyValue[]{new KeyValue((WritableValue)this.transitionProperty, (Object)dest), new KeyValue((WritableValue)this.arrow.scaleProperty(), (Object)destScale)})});
        this.animation.setOnFinished(ev -> {
            this.animation = null;
        });
        this.animation.playFromStart();
    }

    public BooleanProperty expandedProperty() {
        return this.expanded;
    }

    protected void layoutChildren() {
        this.layoutChildren(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    private void layoutChildren(double x, double y, double w, double h) {
        double arrowSize = this.snapSize(10.0 + 2.0);
        if (this.isVertical()) {
            this.arrowWrapper.resize(w, arrowSize);
        } else {
            this.arrowWrapper.resize(arrowSize, h);
        }
        this.positionInArea((Node)this.arrowWrapper, x, y, this.isVertical() ? w : arrowSize, this.isVertical() ? arrowSize : h, 0.0, HPos.CENTER, VPos.CENTER);
        double contentSize = this.snapSize((this.isVertical() ? h : w) - arrowSize);
        if (this.isVertical()) {
            y += arrowSize;
            this.content.resize(w, contentSize);
            this.clipRect.setHeight(contentSize);
        } else {
            x += arrowSize;
            this.content.resize(contentSize, h);
            this.clipRect.setWidth(contentSize);
        }
        this.positionInArea(this.content, x, y, this.isVertical() ? w : contentSize, this.isVertical() ? contentSize : h, 0.0, HPos.CENTER, VPos.CENTER);
    }

    protected double computePrefWidth(double height) {
        return this.isVertical() ? this.content.prefWidth(height) : this.content.prefWidth(height) * this.getTransition() + 10.0 + 2.0;
    }

    protected double computePrefHeight(double width) {
        return this.isVertical() ? this.content.prefHeight(width) * this.getTransition() + 10.0 + 2.0 : this.content.prefHeight(width);
    }

    protected double computeMinWidth(double height) {
        return this.isVertical() ? this.content.minWidth(height) : this.content.minWidth(height) * this.getTransition() + 10.0 + 2.0;
    }

    protected double computeMinHeight(double width) {
        return this.isVertical() ? this.content.minHeight(width) * this.getTransition() + 10.0 + 2.0 : this.content.minHeight(width);
    }

    private double getTransition() {
        return this.transitionProperty.get();
    }

    public void addArrowWrapperStyleClass(String styleClass) {
        this.arrowWrapper.getStyleClass().add((Object)styleClass);
    }

    public static enum ArrowLocation {
        TOP,
        LEFT;

    }
}

