/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.Config;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.stage.Modality;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform, ignoreParent=true)
public class FXCustomizedDialog<R>
extends Dialog<R> {
    protected FXCustomizedDialog(Window owner, String title, String style) {
        this.initOwner(owner);
        this.initModality(Modality.WINDOW_MODAL);
        this.setTitle(Config.getString(title));
        this.setResizable(true);
        this.setDialogPane(new DialogPane(){

            @OnThread(value=Tag.FXPlatform, ignoreParent=true)
            protected @OnThread(value=Tag.FXPlatform, ignoreParent=true) Node createButtonBar() {
                return FXCustomizedDialog.this.wrapButtonBar(super.createButtonBar());
            }
        });
        JavaFXUtil.addStyleClass((Styleable)this.getDialogPane(), style);
        Config.addDialogStylesheets(this.getDialogPane());
    }

    protected Node wrapButtonBar(Node original) {
        return original;
    }

    protected void setModal(boolean makeModal) {
        this.initModality(makeModal ? Modality.APPLICATION_MODAL : Modality.NONE);
    }

    protected void setContentPane(Node content) {
        this.getDialogPane().setContent(content);
    }

    public Window asWindow() {
        Scene scene = this.getDialogPane().getScene();
        if (scene == null) {
            return null;
        }
        return scene.getWindow();
    }

    public void setLocationRelativeTo(Node comp) {
    }

    @OnThread(value=Tag.FXPlatform)
    public void setLocationRelativeTo(Window window) {
    }

    protected void dialogThenHide(FXPlatformRunnable action) {
        action.run();
        this.hide();
    }
}

