/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Boot;
import bluej.Config;
import bluej.parser.ImportedTypeCompletion;
import bluej.pkgmgr.JavadocResolver;
import bluej.pkgmgr.Project;
import bluej.stride.generic.AssistContentThreadSafe;
import bluej.utility.Debug;
import bluej.utility.Utility;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javafx.application.Platform;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ImportScanner {
    private final Object monitor = new Object();
    private CompletableFuture<RootPackageInfo> root;
    private Reflections reflections;
    private Project project;

    public ImportScanner(Project project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    private CompletableFuture<? extends PackageInfo> getRoot() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.root != null) {
                return this.root;
            }
            this.root = new CompletableFuture();
            new Thread(){

                @Override
                public void run() {
                    RootPackageInfo rootPkg = ImportScanner.this.findAllTypes();
                    try {
                        ImportScanner.this.loadCachedImports(rootPkg);
                    }
                    finally {
                        ImportScanner.this.root.complete(rootPkg);
                    }
                }
            }.start();
            return this.root;
        }
    }

    @OnThread(value=Tag.Worker)
    public List<AssistContentThreadSafe> getImportedTypes(String importSrc, JavadocResolver javadocResolver) {
        try {
            return this.getRoot().get().getImportedTypes("", Arrays.asList(importSrc.split("\\.", -1)).iterator(), javadocResolver);
        }
        catch (InterruptedException | ExecutionException e) {
            Debug.reportError("Exception in getImportedTypes", e);
            return Collections.emptyList();
        }
    }

    @OnThread(value=Tag.Unique)
    private ConfigurationBuilder getClassloaderConfig() {
        ArrayList<ClassLoader> classLoadersList = new ArrayList<ClassLoader>();
        classLoadersList.add(ClasspathHelper.contextClassLoader());
        classLoadersList.add(ClasspathHelper.staticClassLoader());
        try {
            CompletableFuture projectClassLoader = new CompletableFuture();
            Platform.runLater(() -> projectClassLoader.complete(this.project.getClassLoader()));
            classLoadersList.add((ClassLoader)projectClassLoader.get());
        }
        catch (InterruptedException | ExecutionException e) {
            Debug.reportError(e);
        }
        HashSet<URL> urls = new HashSet<URL>();
        urls.addAll(ClasspathHelper.forClassLoader((ClassLoader[])classLoadersList.toArray(new ClassLoader[0])));
        urls.addAll(Arrays.asList(Boot.getInstance().getRuntimeUserClassPath()));
        try {
            urls.add(Boot.getJREJar((String)"rt.jar"));
        }
        catch (MalformedURLException e) {
            Debug.reportError(e);
        }
        urls.removeIf(u -> u.toExternalForm().endsWith("jnilib") || u.toExternalForm().endsWith("zip"));
        urls.removeIf(u -> {
            if ("file".equals(u.getProtocol())) {
                try {
                    File f = new File(u.toURI());
                    if (f.getName().startsWith(".")) {
                        return true;
                    }
                    if (f.getName().endsWith(".so")) {
                        return true;
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            return false;
        });
        URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[0]));
        return new ConfigurationBuilder().setScanners(new Scanner[]{new SubTypesScanner(false)}).setUrls(urls).addClassLoader((ClassLoader)cl).useParallelExecutor();
    }

    @OnThread(value=Tag.Unique)
    private Reflections getReflections(List<String> importSrcs) {
        FilterBuilder filter = new FilterBuilder();
        for (String importSrc : importSrcs) {
            if (importSrc.endsWith(".*")) {
                String importSrcRegex = importSrc.substring(0, importSrc.length() - 1).replace(".", "\\.");
                filter = filter.include(importSrcRegex + ".*");
                continue;
            }
            filter = filter.include(importSrc.replace(".", "\\.") + ".*");
        }
        filter = filter.exclude(".*\\$\\d.*");
        filter = filter.exclude("com\\.sun\\..*");
        try {
            return new Reflections((Configuration)this.getClassloaderConfig().filterInputsBy((Predicate)filter));
        }
        catch (Throwable e) {
            Debug.reportError(e);
            return null;
        }
    }

    @OnThread(value=Tag.Unique)
    private RootPackageInfo findAllTypes() {
        HashSet<String> classes;
        this.reflections = this.getReflections(Collections.emptyList());
        if (this.reflections == null) {
            return new RootPackageInfo();
        }
        try {
            classes = this.reflections.getSubTypeNamesOf(Object.class);
        }
        catch (Throwable t) {
            Debug.reportError(t);
            classes = new HashSet<String>();
        }
        classes.add(Object.class.getName());
        RootPackageInfo r = new RootPackageInfo();
        classes.forEach(c -> r.addClass((String)c));
        return r;
    }

    public void startScanning() {
        this.getRoot();
    }

    public void saveCachedImports() {
        if (this.getRoot().isDone()) {
            Element cache = new Element("packages");
            cache.addAttribute(new Attribute("javaHome", ImportScanner.getJavaHome()));
            cache.addAttribute(new Attribute("version", ImportScanner.getVersion()));
            try {
                PackageInfo javaPkg = this.getRoot().get().subPackages.get("java");
                if (javaPkg != null) {
                    cache.appendChild((Node)ImportScanner.toXML(javaPkg, "java"));
                    FileOutputStream os = new FileOutputStream(ImportScanner.getImportCachePath());
                    Utility.serialiseCodeTo(cache, os);
                    os.close();
                }
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                Debug.reportError(e);
            }
        }
    }

    private static String getVersion() {
        return Config.isGreenfoot() ? Boot.GREENFOOT_VERSION : "4.1.1";
    }

    private static String getJavaHome() {
        return Boot.getInstance().getJavaHome().getAbsolutePath();
    }

    private static File getImportCachePath() {
        return new File(Config.getUserConfigDir(), "import-cache.xml");
    }

    public void loadCachedImports(PackageInfo rootPkg) {
        try {
            Document xml = new Builder().build(ImportScanner.getImportCachePath());
            Element packagesEl = xml.getRootElement();
            if (!packagesEl.getLocalName().equals("packages")) {
                return;
            }
            if (!ImportScanner.getJavaHome().equals(packagesEl.getAttributeValue("javaHome")) || !ImportScanner.getVersion().equals(packagesEl.getAttributeValue("version"))) {
                return;
            }
            for (int i = 0; i < packagesEl.getChildElements().size(); ++i) {
                this.fromXML(packagesEl.getChildElements().get(i), rootPkg);
            }
        }
        catch (IOException | ParsingException e) {
            Debug.message(e.getClass().getName() + " while reading import cache: " + e.getMessage());
        }
    }

    private void fromXML(Element pkgEl, PackageInfo addToParent) {
        String name = pkgEl.getAttributeValue("name");
        if (name == null) {
            return;
        }
        PackageInfo loadPkg = new PackageInfo();
        for (int i = 0; i < pkgEl.getChildElements().size(); ++i) {
            Element el = pkgEl.getChildElements().get(i);
            if (el.getLocalName().equals("package")) {
                this.fromXML(el, loadPkg);
                continue;
            }
            AssistContentThreadSafe acts = new AssistContentThreadSafe(el);
            String nameWithoutPackage = (acts.getDeclaringClass() == null ? "" : acts.getDeclaringClass() + "$") + acts.getName();
            loadPkg.types.put(nameWithoutPackage, acts);
        }
        addToParent.subPackages.putIfAbsent(name, new PackageInfo());
        addToParent.subPackages.get(name).addTypes(loadPkg);
    }

    private static Element toXML(PackageInfo pkg, String name) {
        Element el = new Element("package");
        el.addAttribute(new Attribute("name", name));
        pkg.types.values().forEach(acts -> {
            if (acts != null) {
                el.appendChild((Node)acts.toXML());
            }
        });
        pkg.subPackages.forEach((subName, subPkg) -> el.appendChild((Node)ImportScanner.toXML(subPkg, subName)));
        return el;
    }

    private class RootPackageInfo
    extends PackageInfo {
        private RootPackageInfo() {
        }

        public void addClass(String name) {
            String[] splitParts = name.split("\\.", -1);
            this.addClass(Arrays.asList(Arrays.copyOf(splitParts, splitParts.length - 1)).iterator(), splitParts[splitParts.length - 1]);
        }
    }

    private class PackageInfo {
        public final HashMap<String, AssistContentThreadSafe> types = new HashMap();
        public final HashMap<String, PackageInfo> subPackages = new HashMap();

        private PackageInfo() {
        }

        protected void addClass(Iterator<String> packageIdents, String name) {
            if (packageIdents.hasNext()) {
                String ident = packageIdents.next();
                PackageInfo subPkg = this.subPackages.get(ident);
                if (subPkg == null) {
                    subPkg = new PackageInfo();
                    this.subPackages.put(ident, subPkg);
                }
                subPkg.addClass(packageIdents, name);
            } else {
                this.types.put(name, null);
            }
        }

        @OnThread(value=Tag.Worker)
        private AssistContentThreadSafe getType(String prefix, String name, JavadocResolver javadocResolver) {
            return this.types.computeIfAbsent(name, s -> {
                try {
                    Class c = ImportScanner.this.reflections.typeNameToClass(prefix + s);
                    CompletableFuture f = new CompletableFuture();
                    Platform.runLater(() -> f.complete(new AssistContentThreadSafe(new ImportedTypeCompletion(c, javadocResolver))));
                    return (AssistContentThreadSafe)f.get();
                }
                catch (ReflectionsException e) {
                    return null;
                }
                catch (Exception e) {
                    Debug.reportError(e);
                    return null;
                }
            });
        }

        @OnThread(value=Tag.Worker)
        public List<AssistContentThreadSafe> getImportedTypes(String prefix, Iterator<String> idents, JavadocResolver javadocResolver) {
            if (!idents.hasNext()) {
                return Collections.emptyList();
            }
            String s = idents.next();
            if (s.equals("*")) {
                ArrayList<String> typeNames = new ArrayList<String>(this.types.keySet());
                return typeNames.stream().map(t -> this.getType(prefix, (String)t, javadocResolver)).filter(ac -> ac != null).collect(Collectors.toList());
            }
            if (idents.hasNext()) {
                if (this.subPackages.containsKey(s)) {
                    return this.subPackages.get(s).getImportedTypes(prefix + s + ".", idents, javadocResolver);
                }
                return Collections.emptyList();
            }
            AssistContentThreadSafe ac2 = this.getType(prefix, s, javadocResolver);
            if (ac2 != null) {
                return Collections.singletonList(ac2);
            }
            return Collections.emptyList();
        }

        public void addTypes(PackageInfo from) {
            this.types.putAll(from.types);
            from.subPackages.forEach((name, pkg) -> {
                this.subPackages.putIfAbsent((String)name, new PackageInfo());
                this.subPackages.get(name).addTypes((PackageInfo)pkg);
            });
        }
    }
}

