/*
 * Decompiled with CFR 0.152.
 */
package bluej.terminal;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.BlueJTheme;
import bluej.Config;
import bluej.collect.DataCollector;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerTerminal;
import bluej.debugmgr.ExecutionEvent;
import bluej.editor.moe.MoeEditor;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.terminal.ExceptionSourceLocation;
import bluej.terminal.InputBuffer;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.utility.Utility;
import bluej.utility.javafx.JavaFXUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.CharacterHit;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.StyledTextArea;
import org.fxmisc.richtext.TextExt;
import org.fxmisc.richtext.model.EditableStyledDocument;
import org.fxmisc.richtext.model.GenericEditableStyledDocument;
import org.fxmisc.richtext.model.NavigationActions;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledText;
import org.fxmisc.richtext.model.TextOps;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import threadchecker.OnThread;
import threadchecker.Tag;

public final class Terminal
implements BlueJEventListener,
DebuggerTerminal {
    private static final int MAX_BUFFER_LINES = 200;
    private VirtualizedScrollPane<?> errorScrollPane;
    private static final String WINDOWTITLE = Config.getApplicationName() + ": " + Config.getString("terminal.title");
    private static final String RECORDMETHODCALLSPROPNAME = "bluej.terminal.recordcalls";
    private static final String CLEARONMETHODCALLSPROPNAME = "bluej.terminal.clearscreen";
    private static final String UNLIMITEDBUFFERINGCALLPROPNAME = "bluej.terminal.buffering";
    private final String title;
    private final Project project;
    private final StyledTextArea<Void, StdoutStyle> text;
    private StyledTextArea<Void, StderrStyle> errorText = null;
    private final TextField input;
    private final SplitPane splitPane;
    private boolean isActive = false;
    private static BooleanProperty recordMethodCalls = Config.getPropBooleanProperty("bluej.terminal.recordcalls");
    private static BooleanProperty clearOnMethodCall = Config.getPropBooleanProperty("bluej.terminal.clearscreen");
    private static BooleanProperty unlimitedBufferingCall = Config.getPropBooleanProperty("bluej.terminal.buffering");
    private boolean newMethodCall = true;
    private boolean errorShown = false;
    private final InputBuffer buffer;
    private final BooleanProperty showingProperty = new SimpleBooleanProperty(false);
    private final @OnThread(value=Tag.Any) Reader in = new TerminalReader();
    private final @OnThread(value=Tag.Any) Writer out = new TerminalWriter(false);
    private final @OnThread(value=Tag.Any) Writer err = new TerminalWriter(true);
    private Stage window;

    public Terminal(Project project) {
        this.title = WINDOWTITLE + " - " + project.getProjectName();
        this.project = project;
        this.buffer = new InputBuffer(256);
        this.text = new StyledTextArea(null, (t, v) -> {}, (Object)StdoutStyle.OUTPUT, this::applyStyle);
        VirtualizedScrollPane scrollPane = new VirtualizedScrollPane(this.text);
        this.text.setEditable(false);
        this.text.getStyleClass().add((Object)"terminal");
        this.text.styleProperty().bind((ObservableValue)PrefMgr.getEditorFontCSS(true));
        unlimitedBufferingCall.addListener(c -> this.trimToMaxBufferLines(this.text));
        this.input = new TextField();
        this.input.getStyleClass().add((Object)"terminal-input-field");
        this.input.setOnAction(e -> {
            this.sendInput(false);
            e.consume();
        });
        this.input.styleProperty().bind((ObservableValue)PrefMgr.getEditorFontCSS(true));
        this.input.setEditable(false);
        this.input.disableProperty().bind((ObservableValue)this.input.editableProperty().not());
        this.input.promptTextProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.input.editableProperty()).then(Config.getString("terminal.running")).otherwise(Config.getString("terminal.notRunning")));
        Nodes.addInputMap((Node)this.input, (InputMap)InputMap.sequence((InputMap[])new InputMap[]{InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.D, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN})), e -> {
            this.sendInput(true);
            e.consume();
        }), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN})), e -> {
            this.sendInput(true);
            e.consume();
        }), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.EQUALS, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN})), e -> Utility.increaseFontSize(PrefMgr.getEditorFontSize())), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.MINUS, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN})), e -> Utility.decreaseFontSize(PrefMgr.getEditorFontSize())), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT0, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN})), e -> PrefMgr.getEditorFontSize().set(10))}));
        this.text.setOnMouseClicked(e -> {
            if (e.getButton() == MouseButton.PRIMARY) {
                this.input.requestFocus();
                e.consume();
            }
        });
        this.splitPane = new SplitPane(new Node[]{new BorderPane((Node)scrollPane, null, null, (Node)this.input, null)});
        JavaFXUtil.addStyleClass((Styleable)this.splitPane, "terminal-split");
        BorderPane mainPanel = new BorderPane();
        mainPanel.setCenter((Node)this.splitPane);
        mainPanel.setTop((Node)this.makeMenuBar());
        this.window = new Stage();
        this.window.setWidth(500.0);
        this.window.setHeight(500.0);
        BlueJTheme.setWindowIconFX(this.window);
        this.window.setTitle(this.title);
        Scene scene = new Scene((Parent)mainPanel);
        Config.addTerminalStylesheets(scene);
        this.window.setScene(scene);
        this.window.setOnCloseRequest(e -> {
            e.consume();
            if (project != null && project.getDebugger().getStatus() == 3) {
                return;
            }
            this.showHide(false);
        });
        this.window.setOnShown(e -> this.showingProperty.set(true));
        this.window.setOnHidden(e -> this.showingProperty.set(false));
        JavaFXUtil.addChangeListenerPlatform(this.showingProperty, this::showHide);
        Config.loadAndTrackPositionAndSize((Window)this.window, "bluej.terminal");
        BlueJEvent.addListener(this);
    }

    private void sendInput(boolean eof) {
        String inputString = this.input.getText() + "\n";
        this.buffer.putString(inputString);
        if (eof) {
            this.buffer.signalEOF();
        } else {
            this.buffer.notifyReaders();
        }
        this.input.clear();
        this.writeToPane(this.text, inputString, StdoutStyle.INPUT);
    }

    private void applyStyle(TextExt t, TextAreaStyle s) {
        JavaFXUtil.addStyleClass((Styleable)t, s.getCSSClass());
    }

    public void showHide(boolean show) {
        DataCollector.showHideTerminal(this.project, show);
        if (show) {
            this.window.show();
            this.input.requestFocus();
        } else {
            this.window.hide();
        }
    }

    public void dispose() {
        this.showHide(false);
        this.window = null;
    }

    public boolean isShown() {
        return this.window.isShowing();
    }

    public void activate(boolean active) {
        if (active != this.isActive) {
            this.input.setEditable(active);
            this.isActive = active;
        }
    }

    public void clear() {
        this.text.replaceText("");
        if (this.errorText != null) {
            this.errorText.replaceText("");
        }
        this.hideErrorPane();
    }

    public void save() {
        File fileName = FileUtility.getSaveFileFX((Window)this.window, Config.getString("terminal.save.title"), null, false);
        if (fileName != null) {
            if (fileName.exists() && DialogManager.askQuestionFX((Window)this.window, "error-file-exists") != 0) {
                return;
            }
            try {
                FileWriter writer = new FileWriter(fileName);
                writer.write(this.text.getText());
                writer.close();
            }
            catch (IOException ex) {
                DialogManager.showErrorFX((Window)this.window, "error-save-file");
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void print() {
        final PrinterJob job = JavaFXUtil.createPrinterJob();
        if (job == null) {
            DialogManager.showErrorFX((Window)this.window, "print-no-printers");
        } else if (job.showPrintDialog((Window)this.window)) {
            GenericEditableStyledDocument doc = new GenericEditableStyledDocument(null, (Object)StdoutStyle.OUTPUT, StyledText.textOps());
            doc.replace(0, 0, (StyledDocument)ReadOnlyStyledDocument.from((StyledDocument)this.text.getDocument()));
            final StyledTextArea offScreenEditor = new StyledTextArea(null, (t, v) -> {}, (Object)StdoutStyle.OUTPUT, this::applyStyle, (EditableStyledDocument)doc);
            Scene scene = new Scene((Parent)offScreenEditor);
            Config.addTerminalStylesheets(scene);
            double pixelWidth = job.getJobSettings().getPageLayout().getPrintableWidth();
            double pixelHeight = job.getJobSettings().getPageLayout().getPrintableHeight();
            offScreenEditor.resize(pixelWidth, pixelHeight);
            offScreenEditor.setWrapText(true);
            offScreenEditor.requestLayout();
            offScreenEditor.layout();
            offScreenEditor.applyCss();
            final VirtualFlow virtualFlow = (VirtualFlow)offScreenEditor.lookup(".virtual-flow");
            new Thread(new Runnable(){

                @Override
                @OnThread(value=Tag.FX, ignoreParent=true)
                public void run() {
                    MoeEditor.printPages((PrinterJob)job, (GenericStyledArea)offScreenEditor, (VirtualFlow)virtualFlow);
                    job.endJob();
                }
            }).start();
        }
    }

    private <S extends TextAreaStyle> void writeToPane(StyledTextArea<Void, S> pane, String s, S style) {
        int n;
        this.prepare();
        if (pane == this.errorText) {
            this.showErrorPane();
        }
        if ((n = s.lastIndexOf(12)) != -1) {
            this.clear();
            s = s.substring(n + 1);
        }
        pane.append(Terminal.styled(s, style));
        if (pane != this.errorText) {
            this.trimToMaxBufferLines(pane);
        }
        pane.end(NavigationActions.SelectionPolicy.CLEAR);
        pane.requestFollowCaret();
    }

    private <S extends TextAreaStyle> void trimToMaxBufferLines(StyledTextArea<Void, S> pane) {
        if (!unlimitedBufferingCall.get() && pane.getParagraphs().size() >= 200) {
            int newStart = pane.position(pane.getParagraphs().size() - 200, 0).toOffset();
            pane.replaceText(0, newStart, "");
        }
    }

    private void prepare() {
        if (this.newMethodCall) {
            this.showHide(true);
            this.newMethodCall = false;
        } else if (Config.isGreenfoot() && !this.window.isShowing()) {
            this.showHide(true);
        }
    }

    private void methodCall(String callString) {
        this.newMethodCall = false;
        if (clearOnMethodCall.get()) {
            this.clear();
        }
        if (recordMethodCalls.get()) {
            this.text.append(Terminal.styled(callString + "\n", StdoutStyle.METHOD_RECORDING));
        }
        this.newMethodCall = true;
    }

    private static <S> ReadOnlyStyledDocument<Void, StyledText<S>, S> styled(String text, S style) {
        return ReadOnlyStyledDocument.fromString((String)text, null, style, (TextOps)StyledText.textOps());
    }

    private void constructorCall(InvokerRecord ir) {
        this.newMethodCall = false;
        if (clearOnMethodCall.get()) {
            this.clear();
        }
        if (recordMethodCalls.get()) {
            String callString = ir.getResultTypeString() + " " + ir.getResultName() + " = " + ir.toExpression() + ";";
            this.text.append(Terminal.styled(callString + "\n", StdoutStyle.METHOD_RECORDING));
        }
        this.newMethodCall = true;
    }

    private void methodResult(ExecutionEvent event) {
        if (recordMethodCalls.get()) {
            String result = null;
            String resultType = event.getResult();
            if (resultType == "Normal exit") {
                DebuggerObject object = event.getResultObject();
                if (object != null) {
                    if (event.getClassName() != null && event.getMethodName() == null) {
                        return;
                    }
                    if (object.isNullObject()) {
                        return;
                    }
                    DebuggerField resultField = object.getField(0);
                    result = "    returned " + resultField.getType().toString(true) + " ";
                    result = result + resultField.getValueString();
                }
            } else if (resultType == "An exception occurred") {
                result = "    Exception occurred.";
            } else if (resultType == "User terminated") {
                result = "    VM terminated.";
            }
            if (result != null) {
                this.text.append(Terminal.styled(result + "\n", StdoutStyle.METHOD_RECORDING));
            }
        }
    }

    private void scanForStackTrace() {
        try {
            String content = this.errorText.getText();
            Pattern p = Pattern.compile("at (\\S+)\\((\\S+)\\.java:(\\d+)\\)");
            Matcher m = p.matcher(content);
            while (m.find()) {
                String fullyQualifiedMethodName = m.group(1);
                String javaFile = m.group(2);
                int lineNumber = Integer.parseInt(m.group(3));
                String fullyQualifiedClassName = JavaNames.getPrefix(fullyQualifiedMethodName);
                String packageName = JavaNames.getPrefix(fullyQualifiedClassName);
                Package pkg = this.project.getPackage(packageName);
                if (pkg != null && pkg.getAllClassnames().contains(javaFile)) {
                    this.errorText.setStyle(m.start(1), m.end(), (Object)new StderrStyle(new ExceptionSourceLocation(m.start(1), m.end(), pkg, javaFile, lineNumber)));
                    continue;
                }
                this.errorText.setStyle(m.start(), m.end(), (Object)StderrStyle.FOREIGN_STACK_TRACE);
            }
            p = Pattern.compile("at \\S+\\((Native Method|Unknown Source)\\)");
            m = p.matcher(content);
            while (m.find()) {
                this.errorText.setStyle(m.start(), m.end(), (Object)StderrStyle.FOREIGN_STACK_TRACE);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    @Override
    @OnThread(value=Tag.Any, ignoreParent=true)
    public @OnThread(value=Tag.Any, ignoreParent=true) Reader getReader() {
        return this.in;
    }

    @Override
    @OnThread(value=Tag.Any, ignoreParent=true)
    public @OnThread(value=Tag.Any, ignoreParent=true) Writer getWriter() {
        return this.out;
    }

    @Override
    @OnThread(value=Tag.Any)
    public void showOnInput() {
        Platform.runLater(() -> {
            if (!this.isShown()) {
                this.showHide(true);
            }
            if (this.isShown()) {
                Utility.bringToFrontFX((Window)this.window);
                this.input.requestFocus();
            }
        });
    }

    @Override
    @OnThread(value=Tag.Any, ignoreParent=true)
    public @OnThread(value=Tag.Any, ignoreParent=true) Writer getErrorWriter() {
        return this.err;
    }

    @Override
    public void blueJEvent(int eventId, Object arg) {
        if (eventId == 3) {
            InvokerRecord ir = (InvokerRecord)arg;
            if (ir.getResultName() != null) {
                this.constructorCall(ir);
            } else {
                boolean isVoid = ir.hasVoidResult();
                if (isVoid) {
                    this.methodCall(ir.toStatement());
                } else {
                    this.methodCall(ir.toExpression());
                }
            }
        } else if (eventId == 5) {
            this.methodResult((ExecutionEvent)arg);
        }
    }

    private void showErrorPane() {
        if (this.errorShown) {
            return;
        }
        if (this.errorText == null) {
            this.errorText = new StyledTextArea(null, (t, v) -> {}, (Object)StderrStyle.NORMAL, this::applyStyle);
            this.errorText.getStyleClass().add((Object)"terminal-error");
            this.errorScrollPane = new VirtualizedScrollPane(this.errorText);
            this.errorText.styleProperty().bind((ObservableValue)PrefMgr.getEditorFontCSS(true));
            this.errorText.setEditable(false);
            this.errorText.plainTextChanges().subscribe(c -> this.scanForStackTrace());
            Consumer<MouseEvent> onClick = e -> {
                CharacterHit hit = this.errorText.hit(e.getX(), e.getY());
                StderrStyle style = (StderrStyle)this.errorText.getStyleAtPosition(hit.getInsertionIndex());
                if (style.exceptionSourceLocation != null) {
                    style.exceptionSourceLocation.showInEditor();
                } else {
                    this.errorText.moveTo(hit.getInsertionIndex(), NavigationActions.SelectionPolicy.CLEAR);
                }
            };
            this.errorText.setOnOutsideSelectionMousePress(onClick);
            this.errorText.setOnInsideSelectionMousePressRelease(onClick);
        }
        this.splitPane.getItems().add(this.errorScrollPane);
        Config.rememberDividerPosition((Window)this.window, this.splitPane, "bluej.terminal.dividerpos");
        this.errorShown = true;
    }

    private void hideErrorPane() {
        if (!this.errorShown) {
            return;
        }
        this.splitPane.getItems().remove(this.errorScrollPane);
        this.errorShown = false;
    }

    public BooleanProperty showingProperty() {
        return this.showingProperty;
    }

    private MenuBar makeMenuBar() {
        MenuBar menubar = new MenuBar();
        menubar.setUseSystemMenuBar(true);
        Menu menu = new Menu(Config.getString("terminal.options"));
        MenuItem clearItem = new MenuItem(Config.getString("terminal.clear"));
        clearItem.setOnAction(e -> this.clear());
        clearItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.K, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        MenuItem copyItem = new MenuItem(Config.getString("terminal.copy"));
        copyItem.setOnAction(e -> this.text.copy());
        copyItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        MenuItem saveItem = new MenuItem(Config.getString("terminal.save"));
        saveItem.setOnAction(e -> this.save());
        saveItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        MenuItem printItem = new MenuItem(Config.getString("terminal.print"));
        printItem.setOnAction(e -> this.print());
        printItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        menu.getItems().addAll((Object[])new MenuItem[]{clearItem, copyItem, saveItem, printItem, new SeparatorMenuItem()});
        CheckMenuItem autoClear = new CheckMenuItem(Config.getString("terminal.clearScreen"));
        autoClear.selectedProperty().bindBidirectional((Property)clearOnMethodCall);
        CheckMenuItem recordCalls = new CheckMenuItem(Config.getString("terminal.recordCalls"));
        recordCalls.selectedProperty().bindBidirectional((Property)recordMethodCalls);
        CheckMenuItem unlimitedBuffering = new CheckMenuItem(Config.getString("terminal.buffering"));
        unlimitedBuffering.selectedProperty().bindBidirectional((Property)unlimitedBufferingCall);
        menu.getItems().addAll((Object[])new MenuItem[]{autoClear, recordCalls, unlimitedBuffering});
        MenuItem closeItem = new MenuItem(Config.getString("terminal.close"));
        closeItem.setOnAction(e -> this.showHide(false));
        closeItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        menu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), closeItem});
        menubar.getMenus().add((Object)menu);
        return menubar;
    }

    public void cleanup() {
        BlueJEvent.removeListener(this);
    }

    @OnThread(value=Tag.Any)
    private class TerminalWriter
    extends Writer {
        private boolean isErrorOut;

        TerminalWriter(boolean isError) {
            this.isErrorOut = isError;
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            try {
                CompletableFuture written = new CompletableFuture();
                Platform.runLater(() -> {
                    try {
                        String s = new String(cbuf, off, len);
                        if (this.isErrorOut) {
                            Terminal.this.showErrorPane();
                            Terminal.this.writeToPane(Terminal.this.errorText, s, StderrStyle.NORMAL);
                        } else {
                            Terminal.this.writeToPane(Terminal.this.text, s, StdoutStyle.OUTPUT);
                        }
                    }
                    finally {
                        written.complete(true);
                    }
                });
                written.get(2000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ie) {
                Debug.reportError(ie);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    @OnThread(value=Tag.Any)
    private class TerminalReader
    extends Reader {
        private TerminalReader() {
        }

        @Override
        public int read(char[] cbuf, int off, int len) {
            int charsRead;
            for (charsRead = 0; charsRead < len; ++charsRead) {
                cbuf[off + charsRead] = Terminal.this.buffer.getChar();
                if (!Terminal.this.buffer.isEmpty()) continue;
                break;
            }
            return charsRead;
        }

        @Override
        public boolean ready() {
            return !Terminal.this.buffer.isEmpty();
        }

        @Override
        public void close() {
        }
    }

    private static class StderrStyle
    implements TextAreaStyle {
        private final StderrStyleType type;
        private final ExceptionSourceLocation exceptionSourceLocation;
        public static final StderrStyle NORMAL = new StderrStyle(StderrStyleType.NORMAL);
        public static final StderrStyle FOREIGN_STACK_TRACE = new StderrStyle(StderrStyleType.FOREIGN_STACK_TRACE);

        private StderrStyle(StderrStyleType type) {
            this.type = type;
            this.exceptionSourceLocation = null;
        }

        public StderrStyle(ExceptionSourceLocation exceptionSourceLocation) {
            this.type = StderrStyleType.LINKED_STACK_TRACE;
            this.exceptionSourceLocation = exceptionSourceLocation;
        }

        @Override
        public String getCSSClass() {
            return this.type.getCSSClass();
        }
    }

    private static enum StderrStyleType {
        NORMAL("terminal-error"),
        LINKED_STACK_TRACE("terminal-stack-link"),
        FOREIGN_STACK_TRACE("terminal-stack-foreign");

        private final String cssClass;

        private StderrStyleType(String cssClass) {
            this.cssClass = cssClass;
        }

        public String getCSSClass() {
            return this.cssClass;
        }
    }

    private static enum StdoutStyle implements TextAreaStyle
    {
        OUTPUT("terminal-output"),
        INPUT("terminal-input"),
        METHOD_RECORDING("terminal-method-record");

        private final String cssClass;

        private StdoutStyle(String cssClass) {
            this.cssClass = cssClass;
        }

        @Override
        public String getCSSClass() {
            return this.cssClass;
        }
    }

    private static interface TextAreaStyle {
        public String getCSSClass();
    }
}

