/*
 * Decompiled with CFR 0.152.
 */
package bluej.terminal;

import java.awt.Toolkit;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public final class InputBuffer {
    private char[] buffer;
    private int bufferNextFull = 0;
    private int bufferNextFree = 0;
    private int bufferSize;
    private boolean eofMark = false;
    public static char EOF_CHAR = (char)4;

    public InputBuffer(int size) {
        this.buffer = new char[size];
        this.bufferSize = size;
    }

    public synchronized boolean putChar(char ch) {
        if (this.isFull()) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        this.buffer[this.bufferNextFree] = ch;
        this.bufferNextFree = this.advance(this.bufferNextFree);
        return true;
    }

    public synchronized boolean putString(String input) {
        boolean putAny = false;
        for (char c : input.toCharArray()) {
            putAny = this.putChar(c) || putAny;
        }
        return putAny;
    }

    public synchronized boolean backSpace() {
        if (!this.isEmpty()) {
            this.bufferNextFree = this.backwards(this.bufferNextFree);
            return true;
        }
        Toolkit.getDefaultToolkit().beep();
        return false;
    }

    public synchronized char getChar() {
        while (this.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return '\n';
            }
        }
        char ch = this.buffer[this.bufferNextFull];
        this.bufferNextFull = this.advance(this.bufferNextFull);
        if (this.eofMark) {
            this.eofMark = false;
            this.putChar(EOF_CHAR);
            this.notifyReaders();
        }
        return ch;
    }

    public synchronized void signalEOF() {
        if (!this.isFull()) {
            this.putChar(EOF_CHAR);
        } else {
            this.eofMark = true;
        }
        this.notifyReaders();
    }

    public synchronized void notifyReaders() {
        this.notify();
    }

    public synchronized boolean isEmpty() {
        return this.bufferNextFull == this.bufferNextFree;
    }

    private boolean isFull() {
        return this.advance(this.bufferNextFree) == this.bufferNextFull;
    }

    private int advance(int pos) {
        return ++pos % this.bufferSize;
    }

    private int backwards(int pos) {
        return --pos < 0 ? this.bufferSize - 1 : pos;
    }
}

