/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.operations;

import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.operations.AbstractOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.EditableSlot;
import java.util.Arrays;
import java.util.List;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCombination;
import threadchecker.OnThread;
import threadchecker.Tag;

public class DisableFrameOperation
extends FrameOperation {
    public DisableFrameOperation(InteractionManager editor) {
        super(editor, "DISABLE", AbstractOperation.Combine.ANY, (KeyCombination)new KeyCharacterCombination("\\", new KeyCombination.Modifier[0]));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void enablePreview() {
        this.editor.getSelection().getSelected().forEach(frame -> frame.setFrameEnablePreview(Frame.FramePreviewEnabled.PREVIEW_DISABLED));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void disablePreview() {
        this.editor.getSelection().getSelected().forEach(frame -> frame.setFrameEnablePreview(Frame.FramePreviewEnabled.PREVIEW_NONE));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    protected void execute(List<Frame> frames) {
        frames.forEach(frame -> frame.setFrameEnabled(false));
    }

    @Override
    public List<AbstractOperation.ItemLabel> getLabels() {
        return Arrays.asList(this.l("Disable", EditableSlot.MenuItemOrder.DISABLE_FRAME));
    }

    @Override
    public boolean onlyOnContextMenu() {
        return true;
    }
}

