/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.Config;
import bluej.parser.entity.EntityResolver;
import bluej.stride.framedjava.ast.JavadocUnit;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ImportElement;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.ImportFrame;
import bluej.stride.framedjava.frames.StrideDictionary;
import bluej.stride.framedjava.frames.TopLevelFrame;
import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.DocumentedMultiCanvasFrame;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentItem;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameTypeCheck;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.RecallableFocus;
import bluej.stride.slots.ClassNameDefTextSlot;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.Focus;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.SlotLabel;
import bluej.stride.slots.SlotTraversalChars;
import bluej.stride.slots.TextSlot;
import bluej.stride.slots.TriangleLabel;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.MultiListener;
import bluej.utility.javafx.SharedTransition;
import bluej.utility.javafx.binding.DeepListBinding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class TopLevelDocumentMultiCanvasFrame<ELEMENT extends CodeElement>
extends DocumentedMultiCanvasFrame
implements TopLevelFrame<ELEMENT> {
    protected final InteractionManager editor;
    protected final EntityResolver projectResolver;
    private final String stylePrefix;
    protected @OnThread(value=Tag.Any, requireSynchronized=true) ELEMENT element;
    protected FrameContentRow packageRow;
    protected SlotLabel packageNameLabel;
    protected final FrameContentRow importRow;
    protected final FrameCanvas importCanvas;
    protected final ObservableList<String> boundImports = FXCollections.observableArrayList();
    protected final SlotLabel importsLabel;
    protected final TriangleLabel importTriangleLabel;
    protected TextSlot<NameDefSlotFragment> paramName;
    protected final FrameCanvas fieldsCanvas;
    protected final FrameCanvas methodsCanvas;
    protected final SlotLabel fieldsLabel;
    protected final SlotLabel methodsLabel;
    protected final FrameContentRow fieldsLabelRow;
    protected final FrameContentRow methodsLabelRow;
    protected final FrameContentItem endSpacer;

    public TopLevelDocumentMultiCanvasFrame(InteractionManager editor, EntityResolver projectResolver, String caption, String stylePrefix, String packageName, List<ImportElement> imports, JavadocUnit documentation, NameDefSlotFragment topLevelFrameName, boolean enabled) {
        super(editor, caption, stylePrefix);
        this.editor = editor;
        this.projectResolver = projectResolver;
        this.stylePrefix = stylePrefix;
        this.endSpacer = new FrameContentItem(){
            private Rectangle r = new Rectangle(1.0, 200.0, (Paint)Color.TRANSPARENT);

            @Override
            public Stream<HeaderItem> getHeaderItemsDeep() {
                return Stream.empty();
            }

            @Override
            public Stream<HeaderItem> getHeaderItemsDirect() {
                return Stream.empty();
            }

            @Override
            public Bounds getSceneBounds() {
                return this.r.localToScene(this.r.getBoundsInLocal());
            }

            @Override
            public Optional<FrameCanvas> getCanvas() {
                return Optional.empty();
            }

            @Override
            public boolean focusLeftEndFromPrev() {
                return false;
            }

            @Override
            public boolean focusRightEndFromNext() {
                return false;
            }

            @Override
            public boolean focusTopEndFromPrev() {
                return false;
            }

            @Override
            public boolean focusBottomEndFromNext() {
                return false;
            }

            @Override
            public void setView(Frame.View oldView, Frame.View newView, SharedTransition animation) {
            }

            @Override
            public Node getNode() {
                return this.r;
            }
        };
        if (Config.isGreenfoot()) {
            this.packageRow = null;
            this.packageNameLabel = null;
        } else if (packageName != null && !packageName.isEmpty()) {
            this.packageRow = new FrameContentRow((Frame)this, new HeaderItem[0]);
            this.packageNameLabel = new SlotLabel(packageName, "package-slot-");
            this.packageRow.bindContentsConcat((ObservableList<ObservableList<? extends HeaderItem>>)FXCollections.observableArrayList((Object[])new ObservableList[]{FXCollections.observableArrayList((Object[])new SlotLabel[]{new SlotLabel("package ", new String[0]), this.packageNameLabel})}));
        }
        this.importsLabel = this.makeLabel("Imports");
        this.fieldsLabel = this.makeLabel("Fields");
        this.methodsLabel = this.makeLabel("Methods");
        this.importCanvas = this.createImportsCanvas(imports);
        this.importCanvas.getShowingProperty().set(false);
        JavaFXUtil.addChangeListener(this.importCanvas.getShowingProperty(), showing -> {
            if (!showing.booleanValue() && this.isCanvasHasFocus(this.importCanvas)) {
                this.getfieldsCanvas().getFirstCursor().requestFocus();
            }
        });
        this.importTriangleLabel = new TriangleLabel(editor, t -> this.importCanvas.growUsing(t.getProgress()), t -> this.importCanvas.shrinkUsing(t.getOppositeProgress()), this.importCanvas.getShowingProperty());
        JavaFXUtil.addChangeListener(this.importTriangleLabel.expandedProperty(), b -> editor.updateErrorOverviewBar());
        this.importRow = new FrameContentRow((Frame)this, this.importsLabel, this.importTriangleLabel);
        Properties localProperties = new Properties();
        localProperties.put("CAPTION", caption);
        this.paramName = new ClassNameDefTextSlot(editor, this, this.getHeaderRow(), stylePrefix + "name-");
        this.paramName.addValueListener(SlotTraversalChars.IDENTIFIER);
        this.paramName.setPromptText(Config.getString("frame.editor.param.prompt", null, localProperties));
        this.paramName.setText(topLevelFrameName);
        localProperties.put("CLASSNAME", this.paramName.textProperty().get());
        this.setDocumentation(documentation.toString());
        this.documentationPromptTextProperty().bind((ObservableValue)new SimpleStringProperty(Config.getString("frame.editor.toplevel.doc.prompt", null, localProperties)));
        this.fieldsCanvas = new FrameCanvas(editor, this, stylePrefix + "fields-");
        this.fieldsLabelRow = new FrameContentRow((Frame)this, this.fieldsLabel);
        this.addCanvas(this.fieldsLabelRow, this.fieldsCanvas);
        this.methodsCanvas = new FrameCanvas(editor, this, stylePrefix);
        this.methodsLabelRow = new FrameContentRow((Frame)this, this.methodsLabel);
        this.addCanvas(this.methodsLabelRow, this.methodsCanvas);
        this.frameEnabledProperty.set(enabled);
    }

    protected boolean isCanvasHasFocus(FrameCanvas canvas) {
        if (canvas.getFocusableCursors().stream().anyMatch(c -> c.isFocused())) {
            return true;
        }
        return canvas.getBlockContents().stream().anyMatch(b -> b.getFocusablesInclContained().anyMatch(s -> s.isFocused()));
    }

    protected SlotLabel makeLabel(String content) {
        SlotLabel l = new SlotLabel(content, new String[0]);
        JavaFXUtil.addStyleClass((Styleable)l, this.stylePrefix + "section-label");
        return l;
    }

    @Override
    public boolean canDrag() {
        return false;
    }

    protected List<CodeElement> getMembers(FrameCanvas frameCanvas) {
        ArrayList<CodeElement> members = new ArrayList<CodeElement>();
        for (CodeFrame c : frameCanvas.getBlocksSubtype(CodeFrame.class)) {
            c.regenerateCode();
            members.add((CodeElement)c.getCode());
        }
        return members;
    }

    private FrameCanvas createImportsCanvas(List<ImportElement> imports) {
        final FrameCanvas importCanvas = new FrameCanvas(this.editor, new CanvasParent(){

            @Override
            public FrameCursor findCursor(double sceneX, double sceneY, FrameCursor prevCursor, FrameCursor nextCursor, List<Frame> exclude, boolean isDrag, boolean canDescend) {
                return TopLevelDocumentMultiCanvasFrame.this.importCanvas.findClosestCursor(sceneX, sceneY, exclude, isDrag, canDescend);
            }

            @Override
            public FrameTypeCheck check(FrameCanvas canvasBase) {
                return StrideDictionary.checkImport();
            }

            @Override
            public List<ExtensionDescription> getAvailableExtensions(FrameCanvas canvas, FrameCursor cursor) {
                return Collections.emptyList();
            }

            @Override
            public Frame getFrame() {
                return TopLevelDocumentMultiCanvasFrame.this;
            }

            @Override
            public InteractionManager getEditor() {
                return TopLevelDocumentMultiCanvasFrame.this.editor;
            }

            @Override
            public CanvasParent.CanvasKind getChildKind(FrameCanvas c) {
                return CanvasParent.CanvasKind.IMPORTS;
            }
        }, this.stylePrefix + "import-");
        importCanvas.setAnimateLeftMarginScale(true);
        ArrayList<ImportElement> importsRev = new ArrayList<ImportElement>(imports);
        Collections.reverse(importsRev);
        importsRev.forEach(item -> importCanvas.insertBlockBefore(item.createFrame(this.editor), importCanvas.getFirstCursor()));
        JavaFXUtil.onceInScene(importCanvas.getNode(), () -> importCanvas.shrinkUsing((DoubleExpression)new ReadOnlyDoubleWrapper(0.0)));
        new DeepListBinding<String>(this.boundImports){
            private final ChangeListener<String> listener;
            private final MultiListener<ObservableStringValue> stringListener;
            {
                super(dest);
                this.listener = (a, b, c) -> this.update();
                this.stringListener = new MultiListener<ObservableStringValue>(v -> {
                    v.addListener(this.listener);
                    return () -> v.removeListener(this.listener);
                });
            }

            @Override
            protected Stream<ObservableList<?>> getListenTargets() {
                return Stream.of(importCanvas.getBlockContents());
            }

            @Override
            protected Stream<String> calculateValues() {
                return importCanvas.getBlockContents().stream().map(f -> (ImportFrame)f).map(ImportFrame::getImport);
            }

            @Override
            protected void update() {
                this.stringListener.listenOnlyTo(importCanvas.getBlockContents().stream().map(f -> (ImportFrame)f).map(ImportFrame::importProperty));
                super.update();
            }
        }.startListening();
        return importCanvas;
    }

    @Override
    public ObservableList<String> getImports() {
        return this.boundImports;
    }

    @Override
    public void addImport(String importSrc) {
        this.importCanvas.insertBlockAfter(new ImportFrame(this.editor, importSrc), this.importCanvas.getLastCursor());
    }

    public FrameCanvas getfieldsCanvas() {
        return this.fieldsCanvas;
    }

    public FrameCanvas getMethodsCanvas() {
        return this.methodsCanvas;
    }

    @Override
    protected void modifyChildren(List<FrameContentItem> updatedChildren) {
        super.modifyChildren(updatedChildren);
        int n = 0;
        if (this.packageNameLabel != null) {
            updatedChildren.add(n, this.packageRow);
            ++n;
        }
        updatedChildren.add(n, this.importRow);
        updatedChildren.add(n + 1, this.importCanvas);
        updatedChildren.add(this.endSpacer);
    }

    @Override
    public void bindMinHeight(DoubleBinding prop) {
        this.getRegion().minHeightProperty().bind((ObservableValue)prop);
    }

    @Override
    public void insertAtEnd(Frame frame) {
        this.getLastCanvas().getLastCursor().insertBlockAfter(frame);
    }

    @Override
    public ObservableStringValue nameProperty() {
        return this.paramName.textProperty();
    }

    @Override
    public FrameCanvas getImportCanvas() {
        return this.importCanvas;
    }

    @Override
    public void ensureImportCanvasShowing() {
        this.importCanvas.getShowingProperty().set(true);
    }

    @Override
    public EditableSlot getErrorShowRedirect() {
        return this.paramName;
    }

    @Override
    public void focusName() {
        this.paramName.requestFocus(Focus.LEFT);
    }

    @Override
    public Stream<RecallableFocus> getFocusables() {
        return this.getFocusablesInclContained();
    }

    @Override
    public void focusOnBody(TopLevelFrame.BodyFocus on) {
        FrameCursor c;
        if (on == TopLevelFrame.BodyFocus.TOP) {
            c = this.fieldsCanvas.getFirstCursor();
        } else if (on == TopLevelFrame.BodyFocus.BOTTOM) {
            c = this.methodsCanvas.getLastCursor();
        } else {
            Optional<CodeError> error = this.getCurrentErrors().findFirst();
            if (error.isPresent()) {
                error.get().jumpTo(this.editor);
                return;
            }
            Frame specialMethod = this.findASpecialMethod();
            c = specialMethod != null ? specialMethod.getFirstInternalCursor() : this.methodsCanvas.getFirstCursor();
        }
        c.requestFocus();
        this.editor.scrollTo((Node)c.getNode(), -100.0);
    }

    protected abstract Frame findASpecialMethod();

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animateProgress) {
        boolean java;
        super.setView(oldView, newView, animateProgress);
        boolean bl = java = newView == Frame.View.JAVA_PREVIEW;
        if (java || oldView == Frame.View.JAVA_PREVIEW) {
            this.fieldsCanvas.previewCurly(java, true, false, this.header.getLeftFirstItem(), null, animateProgress);
            this.methodsCanvas.previewCurly(java, false, true, this.header.getLeftFirstItem(), null, animateProgress);
        }
        this.getCanvases().forEach(canvas -> {
            canvas.setView(oldView, newView, animateProgress);
            canvas.getCursors().forEach(c -> c.setView(newView, animateProgress));
        });
        this.animateLabelRows(newView, animateProgress);
        if (java) {
            this.importTriangleLabel.expandedProperty().set(true);
        } else if (newView.isBirdseye()) {
            this.importTriangleLabel.expandedProperty().set(false);
        }
        this.animateCanvasLabels(oldView, newView, animateProgress);
    }

    private void animateLabelRows(Frame.View newView, SharedTransition animateProgress) {
        List<FrameContentRow> labelRows = this.getLabelRows();
        if (newView == Frame.View.NORMAL) {
            animateProgress.addOnStopped(() -> {
                this.importTriangleLabel.setVisible(true);
                this.importTriangleLabel.setManaged(true);
                labelRows.forEach(r -> r.setSnapToPixel(true));
            });
        } else {
            labelRows.forEach(r -> r.setSnapToPixel(false));
            this.importTriangleLabel.setVisible(false);
            this.importTriangleLabel.setManaged(false);
        }
    }

    protected abstract List<FrameContentRow> getLabelRows();

    private void animateCanvasLabels(Frame.View oldView, Frame.View newView, SharedTransition animateProgress) {
        List<SlotLabel> animateLabels = this.getCanvasLabels();
        if (newView == Frame.View.JAVA_PREVIEW) {
            animateLabels.forEach(l -> l.shrinkVertically(animateProgress));
        } else if (oldView == Frame.View.JAVA_PREVIEW) {
            animateLabels.forEach(l -> l.growVertically(animateProgress));
        }
    }

    protected abstract List<SlotLabel> getCanvasLabels();
}

