/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.canvases.JavaCanvas;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.SandwichCanvasesElement;
import bluej.stride.framedjava.frames.BlankFrame;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.DebuggableFrame;
import bluej.stride.framedjava.frames.DebuggableParentFrame;
import bluej.stride.framedjava.frames.StrideDictionary;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameTypeCheck;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.MultiCanvasFrame;
import bluej.stride.operations.PullUpContentsOperation;
import bluej.stride.slots.SlotLabel;
import bluej.utility.Utility;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.css.Styleable;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class SandwichCanvasesFrame
extends MultiCanvasFrame
implements CodeFrame<SandwichCanvasesElement>,
DebuggableFrame {
    private String stylePrefix;
    private String frameCaption;
    private final JavaCanvas firstCanvas;
    private String intermediateCanvasCaption;
    private final List<JavaCanvas> intermediateCanvases = new ArrayList<JavaCanvas>();
    private String tailCanvasCaption;
    private JavaCanvas tailCanvas;
    protected SandwichCanvasesElement element;
    protected final InteractionManager editor;
    private StrideDictionary dictionary = StrideDictionary.getDictionary();

    protected SandwichCanvasesFrame(InteractionManager editor, String frameCaption, String intermediateCanvasCaption, String tailCanvasCaption, String stylePrefix) {
        super(editor, frameCaption, stylePrefix);
        this.frameCaption = frameCaption;
        this.editor = editor;
        this.stylePrefix = stylePrefix;
        this.intermediateCanvasCaption = intermediateCanvasCaption;
        this.tailCanvasCaption = tailCanvasCaption;
        this.firstCanvas = new JavaCanvas(editor, this, stylePrefix, false);
        this.addCanvas(null, this.firstCanvas);
    }

    protected void addIntermediateCanvas() {
        this.addIntermediateCanvas(null, null);
    }

    private void addIntermediateCanvas(FrameCanvas canvas, FrameCursor cursor, int at) {
        ArrayList<Frame> contents = new ArrayList<Frame>();
        if (canvas != null && cursor != null) {
            while (cursor.getFrameAfter() != null) {
                contents.add(cursor.getFrameAfter());
                cursor = cursor.getDown();
            }
            contents.forEach(c -> canvas.removeBlock((Frame)c));
        }
        this.addIntermediateCanvas(null, contents, at);
    }

    public void addIntermediateCanvas(List<SlotFragment> slots, List contents) {
        this.addIntermediateCanvas(slots, contents, this.canvases.size());
    }

    private void addIntermediateCanvas(List<SlotFragment> slots, List contents, int at) {
        JavaCanvas intermediateCanvas = new JavaCanvas(this.editor, this, this.stylePrefix, false);
        if (contents != null) {
            intermediateCanvas.getFirstCursor().insertFramesAfter(contents);
        }
        FrameContentRow intermediateHeader = this.getFrameContentRow(slots, intermediateCanvas, at - 1);
        this.addCanvas(intermediateHeader, intermediateCanvas, at);
        if (!intermediateHeader.focusLeftEndFromPrev()) {
            intermediateCanvas.getFirstCursor().requestFocus();
        }
        this.intermediateCanvases.add(at - 1, intermediateCanvas);
        this.editor.modifiedFrame(this, false);
    }

    protected abstract FrameContentRow getFrameContentRow(List<SlotFragment> var1, JavaCanvas var2, int var3);

    protected void pullUpCanvasContents(FrameCursor cursor, FrameCanvas canvas) {
        canvas.getFirstCursor().getUp().requestFocus();
        ArrayList<Frame> contents = new ArrayList<Frame>((Collection<Frame>)canvas.getBlockContents());
        contents.forEach(frame -> {
            canvas.removeBlock((Frame)frame);
            frame.setParentCanvas(null);
        });
        cursor.insertFramesAfter(contents);
        if (!contents.isEmpty()) {
            cursor.insertBlockAfter(new BlankFrame(this.editor));
        }
        this.removeCanvas(canvas);
        this.editor.modifiedFrame(this, false);
    }

    public boolean addTailCanvas() {
        if (this.tailCanvas != null) {
            return false;
        }
        this.tailCanvas = new JavaCanvas(this.editor, this, this.stylePrefix, false);
        SlotLabel tailCanvasLabel = new SlotLabel(this.tailCanvasCaption, new String[0]);
        JavaFXUtil.addStyleClass((Styleable)tailCanvasLabel, "divider-" + this.tailCanvasCaption);
        this.addCanvas(new FrameContentRow((Frame)this, tailCanvasLabel), this.tailCanvas);
        this.tailCanvas.getFirstCursor().requestFocus();
        this.editor.modifiedFrame(this, false);
        return true;
    }

    private void addTailCanvas(FrameCanvas canvas, FrameCursor cursor) {
        if (this.addTailCanvas()) {
            ArrayList<Frame> contents = new ArrayList<Frame>();
            if (canvas != null && cursor != null) {
                while (cursor.getFrameAfter() != null) {
                    contents.add(cursor.getFrameAfter());
                    cursor = cursor.getDown();
                }
                contents.forEach(c -> canvas.removeBlock((Frame)c));
            }
            this.tailCanvas.getFirstCursor().insertFramesAfter(contents);
        }
    }

    @Override
    protected void removeCanvas(FrameCanvas canvas) {
        super.removeCanvas(canvas);
        if (this.intermediateCanvases.contains(canvas)) {
            this.intermediateCanvases.remove(canvas);
        }
        if (this.tailCanvas == canvas) {
            this.tailCanvas = null;
        }
        this.editor.modifiedFrame(this, false);
    }

    @Override
    public void regenerateCode() {
        ArrayList<CodeElement> firstCanvasContents = new ArrayList<CodeElement>();
        this.firstCanvas.getBlocksSubtype(CodeFrame.class).forEach(f -> {
            f.regenerateCode();
            firstCanvasContents.add((CodeElement)f.getCode());
        });
        List<List<CodeElement>> intermediateCanvasesContents = Utility.mapList(this.intermediateCanvases, canvas -> Utility.mapList(canvas.getBlocksSubtype(CodeFrame.class), f -> {
            f.regenerateCode();
            return f.getCode();
        }));
        ArrayList<CodeElement> tailCanvasContents = null;
        if (this.tailCanvas != null) {
            tailCanvasContents = new ArrayList<CodeElement>();
            for (CodeFrame f2 : this.tailCanvas.getBlocksSubtype(CodeFrame.class)) {
                f2.regenerateCode();
                tailCanvasContents.add((CodeElement)f2.getCode());
            }
        }
        this.element = this.regenerateCodeElement(firstCanvasContents, intermediateCanvasesContents, tailCanvasContents, this.frameEnabledProperty.get());
    }

    protected abstract SandwichCanvasesElement regenerateCodeElement(List<CodeElement> var1, List<List<CodeElement>> var2, List<CodeElement> var3, boolean var4);

    @Override
    public SandwichCanvasesElement getCode() {
        return this.element;
    }

    public JavaCanvas getFirstCanvas() {
        return this.firstCanvas;
    }

    public JavaCanvas getTailCanvas() {
        return this.tailCanvas;
    }

    public DebuggableParentFrame getFirstCanvasDebug() {
        return new DebuggableParentFrame(){

            @Override
            @OnThread(value=Tag.FXPlatform)
            public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
                return ((JavaCanvas)this.getParentCanvas()).showDebugBefore(SandwichCanvasesFrame.this, debug);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
                return SandwichCanvasesFrame.this.getFirstCanvas().showDebugBefore(null, debug);
            }

            @Override
            public FrameCanvas getParentCanvas() {
                return SandwichCanvasesFrame.this.getFirstCanvas();
            }
        };
    }

    public DebuggableParentFrame getIntermediateCanvasDebug(final int intermediateCanvasIndex) {
        return new DebuggableParentFrame(){

            @Override
            @OnThread(value=Tag.FXPlatform)
            public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
                return ((JavaCanvas)this.getParentCanvas()).showDebugBefore(SandwichCanvasesFrame.this, debug);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
                return ((JavaCanvas)SandwichCanvasesFrame.this.intermediateCanvases.get(intermediateCanvasIndex)).showDebugBefore(null, debug);
            }

            @Override
            public FrameCanvas getParentCanvas() {
                return (FrameCanvas)SandwichCanvasesFrame.this.intermediateCanvases.get(intermediateCanvasIndex);
            }
        };
    }

    public DebuggableParentFrame getTailCanvasDebug() {
        return new DebuggableParentFrame(){

            @Override
            @OnThread(value=Tag.FXPlatform)
            public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
                return ((JavaCanvas)this.getParentCanvas()).showDebugBefore(SandwichCanvasesFrame.this, debug);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
                return SandwichCanvasesFrame.this.getTailCanvas().showDebugBefore(null, debug);
            }

            @Override
            public FrameCanvas getParentCanvas() {
                return SandwichCanvasesFrame.this.getTailCanvas();
            }
        };
    }

    @Override
    public boolean focusWhenJustAdded() {
        this.firstCanvas.getFirstCursor().requestFocus();
        return true;
    }

    @Override
    public FrameTypeCheck check(FrameCanvas canvas) {
        return StrideDictionary.checkStatement();
    }

    @Override
    public List<ExtensionDescription> getAvailableExtensions(FrameCanvas canvas, FrameCursor cursor) {
        ArrayList<ExtensionDescription> inners = new ArrayList<ExtensionDescription>();
        inners.addAll(super.getAvailableExtensions(canvas, cursor));
        if (canvas == this.firstCanvas) {
            inners.add(new ExtensionDescription('\b', "Remove " + this.frameCaption + ", keep contents", () -> new PullUpContentsOperation(this.editor).activate(this.getFrame()), false, ExtensionDescription.ExtensionSource.INSIDE_FIRST, new ExtensionDescription.ExtensionSource[0]));
        }
        if (canvas == this.firstCanvas || this.intermediateCanvases.contains(canvas) || canvas == null) {
            ArrayList<ExtensionDescription.ExtensionSource> otherSources = new ArrayList<ExtensionDescription.ExtensionSource>();
            otherSources.addAll(Arrays.asList(ExtensionDescription.ExtensionSource.INSIDE_FIRST, ExtensionDescription.ExtensionSource.INSIDE_LATER));
            if (this.tailCanvas == null) {
                otherSources.add(ExtensionDescription.ExtensionSource.AFTER);
            }
            inners.add(new ExtensionDescription(this.dictionary.getExtensionChar(this.intermediateCanvasCaption), "Add " + this.intermediateCanvasCaption, () -> {
                if (cursor == null) {
                    this.addIntermediateCanvas();
                } else {
                    this.addIntermediateCanvas(canvas, cursor, this.canvases.indexOf(canvas) + 1);
                }
            }, true, ExtensionDescription.ExtensionSource.MODIFIER, otherSources.toArray(new ExtensionDescription.ExtensionSource[0])));
        }
        if (this.intermediateCanvases.contains(canvas)) {
            inners.add(new ExtensionDescription('\b', "Remove " + this.intermediateCanvasCaption + ", keep contents", () -> this.pullUpCanvasContents(this.getCursorBefore(canvas), canvas), false, ExtensionDescription.ExtensionSource.INSIDE_FIRST, new ExtensionDescription.ExtensionSource[0]));
        }
        if ((canvas == null || Utility.findLast(this.getCanvases()).orElse(null) == canvas) && this.tailCanvas == null) {
            inners.add(new ExtensionDescription(this.dictionary.getExtensionChar(this.tailCanvasCaption), "Add " + this.tailCanvasCaption, () -> {
                if (cursor == null) {
                    this.addTailCanvas();
                } else {
                    this.addTailCanvas(canvas, cursor);
                }
            }, true, ExtensionDescription.ExtensionSource.INSIDE_FIRST, ExtensionDescription.ExtensionSource.INSIDE_LATER, ExtensionDescription.ExtensionSource.MODIFIER, ExtensionDescription.ExtensionSource.AFTER));
        }
        if (this.tailCanvas != null && this.tailCanvas == canvas) {
            inners.add(new ExtensionDescription('\b', "Remove " + this.tailCanvasCaption + ", keep contents", () -> this.pullUpCanvasContents(this.getCursorBefore(canvas), canvas), false, ExtensionDescription.ExtensionSource.INSIDE_FIRST, new ExtensionDescription.ExtensionSource[0]));
        }
        return inners;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
        super.setView(oldView, newView, animate);
        JavaFXUtil.setPseudoclass("bj-java-preview", newView == Frame.View.JAVA_PREVIEW, this.sidebar.getStyleable());
        this.getCanvases().forEach(c -> {
            c.getCursors().forEach(cur -> cur.setView(newView, animate));
            if (this.isFrameEnabled() && (oldView == Frame.View.JAVA_PREVIEW || newView == Frame.View.JAVA_PREVIEW)) {
                c.previewCurly(newView == Frame.View.JAVA_PREVIEW, this.header.getLeftFirstItem(), null, animate);
            }
            c.setView(oldView, newView, animate);
        });
    }
}

