/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.parser.entity.EntityResolver;
import bluej.stride.framedjava.elements.ClassElement;
import bluej.stride.framedjava.elements.TopLevelCodeElement;
import bluej.stride.framedjava.frames.TopLevelFrame;
import bluej.stride.generic.RecallableFocus;
import bluej.utility.Debug;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import nu.xom.Builder;
import nu.xom.ParsingException;

public class FrameState {
    private String classElementXML;
    private int cursorIndex;
    private int cursorInfo;

    public FrameState(TopLevelCodeElement topLevelElement) {
        this.classElementXML = topLevelElement.toXML().toXML();
        this.cursorIndex = -1;
        this.cursorInfo = -1;
    }

    public FrameState(TopLevelFrame<?> frame, TopLevelCodeElement classElement, RecallableFocus focusOverride) {
        this.classElementXML = classElement.toXML().toXML();
        List focusables = frame.getFocusables().collect(Collectors.toList());
        this.cursorIndex = -1;
        if (focusOverride != null) {
            this.cursorIndex = focusables.indexOf(focusOverride);
            this.cursorInfo = focusOverride.getFocusInfo();
        } else {
            for (int i = 0; i < focusables.size(); ++i) {
                RecallableFocus recallableFocus = (RecallableFocus)focusables.get(i);
                if (recallableFocus == null || !recallableFocus.isFocused()) continue;
                this.cursorIndex = i;
                this.cursorInfo = recallableFocus.getFocusInfo();
                break;
            }
        }
    }

    public ClassElement getClassElement(EntityResolver resolver) {
        try {
            return new ClassElement(new Builder().build((Reader)new StringReader(this.classElementXML)).getRootElement(), resolver);
        }
        catch (IOException | ParsingException e) {
            Debug.reportError("Error restoring state from string: ", e);
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FrameState)) {
            return false;
        }
        FrameState otherState = (FrameState)obj;
        return otherState.classElementXML.equals(this.classElementXML);
    }

    public int hashCode() {
        return this.classElementXML.hashCode();
    }

    public Node recallFocus(TopLevelFrame<?> frame) {
        List focusables = frame.getFocusables().collect(Collectors.toList());
        if (this.cursorIndex >= 0 && this.cursorIndex < focusables.size()) {
            return ((RecallableFocus)focusables.get(this.cursorIndex)).recallFocus(this.cursorInfo);
        }
        return null;
    }
}

