/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.links.PossibleLink;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.slots.TextOverlayPosition;
import bluej.stride.framedjava.slots.UnderlineContainer;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentItem;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.Focus;
import bluej.stride.slots.FocusParent;
import bluej.stride.slots.HeaderItem;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.ScalableHeightLabel;
import bluej.utility.javafx.ScrollFreeTextArea;
import bluej.utility.javafx.SharedTransition;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import threadchecker.OnThread;
import threadchecker.Tag;

public class DocumentationTextArea
extends ScrollFreeTextArea
implements EditableSlot,
FrameContentItem {
    private Frame frameParent;
    private Frame.View curView = Frame.View.NORMAL;
    private final ScalableHeightLabel previewCommentStart = new ScalableHeightLabel("/**", true);
    private final ScalableHeightLabel previewCommentEnd = new ScalableHeightLabel("*/", true);
    private final BorderPane wrapper = new BorderPane(super.getNode());
    private boolean hacking;

    public DocumentationTextArea(InteractionManager editor, Frame frameParent, FocusParent<? super DocumentationTextArea> focusParent, String stylePrefix) {
        this(editor, frameParent, focusParent, stylePrefix, null);
    }

    public DocumentationTextArea(InteractionManager editor, Frame frameParent, FocusParent<? super DocumentationTextArea> focusParent, String stylePrefix, FXRunnable enterAction) {
        super(editor);
        JavaFXUtil.addStyleClass((Styleable)this.wrapper, "documentation-text-wrapper", stylePrefix + "documentation-text-wrapper");
        this.frameParent = frameParent;
        this.addTextStyleClasses("documentation-text", stylePrefix + "documentation-text");
        this.setFocusTraversable(true);
        editor.setupFocusableSlotComponent(this, super.getNode(), false, Collections::emptyList, Collections.emptyList());
        this.textProperty().addListener((e, oldValue, newValue) -> {
            if (!this.hacking) {
                editor.modifiedFrame(frameParent, false);
            }
        });
        JavaFXUtil.addStyleClass((Styleable)this.previewCommentStart, "preview-slashstar");
        JavaFXUtil.addStyleClass((Styleable)this.previewCommentEnd, "preview-slashstar");
        this.wrapper.setTop((Node)this.previewCommentStart);
        this.wrapper.setBottom((Node)this.previewCommentEnd);
        this.setPseudoclass("bj-blank", true);
        this.textProperty().addListener((a, b, c) -> this.setPseudoclass("bj-blank", this.getText().equals("")));
        this.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            switch (event.getCode()) {
                case TAB: {
                    if (event.isShiftDown()) {
                        focusParent.focusLeft(this);
                    } else {
                        focusParent.focusRight(this);
                    }
                    event.consume();
                    break;
                }
                case UP: {
                    if (this.getCaretPosition() != 0) {
                        int oldPos = this.getCaretPosition();
                        JavaFXUtil.runAfterCurrent(() -> {
                            if (this.getCaretPosition() == oldPos) {
                                focusParent.focusUp(this, true);
                            }
                        });
                    }
                }
                case LEFT: {
                    if (this.caretPositionProperty().get() != 0) break;
                    focusParent.focusUp(this, true);
                    event.consume();
                    break;
                }
                case DOWN: {
                    if (this.getCaretPosition() != this.getLength()) {
                        int oldPos = this.getCaretPosition();
                        JavaFXUtil.runAfterCurrent(() -> {
                            if (this.getCaretPosition() == oldPos) {
                                focusParent.focusDown(this);
                            }
                        });
                    }
                }
                case RIGHT: {
                    if (this.caretPositionProperty().get() != this.getLength()) break;
                    focusParent.focusDown(this);
                    event.consume();
                    break;
                }
                case ENTER: {
                    if (event.isShiftDown() || event.isControlDown() || event.isShortcutDown()) {
                        this.insertAtCaret("\n");
                        event.consume();
                        break;
                    }
                    if (enterAction == null) break;
                    enterAction.run();
                    event.consume();
                }
            }
        });
    }

    @Override
    public void requestFocus(Focus on) {
        this.requestFocus();
        if (on == Focus.LEFT) {
            this.positionCaret(0);
        } else if (on == Focus.RIGHT) {
            this.positionCaret(this.getLength());
        } else if (on == Focus.SELECT_ALL) {
            this.selectAll();
        }
    }

    public ObservableList<Node> getComponents() {
        return FXCollections.observableArrayList((Object[])new Node[]{this.getNode()});
    }

    @Override
    public TextOverlayPosition getOverlayLocation(int caretPos, boolean javaPos) {
        return null;
    }

    @Override
    public void removeOldErrors() {
    }

    @Override
    public void flagErrorsAsOld() {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void addError(CodeError err) {
    }

    @Override
    public void focusAndPositionAtError(CodeError err) {
    }

    @Override
    public Stream<CodeError> getCurrentErrors() {
        return Stream.empty();
    }

    @Override
    public void addUnderline(UnderlineContainer.Underline u) {
    }

    @Override
    public void removeAllUnderlines() {
    }

    @Override
    public void saved() {
    }

    @Override
    public int getFocusInfo() {
        return this.getCaretPosition();
    }

    @Override
    public Node recallFocus(int info) {
        this.positionCaret(info);
        return this.getNode();
    }

    @Override
    public List<? extends PossibleLink> findLinks() {
        return Collections.emptyList();
    }

    @Override
    public Frame getParentFrame() {
        return this.frameParent;
    }

    @Override
    public void lostFocus() {
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
        this.setDisable(newView != Frame.View.NORMAL);
        if (newView == Frame.View.BIRDSEYE_NODOC) {
            this.shrinkToNothingUsing(animate);
        } else if (oldView == Frame.View.BIRDSEYE_NODOC) {
            this.growFromNothingUsing(animate);
        }
        if (newView == Frame.View.JAVA_PREVIEW && (this.getParentFrame() == null || this.getParentFrame().isFrameEnabled())) {
            this.previewCommentStart.growToFullHeightWith(animate, true);
            this.previewCommentEnd.growToFullHeightWith(animate, true);
            this.wrapper.setSnapToPixel(false);
        } else if (this.curView == Frame.View.JAVA_PREVIEW) {
            this.previewCommentStart.shrinkToNothingWith(animate, true);
            this.previewCommentEnd.shrinkToNothingWith(animate, true);
            animate.addOnStopped(() -> this.wrapper.setSnapToPixel(true));
        }
        this.curView = newView;
    }

    public String getJavadocs(String prefix) {
        String out = "";
        if (!this.getText().isEmpty()) {
            String[] lines = this.getText().split("\n");
            for (int i = 0; i < lines.length; ++i) {
                out = out + prefix + " * " + lines[i] + "\n";
            }
        }
        return out;
    }

    @OnThread(value=Tag.FXPlatform)
    public void hackFixSizing() {
        this.hacking = true;
        String s = this.getText();
        this.setText("");
        this.setText(s);
        this.hacking = false;
    }

    @Override
    public JavaFragment getSlotElement() {
        return null;
    }

    @Override
    public boolean isAlmostBlank() {
        return this.getText().trim().isEmpty();
    }

    @Override
    public Optional<FrameCanvas> getCanvas() {
        return Optional.empty();
    }

    @Override
    public Stream<HeaderItem> getHeaderItemsDeep() {
        return Stream.of(this);
    }

    @Override
    public Stream<HeaderItem> getHeaderItemsDirect() {
        return Stream.of(this);
    }

    @Override
    public boolean focusTopEndFromPrev() {
        this.requestFocus(Focus.LEFT);
        return true;
    }

    @Override
    public boolean focusBottomEndFromNext() {
        this.requestFocus(Focus.LEFT);
        return true;
    }

    @Override
    public boolean focusLeftEndFromPrev() {
        this.requestFocus(Focus.LEFT);
        return true;
    }

    @Override
    public boolean focusRightEndFromNext() {
        this.requestFocus(Focus.RIGHT);
        return true;
    }

    @Override
    public boolean isEditable() {
        return !this.isDisable();
    }

    @Override
    public void setEditable(boolean editable) {
        this.setDisable(!editable);
    }

    @Override
    public Node getNode() {
        return this.wrapper;
    }

    public void setDocComment(boolean docComment) {
        this.previewCommentStart.setText(docComment ? "/**" : "/*");
    }

    @Override
    public ObservableBooleanValue effectivelyFocusedProperty() {
        return this.focusedProperty();
    }

    @Override
    public int calculateEffort() {
        return this.getText().length();
    }
}

