/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.slots;

import bluej.stride.framedjava.slots.CaretPos;
import bluej.stride.framedjava.slots.InfixStructured;
import bluej.stride.framedjava.slots.PosAndDist;
import bluej.stride.framedjava.slots.StructuredSlot;
import bluej.stride.framedjava.slots.StructuredSlotComponent;
import bluej.stride.framedjava.slots.TextOverlayPosition;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.EditableSlot;
import bluej.utility.javafx.DelegableScalableTextField;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.HangingFlowPane;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import threadchecker.OnThread;
import threadchecker.Tag;

class StructuredSlotField
implements StructuredSlotComponent {
    private final DelegableScalableTextField<StructuredSlotField> field;
    private final InfixStructured parent;

    public StructuredSlotField(InfixStructured parent, String content, boolean stringLiteral) {
        this.parent = parent;
        this.field = new DelegableScalableTextField<StructuredSlotField>(parent, this, content);
        JavaFXUtil.addStyleClass(this.field, new String[]{"expression-slot-field"});
        if (stringLiteral) {
            JavaFXUtil.addStyleClass(this.field, new String[]{"expression-string-literal"});
        }
        Runnable shrinkGrow = () -> {
            boolean suggesting = parent.suggestingFor(this);
            if (!this.field.isFocused() && !suggesting) {
                this.notifyLostFocus(null);
            } else {
                JavaFXUtil.setPseudoclass("bj-transparent", false, new Node[]{this.field});
            }
        };
        this.field.focusedProperty().addListener((a, b, focused) -> {
            shrinkGrow.run();
            parent.caretMoved();
            if (focused.booleanValue()) {
                parent.getSlot().notifyGainFocus(this);
            }
        });
        this.field.textProperty().addListener((a, b, c) -> {
            shrinkGrow.run();
            if (!stringLiteral) {
                this.updateBreaks();
            }
        });
        this.field.promptTextProperty().addListener((a, b, c) -> {
            shrinkGrow.run();
            if (!stringLiteral) {
                this.updateBreaks();
            }
        });
        JavaFXUtil.initializeCustomHelp(parent.getEditor(), this.field, this::calculateTooltip, true);
        JavaFXUtil.onceInScene(this.field, () -> {
            shrinkGrow.run();
            if (parent.getSlot() != null) {
                this.field.setContextMenu(EditableSlot.MenuItems.makeContextMenu(parent.getSlot().getMenuItems(true)));
            }
        });
        if (!stringLiteral) {
            this.updateBreaks();
        }
    }

    private void updateBreaks() {
        HangingFlowPane.setBreakBefore(this.field, !this.getText().isEmpty() || !this.field.getPromptText().isEmpty());
    }

    private double calculateSceneX(CaretPos pos) {
        return this.field.calculateSceneX(pos.index);
    }

    private double calculateSceneY(double y) {
        return this.field.localToScene(new Point2D(0.0, y)).getY();
    }

    @Override
    public TextOverlayPosition calculateOverlayPos(CaretPos pos) {
        return TextOverlayPosition.fromScene(this.calculateSceneX(pos), this.calculateSceneY(0.0), this.calculateSceneY(this.field.getBaselineOffset()), this.calculateSceneY(this.field.getHeight()), this);
    }

    public TextOverlayPosition calculateOverlayEnd() {
        return TextOverlayPosition.fromScene(this.field.localToScene(this.field.getBoundsInLocal()).getMaxX(), this.calculateSceneY(0.0), this.calculateSceneY(this.field.getBaselineOffset()), this.calculateSceneY(this.field.getHeight()), this);
    }

    @Override
    public void focusAtStart() {
        this.focusAt(0);
    }

    private void focusAt(int i) {
        this.field.requestFocus();
        this.field.positionCaret(i);
    }

    @Override
    public void focusAtEnd() {
        this.focusAt(this.field.getLength());
    }

    @Override
    public Node focusAtPos(CaretPos caretPos) {
        this.focusAt(caretPos.index);
        return this.field;
    }

    @Override
    public CaretPos getStartPos() {
        return new CaretPos(0, null);
    }

    @Override
    public CaretPos getEndPos() {
        return new CaretPos(this.field.getLength(), null);
    }

    public boolean isEmpty() {
        return this.field.getText().equals("");
    }

    public void requestFocus() {
        this.field.requestFocus();
    }

    @Override
    public PosAndDist getNearest(double sceneX, double sceneY, boolean allowDescend, boolean anchorInItem) {
        double topYDist = Math.abs(this.calculateSceneY(0.0) - sceneY);
        double bottomYDist = Math.abs(this.calculateSceneY(this.field.getHeight() - 1.0) - sceneY);
        PosAndDist nearest = new PosAndDist();
        for (int j = 0; j <= this.field.getLength(); ++j) {
            CaretPos pos = new CaretPos(j, null);
            double xDist = this.calculateSceneX(pos) - sceneX;
            double dist = Math.hypot(xDist, Math.min(topYDist, bottomYDist));
            nearest = PosAndDist.nearest(nearest, new PosAndDist(pos, dist));
        }
        Bounds b = this.field.localToScene(this.field.getBoundsInLocal());
        nearest = PosAndDist.nearest(nearest, new PosAndDist(new CaretPos(0, null), Math.hypot(b.getMinX() - sceneX, Math.min(topYDist, bottomYDist))));
        nearest = PosAndDist.nearest(nearest, new PosAndDist(new CaretPos(this.field.getLength(), null), Math.hypot(b.getMaxX() - sceneX, Math.min(topYDist, bottomYDist))));
        return nearest;
    }

    @Override
    public CaretPos getSelectIntoPos(boolean atEnd) {
        return new CaretPos(atEnd ? this.field.getLength() : 0, null);
    }

    @Override
    public String getText() {
        return this.field.getText();
    }

    public void setText(String s, StructuredSlot.ModificationToken token) {
        token.check();
        this.field.setText(s);
    }

    @Override
    public String getCopyText(CaretPos from, CaretPos to) {
        int start = from == null ? 0 : from.index;
        int end = to == null ? this.field.getLength() : to.index;
        return this.field.getText().substring(start, end);
    }

    @Override
    public String getJavaCode() {
        return this.field.getText();
    }

    @Override
    public CaretPos getCurrentPos() {
        if (this.field.isFocused()) {
            return new CaretPos(this.field.getCaretPosition(), null);
        }
        return null;
    }

    public void setPromptText(String s) {
        this.field.setPromptText(s);
    }

    public ObservableList<Region> getComponents() {
        return FXCollections.observableArrayList((Object[])new Region[]{this.field});
    }

    @Override
    public List<InfixStructured.CaretPosMap> mapCaretPosStringPos(InfixStructured.IntCounter len, boolean javaString) {
        String text = this.getText();
        List<InfixStructured.CaretPosMap> r = Collections.singletonList(new InfixStructured.CaretPosMap(null, len.counter, len.counter + text.length()));
        len.counter += text.length();
        return r;
    }

    @Override
    public Region getNodeForPos(CaretPos pos) {
        return this.field;
    }

    @Override
    public String testingGetState(CaretPos pos) {
        if (pos == null) {
            return "{" + this.field.getText() + "}";
        }
        return "{" + this.field.getText().substring(0, pos.index) + "$" + this.field.getText().substring(pos.index) + "}";
    }

    @Override
    public boolean isFocused() {
        return this.field.isFocused();
    }

    @Override
    public boolean isFieldAndEmpty() {
        return this.field.getText().isEmpty();
    }

    public ObjectProperty<EventHandler<? super KeyEvent>> onKeyPressedProperty() {
        return this.field.onKeyPressedProperty();
    }

    public DoubleExpression heightProperty() {
        return this.field.heightProperty();
    }

    @Override
    public void insertSuggestion(CaretPos p, String name, char opening, List<String> params, StructuredSlot.ModificationToken token) {
        if (params != null) {
            throw new IllegalArgumentException();
        }
        this.setText(this.getText().substring(0, p.index) + name + this.getText().substring(p.index), token);
    }

    @OnThread(value=Tag.FXPlatform)
    private void calculateTooltip(FXConsumer<String> tooltipConsumer) {
        if (!this.getText().equals("") && !this.isFocused()) {
            tooltipConsumer.accept("");
        } else {
            this.parent.calculateTooltipFor(this, tooltipConsumer);
        }
    }

    @Override
    public Stream<TextOverlayPosition> getAllStartEndPositionsBetween(CaretPos start, CaretPos end) {
        if (start == null) {
            start = this.getStartPos();
        }
        if (end == null) {
            end = this.getEndPos();
        }
        return Stream.of(this.calculateOverlayPos(start), this.calculateOverlayPos(end));
    }

    @Override
    public Stream<InfixStructured<?, ?>> getAllExpressions() {
        return Stream.empty();
    }

    public void addEventHandler(EventType<MouseEvent> mouseEvent, EventHandler<? super MouseEvent> eventHandler) {
        this.field.addEventHandler(mouseEvent, eventHandler);
    }

    public ObservableStringValue textProperty() {
        return this.field.textProperty();
    }

    public void setPseudoclass(String name, boolean on) {
        JavaFXUtil.setPseudoclass(name, on, new Node[]{this.field});
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
        this.field.setEditable(newView == Frame.View.NORMAL);
        this.field.setDisable(newView != Frame.View.NORMAL);
        if (newView == Frame.View.JAVA_PREVIEW) {
            animate.addOnStopped(() -> JavaFXUtil.setPseudoclass("bj-java-preview", newView == Frame.View.JAVA_PREVIEW, new Node[]{this.field}));
        } else {
            JavaFXUtil.setPseudoclass("bj-java-preview", newView == Frame.View.JAVA_PREVIEW, new Node[]{this.field});
        }
    }

    void cut() {
        this.field.cut();
    }

    void copy() {
        this.field.copy();
    }

    void paste() {
        this.field.paste();
    }

    @Override
    public boolean isAlmostBlank() {
        return this.isEmpty();
    }

    @Override
    public void notifyLostFocus(StructuredSlotField except) {
        boolean empty;
        boolean collapsible = this.parent.isCollapsible(this);
        boolean bl = empty = this.field.getText().isEmpty() && this.field.getPromptText().isEmpty();
        if (empty && collapsible) {
            JavaFXUtil.setPseudoclass("bj-transparent", true, new Node[]{this.field});
        } else {
            JavaFXUtil.setPseudoclass("bj-transparent", collapsible || !this.field.getText().isEmpty(), new Node[]{this.field});
        }
    }

    @Override
    public void setEditable(boolean editable) {
        this.field.setDisable(!editable);
    }

    public void nextWord() {
        this.field.nextWord();
    }

    public void previousWord() {
        this.field.previousWord();
    }

    @Override
    public boolean isNumericLiteral() {
        return this.getText().matches("\\A\\d*\\z");
    }

    @Override
    public int calculateEffort() {
        return Math.min(3, this.field.getText().length());
    }

    @Override
    public Stream<Node> makeDisplayClone(InteractionManager editor) {
        TextField f = new TextField();
        f.textProperty().bind((ObservableValue)this.field.textProperty());
        f.prefWidthProperty().bind((ObservableValue)this.field.prefWidthProperty());
        JavaFXUtil.bindList(f.getStyleClass(), this.field.getStyleClass());
        JavaFXUtil.bindPseudoclasses((Node)f, (ObservableSet<PseudoClass>)this.field.getPseudoClassStates());
        JavaFXUtil.setPseudoclass("bj-pinned", true, new Node[]{f});
        f.styleProperty().bind((ObservableValue)this.field.styleProperty().concat((Object)editor.getFontCSS()));
        return Stream.of(f);
    }
}

