/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.ast.ExpressionSlotFragment;
import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.canvases.JavaCanvas;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.WhileElement;
import bluej.stride.framedjava.frames.BreakFrame;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.DebuggableParentFrame;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.FilledExpressionSlot;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SingleCanvasFrame;
import bluej.stride.operations.FrameOperation;
import bluej.stride.operations.PullUpContentsOperation;
import bluej.stride.slots.SlotLabel;
import bluej.utility.Utility;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

public class WhileFrame
extends SingleCanvasFrame
implements CodeFrame<WhileElement>,
DebuggableParentFrame {
    private final ExpressionSlot<FilledExpressionSlotFragment> paramCondition;
    private WhileElement element;

    private WhileFrame(InteractionManager editor) {
        super(editor, "while", "while-");
        this.paramCondition = new FilledExpressionSlot(editor, this, this, this.getHeaderRow(), "while-"){

            @Override
            @OnThread(value=Tag.FXPlatform)
            public boolean backspaceAtStart() {
                if (this.isAlmostBlank()) {
                    new PullUpContentsOperation(this.editor).activate(WhileFrame.this.getFrame());
                    return true;
                }
                return super.backspaceAtStart();
            }
        };
        this.paramCondition.setSimplePromptText("condition");
        this.paramCondition.setTargetType("boolean");
        this.setHeaderRow(new SlotLabel("(", new String[0]), this.paramCondition, new SlotLabel(")", new String[0]));
        this.paramCondition.onTextPropertyChange(this.updateSidebarCurried("while "));
    }

    public WhileFrame(InteractionManager editor, ExpressionSlotFragment condition, boolean enabled) {
        this(editor);
        this.paramCondition.setText(condition);
        this.frameEnabledProperty.set(enabled);
    }

    public WhileFrame(InteractionManager editor, List<Frame> contents) {
        this(editor);
        this.getCanvas().getFirstCursor().insertFramesAfter(contents);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public List<FrameOperation> getContextOperations() {
        List<FrameOperation> r = super.getContextOperations();
        r.add(new PullUpContentsOperation(this.getEditor()));
        return r;
    }

    public static FrameFactory<WhileFrame> getFactory() {
        return new FrameFactory<WhileFrame>(){

            @Override
            public WhileFrame createBlock(InteractionManager editor) {
                return new WhileFrame(editor);
            }

            @Override
            public WhileFrame createBlock(InteractionManager editor, List<Frame> contents) {
                return new WhileFrame(editor, contents);
            }

            @Override
            public Class<WhileFrame> getBlockClass() {
                return WhileFrame.class;
            }
        };
    }

    private List<CodeElement> getContents() {
        ArrayList<CodeElement> contents = new ArrayList<CodeElement>();
        this.canvas.getBlocksSubtype(CodeFrame.class).forEach(f -> {
            f.regenerateCode();
            contents.add((CodeElement)f.getCode());
        });
        return contents;
    }

    @Override
    public FrameCanvas createCanvas(InteractionManager editor, String stylePrefix) {
        return new JavaCanvas(editor, this, stylePrefix, false);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
        return ((JavaCanvas)this.getCanvas()).showDebugBefore(null, debug);
    }

    @Override
    public void regenerateCode() {
        this.element = new WhileElement(this, (FilledExpressionSlotFragment)this.paramCondition.getSlotElement(), this.getContents(), this.frameEnabledProperty.get());
    }

    @Override
    public WhileElement getCode() {
        return this.element;
    }

    @Override
    public List<ExtensionDescription> getAvailableExtensions(FrameCanvas canvas, FrameCursor cursorInCanvas) {
        return Utility.concat(super.getAvailableExtensions(canvas, cursorInCanvas), Arrays.asList(new ExtensionDescription('\b', "Remove loop, keep contents", () -> new PullUpContentsOperation(this.getEditor()).activate(this), false, ExtensionDescription.ExtensionSource.INSIDE_FIRST, new ExtensionDescription.ExtensionSource[0])));
    }

    @Override
    public BreakFrame.BreakEncloser asBreakEncloser() {
        return BreakFrame.BreakEncloser.WHILE;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animateProgress) {
        super.setView(oldView, newView, animateProgress);
        if (this.isFrameEnabled() && (oldView == Frame.View.JAVA_PREVIEW || newView == Frame.View.JAVA_PREVIEW)) {
            this.canvas.previewCurly(newView == Frame.View.JAVA_PREVIEW, this.header.getLeftFirstItem() + this.tweakCurlyX(), this.tweakOpeningCurlyY(), animateProgress);
        }
    }
}

